/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.json.JsonInferSchema$;
import org.apache.spark.sql.catalyst.util.DropMalformedMode$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FractionalType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df!B\u000b\u0017\u0001i\u0011\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\t\u000bI\u0002A\u0011A\u001a\t\u000fY\u0002!\u0019!C\u0005o!1a\n\u0001Q\u0001\naBqa\u0014\u0001C\u0002\u0013%\u0001\u000b\u0003\u0004X\u0001\u0001\u0006I!\u0015\u0005\u00061\u0002!\t!\u0017\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0011!\ti\u0002\u0001C\u00011\u0005}qaBA\u0017-!\u0005\u0011q\u0006\u0004\u0007+YA\t!!\r\t\rIZA\u0011AA\u001a\u0011%\t)d\u0003b\u0001\n\u0003\t9\u0004\u0003\u0005\u0002@-\u0001\u000b\u0011BA\u001d\u0011\u001d\tif\u0003C\u0001\u0003?Bq!!\u001d\f\t\u0003\t\u0019\bC\u0004\u0002\f.!\t!!$\t\u0011\u0005U5\u0002)A\u0005\u0003WBq!a&\f\t\u0003\tI\nC\u0005\u0002$.\t\t\u0011\"\u0003\u0002&\ny!j]8o\u0013:4WM]*dQ\u0016l\u0017M\u0003\u0002\u00181\u0005!!n]8o\u0015\tI\"$\u0001\u0005dCR\fG._:u\u0015\tYB$A\u0002tc2T!!\b\u0010\u0002\u000bM\u0004\u0018M]6\u000b\u0005}\u0001\u0013AB1qC\u000eDWMC\u0001\"\u0003\ry'oZ\n\u0004\u0001\rJ\u0003C\u0001\u0013(\u001b\u0005)#\"\u0001\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005!*#AB!osJ+g\r\u0005\u0002%U%\u00111&\n\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\b_B$\u0018n\u001c8t\u0007\u0001\u0001\"a\f\u0019\u000e\u0003YI!!\r\f\u0003\u0017)\u001bvJT(qi&|gn]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005Q*\u0004CA\u0018\u0001\u0011\u0015a#\u00011\u0001/\u00035!WmY5nC2\u0004\u0016M]:feV\t\u0001\b\u0005\u0003%sm2\u0015B\u0001\u001e&\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0002=\u0007:\u0011Q(\u0011\t\u0003}\u0015j\u0011a\u0010\u0006\u0003\u00016\na\u0001\u0010:p_Rt\u0014B\u0001\"&\u0003\u0019\u0001&/\u001a3fM&\u0011A)\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\t+\u0003CA$M\u001b\u0005A%BA%K\u0003\u0011i\u0017\r\u001e5\u000b\u0003-\u000bAA[1wC&\u0011Q\n\u0013\u0002\u000b\u0005&<G)Z2j[\u0006d\u0017A\u00043fG&l\u0017\r\u001c)beN,'\u000fI\u0001\u0013i&lWm\u001d;b[B4uN]7biR,'/F\u0001R!\t\u0011V+D\u0001T\u0015\t!\u0006$\u0001\u0003vi&d\u0017B\u0001,T\u0005I!\u0016.\\3ti\u0006l\u0007OR8s[\u0006$H/\u001a:\u0002'QLW.Z:uC6\u0004hi\u001c:nCR$XM\u001d\u0011\u0002\u000b%tg-\u001a:\u0016\u0005iSGcA.bgB\u0011AlX\u0007\u0002;*\u0011aLG\u0001\u0006if\u0004Xm]\u0005\u0003Av\u0013!b\u0015;sk\u000e$H+\u001f9f\u0011\u00159r\u00011\u0001c!\r\u0019g\r[\u0007\u0002I*\u0011Q\rH\u0001\u0004e\u0012$\u0017BA4e\u0005\r\u0011F\t\u0012\t\u0003S*d\u0001\u0001B\u0003l\u000f\t\u0007ANA\u0001U#\ti\u0007\u000f\u0005\u0002%]&\u0011q.\n\u0002\b\u001d>$\b.\u001b8h!\t!\u0013/\u0003\u0002sK\t\u0019\u0011I\\=\t\u000bQ<\u0001\u0019A;\u0002\u0019\r\u0014X-\u0019;f!\u0006\u00148/\u001a:\u0011\r\u00112\b\u0010[A\u0005\u0013\t9XEA\u0005Gk:\u001cG/[8oeA\u0019\u00110!\u0002\u000e\u0003iT!a\u001f?\u0002\t\r|'/\u001a\u0006\u0003{z\fqA[1dWN|gNC\u0002\u0000\u0003\u0003\t\u0011BZ1ti\u0016\u0014\b0\u001c7\u000b\u0005\u0005\r\u0011aA2p[&\u0019\u0011q\u0001>\u0003\u0017)\u001bxN\u001c$bGR|'/\u001f\t\u0004s\u0006-\u0011bAA\u0007u\nQ!j]8o!\u0006\u00148/\u001a:\u0002\u0015%tg-\u001a:GS\u0016dG\r\u0006\u0003\u0002\u0014\u0005e\u0001c\u0001/\u0002\u0016%\u0019\u0011qC/\u0003\u0011\u0011\u000bG/\u0019+za\u0016Dq!a\u0007\t\u0001\u0004\tI!\u0001\u0004qCJ\u001cXM]\u0001\u0011G\u0006twN\\5dC2L'0\u001a+za\u0016$b!!\t\u0002(\u0005-\u0002#\u0002\u0013\u0002$\u0005M\u0011bAA\u0013K\t1q\n\u001d;j_:Dq!!\u000b\n\u0001\u0004\t\u0019\"A\u0002ua\u0016DQ\u0001L\u0005A\u00029\nqBS:p]&sg-\u001a:TG\",W.\u0019\t\u0003_-\u00192aC\u0012*)\t\ty#A\u000btiJ,8\r\u001e$jK2$7i\\7qCJ\fGo\u001c:\u0016\u0005\u0005e\"CBA\u001e\u0003\u0003\niE\u0002\u0004\u0002>9\u0001\u0011\u0011\b\u0002\ryI,g-\u001b8f[\u0016tGOP\u0001\u0017gR\u0014Xo\u0019;GS\u0016dGmQ8na\u0006\u0014\u0018\r^8sAA!\u00111IA%\u001b\t\t)EC\u0002\u0002H)\u000bA\u0001\\1oO&!\u00111JA#\u0005\u0019y%M[3diB1\u0011qJA*\u0003/j!!!\u0015\u000b\u0005QS\u0015\u0002BA+\u0003#\u0012!bQ8na\u0006\u0014\u0018\r^8s!\ra\u0016\u0011L\u0005\u0004\u00037j&aC*ueV\u001cGOR5fY\u0012\f\u0001\"[:T_J$X\r\u001a\u000b\u0005\u0003C\n9\u0007E\u0002%\u0003GJ1!!\u001a&\u0005\u001d\u0011un\u001c7fC:Dq!!\u001b\u0010\u0001\u0004\tY'A\u0002beJ\u0004R\u0001JA7\u0003/J1!a\u001c&\u0005\u0015\t%O]1z\u0003A9\u0018\u000e\u001e5D_J\u0014X\u000f\u001d;GS\u0016dG\rF\u0005\\\u0003k\nI(! \u0002\u0002\"1\u0011q\u000f\tA\u0002m\u000baa\u001d;sk\u000e$\bbBA>!\u0001\u0007\u00111C\u0001\u0006_RDWM\u001d\u0005\u0007\u0003\u007f\u0002\u0002\u0019A\u001e\u00025\r|G.^7o\u001d\u0006lWm\u00144D_J\u0014X\u000f\u001d;SK\u000e|'\u000fZ:\t\u000f\u0005\r\u0005\u00031\u0001\u0002\u0006\u0006I\u0001/\u0019:tK6{G-\u001a\t\u0004%\u0006\u001d\u0015bAAE'\nI\u0001+\u0019:tK6{G-Z\u0001\u0013G>l\u0007/\u0019;jE2,'k\\8u)f\u0004X\r\u0006\u0004\u0002\u0010\u0006E\u00151\u0013\t\tIY\f\u0019\"a\u0005\u0002\u0014!1\u0011qP\tA\u0002mBq!a!\u0012\u0001\u0004\t))A\u000bf[B$\u0018p\u0015;sk\u000e$h)[3mI\u0006\u0013(/Y=\u0002\u001d\r|W\u000e]1uS\ndW\rV=qKR1\u00111CAN\u0003?Cq!!(\u0014\u0001\u0004\t\u0019\"\u0001\u0002uc!9\u0011\u0011U\nA\u0002\u0005M\u0011A\u0001;3\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u0005\u0003")
public class JsonInferSchema
implements scala.Serializable {
    private final JSONOptions options;
    private final Function1<String, BigDecimal> decimalParser;
    private final TimestampFormatter timestampFormatter;

    public static DataType compatibleType(DataType dataType, DataType dataType2) {
        return JsonInferSchema$.MODULE$.compatibleType(dataType, dataType2);
    }

    public static Function2<DataType, DataType, DataType> compatibleRootType(String string, ParseMode parseMode) {
        return JsonInferSchema$.MODULE$.compatibleRootType(string, parseMode);
    }

    public static StructType withCorruptField(StructType structType, DataType dataType, String string, ParseMode parseMode) {
        return JsonInferSchema$.MODULE$.withCorruptField(structType, dataType, string, parseMode);
    }

    public static boolean isSorted(StructField[] structFieldArray) {
        return JsonInferSchema$.MODULE$.isSorted(structFieldArray);
    }

    public static Comparator<StructField> structFieldComparator() {
        return JsonInferSchema$.MODULE$.structFieldComparator();
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    private TimestampFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    public <T> StructType infer(RDD<T> json, Function2<JsonFactory, T, JsonParser> createParser) {
        ParseMode parseMode = this.options.parseMode();
        String columnNameOfCorruptRecord = this.options.columnNameOfCorruptRecord();
        Function2<DataType, DataType, DataType> typeMerger = JsonInferSchema$.MODULE$.compatibleRootType(columnNameOfCorruptRecord, parseMode);
        RDD mergedTypesFromPartitions = json.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            JsonFactory factory = $this.options.buildJsonFactory();
            return Option$.MODULE$.option2Iterable(iter.flatMap((Function1 & Serializable & scala.Serializable)row -> {
                Iterable iterable;
                try {
                    iterable = Option$.MODULE$.option2Iterable((Option)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> (JsonParser)createParser.apply((Object)factory, row), (Function1 & Serializable & scala.Serializable)parser -> {
                        parser.nextToken();
                        return new Some((Object)this.inferField((JsonParser)parser));
                    }));
                    return iterable;
                }
                catch (Throwable throwable) {
                    Iterable iterable2;
                    Throwable throwable2 = throwable;
                    boolean bl = throwable2 instanceof RuntimeException ? true : throwable2 instanceof JsonProcessingException;
                    if (!bl) throw throwable;
                    ParseMode parseMode = parseMode;
                    if (PermissiveMode$.MODULE$.equals(parseMode)) {
                        iterable2 = Option$.MODULE$.option2Iterable((Option)new Some((Object)StructType$.MODULE$.apply((Seq<StructField>)((Seq)new .colon.colon((Object)new StructField(columnNameOfCorruptRecord, StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
                    } else if (DropMalformedMode$.MODULE$.equals(parseMode)) {
                        iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    } else {
                        if (!FailFastMode$.MODULE$.equals(parseMode)) throw new MatchError((Object)parseMode);
                        throw QueryExecutionErrors$.MODULE$.malformedRecordsDetectedInSchemaInferenceError(throwable2);
                    }
                    Iterable iterable3 = iterable2;
                    iterable = iterable3;
                }
                return iterable;
            }).reduceOption(typeMerger)).toIterator();
        }, json.mapPartitions$default$2(), ClassTag$.MODULE$.apply(DataType.class));
        SQLConf existingConf = SQLConf$.MODULE$.get();
        ObjectRef rootType = ObjectRef.create((Object)StructType$.MODULE$.apply((Seq<StructField>)Nil$.MODULE$));
        Function1 & Serializable & scala.Serializable foldPartition = (Function1 & Serializable & scala.Serializable)iter -> (DataType)iter.fold((Object)StructType$.MODULE$.apply((Seq<StructField>)Nil$.MODULE$), typeMerger);
        Function2 & Serializable & scala.Serializable mergeResult = (Function2 & Serializable & scala.Serializable)(index, taskResult) -> {
            rootType.elem = (DataType)SQLConf$.MODULE$.withExistingConf(existingConf, (Function0 & Serializable & scala.Serializable)() -> (DataType)typeMerger$1.apply((Object)((DataType)rootType$1.elem), (Object)taskResult));
            return BoxedUnit.UNIT;
        };
        json.sparkContext().runJob(mergedTypesFromPartitions, (Function1)foldPartition, (Function2)mergeResult, ClassTag$.MODULE$.apply(DataType.class));
        return (StructType)Option$.MODULE$.option2Iterable(this.canonicalizeType((DataType)rootType.elem, this.options)).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JsonInferSchema.$anonfun$infer$8(x$1))).getOrElse((Function0 & Serializable & scala.Serializable)() -> StructType$.MODULE$.apply((Seq<StructField>)Nil$.MODULE$));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public DataType inferField(JsonParser parser) {
        void var2_16;
        boolean bl = false;
        JsonToken jsonToken = null;
        JsonToken jsonToken2 = parser.getCurrentToken();
        boolean bl2 = jsonToken2 == null ? true : JsonToken.VALUE_NULL.equals(jsonToken2);
        if (bl2) {
            NullType$ nullType$ = NullType$.MODULE$;
            return var2_16;
        }
        if (JsonToken.FIELD_NAME.equals(jsonToken2)) {
            parser.nextToken();
            DataType dataType = this.inferField(parser);
            return var2_16;
        }
        if (JsonToken.VALUE_STRING.equals(jsonToken2)) {
            bl = true;
            jsonToken = jsonToken2;
            if (parser.getTextLength() < 1) {
                NullType$ nullType$ = NullType$.MODULE$;
                return var2_16;
            }
        }
        if (bl) {
            LazyRef decimalTry$lzy = new LazyRef();
            String field = parser.getText();
            StringType$ stringType$ = this.options.prefersDecimal() && this.decimalTry$1(decimalTry$lzy, field).isDefined() ? (DataType)this.decimalTry$1(decimalTry$lzy, field).get() : (this.options.inferTimestamp() && Exception$.MODULE$.allCatch().opt((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.timestampFormatter().parse(field)).isDefined() ? TimestampType$.MODULE$ : StringType$.MODULE$);
            return var2_16;
        }
        if (JsonToken.START_OBJECT.equals(jsonToken2)) {
            ArrayBuilder builder = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(StructField.class));
            while (true) {
                if (!JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
                    StructField[] fields = (StructField[])builder.result();
                    Arrays.sort((Object[])fields, JsonInferSchema$.MODULE$.structFieldComparator());
                    StructType structType = new StructType(fields);
                    return var2_16;
                }
                builder.$plus$eq((Object)new StructField(parser.getCurrentName(), this.inferField(parser), true, StructField$.MODULE$.apply$default$4()));
            }
        }
        if (JsonToken.START_ARRAY.equals(jsonToken2)) {
            NullType$ nullType$ = NullType$.MODULE$;
            while (true) {
                void var20_22;
                if (!JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_ARRAY)) {
                    ArrayType arrayType = ArrayType$.MODULE$.apply((DataType)var20_22);
                    return var2_16;
                }
                DataType dataType = JsonInferSchema$.MODULE$.compatibleType((DataType)var20_22, this.inferField(parser));
            }
        }
        boolean bl3 = JsonToken.VALUE_NUMBER_INT.equals(jsonToken2) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken2);
        if (bl3 && this.options.primitivesAsString()) {
            StringType$ stringType$ = StringType$.MODULE$;
            return var2_16;
        }
        boolean bl4 = JsonToken.VALUE_TRUE.equals(jsonToken2) ? true : JsonToken.VALUE_FALSE.equals(jsonToken2);
        if (bl4 && this.options.primitivesAsString()) {
            StringType$ stringType$ = StringType$.MODULE$;
            return var2_16;
        }
        boolean bl5 = JsonToken.VALUE_NUMBER_INT.equals(jsonToken2) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken2);
        if (bl5) {
            void var4_33;
            JsonParser.NumberType numberType = parser.getNumberType();
            boolean bl6 = JsonParser.NumberType.INT.equals(numberType) ? true : JsonParser.NumberType.LONG.equals(numberType);
            if (bl6) {
                LongType$ longType$ = LongType$.MODULE$;
            } else {
                boolean bl7 = JsonParser.NumberType.BIG_INTEGER.equals(numberType) ? true : JsonParser.NumberType.BIG_DECIMAL.equals(numberType);
                if (bl7) {
                    BigDecimal v = parser.getDecimalValue();
                    FractionalType fractionalType = Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION() ? new DecimalType(Math.max(v.precision(), v.scale()), v.scale()) : DoubleType$.MODULE$;
                } else {
                    boolean bl8 = JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType);
                    if (bl8 && this.options.prefersDecimal()) {
                        BigDecimal v = parser.getDecimalValue();
                        FractionalType fractionalType = Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION() ? new DecimalType(Math.max(v.precision(), v.scale()), v.scale()) : DoubleType$.MODULE$;
                    } else {
                        boolean bl9 = JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType);
                        if (!bl9) throw new MatchError((Object)numberType);
                        DoubleType$ doubleType$ = DoubleType$.MODULE$;
                    }
                }
            }
            void var2_14 = var4_33;
            return var2_16;
        }
        boolean bl10 = JsonToken.VALUE_TRUE.equals(jsonToken2) ? true : JsonToken.VALUE_FALSE.equals(jsonToken2);
        if (!bl10) throw QueryExecutionErrors$.MODULE$.malformedJSONError();
        BooleanType$ booleanType$ = BooleanType$.MODULE$;
        return var2_16;
    }

    public Option<DataType> canonicalizeType(DataType tpe, JSONOptions options) {
        Object object;
        DataType dataType = tpe;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            object = this.canonicalizeType(arrayType.elementType(), options).map((Function1 & Serializable & scala.Serializable)t -> arrayType.copy((DataType)t, arrayType.copy$default$2()));
        } else {
            StructType structType;
            StructField[] fields;
            StructField[] canonicalFields;
            object = dataType instanceof StructType ? (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(canonicalFields = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(fields = (structType = (StructType)dataType).fields()))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JsonInferSchema.$anonfun$canonicalizeType$2(x$2))))).flatMap((Function1 & Serializable & scala.Serializable)f -> Option$.MODULE$.option2Iterable(this.canonicalizeType(f.dataType(), options).map((Function1 & Serializable & scala.Serializable)t -> {
                DataType x$1 = t;
                String x$2 = f.copy$default$1();
                boolean x$3 = f.copy$default$3();
                Metadata x$4 = f.copy$default$4();
                return f.copy(x$2, x$1, x$3, x$4);
            })), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))))).isEmpty() ? None$.MODULE$ : new Some((Object)new StructType(canonicalFields))) : (NullType$.MODULE$.equals(dataType) ? (options.dropFieldIfAllNull() ? None$.MODULE$ : new Some((Object)StringType$.MODULE$)) : new Some((Object)dataType));
        }
        return object;
    }

    public static final /* synthetic */ boolean $anonfun$infer$8(DataType x$1) {
        return x$1 instanceof StructType;
    }

    private final /* synthetic */ Option decimalTry$lzycompute$1(LazyRef decimalTry$lzy$1, String field$1) {
        Option option;
        LazyRef lazyRef = decimalTry$lzy$1;
        synchronized (lazyRef) {
            option = decimalTry$lzy$1.initialized() ? (Option)decimalTry$lzy$1.value() : (Option)decimalTry$lzy$1.initialize((Object)Exception$.MODULE$.allCatch().opt((Function0 & Serializable & scala.Serializable)() -> {
                BigDecimal bigDecimal = (BigDecimal)this.decimalParser().apply((Object)field$1);
                return new DecimalType(bigDecimal.precision(), bigDecimal.scale());
            }));
        }
        return option;
    }

    private final Option decimalTry$1(LazyRef decimalTry$lzy$1, String field$1) {
        return decimalTry$lzy$1.initialized() ? (Option)decimalTry$lzy$1.value() : this.decimalTry$lzycompute$1(decimalTry$lzy$1, field$1);
    }

    public static final /* synthetic */ boolean $anonfun$canonicalizeType$2(StructField x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2.name())).nonEmpty();
    }

    public JsonInferSchema(JSONOptions options) {
        this.options = options;
        this.decimalParser = ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.timestampFormatter = TimestampFormatter$.MODULE$.apply(options.timestampFormat(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
    }
}

