/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.dsl.package$expressions$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.CheckOverflowInSum;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.If;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.KnownNotNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Predicate;
import org.apache.spark.sql.catalyst.expressions.aggregate.DeclarativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.catalyst.trees.UnaryLike;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DecimalType$Fixed$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import scala.Enumeration;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the sum calculated from values of a group.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (5), (10), (15) AS tab(col);\n       30\n      > SELECT _FUNC_(col) FROM VALUES (NULL), (10), (15) AS tab(col);\n       25\n      > SELECT _FUNC_(col) FROM VALUES (NULL), (NULL) AS tab(col);\n       NULL\n  ", group="agg_funcs", since="1.0.0")
@ScalaSignature(bytes="\u0006\u0001\tUc\u0001\u0002\u0016,\u0001jB\u0001\"\u0016\u0001\u0003\u0016\u0004%\tA\u0016\u0005\t/\u0002\u0011\t\u0012)A\u0005\u0013\"A\u0001\f\u0001BK\u0002\u0013\u0005\u0011\f\u0003\u0005^\u0001\tE\t\u0015!\u0003[\u0011\u0015q\u0006\u0001\"\u0001`\u0011\u0015q\u0006\u0001\"\u0001d\u0011\u0015)\u0007\u0001\"\u0011Z\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015q\u0007\u0001\"\u0011p\u0011\u0019y\b\u0001\"\u0011\u0002\u0002!I\u0011q\u0002\u0001C\u0002\u0013\u0015\u0013\u0011\u0003\u0005\t\u0003w\u0001\u0001\u0015!\u0004\u0002\u0014!Q\u0011Q\b\u0001\t\u0006\u0004%I!a\u0010\t\u0015\u00055\u0003\u0001#b\u0001\n\u0013\ty\u0005\u0003\u0006\u0002X\u0001A)\u0019!C\u0005\u0003\u001fB!\"!\u0017\u0001\u0011\u000b\u0007I\u0011BA.\u0011)\t\u0019\u0007\u0001EC\u0002\u0013\u0005\u0013Q\r\u0005\u000b\u0003S\u0002\u0001R1A\u0005B\u0005-\u0004BCA8\u0001!\u0015\r\u0011\"\u0011\u0002l!Q\u0011\u0011\u000f\u0001\t\u0006\u0004%\t%a\u001b\t\u0013\u0005M\u0004\u0001#b\u0001\n\u00032\u0006bBA;\u0001\u0011E\u0013q\u000f\u0005\b\u0003{\u0002A\u0011IA@\u0011%\ti\tAA\u0001\n\u0003\ty\tC\u0005\u0002\u0016\u0002\t\n\u0011\"\u0001\u0002\u0018\"I\u0011Q\u0016\u0001\u0012\u0002\u0013\u0005\u0011q\u0016\u0005\n\u0003g\u0003\u0011\u0011!C!\u0003kC\u0011\"a2\u0001\u0003\u0003%\t!!3\t\u0013\u0005E\u0007!!A\u0005\u0002\u0005M\u0007\"CAm\u0001\u0005\u0005I\u0011IAn\u0011%\t9\u000fAA\u0001\n\u0003\tI\u000fC\u0005\u0002n\u0002\t\t\u0011\"\u0011\u0002p\u001eI!1C\u0016\u0002\u0002#\u0005!Q\u0003\u0004\tU-\n\t\u0011#\u0001\u0003\u0018!1aL\tC\u0001\u0005KA\u0011Ba\n#\u0003\u0003%)E!\u000b\t\u0013\t-\"%!A\u0005\u0002\n5\u0002\"\u0003B\u001aEE\u0005I\u0011AAX\u0011%\u0011)DIA\u0001\n\u0003\u00139\u0004C\u0005\u0003J\t\n\n\u0011\"\u0001\u00020\"I!1\n\u0012\u0002\u0002\u0013%!Q\n\u0002\u0004'Vl'B\u0001\u0017.\u0003%\twm\u001a:fO\u0006$XM\u0003\u0002/_\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u0001\u0014'\u0001\u0005dCR\fG._:u\u0015\t\u00114'A\u0002tc2T!\u0001N\u001b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y:\u0014AB1qC\u000eDWMC\u00019\u0003\ry'oZ\u0002\u0001'\u0019\u00011hP\"M%B\u0011A(P\u0007\u0002W%\u0011ah\u000b\u0002\u0015\t\u0016\u001cG.\u0019:bi&4X-Q4he\u0016<\u0017\r^3\u0011\u0005\u0001\u000bU\"A\u0017\n\u0005\tk#AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0007\u0011;\u0015*D\u0001F\u0015\t1u&A\u0003ue\u0016,7/\u0003\u0002I\u000b\nIQK\\1ss2K7.\u001a\t\u0003\u0001*K!aS\u0017\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002N!6\taJC\u0001P\u0003\u0015\u00198-\u00197b\u0013\t\tfJA\u0004Qe>$Wo\u0019;\u0011\u00055\u001b\u0016B\u0001+O\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015\u0019\u0007.\u001b7e+\u0005I\u0015AB2iS2$\u0007%A\u0006gC&dwJ\\#se>\u0014X#\u0001.\u0011\u00055[\u0016B\u0001/O\u0005\u001d\u0011un\u001c7fC:\fABZ1jY>sWI\u001d:pe\u0002\na\u0001P5oSRtDc\u00011bEB\u0011A\b\u0001\u0005\u0006+\u0016\u0001\r!\u0013\u0005\b1\u0016\u0001\n\u00111\u0001[)\t\u0001G\rC\u0003V\r\u0001\u0007\u0011*\u0001\u0005ok2d\u0017M\u00197f\u0003!!\u0017\r^1UsB,W#\u00015\u0011\u0005%dW\"\u00016\u000b\u0005-\f\u0014!\u0002;za\u0016\u001c\u0018BA7k\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\t\u0001\u000fE\u0002rsrt!A]<\u000f\u0005M4X\"\u0001;\u000b\u0005UL\u0014A\u0002\u001fs_>$h(C\u0001P\u0013\tAh*A\u0004qC\u000e\\\u0017mZ3\n\u0005i\\(aA*fc*\u0011\u0001P\u0014\t\u0003SvL!A 6\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cHCAA\u0002!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005_\u0005A\u0011M\\1msNL7/\u0003\u0003\u0002\u000e\u0005\u001d!a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u00199|G-\u001a)biR,'O\\:\u0016\u0005\u0005M\u0001\u0003B9z\u0003+\u0001B!a\u0006\u000269!\u0011\u0011DA\u0019\u001d\u0011\tY\"a\f\u000f\t\u0005u\u0011Q\u0006\b\u0005\u0003?\tYC\u0004\u0003\u0002\"\u0005%b\u0002BA\u0012\u0003Oq1a]A\u0013\u0013\u0005A\u0014B\u0001\u001c8\u0013\t!T'\u0003\u00023g%\u0011\u0001'M\u0005\u0003\r>J1!a\rF\u0003-!&/Z3QCR$XM\u001d8\n\t\u0005]\u0012\u0011\b\u0002\f)J,W\rU1ui\u0016\u0014hNC\u0002\u00024\u0015\u000bQB\\8eKB\u000bG\u000f^3s]N\u0004\u0013A\u0003:fgVdG\u000fV=qKV\u0011\u0011\u0011\t\n\u0007\u0003\u0007\n9\u0005\u0014*\u0007\r\u0005\u0015\u0003\u0001AA!\u00051a$/\u001a4j]\u0016lWM\u001c;?!\rI\u0017\u0011J\u0005\u0004\u0003\u0017R'AC!u_6L7\rV=qK\u0006\u00191/^7\u0016\u0005\u0005E\u0003c\u0001!\u0002T%\u0019\u0011QK\u0017\u0003%\u0005#HO]5ckR,'+\u001a4fe\u0016t7-Z\u0001\bSN,U\u000e\u001d;z\u0003\u0011QXM]8\u0016\u0005\u0005u\u0003c\u0001!\u0002`%\u0019\u0011\u0011M\u0017\u0003\u000f1KG/\u001a:bY\u0006\u0019\u0012mZ4Ck\u001a4WM]!uiJL'-\u001e;fgV\u0011\u0011q\r\t\u0005cf\f\t&A\u0007j]&$\u0018.\u00197WC2,Xm]\u000b\u0003\u0003[\u00022!]=J\u0003E)\b\u000fZ1uK\u0016C\bO]3tg&|gn]\u0001\u0011[\u0016\u0014x-Z#yaJ,7o]5p]N\f!#\u001a<bYV\fG/Z#yaJ,7o]5p]\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$2\u0001YA=\u0011\u0019\tYH\u0006a\u0001\u0013\u0006Aa.Z<DQ&dG-A\u0007gY\u0006$\u0018I]4v[\u0016tGo]\u000b\u0003\u0003\u0003\u0003R!]AB\u0003\u000fK1!!\"|\u0005!IE/\u001a:bi>\u0014\bcA'\u0002\n&\u0019\u00111\u0012(\u0003\u0007\u0005s\u00170\u0001\u0003d_BLH#\u00021\u0002\u0012\u0006M\u0005bB+\u0019!\u0003\u0005\r!\u0013\u0005\b1b\u0001\n\u00111\u0001[\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!'+\u0007%\u000bYj\u000b\u0002\u0002\u001eB!\u0011qTAU\u001b\t\t\tK\u0003\u0003\u0002$\u0006\u0015\u0016!C;oG\",7m[3e\u0015\r\t9KT\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAV\u0003C\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!-+\u0007i\u000bY*A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003o\u0003B!!/\u0002D6\u0011\u00111\u0018\u0006\u0005\u0003{\u000by,\u0001\u0003mC:<'BAAa\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00171\u0018\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005-\u0007cA'\u0002N&\u0019\u0011q\u001a(\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\u001d\u0015Q\u001b\u0005\n\u0003/l\u0012\u0011!a\u0001\u0003\u0017\f1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAo!\u0019\ty.!:\u0002\b6\u0011\u0011\u0011\u001d\u0006\u0004\u0003Gt\u0015AC2pY2,7\r^5p]&!\u0011QQAq\u0003!\u0019\u0017M\\#rk\u0006dGc\u0001.\u0002l\"I\u0011q[\u0010\u0002\u0002\u0003\u0007\u0011qQ\u0001\u0007KF,\u0018\r\\:\u0015\u0007i\u000b\t\u0010C\u0005\u0002X\u0002\n\t\u00111\u0001\u0002\b\"\u001a\u0002!!>\u0002|\u0006u(\u0011\u0001B\u0002\u0005\u000f\u0011IA!\u0004\u0003\u0010A\u0019\u0001)a>\n\u0007\u0005eXFA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005}\u0018!Q0G+:\u001bu\fK3yaJL\u0003%\f\u0011SKR,(O\\:!i\",\u0007e];nA\r\fGnY;mCR,G\r\t4s_6\u0004c/\u00197vKN\u0004sN\u001a\u0011bA\u001d\u0014x.\u001e9/\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B\u0003\u0003\u0005}(\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2pY&\u0002cIU(NAY\u000bE*V#TA!*\u0014\u0006\f\u0011)cAJC\u0006\t\u00152k%\u0002\u0013i\u0015\u0011uC\nD3m\u001c7*w)\u0001\u0003\u0005\t\u0011!A\u0001\u001a\u0004G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015d_2L\u0003E\u0012*P\u001b\u00022\u0016\tT+F'\u0002Bc*\u0016'MS1\u0002\u0003&\r\u0019*Y\u0001B\u0013'N\u0015!\u0003N\u0003C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113k)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C3m\u001c7*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)\u001dVcE*\u000b\u0017!Q9+F\nT\u0015!\u0003N\u0003C/\u00192)G>d\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011O+2c%\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\t-\u0011!C1hO~3WO\\2t\u0003\u0015\u0019\u0018N\\2fC\t\u0011\t\"A\u00032]Ar\u0003'A\u0002Tk6\u0004\"\u0001\u0010\u0012\u0014\t\t\u0012IB\u0015\t\b\u00057\u0011\t#\u0013.a\u001b\t\u0011iBC\u0002\u0003 9\u000bqA];oi&lW-\u0003\u0003\u0003$\tu!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeQ\u0011!QC\u0001\ti>\u001cFO]5oOR\u0011\u0011qW\u0001\u0006CB\u0004H.\u001f\u000b\u0006A\n=\"\u0011\u0007\u0005\u0006+\u0016\u0002\r!\u0013\u0005\b1\u0016\u0002\n\u00111\u0001[\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u0012\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005s\u0011)\u0005E\u0003N\u0005w\u0011y$C\u0002\u0003>9\u0013aa\u00149uS>t\u0007#B'\u0003B%S\u0016b\u0001B\"\u001d\n1A+\u001e9mKJB\u0001Ba\u0012(\u0003\u0003\u0005\r\u0001Y\u0001\u0004q\u0012\u0002\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B(!\u0011\tIL!\u0015\n\t\tM\u00131\u0018\u0002\u0007\u001f\nTWm\u0019;")
public class Sum
extends DeclarativeAggregate
implements ImplicitCastInputTypes,
UnaryLike<Expression> {
    private AtomicType resultType;
    private AttributeReference sum;
    private AttributeReference isEmpty;
    private Literal zero;
    private Seq<AttributeReference> aggBufferAttributes;
    private Seq<Expression> initialValues;
    private Seq<Expression> updateExpressions;
    private Seq<Expression> mergeExpressions;
    private Expression evaluateExpression;
    private final Expression child;
    private final boolean failOnError;
    private final Seq<Enumeration.Value> nodePatterns;
    private transient Seq<Expression> children;
    private volatile int bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static boolean $lessinit$greater$default$2() {
        return Sum$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Object>> unapply(Sum sum) {
        return Sum$.MODULE$.unapply(sum);
    }

    public static boolean apply$default$2() {
        return Sum$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple2<Expression, Object>, Sum> tupled() {
        return Sum$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Sum>> curried() {
        return Sum$.MODULE$.curried();
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return UnaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return UnaryLike.withNewChildrenInternal$(this, newChildren);
    }

    private Seq<Expression> children$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if (!this.bitmap$trans$0) {
                this.children = UnaryLike.children$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return !this.bitmap$trans$0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.resultType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, YearMonthIntervalType$.MODULE$, DayTimeIntervalType$.MODULE$})), (List)Nil$.MODULE$);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return TypeUtils$.MODULE$.checkForAnsiIntervalOrNumericType(this.child().dataType(), "sum");
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private AtomicType resultType$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 1) == 0) {
                AtomicType atomicType;
                DecimalType decimalType;
                Option<Tuple2<Object, Object>> option;
                DataType dataType = this.child().dataType();
                if (dataType instanceof DecimalType && !(option = DecimalType$Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
                    int precision = ((Tuple2)option.get())._1$mcI$sp();
                    int scale = ((Tuple2)option.get())._2$mcI$sp();
                    atomicType = DecimalType$.MODULE$.bounded(precision + 10, scale);
                } else if (dataType instanceof IntegralType) {
                    atomicType = LongType$.MODULE$;
                } else if (dataType instanceof YearMonthIntervalType) {
                    YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType;
                    atomicType = yearMonthIntervalType;
                } else if (dataType instanceof DayTimeIntervalType) {
                    DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType;
                    atomicType = dayTimeIntervalType;
                } else {
                    atomicType = DoubleType$.MODULE$;
                }
                this.resultType = atomicType;
                this.bitmap$0 |= 1;
            }
        }
        return this.resultType;
    }

    private AtomicType resultType() {
        return (this.bitmap$0 & 1) == 0 ? this.resultType$lzycompute() : this.resultType;
    }

    private AttributeReference sum$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 2) == 0) {
                String x$1 = "sum";
                AtomicType x$2 = this.resultType();
                boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
                this.sum = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 2;
            }
        }
        return this.sum;
    }

    private AttributeReference sum() {
        return (this.bitmap$0 & 2) == 0 ? this.sum$lzycompute() : this.sum;
    }

    private AttributeReference isEmpty$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 4) == 0) {
                String x$1 = "isEmpty";
                BooleanType$ x$2 = BooleanType$.MODULE$;
                boolean x$3 = false;
                Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
                ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, x$2, x$3, x$4);
                Seq<String> x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, x$2, x$3, x$4);
                this.isEmpty = new AttributeReference(x$1, x$2, x$3, x$4, x$5, x$6);
                this.bitmap$0 |= 4;
            }
        }
        return this.isEmpty;
    }

    private AttributeReference isEmpty() {
        return (this.bitmap$0 & 4) == 0 ? this.isEmpty$lzycompute() : this.isEmpty;
    }

    private Literal zero$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 8) == 0) {
                this.zero = Literal$.MODULE$.default(this.resultType());
                this.bitmap$0 |= 8;
            }
        }
        return this.zero;
    }

    private Literal zero() {
        return (this.bitmap$0 & 8) == 0 ? this.zero$lzycompute() : this.zero;
    }

    private Seq<AttributeReference> aggBufferAttributes$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x10) == 0) {
                List list;
                AtomicType atomicType = this.resultType();
                if (atomicType instanceof DecimalType) {
                    AttributeReference attributeReference = this.sum();
                    AttributeReference attributeReference2 = this.isEmpty();
                    list = Nil$.MODULE$.$colon$colon((Object)attributeReference2).$colon$colon((Object)attributeReference);
                } else {
                    AttributeReference attributeReference = this.sum();
                    list = Nil$.MODULE$.$colon$colon((Object)attributeReference);
                }
                this.aggBufferAttributes = list;
                this.bitmap$0 |= 0x10;
            }
        }
        return this.aggBufferAttributes;
    }

    @Override
    public Seq<AttributeReference> aggBufferAttributes() {
        return (this.bitmap$0 & 0x10) == 0 ? this.aggBufferAttributes$lzycompute() : this.aggBufferAttributes;
    }

    private Seq<Expression> initialValues$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x20) == 0) {
                AtomicType atomicType = this.resultType();
                Seq seq = atomicType instanceof DecimalType ? (Seq)new .colon.colon((Object)this.zero(), (List)new .colon.colon((Object)new Literal(BoxesRunTime.boxToBoolean((boolean)true), BooleanType$.MODULE$), (List)Nil$.MODULE$)) : (Seq)new .colon.colon((Object)new Literal(null, this.resultType()), (List)Nil$.MODULE$);
                this.initialValues = seq;
                this.bitmap$0 |= 0x20;
            }
        }
        return this.initialValues;
    }

    @Override
    public Seq<Expression> initialValues() {
        return (this.bitmap$0 & 0x20) == 0 ? this.initialValues$lzycompute() : this.initialValues;
    }

    private Seq<Expression> updateExpressions$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x40) == 0) {
                Seq seq;
                AtomicType atomicType = this.resultType();
                if (atomicType instanceof DecimalType) {
                    Expression sumExpr = this.child().nullable() ? new If((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNull()), this.sum(), package$expressions$.MODULE$.DslExpression(this.sum()).$plus(package$expressions$.MODULE$.DslExpression(new KnownNotNull(this.child())).cast(this.resultType()))) : package$expressions$.MODULE$.DslExpression(this.sum()).$plus(package$expressions$.MODULE$.DslExpression(this.child()).cast(this.resultType()));
                    Literal isEmptyExpr = this.child().nullable() ? (Expression)((Object)package$expressions$.MODULE$.DslExpression(this.isEmpty()).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.child()).isNull()))) : new Literal(BoxesRunTime.boxToBoolean((boolean)false), BooleanType$.MODULE$);
                    seq = (Seq)new .colon.colon((Object)sumExpr, (List)new .colon.colon((Object)isEmptyExpr, (List)Nil$.MODULE$));
                } else {
                    seq = this.child().nullable() ? (Seq)new .colon.colon((Object)package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.sum(), this.zero()}))).$plus(package$expressions$.MODULE$.DslExpression(this.child()).cast(this.resultType())), this.sum()})), (List)Nil$.MODULE$) : (Seq)new .colon.colon((Object)package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.sum(), this.zero()}))).$plus(package$expressions$.MODULE$.DslExpression(this.child()).cast(this.resultType())), (List)Nil$.MODULE$);
                }
                this.updateExpressions = seq;
                this.bitmap$0 |= 0x40;
            }
        }
        return this.updateExpressions;
    }

    @Override
    public Seq<Expression> updateExpressions() {
        return (this.bitmap$0 & 0x40) == 0 ? this.updateExpressions$lzycompute() : this.updateExpressions;
    }

    private Seq<Expression> mergeExpressions$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x80) == 0) {
                Seq seq;
                AtomicType atomicType = this.resultType();
                if (atomicType instanceof DecimalType) {
                    Predicate bufferOverflow = package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).left()).unary_$bang())).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.sum()).left()).isNull()));
                    Predicate inputOverflow = package$expressions$.MODULE$.DslExpression((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).right()).unary_$bang())).$amp$amp((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.sum()).right()).isNull()));
                    seq = (Seq)new .colon.colon((Object)new If((Expression)((Object)package$expressions$.MODULE$.DslExpression((Expression)((Object)bufferOverflow)).$bar$bar((Expression)((Object)inputOverflow))), Literal$.MODULE$.create(null, this.resultType()), package$expressions$.MODULE$.DslExpression(new KnownNotNull(this.RichAttribute(this.sum()).left())).$plus(new KnownNotNull(this.RichAttribute(this.sum()).right()))), (List)new .colon.colon((Object)((Expression)((Object)package$expressions$.MODULE$.DslExpression(this.RichAttribute(this.isEmpty()).left()).$amp$amp(this.RichAttribute(this.isEmpty()).right()))), (List)Nil$.MODULE$));
                } else {
                    seq = (Seq)new .colon.colon((Object)package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{package$expressions$.MODULE$.DslExpression(package$expressions$.MODULE$.coalesce((Seq<Expression>)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.RichAttribute(this.sum()).left(), this.zero()}))).$plus(this.RichAttribute(this.sum()).right()), this.RichAttribute(this.sum()).left()})), (List)Nil$.MODULE$);
                }
                this.mergeExpressions = seq;
                this.bitmap$0 |= 0x80;
            }
        }
        return this.mergeExpressions;
    }

    @Override
    public Seq<Expression> mergeExpressions() {
        return (this.bitmap$0 & 0x80) == 0 ? this.mergeExpressions$lzycompute() : this.mergeExpressions;
    }

    private Expression evaluateExpression$lzycompute() {
        Sum sum = this;
        synchronized (sum) {
            if ((this.bitmap$0 & 0x100) == 0) {
                Expression expression;
                AtomicType atomicType = this.resultType();
                if (atomicType instanceof DecimalType) {
                    DecimalType decimalType = (DecimalType)atomicType;
                    expression = new If(this.isEmpty(), Literal$.MODULE$.create(null, this.resultType()), new CheckOverflowInSum(this.sum(), decimalType, !this.failOnError()));
                } else {
                    expression = this.sum();
                }
                this.evaluateExpression = expression;
                this.bitmap$0 |= 0x100;
            }
        }
        return this.evaluateExpression;
    }

    @Override
    public Expression evaluateExpression() {
        return (this.bitmap$0 & 0x100) == 0 ? this.evaluateExpression$lzycompute() : this.evaluateExpression;
    }

    @Override
    public Sum withNewChildInternal(Expression newChild) {
        return this.copy(newChild, this.copy$default$2());
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child()}));
    }

    public Sum copy(Expression child, boolean failOnError) {
        return new Sum(child, failOnError);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public boolean copy$default$2() {
        return this.failOnError();
    }

    @Override
    public String productPrefix() {
        return "Sum";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Sum;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Sum)) return false;
        boolean bl = true;
        if (!bl) return false;
        Sum sum = (Sum)x$1;
        Expression expression = this.child();
        Expression expression2 = sum.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.failOnError() != sum.failOnError()) return false;
        if (!sum.canEqual(this)) return false;
        return true;
    }

    public Sum(Expression child, boolean failOnError) {
        this.child = child;
        this.failOnError = failOnError;
        ExpectsInputTypes.$init$(this);
        UnaryLike.$init$(this);
        this.nodePatterns = (Seq)new .colon.colon((Object)TreePattern$.MODULE$.SUM(), (List)Nil$.MODULE$);
    }

    public Sum(Expression child) {
        this(child, SQLConf$.MODULE$.get().ansiEnabled());
    }
}

