/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.QuaternaryExpression;
import org.apache.spark.sql.catalyst.expressions.RegExpReplace$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function4;
import scala.Option;
import scala.Product;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, regexp, rep[, position]) - Replaces all substrings of `str` that match `regexp` with `rep`.", arguments="\n    Arguments:\n      * str - a string expression to search for a regular expression pattern match.\n      * regexp - a string representing a regular expression. The regex string should be a\n          Java regular expression.<br><br>\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser. For example, to match \"\\abc\", a regular expression for `regexp` can be\n          \"^\\\\abc$\".<br><br>\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".\n      * rep - a string expression to replace matched substrings.\n      * position - a positive integer literal that indicates the position within `str` to begin searching.\n          The default is 1. If position is greater than the number of characters in `str`, the result is `str`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('100-200', '(\\\\d+)', 'num');\n       num-num\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\t\u0015g\u0001B\u001b7\u0001\u000eC\u0001b\u0017\u0001\u0003\u0016\u0004%\t\u0001\u0018\u0005\tA\u0002\u0011\t\u0012)A\u0005;\"A\u0011\r\u0001BK\u0002\u0013\u0005A\f\u0003\u0005c\u0001\tE\t\u0015!\u0003^\u0011!\u0019\u0007A!f\u0001\n\u0003a\u0006\u0002\u00033\u0001\u0005#\u0005\u000b\u0011B/\t\u0011\u0015\u0004!Q3A\u0005\u0002qC\u0001B\u001a\u0001\u0003\u0012\u0003\u0006I!\u0018\u0005\u0006O\u0002!\t\u0001\u001b\u0005\u0006O\u0002!\tA\u001c\u0005\u0006e\u0002!\te\u001d\u0005\nu\u0002\u0001\r\u00111A\u0005\nmD1\"!\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\f!Q\u0011q\u0003\u0001A\u0002\u0003\u0005\u000b\u0015\u0002?\t\u0017\u0005\u0005\u0002\u00011AA\u0002\u0013%\u00111\u0005\u0005\f\u0003s\u0001\u0001\u0019!a\u0001\n\u0013\tY\u0004C\u0006\u0002@\u0001\u0001\r\u0011!Q!\n\u0005\u0015\u0002bCA\"\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u000bB1\"!\u0018\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002`!Y\u00111\r\u0001A\u0002\u0003\u0005\u000b\u0015BA$\u0011)\t9\u0007\u0001a\u0001\u0002\u0004%Ia\u001f\u0005\f\u0003S\u0002\u0001\u0019!a\u0001\n\u0013\tY\u0007\u0003\u0006\u0002p\u0001\u0001\r\u0011!Q!\nqD!\"a\u001d\u0001\u0011\u000b\u0007I\u0011BA;\u0011\u001d\t)\t\u0001C!\u0003\u000fCq!a(\u0001\t\u0003\n\t\u000bC\u0004\u0002.\u0002!\t%a,\t\u000f\u0005\u001d\u0007\u0001\"\u0011\u0002F!9\u0011\u0011\u001a\u0001\u0005R\u0005-\u0007BBAt\u0001\u0011\u0005C\f\u0003\u0004\u0002j\u0002!\t\u0005\u0018\u0005\u0007\u0003W\u0004A\u0011\t/\t\r\u00055\b\u0001\"\u0011]\u0011\u001d\ty\u000f\u0001C)\u0003cD\u0011\"a?\u0001\u0003\u0003%\t!!@\t\u0013\t\u001d\u0001!%A\u0005\u0002\t%\u0001\"\u0003B\u0010\u0001E\u0005I\u0011\u0001B\u0005\u0011%\u0011\t\u0003AI\u0001\n\u0003\u0011I\u0001C\u0005\u0003$\u0001\t\n\u0011\"\u0001\u0003\n!I!Q\u0005\u0001\u0002\u0002\u0013\u0005#q\u0005\u0005\n\u0005[\u0001\u0011\u0011!C\u0001\u0005_A\u0011Ba\u000e\u0001\u0003\u0003%\tA!\u000f\t\u0013\tu\u0002!!A\u0005B\t}\u0002\"\u0003B'\u0001\u0005\u0005I\u0011\u0001B(\u0011%\u0011I\u0006AA\u0001\n\u0003\u0012YfB\u0004\u0003\u0006ZB\tAa\"\u0007\rU2\u0004\u0012\u0001BE\u0011\u00199w\u0006\"\u0001\u0003\u0012\"9!1S\u0018\u0005\u0002\tU\u0005\"\u0003BJ_\u0005\u0005I\u0011\u0011BO\u0011%\u00119kLA\u0001\n\u0003\u0013I\u000bC\u0005\u0003<>\n\t\u0011\"\u0003\u0003>\ni!+Z4FqB\u0014V\r\u001d7bG\u0016T!a\u000e\u001d\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003si\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003wq\n1a]9m\u0015\tid(A\u0003ta\u0006\u00148N\u0003\u0002@\u0001\u00061\u0011\r]1dQ\u0016T\u0011!Q\u0001\u0004_J<7\u0001A\n\u0007\u0001\u0011C5J\u0015-\u0011\u0005\u00153U\"\u0001\u001c\n\u0005\u001d3$\u0001F)vCR,'O\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u0002F\u0013&\u0011!J\u000e\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011Aj\u0014\b\u0003\u000b6K!A\u0014\u001c\u0002\u000fA\f7m[1hK&\u0011\u0001+\u0015\u0002\u000f\u001dVdG.\u00138u_2,'/\u00198u\u0015\tqe\u0007\u0005\u0002T-6\tAKC\u0001V\u0003\u0015\u00198-\u00197b\u0013\t9FKA\u0004Qe>$Wo\u0019;\u0011\u0005MK\u0016B\u0001.U\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u001d\u0019XO\u00196fGR,\u0012!\u0018\t\u0003\u000bzK!a\u0018\u001c\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0005tk\nTWm\u0019;!\u0003\u0019\u0011XmZ3ya\u00069!/Z4fqB\u0004\u0013a\u0001:fa\u0006!!/\u001a9!\u0003\r\u0001xn]\u0001\u0005a>\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0006S*\\G.\u001c\t\u0003\u000b\u0002AQaW\u0005A\u0002uCQ!Y\u0005A\u0002uCQaY\u0005A\u0002uCQ!Z\u0005A\u0002u#B![8qc\")1L\u0003a\u0001;\")\u0011M\u0003a\u0001;\")1M\u0003a\u0001;\u0006\u00192\r[3dW&s\u0007/\u001e;ECR\fG+\u001f9fgR\tA\u000f\u0005\u0002vq6\taO\u0003\u0002xq\u0005A\u0011M\\1msNL7/\u0003\u0002zm\nyA+\u001f9f\u0007\",7m\u001b*fgVdG/A\u0005mCN$(+Z4fqV\tA\u0010E\u0002~\u0003\u000bi\u0011A \u0006\u0004\u007f\u0006\u0005\u0011!\u0002;za\u0016\u001c(bAA\u0002y\u00051QO\\:bM\u0016L1!a\u0002\u007f\u0005))FK\u0012\u001dTiJLgnZ\u0001\u000eY\u0006\u001cHOU3hKb|F%Z9\u0015\t\u00055\u00111\u0003\t\u0004'\u0006=\u0011bAA\t)\n!QK\\5u\u0011!\t)\"DA\u0001\u0002\u0004a\u0018a\u0001=%c\u0005QA.Y:u%\u0016<W\r\u001f\u0011)\u00079\tY\u0002E\u0002T\u0003;I1!a\bU\u0005%!(/\u00198tS\u0016tG/A\u0004qCR$XM\u001d8\u0016\u0005\u0005\u0015\u0002\u0003BA\u0014\u0003ki!!!\u000b\u000b\t\u0005-\u0012QF\u0001\u0006e\u0016<W\r\u001f\u0006\u0005\u0003_\t\t$\u0001\u0003vi&d'BAA\u001a\u0003\u0011Q\u0017M^1\n\t\u0005]\u0012\u0011\u0006\u0002\b!\u0006$H/\u001a:o\u0003-\u0001\u0018\r\u001e;fe:|F%Z9\u0015\t\u00055\u0011Q\b\u0005\n\u0003+\u0001\u0012\u0011!a\u0001\u0003K\t\u0001\u0002]1ui\u0016\u0014h\u000e\t\u0015\u0004#\u0005m\u0011a\u00047bgR\u0014V\r\u001d7bG\u0016lWM\u001c;\u0016\u0005\u0005\u001d\u0003\u0003BA%\u0003/rA!a\u0013\u0002TA\u0019\u0011Q\n+\u000e\u0005\u0005=#bAA)\u0005\u00061AH]8pizJ1!!\u0016U\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011LA.\u0005\u0019\u0019FO]5oO*\u0019\u0011Q\u000b+\u0002'1\f7\u000f\u001e*fa2\f7-Z7f]R|F%Z9\u0015\t\u00055\u0011\u0011\r\u0005\n\u0003+\u0019\u0012\u0011!a\u0001\u0003\u000f\n\u0001\u0003\\1tiJ+\u0007\u000f\\1dK6,g\u000e\u001e\u0011)\u0007Q\tY\"A\u000bmCN$(+\u001a9mC\u000e,W.\u001a8u\u0013:,FK\u0012\u001d\u000231\f7\u000f\u001e*fa2\f7-Z7f]RLe.\u0016+Gq}#S-\u001d\u000b\u0005\u0003\u001b\ti\u0007\u0003\u0005\u0002\u0016Y\t\t\u00111\u0001}\u0003Ya\u0017m\u001d;SKBd\u0017mY3nK:$\u0018J\\+U\rb\u0002\u0003fA\f\u0002\u001c\u00051!/Z:vYR,\"!a\u001e\u0011\t\u0005e\u0014qP\u0007\u0003\u0003wRA!! \u00022\u0005!A.\u00198h\u0013\u0011\t\t)a\u001f\u0003\u0019M#(/\u001b8h\u0005V4g-\u001a:)\u0007a\tY\"\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0006\u0002\n\u0006=\u00151SAL\u00037\u00032aUAF\u0013\r\ti\t\u0016\u0002\u0004\u0003:L\bbBAI3\u0001\u0007\u0011\u0011R\u0001\u0002g\"9\u0011QS\rA\u0002\u0005%\u0015!\u00019\t\u000f\u0005e\u0015\u00041\u0001\u0002\n\u0006\t!\u000fC\u0004\u0002\u001ef\u0001\r!!#\u0002\u0003%\f\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003G\u0003B!!*\u0002*6\u0011\u0011q\u0015\u0006\u0003\u007fjJA!a+\u0002(\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\"!!-\u0011\r\u0005M\u00161XAa\u001d\u0011\t),!/\u000f\t\u00055\u0013qW\u0005\u0002+&\u0011a\nV\u0005\u0005\u0003{\u000byLA\u0002TKFT!A\u0014+\u0011\t\u0005\u0015\u00161Y\u0005\u0005\u0003\u000b\f9K\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006Q\u0001O]3uift\u0015-\\3\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBAg\u00033\f\u0019\u000f\u0005\u0003\u0002P\u0006UWBAAi\u0015\r\t\u0019NN\u0001\bG>$WmZ3o\u0013\u0011\t9.!5\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a7\u001e\u0001\u0004\ti.A\u0002dib\u0004B!a4\u0002`&!\u0011\u0011]Ai\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!:\u001e\u0001\u0004\ti-\u0001\u0002fm\u0006)a-\u001b:ti\u000611/Z2p]\u0012\fQ\u0001\u001e5je\u0012\faAZ8veRD\u0017aF<ji\"tUm^\"iS2$'/\u001a8J]R,'O\\1m)%I\u00171_A{\u0003o\fI\u0010\u0003\u0004\u0002h\n\u0002\r!\u0018\u0005\u0007\u0003S\u0014\u0003\u0019A/\t\r\u0005-(\u00051\u0001^\u0011\u0019\tiO\ta\u0001;\u0006!1m\u001c9z)%I\u0017q B\u0001\u0005\u0007\u0011)\u0001C\u0004\\GA\u0005\t\u0019A/\t\u000f\u0005\u001c\u0003\u0013!a\u0001;\"91m\tI\u0001\u0002\u0004i\u0006bB3$!\u0003\u0005\r!X\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011YAK\u0002^\u0005\u001bY#Aa\u0004\u0011\t\tE!1D\u0007\u0003\u0005'QAA!\u0006\u0003\u0018\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00053!\u0016AC1o]>$\u0018\r^5p]&!!Q\u0004B\n\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005S\u0001B!!\u001f\u0003,%!\u0011\u0011LA>\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0011\t\u0004E\u0002T\u0005gI1A!\u000eU\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tIIa\u000f\t\u0013\u0005U!&!AA\u0002\tE\u0012a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\u0005\u0003C\u0002B\"\u0005\u0013\nI)\u0004\u0002\u0003F)\u0019!q\t+\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003L\t\u0015#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BA!\u0015\u0003XA\u00191Ka\u0015\n\u0007\tUCKA\u0004C_>dW-\u00198\t\u0013\u0005UA&!AA\u0002\u0005%\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0003R\tu\u0003\"CA\u000b[\u0005\u0005\t\u0019AAEQ]\u0001!\u0011\rB4\u0005S\u0012iGa\u001c\u0003t\tU$\u0011\u0010B>\u0005\u007f\u0012\t\tE\u0002F\u0005GJ1A!\u001a7\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#Aa\u001b\u0002O~3UKT\"`QM$(\u000f\f\u0011sK\u001e,\u0007\u0010\u001d\u0017!e\u0016\u00048\f\f\u0011q_NLG/[8o;&\u0002S\u0006\t*fa2\f7-Z:!C2d\u0007e];cgR\u0014\u0018N\\4tA=4\u0007\u0005Y:ue\u0002\u0004C\u000f[1uA5\fGo\u00195!AJ,w-\u001a=qA\u0002:\u0018\u000e\u001e5!AJ,\u0007\u000f\u0019\u0018\u0002\u0013\u0005\u0014x-^7f]R\u001c\u0018E\u0001B9\u0003\u001dM'\u0002\t\u0011!A\u0005\u0013x-^7f]R\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011tiJ\u0004S\u0006I1!gR\u0014\u0018N\\4!Kb\u0004(/Z:tS>t\u0007\u0005^8!g\u0016\f'o\u00195!M>\u0014\b%\u0019\u0011sK\u001e,H.\u0019:!Kb\u0004(/Z:tS>t\u0007\u0005]1ui\u0016\u0014h\u000eI7bi\u000eDgF\u0003\u0011!A\u0001\u0002\u0003E\u000b\u0011sK\u001e,\u0007\u0010\u001d\u0011.A\u0005\u00043\u000f\u001e:j]\u001e\u0004#/\u001a9sKN,g\u000e^5oO\u0002\n\u0007E]3hk2\f'\u000fI3yaJ,7o]5p]:\u0002C\u000b[3!e\u0016<W\r\u001f\u0011tiJLgn\u001a\u0011tQ>,H\u000e\u001a\u0011cK\u0002\n'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!\u0015\u00064\u0018\r\t:fOVd\u0017M\u001d\u0011fqB\u0014Xm]:j_:tCH\u0019:?y\t\u0014hH\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AMKgnY3!'B\f'o\u001b\u00113]Ab\u0003e\u001d;sS:<\u0007\u0005\\5uKJ\fGn\u001d\u0011)S:\u001cG.\u001e3j]\u001e\u0004#/Z4fq\u0002\u0002\u0018\r\u001e;fe:\u001c\u0018\u0006I1sK\u0002*h.Z:dCB,G\rI5oA=,(\u000fI*R\u0019*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t9beN,'O\f\u0011G_J\u0004S\r_1na2,G\u0006\t;pA5\fGo\u00195!Eq\u000b'm\u0019\u0012-A\u0005\u0004#/Z4vY\u0006\u0014\b%\u001a=qe\u0016\u001c8/[8oA\u0019|'\u000f\t1sK\u001e,\u0007\u0010\u001d1!G\u0006t\u0007EY3\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002#E\u0018/]C\n\u001cGE\t\u0018=EJtDH\u0019:?\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\u00165fe\u0016\u0004\u0013n\u001d\u0011bAM\u000bF\nI2p]\u001aLw\rI\u0014ta\u0006\u00148NL:rY:\u0002\u0018M]:fe:*7oY1qK\u0012\u001cFO]5oO2KG/\u001a:bYN<\u0003\u0005\u001e5bi\u0002\u001a\u0017M\u001c\u0011cK\u0002*8/\u001a3!i>T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011gC2d'-Y2lAQ|\u0007\u0005\u001e5fAM\u0003\u0018M]6!c92\u0004EY3iCZLwN\u001d\u0011sK\u001e\f'\u000fZ5oO\u0002\u001aHO]5oO\u0002b\u0017\u000e^3sC2\u0004\u0003/\u0019:tS:<g\u0006\t$pe\u0002*\u00070Y7qY\u0016d#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!S\u001a\u0004C\u000f[3!G>tg-[4!SN\u0004SM\\1cY\u0016$G\u0006\t;iK\u0002\u0002'/Z4fqB\u0004\u0007\u0005\u001e5bi\u0002\u001a\u0017M\u001c\u0011nCR\u001c\u0007\u000e\t\u0012]C\n\u001c'\u0005I5tA\trF,\u00192dI\tr#\u0002\t\u0011!A\u0001\u0002#\u0006\t:fa\u0002j\u0003%\u0019\u0011tiJLgn\u001a\u0011fqB\u0014Xm]:j_:\u0004Co\u001c\u0011sKBd\u0017mY3![\u0006$8\r[3eAM,(m\u001d;sS:<7O\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!a>\u001c\u0018\u000e^5p]\u0002j\u0003%\u0019\u0011q_NLG/\u001b<fA%tG/Z4fe\u0002b\u0017\u000e^3sC2\u0004C\u000f[1uA%tG-[2bi\u0016\u001c\b\u0005\u001e5fAA|7/\u001b;j_:\u0004s/\u001b;iS:\u0004\u0003m\u001d;sA\u0002\"x\u000e\t2fO&t\u0007e]3be\u000eD\u0017N\\4/\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\u00165fA\u0011,g-Y;mi\u0002J7\u000fI\u0019/A%3\u0007\u0005]8tSRLwN\u001c\u0011jg\u0002:'/Z1uKJ\u0004C\u000f[1oAQDW\r\t8v[\n,'\u000fI8gA\rD\u0017M]1di\u0016\u00148\u000fI5oA\u0001\u001cHO\u001d1-AQDW\r\t:fgVdG\u000fI5tA\u0001\u001cHO\u001d1/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\t]\u0014a\u0015\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OE\u0002\u0004'\f\u001a1a\u001db\u0003e\n\u0015]9\u0012\\\u0013f\n\u0017!O9,XnJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A9,X.\f8v[*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0003~\u0005)\u0011GL\u001b/a\u0005)qM]8va\u0006\u0012!1Q\u0001\rgR\u0014\u0018N\\4`MVt7m]\u0001\u000e%\u0016<W\t\u001f9SKBd\u0017mY3\u0011\u0005\u0015{3\u0003B\u0018\u0003\fb\u00032a\u0015BG\u0013\r\u0011y\t\u0016\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t\u001d\u0015!B1qa2LHcB5\u0003\u0018\ne%1\u0014\u0005\u00067F\u0002\r!\u0018\u0005\u0006CF\u0002\r!\u0018\u0005\u0006GF\u0002\r!\u0018\u000b\nS\n}%\u0011\u0015BR\u0005KCQa\u0017\u001aA\u0002uCQ!\u0019\u001aA\u0002uCQa\u0019\u001aA\u0002uCQ!\u001a\u001aA\u0002u\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003,\n]\u0006#B*\u0003.\nE\u0016b\u0001BX)\n1q\n\u001d;j_:\u0004ra\u0015BZ;vkV,C\u0002\u00036R\u0013a\u0001V;qY\u0016$\u0004\u0002\u0003B]g\u0005\u0005\t\u0019A5\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B`!\u0011\tIH!1\n\t\t\r\u00171\u0010\u0002\u0007\u001f\nTWm\u0019;")
public class RegExpReplace
extends QuaternaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private transient StringBuffer result;
    private final Expression subject;
    private final Expression regexp;
    private final Expression rep;
    private final Expression pos;
    private transient UTF8String lastRegex;
    private transient Pattern pattern;
    private transient String lastReplacement;
    private transient UTF8String lastReplacementInUTF8;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple4<Expression, Expression, Expression, Expression>> unapply(RegExpReplace regExpReplace) {
        return RegExpReplace$.MODULE$.unapply(regExpReplace);
    }

    public Expression subject() {
        return this.subject;
    }

    public Expression regexp() {
        return this.regexp;
    }

    public Expression rep() {
        return this.rep;
    }

    public Expression pos() {
        return this.pos;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        if (!this.pos().foldable()) {
            return new TypeCheckResult.TypeCheckFailure(new StringBuilder(46).append("Position expression must be foldable, but got ").append(this.pos()).toString());
        }
        Object posEval = this.pos().eval(this.pos().eval$default$1());
        return posEval == null || BoxesRunTime.unboxToInt((Object)posEval) > 0 ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure(new StringBuilder(47).append("Position expression must be positive, but got: ").append(posEval).toString());
    }

    private UTF8String lastRegex() {
        return this.lastRegex;
    }

    private void lastRegex_$eq(UTF8String x$1) {
        this.lastRegex = x$1;
    }

    private Pattern pattern() {
        return this.pattern;
    }

    private void pattern_$eq(Pattern x$1) {
        this.pattern = x$1;
    }

    private String lastReplacement() {
        return this.lastReplacement;
    }

    private void lastReplacement_$eq(String x$1) {
        this.lastReplacement = x$1;
    }

    private UTF8String lastReplacementInUTF8() {
        return this.lastReplacementInUTF8;
    }

    private void lastReplacementInUTF8_$eq(UTF8String x$1) {
        this.lastReplacementInUTF8 = x$1;
    }

    private StringBuffer result$lzycompute() {
        RegExpReplace regExpReplace = this;
        synchronized (regExpReplace) {
            if (!this.bitmap$trans$0) {
                this.result = new StringBuffer();
                this.bitmap$trans$0 = true;
            }
        }
        return this.result;
    }

    private StringBuffer result() {
        return !this.bitmap$trans$0 ? this.result$lzycompute() : this.result;
    }

    @Override
    public Object nullSafeEval(Object s, Object p, Object r, Object i) {
        Object object;
        if (!p.equals(this.lastRegex())) {
            this.lastRegex_$eq(((UTF8String)p).clone());
            this.pattern_$eq(Pattern.compile(this.lastRegex().toString()));
        }
        if (!r.equals(this.lastReplacementInUTF8())) {
            this.lastReplacementInUTF8_$eq(((UTF8String)r).clone());
            this.lastReplacement_$eq(this.lastReplacementInUTF8().toString());
        }
        String source = s.toString();
        int position = BoxesRunTime.unboxToInt((Object)i) - 1;
        if (position == 0 || position < source.length()) {
            Matcher m = this.pattern().matcher(source);
            m.region(position, source.length());
            this.result().delete(0, this.result().length());
            while (m.find()) {
                m.appendReplacement(this.result(), this.lastReplacement());
            }
            m.appendTail(this.result());
            object = UTF8String.fromString((String)this.result().toString());
        } else {
            object = s;
        }
        return object;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)StringType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$))));
    }

    @Override
    public String prettyName() {
        return "regexp_replace";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String termResult = ctx.freshName("termResult");
        String classNamePattern = Pattern.class.getCanonicalName();
        String classNameStringBuffer = StringBuffer.class.getCanonicalName();
        String matcher = ctx.freshName("matcher");
        String source = ctx.freshName("source");
        String position = ctx.freshName("position");
        String termLastRegex = ctx.addMutableState("UTF8String", "lastRegex", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termPattern = ctx.addMutableState(classNamePattern, "pattern", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termLastReplacement = ctx.addMutableState("String", "lastReplacement", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String termLastReplacementInUTF8 = ctx.addMutableState("UTF8String", "lastReplacementInUTF8", ctx.addMutableState$default$3(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
        String setEvNotNull = this.nullable() ? new StringBuilder(9).append(ev.isNull()).append(" = false;").toString() : "";
        return this.nullSafeCodeGen(ctx, ev, (Function4<String, String, String, String, String>)(Function4 & Serializable & scala.Serializable)(subject, regexp, rep, pos) -> new StringBuilder(619).append("\n      if (!").append((String)regexp).append(".equals(").append(termLastRegex).append(")) {\n        // regex value changed\n        ").append(termLastRegex).append(" = ").append((String)regexp).append(".clone();\n        ").append(termPattern).append(" = ").append(classNamePattern).append(".compile(").append(termLastRegex).append(".toString());\n      }\n      if (!").append((String)rep).append(".equals(").append(termLastReplacementInUTF8).append(")) {\n        // replacement string changed\n        ").append(termLastReplacementInUTF8).append(" = ").append((String)rep).append(".clone();\n        ").append(termLastReplacement).append(" = ").append(termLastReplacementInUTF8).append(".toString();\n      }\n      String ").append(source).append(" = ").append((String)subject).append(".toString();\n      int ").append(position).append(" = ").append((String)pos).append(" - 1;\n      if (").append(position).append(" == 0 || ").append(position).append(" < ").append(source).append(".length()) {\n        ").append(classNameStringBuffer).append(" ").append(termResult).append(" = new ").append(classNameStringBuffer).append("();\n        java.util.regex.Matcher ").append(matcher).append(" = ").append(termPattern).append(".matcher(").append(source).append(");\n        ").append(matcher).append(".region(").append(position).append(", ").append(source).append(".length());\n\n        while (").append(matcher).append(".find()) {\n          ").append(matcher).append(".appendReplacement(").append(termResult).append(", ").append(termLastReplacement).append(");\n        }\n        ").append(matcher).append(".appendTail(").append(termResult).append(");\n        ").append(ev.value()).append(" = UTF8String.fromString(").append(termResult).append(".toString());\n        ").append(termResult).append(" = null;\n      } else {\n        ").append(ev.value()).append(" = ").append((String)subject).append(";\n      }\n      ").append(setEvNotNull).append("\n    ").toString());
    }

    @Override
    public Expression first() {
        return this.subject();
    }

    @Override
    public Expression second() {
        return this.regexp();
    }

    @Override
    public Expression third() {
        return this.rep();
    }

    @Override
    public Expression fourth() {
        return this.pos();
    }

    @Override
    public RegExpReplace withNewChildrenInternal(Expression first, Expression second, Expression third, Expression fourth) {
        return this.copy(first, second, third, fourth);
    }

    public RegExpReplace copy(Expression subject, Expression regexp, Expression rep, Expression pos) {
        return new RegExpReplace(subject, regexp, rep, pos);
    }

    public Expression copy$default$1() {
        return this.subject();
    }

    public Expression copy$default$2() {
        return this.regexp();
    }

    public Expression copy$default$3() {
        return this.rep();
    }

    public Expression copy$default$4() {
        return this.pos();
    }

    @Override
    public String productPrefix() {
        return "RegExpReplace";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.subject();
                break;
            }
            case 1: {
                expression = this.regexp();
                break;
            }
            case 2: {
                expression = this.rep();
                break;
            }
            case 3: {
                expression = this.pos();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RegExpReplace;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RegExpReplace)) return false;
        boolean bl = true;
        if (!bl) return false;
        RegExpReplace regExpReplace = (RegExpReplace)x$1;
        Expression expression = this.subject();
        Expression expression2 = regExpReplace.subject();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.regexp();
        Expression expression4 = regExpReplace.regexp();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.rep();
        Expression expression6 = regExpReplace.rep();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.pos();
        Expression expression8 = regExpReplace.pos();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        if (!regExpReplace.canEqual(this)) return false;
        return true;
    }

    public RegExpReplace(Expression subject, Expression regexp, Expression rep, Expression pos) {
        this.subject = subject;
        this.regexp = regexp;
        this.rep = rep;
        this.pos = pos;
        ExpectsInputTypes.$init$(this);
    }

    public RegExpReplace(Expression subject, Expression regexp, Expression rep) {
        this(subject, regexp, rep, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1)));
    }
}

