/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib;

import dev.ludovic.netlib.blas.ForeignLinkerBLAS;
import dev.ludovic.netlib.blas.JNIBLAS;
import dev.ludovic.netlib.blas.Java11BLAS;
import dev.ludovic.netlib.blas.Java8BLAS;
import dev.ludovic.netlib.blas.VectorBLAS;
import java.util.logging.Logger;

final class InstanceBuilder {
    InstanceBuilder() {
    }

    public static final class JavaBLAS {
        private static final dev.ludovic.netlib.JavaBLAS instance = JavaBLAS.getInstanceImpl();

        public static dev.ludovic.netlib.JavaBLAS getInstance() {
            return instance;
        }

        private static dev.ludovic.netlib.JavaBLAS getInstanceImpl() {
            String[] fullVersion = System.getProperty("java.version").split("[+.\\-]+", 2);
            int major = Integer.parseInt(fullVersion[0]);
            if (major >= 16) {
                try {
                    return VectorBLAS.getInstance();
                }
                catch (Throwable t) {
                    Logger.getLogger(JavaBLAS.class.getName()).warning("Failed to load implementation from:" + VectorBLAS.class.getName());
                }
            }
            if (major >= 11) {
                return Java11BLAS.getInstance();
            }
            return Java8BLAS.getInstance();
        }
    }

    public static final class NativeBLAS {
        private static final dev.ludovic.netlib.NativeBLAS instance = NativeBLAS.getInstanceImpl();

        public static dev.ludovic.netlib.NativeBLAS getInstance() {
            return instance;
        }

        private static dev.ludovic.netlib.NativeBLAS getInstanceImpl() {
            try {
                return JNIBLAS.getInstance();
            }
            catch (Throwable t) {
                Logger.getLogger(NativeBLAS.class.getName()).warning("Failed to load implementation from:" + JNIBLAS.class.getName());
                try {
                    return ForeignLinkerBLAS.getInstance();
                }
                catch (Throwable t2) {
                    Logger.getLogger(NativeBLAS.class.getName()).warning("Failed to load implementation from:" + ForeignLinkerBLAS.class.getName());
                    throw new RuntimeException("Unable to load native implementation");
                }
            }
        }
    }

    public static final class BLAS {
        private static final dev.ludovic.netlib.BLAS instance = BLAS.getInstanceImpl();

        public static dev.ludovic.netlib.BLAS getInstance() {
            return instance;
        }

        private static dev.ludovic.netlib.BLAS getInstanceImpl() {
            try {
                return dev.ludovic.netlib.NativeBLAS.getInstance();
            }
            catch (Throwable t) {
                Logger.getLogger(BLAS.class.getName()).warning("Failed to load implementation from:" + dev.ludovic.netlib.NativeBLAS.class.getName());
                return dev.ludovic.netlib.JavaBLAS.getInstance();
            }
        }
    }
}

