/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.io.Serializable;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.CholeskyDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class LocalALS$ {
    public static LocalALS$ MODULE$;
    private int M;
    private int U;
    private int F;
    private int ITERATIONS;
    private final double LAMBDA;

    static {
        new LocalALS$();
    }

    public int M() {
        return this.M;
    }

    public void M_$eq(int x$1) {
        this.M = x$1;
    }

    public int U() {
        return this.U;
    }

    public void U_$eq(int x$1) {
        this.U = x$1;
    }

    public int F() {
        return this.F;
    }

    public void F_$eq(int x$1) {
        this.F = x$1;
    }

    public int ITERATIONS() {
        return this.ITERATIONS;
    }

    public void ITERATIONS_$eq(int x$1) {
        this.ITERATIONS = x$1;
    }

    public double LAMBDA() {
        return this.LAMBDA;
    }

    public RealMatrix generateR() {
        RealMatrix mh = this.randomMatrix(this.M(), this.F());
        RealMatrix uh = this.randomMatrix(this.U(), this.F());
        return mh.multiply(uh.transpose());
    }

    public double rmse(RealMatrix targetR, RealVector[] ms, RealVector[] us) {
        Array2DRowRealMatrix r = new Array2DRowRealMatrix(this.M(), this.U());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.M()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), MODULE$.U()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> r.setEntry(i, j, ms[i].dotProduct(us[j]))));
        RealMatrix diffs = r.subtract(targetR);
        DoubleRef sumSqs = DoubleRef.create((double)0.0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.M()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), MODULE$.U()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            double diff = diffs.getEntry(i, j);
            sumSqs$1.elem += diff * diff;
        }));
        return package$.MODULE$.sqrt(sumSqs.elem / ((double)this.M() * (double)this.U()));
    }

    public RealVector updateMovie(int i, RealVector m, RealVector[] us, RealMatrix R) {
        ObjectRef XtX = ObjectRef.create((Object)new Array2DRowRealMatrix(this.F(), this.F()));
        ObjectRef Xty = ObjectRef.create((Object)new ArrayRealVector(this.F()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.U()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            RealVector u = us[j];
            XtX$1.elem = ((RealMatrix)XtX$1.elem).add(u.outerProduct(u));
            Xty$1.elem = ((RealVector)Xty$1.elem).add(u.mapMultiply(R.getEntry(i, j)));
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.F()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)d -> ((RealMatrix)XtX$1.elem).addToEntry(d, d, MODULE$.LAMBDA() * (double)MODULE$.U()));
        return new CholeskyDecomposition((RealMatrix)XtX.elem).getSolver().solve((RealVector)Xty.elem);
    }

    public RealVector updateUser(int j, RealVector u, RealVector[] ms, RealMatrix R) {
        ObjectRef XtX = ObjectRef.create((Object)new Array2DRowRealMatrix(this.F(), this.F()));
        ObjectRef Xty = ObjectRef.create((Object)new ArrayRealVector(this.F()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.M()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            RealVector m = ms[i];
            XtX$2.elem = ((RealMatrix)XtX$2.elem).add(m.outerProduct(m));
            Xty$2.elem = ((RealVector)Xty$2.elem).add(m.mapMultiply(R.getEntry(i, j)));
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.F()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)d -> ((RealMatrix)XtX$2.elem).addToEntry(d, d, MODULE$.LAMBDA() * (double)MODULE$.M()));
        return new CholeskyDecomposition((RealMatrix)XtX.elem).getSolver().solve((RealVector)Xty.elem);
    }

    public void showWarning() {
        System.err.println(new StringOps(Predef$.MODULE$.augmentString("WARN: This is a naive implementation of ALS and is given as an example!\n        |Please use org.apache.spark.ml.recommendation.ALS\n        |for more conventional use.\n      ")).stripMargin());
    }

    public void main(String[] args) {
        String[] stringArray = args;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(4) == 0) {
            String m = (String)((SeqLike)option.get()).apply(0);
            String u = (String)((SeqLike)option.get()).apply(1);
            String f = (String)((SeqLike)option.get()).apply(2);
            String iters = (String)((SeqLike)option.get()).apply(3);
            this.M_$eq(new StringOps(Predef$.MODULE$.augmentString(m)).toInt());
            this.U_$eq(new StringOps(Predef$.MODULE$.augmentString(u)).toInt());
            this.F_$eq(new StringOps(Predef$.MODULE$.augmentString(f)).toInt());
            this.ITERATIONS_$eq(new StringOps(Predef$.MODULE$.augmentString(iters)).toInt());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            System.err.println("Usage: LocalALS <M> <U> <F> <iters>");
            System.exit(1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        this.showWarning();
        Predef$.MODULE$.println((Object)new StringBuilder(31).append("Running with M=").append(this.M()).append(", U=").append(this.U()).append(", F=").append(this.F()).append(", iters=").append(this.ITERATIONS()).toString());
        RealMatrix R = this.generateR();
        ObjectRef ms = ObjectRef.create((Object)((RealVector[])Array$.MODULE$.fill(this.M(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.randomVector(MODULE$.F()), ClassTag$.MODULE$.apply(RealVector.class))));
        ObjectRef us = ObjectRef.create((Object)((RealVector[])Array$.MODULE$.fill(this.U(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.randomVector(MODULE$.F()), ClassTag$.MODULE$.apply(RealVector.class))));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.ITERATIONS()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
            Predef$.MODULE$.println((Object)new StringBuilder(11).append("Iteration ").append(iter).append(":").toString());
            ms$3.elem = (RealVector[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), MODULE$.M()).map((Function1 & Serializable & scala.Serializable)i -> LocalALS$.MODULE$.updateMovie(BoxesRunTime.unboxToInt((Object)i), ((RealVector[])ms.elem)[BoxesRunTime.unboxToInt((Object)i)], (RealVector[])us.elem, R), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RealVector.class));
            us$3.elem = (RealVector[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), MODULE$.U()).map((Function1 & Serializable & scala.Serializable)j -> LocalALS$.MODULE$.updateUser(BoxesRunTime.unboxToInt((Object)j), ((RealVector[])us.elem)[BoxesRunTime.unboxToInt((Object)j)], (RealVector[])ms.elem, R), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(RealVector.class));
            Predef$.MODULE$.println((Object)new StringBuilder(7).append("RMSE = ").append(MODULE$.rmse(R, (RealVector[])ms$3.elem, (RealVector[])us$3.elem)).toString());
        });
    }

    private RealVector randomVector(int n) {
        return new ArrayRealVector((double[])Array$.MODULE$.fill(n, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> package$.MODULE$.random(), ClassTag$.MODULE$.Double()));
    }

    private RealMatrix randomMatrix(int rows, int cols) {
        return new Array2DRowRealMatrix((double[][])Array$.MODULE$.fill(rows, cols, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> package$.MODULE$.random(), ClassTag$.MODULE$.Double()));
    }

    private LocalALS$() {
        MODULE$ = this;
        this.M = 0;
        this.U = 0;
        this.F = 0;
        this.ITERATIONS = 0;
        this.LAMBDA = 0.01;
    }
}

