/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.client.CustomResource;
import io.fabric8.kubernetes.client.CustomResourceFluent;
import java.util.Objects;

public class CustomResourceFluentImpl<S, T, A extends CustomResourceFluent<S, T, A>>
extends BaseFluent<A>
implements CustomResourceFluent<S, T, A> {
    private ObjectMeta metadata;
    private S spec;
    private T status;
    private String kind;
    private String apiVersion;

    public CustomResourceFluentImpl() {
    }

    public CustomResourceFluentImpl(CustomResource<S, T> instance) {
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.withKind(instance.getKind());
        this.withApiVersion(instance.getApiVersion());
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public S getSpec() {
        return this.spec;
    }

    @Override
    public A withSpec(S spec) {
        this.spec = spec;
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public T getStatus() {
        return this.status;
    }

    @Override
    public A withStatus(T status) {
        this.status = status;
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomResourceFluentImpl that = (CustomResourceFluentImpl)o;
        if (this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.spec, this.status, this.kind, this.apiVersion, super.hashCode());
    }
}

