/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import org.apache.spark.Partitioner;
import org.apache.spark.mllib.linalg.distributed.GridPartitioner$;
import org.sparkproject.guava.base.Objects;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001}4QAG\u000e\u0001?\u001dB\u0001\u0002\f\u0001\u0003\u0006\u0004%\tA\f\u0005\tk\u0001\u0011\t\u0011)A\u0005_!Aa\u0007\u0001BC\u0002\u0013\u0005a\u0006\u0003\u00058\u0001\t\u0005\t\u0015!\u00030\u0011!A\u0004A!b\u0001\n\u0003q\u0003\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u0018\t\u0011i\u0002!Q1A\u0005\u00029B\u0001b\u000f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\u0006y\u0001!\t!\u0010\u0005\b\t\u0002\u0011\r\u0011\"\u0003/\u0011\u0019)\u0005\u0001)A\u0005_!9a\t\u0001b\u0001\n\u0013q\u0003BB$\u0001A\u0003%q\u0006C\u0004I\u0001\t\u0007I\u0011\t\u0018\t\r%\u0003\u0001\u0015!\u00030\u0011\u0015Q\u0005\u0001\"\u0011L\u0011\u0015\t\u0006\u0001\"\u0003S\u0011\u00159\u0006\u0001\"\u0011Y\u0011\u0015q\u0006\u0001\"\u0011`\u000f\u0019\u00017\u0004#\u0001 C\u001a1!d\u0007E\u0001?\tDQ\u0001P\u000b\u0005\u0002%DQA[\u000b\u0005\u0002-DQA[\u000b\u0005\u0002ADq!^\u000b\u0002\u0002\u0013%aOA\bHe&$\u0007+\u0019:uSRLwN\\3s\u0015\taR$A\u0006eSN$(/\u001b2vi\u0016$'B\u0001\u0010 \u0003\u0019a\u0017N\\1mO*\u0011\u0001%I\u0001\u0006[2d\u0017N\u0019\u0006\u0003E\r\nQa\u001d9be.T!\u0001J\u0013\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0013aA8sON\u0011\u0001\u0001\u000b\t\u0003S)j\u0011!I\u0005\u0003W\u0005\u00121\u0002U1si&$\u0018n\u001c8fe\u0006!!o\\<t\u0007\u0001)\u0012a\f\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0004\u0013:$\u0018!\u0002:poN\u0004\u0013\u0001B2pYN\fQaY8mg\u0002\n1B]8xgB+'\u000fU1si\u0006a!o\\<t!\u0016\u0014\b+\u0019:uA\u0005Y1m\u001c7t!\u0016\u0014\b+\u0019:u\u00031\u0019w\u000e\\:QKJ\u0004\u0016M\u001d;!\u0003\u0019a\u0014N\\5u}Q)a\bQ!C\u0007B\u0011q\bA\u0007\u00027!)A&\u0003a\u0001_!)a'\u0003a\u0001_!)\u0001(\u0003a\u0001_!)!(\u0003a\u0001_\u0005i!o\\<QCJ$\u0018\u000e^5p]N\faB]8x!\u0006\u0014H/\u001b;j_:\u001c\b%A\u0007d_2\u0004\u0016M\u001d;ji&|gn]\u0001\u000fG>d\u0007+\u0019:uSRLwN\\:!\u00035qW/\u001c)beRLG/[8og\u0006qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0013\u0001D4fiB\u000b'\u000f^5uS>tGCA\u0018M\u0011\u0015i\u0005\u00031\u0001O\u0003\rYW-\u001f\t\u0003a=K!\u0001U\u0019\u0003\u0007\u0005s\u00170\u0001\bhKR\u0004\u0016M\u001d;ji&|g.\u00133\u0015\u0007=\u001aV\u000bC\u0003U#\u0001\u0007q&A\u0001j\u0011\u00151\u0016\u00031\u00010\u0003\u0005Q\u0017AB3rk\u0006d7\u000f\u0006\u0002Z9B\u0011\u0001GW\u0005\u00037F\u0012qAQ8pY\u0016\fg\u000eC\u0003^%\u0001\u0007a*A\u0002pE*\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002_\u0005yqI]5e!\u0006\u0014H/\u001b;j_:,'\u000f\u0005\u0002@+M\u0019Qc\u00194\u0011\u0005A\"\u0017BA32\u0005\u0019\te.\u001f*fMB\u0011\u0001gZ\u0005\u0003QF\u0012AbU3sS\u0006d\u0017N_1cY\u0016$\u0012!Y\u0001\u0006CB\u0004H.\u001f\u000b\u0006}1lgn\u001c\u0005\u0006Y]\u0001\ra\f\u0005\u0006m]\u0001\ra\f\u0005\u0006q]\u0001\ra\f\u0005\u0006u]\u0001\ra\f\u000b\u0005}E\u00148\u000fC\u0003-1\u0001\u0007q\u0006C\u000371\u0001\u0007q\u0006C\u0003u1\u0001\u0007q&\u0001\ftk\u001e<Wm\u001d;fI:+X\u000eU1si&$\u0018n\u001c8t\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0003]\u0004\"\u0001_?\u000e\u0003eT!A_>\u0002\t1\fgn\u001a\u0006\u0002y\u0006!!.\u0019<b\u0013\tq\u0018P\u0001\u0004PE*,7\r\u001e")
public class GridPartitioner
extends Partitioner {
    private final int rows;
    private final int cols;
    private final int rowsPerPart;
    private final int colsPerPart;
    private final int rowPartitions;
    private final int colPartitions;
    private final int numPartitions;

    public static GridPartitioner apply(int n, int n2, int n3) {
        return GridPartitioner$.MODULE$.apply(n, n2, n3);
    }

    public static GridPartitioner apply(int n, int n2, int n3, int n4) {
        return GridPartitioner$.MODULE$.apply(n, n2, n3, n4);
    }

    public int rows() {
        return this.rows;
    }

    public int cols() {
        return this.cols;
    }

    public int rowsPerPart() {
        return this.rowsPerPart;
    }

    public int colsPerPart() {
        return this.colsPerPart;
    }

    private int rowPartitions() {
        return this.rowPartitions;
    }

    private int colPartitions() {
        return this.colPartitions;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPartition(Object key) {
        Object object = key;
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return n;
        }
        if (object instanceof Tuple2) {
            Tuple2 tuple2 = (Tuple2)object;
            Object i = tuple2._1();
            Object j = tuple2._2();
            if (i instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)i);
                if (j instanceof Integer) {
                    int n2 = BoxesRunTime.unboxToInt((Object)j);
                    return this.getPartitionId(n, n2);
                }
            }
        }
        if (!(object instanceof Tuple3)) throw new IllegalArgumentException(new StringBuilder(19).append("Unrecognized key: ").append(key).append(".").toString());
        Tuple3 tuple3 = (Tuple3)object;
        Object i = tuple3._1();
        Object j = tuple3._2();
        if (!(i instanceof Integer)) throw new IllegalArgumentException(new StringBuilder(19).append("Unrecognized key: ").append(key).append(".").toString());
        int n = BoxesRunTime.unboxToInt((Object)i);
        if (!(j instanceof Integer)) throw new IllegalArgumentException(new StringBuilder(19).append("Unrecognized key: ").append(key).append(".").toString());
        int n3 = BoxesRunTime.unboxToInt((Object)j);
        if (!(tuple3._3() instanceof Integer)) throw new IllegalArgumentException(new StringBuilder(19).append("Unrecognized key: ").append(key).append(".").toString());
        return this.getPartitionId(n, n3);
    }

    private int getPartitionId(int i, int j) {
        Predef$.MODULE$.require(0 <= i && i < this.rows(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(30).append("Row index ").append(i).append(" out of range [0, ").append(this.rows()).append(").").toString());
        Predef$.MODULE$.require(0 <= j && j < this.cols(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(33).append("Column index ").append(j).append(" out of range [0, ").append(this.cols()).append(").").toString());
        return i / this.rowsPerPart() + j / this.colsPerPart() * this.rowPartitions();
    }

    public boolean equals(Object obj) {
        boolean bl;
        Object object = obj;
        if (object instanceof GridPartitioner) {
            GridPartitioner gridPartitioner = (GridPartitioner)((Object)object);
            bl = this.rows() == gridPartitioner.rows() && this.cols() == gridPartitioner.cols() && this.rowsPerPart() == gridPartitioner.rowsPerPart() && this.colsPerPart() == gridPartitioner.colsPerPart();
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Predef$.MODULE$.int2Integer(this.rows()), Predef$.MODULE$.int2Integer(this.cols()), Predef$.MODULE$.int2Integer(this.rowsPerPart()), Predef$.MODULE$.int2Integer(this.colsPerPart())});
    }

    public GridPartitioner(int rows, int cols, int rowsPerPart, int colsPerPart) {
        this.rows = rows;
        this.cols = cols;
        this.rowsPerPart = rowsPerPart;
        this.colsPerPart = colsPerPart;
        Predef$.MODULE$.require(rows > 0);
        Predef$.MODULE$.require(cols > 0);
        Predef$.MODULE$.require(rowsPerPart > 0);
        Predef$.MODULE$.require(colsPerPart > 0);
        this.rowPartitions = (int)package$.MODULE$.ceil((double)rows * 1.0 / (double)rowsPerPart);
        this.colPartitions = (int)package$.MODULE$.ceil((double)cols * 1.0 / (double)colsPerPart);
        this.numPartitions = this.rowPartitions() * this.colPartitions();
    }
}

