/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.RLike$;
import org.apache.spark.sql.catalyst.expressions.StringRegexExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(str, regexp) - Returns true if `str` matches `regexp`, or false otherwise.", arguments="\n    Arguments:\n      * str - a string expression\n      * regexp - a string expression. The regex string should be a Java regular expression.<br><br>\n          Since Spark 2.0, string literals (including regex patterns) are unescaped in our SQL\n          parser. For example, to match \"\\abc\", a regular expression for `regexp` can be\n          \"^\\\\abc$\".<br><br>\n          There is a SQL config 'spark.sql.parser.escapedStringLiterals' that can be used to\n          fallback to the Spark 1.6 behavior regarding string literal parsing. For example,\n          if the config is enabled, the `regexp` that can match \"\\abc\" is \"^\\abc$\".\n  ", examples="\n    Examples:\n      > SET spark.sql.parser.escapedStringLiterals=true;\n      spark.sql.parser.escapedStringLiterals\ttrue\n      > SELECT _FUNC_('%SystemDrive%\\Users\\John', '%SystemDrive%\\\\Users.*');\n      true\n      > SET spark.sql.parser.escapedStringLiterals=false;\n      spark.sql.parser.escapedStringLiterals\tfalse\n      > SELECT _FUNC_('%SystemDrive%\\\\Users\\\\John', '%SystemDrive%\\\\\\\\Users.*');\n      true\n  ", note="\n    Use LIKE to match with simple string pattern.\n  ", since="1.0.0", group="predicate_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001\u0002\u000f\u001e\u0001*B\u0001\u0002\u000f\u0001\u0003\u0016\u0004%\t!\u000f\u0005\t{\u0001\u0011\t\u0012)A\u0005u!Aa\b\u0001BK\u0002\u0013\u0005\u0011\b\u0003\u0005@\u0001\tE\t\u0015!\u0003;\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0011\u0015)\u0005\u0001\"\u0011G\u0011\u0015!\u0006\u0001\"\u0011V\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015\u0011\u0003\u0001\"\u0011i\u0011\u0015I\u0007\u0001\"\u0015k\u0011\u0015A\b\u0001\"\u0015z\u0011\u001dq\b!!A\u0005\u0002}D\u0011\"!\u0002\u0001#\u0003%\t!a\u0002\t\u0013\u0005u\u0001!%A\u0005\u0002\u0005\u001d\u0001\"CA\u0010\u0001\u0005\u0005I\u0011IA\u0011\u0011%\ti\u0003AA\u0001\n\u0003\ty\u0003C\u0005\u00028\u0001\t\t\u0011\"\u0001\u0002:!I\u0011Q\t\u0001\u0002\u0002\u0013\u0005\u0013q\t\u0005\n\u0003+\u0002\u0011\u0011!C\u0001\u0003/B\u0011\"a\u0017\u0001\u0003\u0003%\t%!\u0018\b\u0013\u00055U$!A\t\u0002\u0005=e\u0001\u0003\u000f\u001e\u0003\u0003E\t!!%\t\r\u00013B\u0011AAP\u0011!1g#!A\u0005F\u0005\u0005\u0006\"CAR-\u0005\u0005I\u0011QAS\u0011%\tYKFA\u0001\n\u0003\u000bi\u000bC\u0005\u0002@Z\t\t\u0011\"\u0003\u0002B\n)!\u000bT5lK*\u0011adH\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002!C\u0005A1-\u0019;bYf\u001cHO\u0003\u0002#G\u0005\u00191/\u001d7\u000b\u0005\u0011*\u0013!B:qCJ\\'B\u0001\u0014(\u0003\u0019\t\u0007/Y2iK*\t\u0001&A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001W=*\u0004C\u0001\u0017.\u001b\u0005i\u0012B\u0001\u0018\u001e\u0005U\u0019FO]5oOJ+w-\u001a=FqB\u0014Xm]:j_:\u0004\"\u0001M\u001a\u000e\u0003ER\u0011AM\u0001\u0006g\u000e\fG.Y\u0005\u0003iE\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00021m%\u0011q'\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0005Y\u00164G/F\u0001;!\ta3(\u0003\u0002=;\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\u000b1,g\r\u001e\u0011\u0002\u000bILw\r\u001b;\u0002\rILw\r\u001b;!\u0003\u0019a\u0014N\\5u}Q\u0019!i\u0011#\u0011\u00051\u0002\u0001\"\u0002\u001d\u0006\u0001\u0004Q\u0004\"\u0002 \u0006\u0001\u0004Q\u0014AB3tG\u0006\u0004X\r\u0006\u0002H%B\u0011\u0001j\u0014\b\u0003\u00136\u0003\"AS\u0019\u000e\u0003-S!\u0001T\u0015\u0002\rq\u0012xn\u001c;?\u0013\tq\u0015'\u0001\u0004Qe\u0016$WMZ\u0005\u0003!F\u0013aa\u0015;sS:<'B\u0001(2\u0011\u0015\u0019f\u00011\u0001H\u0003\u00051\u0018aB7bi\u000eDWm\u001d\u000b\u0004-f#\u0007C\u0001\u0019X\u0013\tA\u0016GA\u0004C_>dW-\u00198\t\u000bi;\u0001\u0019A.\u0002\u000bI,w-\u001a=\u0011\u0005q\u0013W\"A/\u000b\u0005is&BA0a\u0003\u0011)H/\u001b7\u000b\u0003\u0005\fAA[1wC&\u00111-\u0018\u0002\b!\u0006$H/\u001a:o\u0011\u0015)w\u00011\u0001H\u0003\r\u0019HO]\u0001\ti>\u001cFO]5oOR\tq)F\u0001H\u0003%!wnR3o\u0007>$W\rF\u0002lcZ\u0004\"\u0001\\8\u000e\u00035T!A\\\u000f\u0002\u000f\r|G-Z4f]&\u0011\u0001/\u001c\u0002\t\u000bb\u0004(oQ8eK\")!O\u0003a\u0001g\u0006\u00191\r\u001e=\u0011\u00051$\u0018BA;n\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQa\u001e\u0006A\u0002-\f!!\u001a<\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGc\u0001\"{y\")1p\u0003a\u0001u\u00059a.Z<MK\u001a$\b\"B?\f\u0001\u0004Q\u0014\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\u0006\u0005\u0006\u0005\u00111\u0001\u0005\bq1\u0001\n\u00111\u0001;\u0011\u001dqD\u0002%AA\u0002i\nabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\n)\u001a!(a\u0003,\u0005\u00055\u0001\u0003BA\b\u00033i!!!\u0005\u000b\t\u0005M\u0011QC\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u00062\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\t\tBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003G\u0001B!!\n\u0002,5\u0011\u0011q\u0005\u0006\u0004\u0003S\u0001\u0017\u0001\u00027b]\u001eL1\u0001UA\u0014\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t\u0004E\u00021\u0003gI1!!\u000e2\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tY$!\u0011\u0011\u0007A\ni$C\u0002\u0002@E\u00121!\u00118z\u0011%\t\u0019%EA\u0001\u0002\u0004\t\t$A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0013\u0002b!a\u0013\u0002R\u0005mRBAA'\u0015\r\ty%M\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA*\u0003\u001b\u0012\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019a+!\u0017\t\u0013\u0005\r3#!AA\u0002\u0005m\u0012AB3rk\u0006d7\u000fF\u0002W\u0003?B\u0011\"a\u0011\u0015\u0003\u0003\u0005\r!a\u000f)7\u0001\t\u0019'!\u001b\u0002l\u0005=\u0014\u0011OA;\u0003o\nY(! \u0002\u0002\u0006\r\u0015qQAE!\ra\u0013QM\u0005\u0004\u0003Oj\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003[\n\u0011k\u0018$V\u001d\u000e{\u0006f\u001d;sY\u0001\u0012XmZ3ya&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011ueV,\u0007%\u001b4!AN$(\u000f\u0019\u0011nCR\u001c\u0007.Z:!AJ,w-\u001a=qA2\u0002sN\u001d\u0011gC2\u001cX\rI8uQ\u0016\u0014x/[:f]\u0005I\u0011M]4v[\u0016tGo]\u0011\u0003\u0003g\nAQ\u001f\u0006!A\u0001\u0002\u0013I]4v[\u0016tGo\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM$(\u000fI\u0017!C\u0002\u001aHO]5oO\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0006!A\u0001\u0002\u0003\u0005\t\u0016!e\u0016<W\r\u001f9![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8o]\u0001\"\u0006.\u001a\u0011sK\u001e,\u0007\u0010I:ue&tw\rI:i_VdG\r\t2fA\u0005\u0004#*\u0019<bAI,w-\u001e7be\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0018=EJtDH\u0019:?\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003eU5oG\u0016\u00043\u000b]1sW\u0002\u0012d\u0006\r\u0017!gR\u0014\u0018N\\4!Y&$XM]1mg\u0002B\u0013N\\2mk\u0012Lgn\u001a\u0011sK\u001e,\u0007\u0010\t9biR,'O\\:*A\u0005\u0014X\rI;oKN\u001c\u0017\r]3eA%t\u0007e\\;sAM\u000bFJ\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!AA\f'o]3s]\u00012uN\u001d\u0011fq\u0006l\u0007\u000f\\3-AQ|\u0007%\\1uG\"\u0004#\u0005X1cG\nb\u0003%\u0019\u0011sK\u001e,H.\u0019:!Kb\u0004(/Z:tS>t\u0007EZ8sA\u0001\u0014XmZ3ya\u0002\u00043-\u00198!E\u0016T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011#=rc\u0016MY2%E9b$M\u001d =EJt$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!)\",'/\u001a\u0011jg\u0002\n\u0007eU)MA\r|gNZ5hA\u001d\u001a\b/\u0019:l]M\fHN\f9beN,'OL3tG\u0006\u0004X\rZ*ue&tw\rT5uKJ\fGn]\u0014!i\"\fG\u000fI2b]\u0002\u0012W\rI;tK\u0012\u0004Co\u001c\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u00012\u0017\r\u001c7cC\u000e\\\u0007\u0005^8!i\",\u0007e\u00159be.\u0004\u0013G\f\u001c!E\u0016D\u0017M^5pe\u0002\u0012XmZ1sI&tw\rI:ue&tw\r\t7ji\u0016\u0014\u0018\r\u001c\u0011qCJ\u001c\u0018N\\4/A\u0019{'\u000fI3yC6\u0004H.\u001a\u0017\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0013N\u001a\u0011uQ\u0016\u00043m\u001c8gS\u001e\u0004\u0013n\u001d\u0011f]\u0006\u0014G.\u001a3-AQDW\r\t1sK\u001e,\u0007\u0010\u001d1!i\"\fG\u000fI2b]\u0002j\u0017\r^2iA\tb\u0016MY2#A%\u001c\bE\t0]C\n\u001cGE\t\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003s\n11\b\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016#\u0006e\u001d9be.t3/\u001d7/a\u0006\u00148/\u001a:/KN\u001c\u0017\r]3e'R\u0014\u0018N\\4MSR,'/\u00197t{Q\u0014X/Z\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011ta\u0006\u00148NL:rY:\u0002\u0018M]:fe:*7oY1qK\u0012\u001cFO]5oO2KG/\u001a:bYNLAO];f\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":SeU=ti\u0016lGI]5wK\u0016bVk]3sgrSu\u000e\u001b8(Y\u0001:SeU=ti\u0016lGI]5wK\u0016bF,V:feNt#fJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!iJ,XM\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000bR\u00033\u000f]1sW:\u001a\u0018\u000f\u001c\u0018qCJ\u001cXM\u001d\u0018fg\u000e\f\u0007/\u001a3TiJLgn\u001a'ji\u0016\u0014\u0018\r\\:>M\u0006d7/Z\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011ta\u0006\u00148NL:rY:\u0002\u0018M]:fe:*7oY1qK\u0012\u001cFO]5oO2KG/\u001a:bYNLa-\u00197tK*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cs%J*zgR,W\u000e\u0012:jm\u0016,C\fX+tKJ\u001cH\f\u0018&pQ:<C\u0006I\u0014&'f\u001cH/Z7Ee&4X-\n/]9r+6/\u001a:t]):\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t;sk\u0016T\u0001\u0005I\u0001\u0005]>$X-\t\u0002\u0002\u0000\u0005)$\u0002\t\u0011!AU\u001bX\r\t'J\u0017\u0016\u0003Co\u001c\u0011nCR\u001c\u0007\u000eI<ji\"\u00043/[7qY\u0016\u00043\u000f\u001e:j]\u001e\u0004\u0003/\u0019;uKJtgF\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t))A\u00032]Ar\u0003'A\u0003he>,\b/\t\u0002\u0002\f\u0006y\u0001O]3eS\u000e\fG/Z0gk:\u001c7/A\u0003S\u0019&\\W\r\u0005\u0002--M!a#a%6!\u001d\t)*a';u\tk!!a&\u000b\u0007\u0005e\u0015'A\u0004sk:$\u0018.\\3\n\t\u0005u\u0015q\u0013\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAAH)\t\t\u0019#A\u0003baBd\u0017\u0010F\u0003C\u0003O\u000bI\u000bC\u000393\u0001\u0007!\bC\u0003?3\u0001\u0007!(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005=\u00161\u0018\t\u0006a\u0005E\u0016QW\u0005\u0004\u0003g\u000b$AB(qi&|g\u000eE\u00031\u0003oS$(C\u0002\u0002:F\u0012a\u0001V;qY\u0016\u0014\u0004\u0002CA_5\u0005\u0005\t\u0019\u0001\"\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAAb!\u0011\t)#!2\n\t\u0005\u001d\u0017q\u0005\u0002\u0007\u001f\nTWm\u0019;")
public class RLike
extends StringRegexExpression
implements scala.Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(RLike rLike) {
        return RLike$.MODULE$.unapply(rLike);
    }

    public static Function1<Tuple2<Expression, Expression>, RLike> tupled() {
        return RLike$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, RLike>> curried() {
        return RLike$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public String escape(String v) {
        return v;
    }

    @Override
    public boolean matches(Pattern regex, String str) {
        return regex.matcher(str).find(0);
    }

    @Override
    public String toString() {
        return new StringBuilder(9).append("RLIKE(").append(this.left()).append(", ").append(this.right()).append(")").toString();
    }

    @Override
    public String sql() {
        return new StringBuilder(4).append(this.prettyName().toUpperCase(Locale.ROOT)).append("(").append(this.left().sql()).append(", ").append(this.right().sql()).append(")").toString();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String patternClass = Pattern.class.getName();
        if (this.right().foldable()) {
            Object rVal = this.right().eval(this.right().eval$default$1());
            if (rVal != null) {
                String regexStr = StringEscapeUtils.escapeJava((String)((UTF8String)rVal).toString());
                String pattern = ctx.addMutableState(patternClass, "patternRLike", (Function1<String, String>)(Function1 & Serializable & scala.Serializable)v -> new StringBuilder(16).append((String)v).append(" = ").append(patternClass).append(".compile(\"").append(regexStr).append("\");").toString(), ctx.addMutableState$default$4(), ctx.addMutableState$default$5());
                ExprCode eval = this.left().genCode(ctx);
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = ", ";\n          ", " ", " = ", ";\n          if (!", ") {\n            ", " = ", ".matcher(", ".toString()).find(0);\n          }\n        "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eval.code(), ev.isNull(), eval.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), ev.isNull(), ev.value(), pattern, eval.value()})), ev.copy$default$2(), ev.copy$default$3());
            } else {
                exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          boolean ", " = true;\n          ", " ", " = ", ";\n        "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2())})), ev.copy$default$2(), ev.copy$default$3());
            }
        } else {
            String rightStr = ctx.freshName("rightStr");
            String pattern = ctx.freshName("pattern");
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(eval1, eval2) -> new StringBuilder(112).append("\n          String ").append(rightStr).append(" = ").append((String)eval2).append(".toString();\n          ").append(patternClass).append(" ").append(pattern).append(" = ").append(patternClass).append(".compile(").append(rightStr).append(");\n          ").append(ev.value()).append(" = ").append(pattern).append(".matcher(").append((String)eval1).append(".toString()).find(0);\n        ").toString());
        }
        return exprCode;
    }

    @Override
    public RLike withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public RLike copy(Expression left, Expression right) {
        return new RLike(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "RLike";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RLike;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RLike)) return false;
        boolean bl = true;
        if (!bl) return false;
        RLike rLike = (RLike)x$1;
        Expression expression = this.left();
        Expression expression2 = rLike.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = rLike.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!rLike.canEqual(this)) return false;
        return true;
    }

    public RLike(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
}

