/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.ProjectionOverSchema;
import org.apache.spark.sql.catalyst.expressions.SchemaPruning;
import org.apache.spark.sql.catalyst.planning.PhysicalOperation$;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LeafNode;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.SchemaUtils$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class SchemaPruning$
extends Rule<LogicalPlan> {
    public static SchemaPruning$ MODULE$;

    static {
        new SchemaPruning$();
    }

    public LogicalPlan apply(LogicalPlan plan) {
        return this.conf().nestedSchemaPruningEnabled() ? this.apply0(plan) : plan;
    }

    private LogicalPlan apply0(LogicalPlan plan) {
        return (LogicalPlan)plan.transformDown((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = PhysicalOperation$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    HadoopFsRelation hadoopFsRelation;
                    LogicalRelation logicalRelation;
                    BaseRelation hadoopFsRelation2;
                    Seq projects = (Seq)((Tuple3)option.get())._1();
                    Seq filters = (Seq)((Tuple3)option.get())._2();
                    LogicalPlan l = (LogicalPlan)((Tuple3)option.get())._3();
                    if (l instanceof LogicalRelation && (hadoopFsRelation2 = (logicalRelation = (LogicalRelation)l).relation()) instanceof HadoopFsRelation && SchemaPruning$.MODULE$.org$apache$spark$sql$execution$datasources$SchemaPruning$$canPruneRelation(hadoopFsRelation = (HadoopFsRelation)hadoopFsRelation2)) {
                        object = SchemaPruning$.MODULE$.org$apache$spark$sql$execution$datasources$SchemaPruning$$prunePhysicalColumns(logicalRelation.output(), (Seq<NamedExpression>)projects, (Seq<Expression>)filters, hadoopFsRelation.dataSchema(), (Function1<StructType, LeafNode>)(Function1 & Serializable & scala.Serializable)prunedDataSchema -> {
                            StructType x$1 = prunedDataSchema;
                            FileIndex x$2 = hadoopFsRelation.copy$default$1();
                            StructType x$3 = hadoopFsRelation.copy$default$2();
                            Option<BucketSpec> x$4 = hadoopFsRelation.copy$default$4();
                            FileFormat x$5 = hadoopFsRelation.copy$default$5();
                            Map<String, String> x$6 = hadoopFsRelation.copy$default$6();
                            SparkSession x$7 = hadoopFsRelation.sparkSession();
                            HadoopFsRelation prunedHadoopRelation = hadoopFsRelation.copy(x$2, x$3, x$1, x$4, x$5, x$6, x$7);
                            return SchemaPruning$.MODULE$.org$apache$spark$sql$execution$datasources$SchemaPruning$$buildPrunedRelation(logicalRelation, prunedHadoopRelation);
                        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> A1);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                HadoopFsRelation hadoopFsRelation;
                LogicalRelation logicalRelation;
                BaseRelation hadoopFsRelation2;
                LogicalPlan l;
                LogicalPlan logicalPlan2 = x1;
                Option option = PhysicalOperation$.MODULE$.unapply(logicalPlan2);
                boolean bl = !option.isEmpty() && (l = (LogicalPlan)((Tuple3)option.get())._3()) instanceof LogicalRelation && (hadoopFsRelation2 = (logicalRelation = (LogicalRelation)l).relation()) instanceof HadoopFsRelation && SchemaPruning$.MODULE$.org$apache$spark$sql$execution$datasources$SchemaPruning$$canPruneRelation(hadoopFsRelation = (HadoopFsRelation)hadoopFsRelation2);
                return bl;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.datasources.HadoopFsRelation org.apache.spark.sql.execution.datasources.LogicalRelation org.apache.spark.sql.types.StructType ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan )}, serializedLambda);
            }
        });
    }

    public Option<LogicalPlan> org$apache$spark$sql$execution$datasources$SchemaPruning$$prunePhysicalColumns(Seq<AttributeReference> output, Seq<NamedExpression> projects, Seq<Expression> filters, StructType dataSchema, Function1<StructType, LeafNode> leafNodeBuilder) {
        None$ none$;
        Tuple2<Seq<NamedExpression>, Seq<Expression>> tuple2 = this.normalizeAttributeRefNames(output, projects, filters);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq normalizedProjects = (Seq)tuple2._1();
        Seq normalizedFilters = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)normalizedProjects, (Object)normalizedFilters);
        Tuple2 tuple23 = tuple22;
        Seq normalizedProjects2 = (Seq)tuple23._1();
        Seq normalizedFilters2 = (Seq)tuple23._2();
        Seq requestedRootFields = org.apache.spark.sql.catalyst.expressions.SchemaPruning$.MODULE$.identifyRootFields(normalizedProjects2, normalizedFilters2);
        if (requestedRootFields.exists((Function1 & Serializable & scala.Serializable)root -> BoxesRunTime.boxToBoolean((boolean)SchemaPruning$.$anonfun$prunePhysicalColumns$1(root)))) {
            StructType prunedDataSchema = org.apache.spark.sql.catalyst.expressions.SchemaPruning$.MODULE$.pruneDataSchema(dataSchema, requestedRootFields);
            if (this.countLeaves((DataType)dataSchema) > this.countLeaves((DataType)prunedDataSchema)) {
                LeafNode prunedRelation = (LeafNode)leafNodeBuilder.apply((Object)prunedDataSchema);
                ProjectionOverSchema projectionOverSchema = new ProjectionOverSchema(prunedDataSchema, AttributeSet$.MODULE$.apply(output));
                none$ = new Some((Object)this.buildNewProjection(projects, (Seq<NamedExpression>)normalizedProjects2, (Seq<Expression>)normalizedFilters2, prunedRelation, projectionOverSchema));
            } else {
                none$ = None$.MODULE$;
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public boolean org$apache$spark$sql$execution$datasources$SchemaPruning$$canPruneRelation(HadoopFsRelation fsRelation) {
        return fsRelation.fileFormat() instanceof ParquetFileFormat || fsRelation.fileFormat() instanceof OrcFileFormat;
    }

    private Tuple2<Seq<NamedExpression>, Seq<Expression>> normalizeAttributeRefNames(Seq<AttributeReference> output, Seq<NamedExpression> projects, Seq<Expression> filters) {
        Map normalizedAttNameMap = ((TraversableOnce)output.map((Function1 & Serializable & scala.Serializable)att -> new Tuple2((Object)att.exprId(), (Object)att.name()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq normalizedProjects = (Seq)((TraversableLike)projects.map((Function1 & Serializable & scala.Serializable)x$2 -> (Expression)((TreeNode)x$2).transform((PartialFunction)new scala.Serializable(normalizedAttNameMap){
            public static final long serialVersionUID = 0L;
            private final Map normalizedAttNameMap$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                AttributeReference attributeReference;
                A1 A1 = x1;
                Object object = A1 instanceof AttributeReference && this.normalizedAttNameMap$1.contains((Object)(attributeReference = (AttributeReference)A1).exprId()) ? attributeReference.withName((String)this.normalizedAttNameMap$1.apply((Object)attributeReference.exprId())) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                AttributeReference attributeReference;
                Expression expression = x1;
                boolean bl = expression instanceof AttributeReference && this.normalizedAttNameMap$1.contains((Object)(attributeReference = (AttributeReference)expression).exprId());
                return bl;
            }
            {
                this.normalizedAttNameMap$1 = normalizedAttNameMap$1;
            }
        }), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            NamedExpression namedExpression;
            Expression expression = x0$1;
            if (!(expression instanceof NamedExpression)) {
                throw new MatchError((Object)expression);
            }
            NamedExpression namedExpression2 = namedExpression = (NamedExpression)expression;
            return namedExpression2;
        }, Seq$.MODULE$.canBuildFrom());
        Seq normalizedFilters = (Seq)filters.map((Function1 & Serializable & scala.Serializable)x$3 -> (Expression)x$3.transform((PartialFunction)new scala.Serializable(normalizedAttNameMap){
            public static final long serialVersionUID = 0L;
            private final Map normalizedAttNameMap$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                AttributeReference attributeReference;
                A1 A1 = x2;
                Object object = A1 instanceof AttributeReference && this.normalizedAttNameMap$1.contains((Object)(attributeReference = (AttributeReference)A1).exprId()) ? attributeReference.withName((String)this.normalizedAttNameMap$1.apply((Object)attributeReference.exprId())) : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x2) {
                AttributeReference attributeReference;
                Expression expression = x2;
                boolean bl = expression instanceof AttributeReference && this.normalizedAttNameMap$1.contains((Object)(attributeReference = (AttributeReference)expression).exprId());
                return bl;
            }
            {
                this.normalizedAttNameMap$1 = normalizedAttNameMap$1;
            }
        }), Seq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)normalizedProjects, (Object)normalizedFilters);
    }

    private Project buildNewProjection(Seq<NamedExpression> projects, Seq<NamedExpression> normalizedProjects, Seq<Expression> filters, LeafNode leafNode, ProjectionOverSchema projectionOverSchema) {
        LogicalPlan logicalPlan2;
        if (filters.nonEmpty()) {
            Seq projectedFilters = (Seq)filters.map((Function1 & Serializable & scala.Serializable)x$4 -> (Expression)x$4.transformDown((PartialFunction)new scala.Serializable(projectionOverSchema){
                public static final long serialVersionUID = 0L;
                private final ProjectionOverSchema projectionOverSchema$1;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    Option option = this.projectionOverSchema$1.unapply(A1);
                    if (!option.isEmpty()) {
                        Expression expr = (Expression)option.get();
                        object = expr;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Expression x1) {
                    Expression expression = x1;
                    Option option = this.projectionOverSchema$1.unapply(expression);
                    boolean bl = !option.isEmpty();
                    return bl;
                }
                {
                    this.projectionOverSchema$1 = projectionOverSchema$1;
                }
            }), Seq$.MODULE$.canBuildFrom());
            Expression newFilterCondition = (Expression)projectedFilters.reduce((Function2)And$.MODULE$);
            logicalPlan2 = new Filter(newFilterCondition, (LogicalPlan)leafNode);
        } else {
            logicalPlan2 = (LogicalPlan)leafNode;
        }
        LogicalPlan projectionChild = logicalPlan2;
        Seq newProjects = (Seq)((TraversableLike)normalizedProjects.map((Function1 & Serializable & scala.Serializable)x$5 -> (Expression)((TreeNode)x$5).transformDown((PartialFunction)new scala.Serializable(projectionOverSchema){
            public static final long serialVersionUID = 0L;
            private final ProjectionOverSchema projectionOverSchema$1;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                Option option = this.projectionOverSchema$1.unapply(A1);
                if (!option.isEmpty()) {
                    Expression expr = (Expression)option.get();
                    object = expr;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                Option option = this.projectionOverSchema$1.unapply(expression);
                boolean bl = !option.isEmpty();
                return bl;
            }
            {
                this.projectionOverSchema$1 = projectionOverSchema$1;
            }
        }), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            NamedExpression namedExpression;
            Expression expression = x0$1;
            if (!(expression instanceof NamedExpression)) {
                throw new MatchError((Object)expression);
            }
            NamedExpression namedExpression2 = namedExpression = (NamedExpression)expression;
            return namedExpression2;
        }, Seq$.MODULE$.canBuildFrom());
        if (this.log().isDebugEnabled()) {
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("New projects:\n").append(((TraversableOnce)newProjects.map((Function1 & Serializable & scala.Serializable)x$6 -> ((TreeNode)x$6).treeString(), Seq$.MODULE$.canBuildFrom())).mkString("\n")).toString());
        }
        return new Project(SchemaUtils$.MODULE$.restoreOriginalOutputNames(newProjects, (Seq)projects.map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.name(), Seq$.MODULE$.canBuildFrom())), projectionChild);
    }

    public LogicalRelation org$apache$spark$sql$execution$datasources$SchemaPruning$$buildPrunedRelation(LogicalRelation outputRelation, HadoopFsRelation prunedBaseRelation) {
        Seq<AttributeReference> prunedOutput = this.getPrunedOutput(outputRelation.output(), prunedBaseRelation.schema());
        return outputRelation.copy(prunedBaseRelation, prunedOutput, outputRelation.copy$default$3(), outputRelation.copy$default$4());
    }

    private Seq<AttributeReference> getPrunedOutput(Seq<AttributeReference> output, StructType requiredSchema) {
        Map outputIdMap = ((TraversableOnce)output.map((Function1 & Serializable & scala.Serializable)att -> new Tuple2((Object)att.name(), (Object)att.exprId()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return (Seq)requiredSchema.toAttributes().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AttributeReference attributeReference = x0$1;
            AttributeReference attributeReference2 = outputIdMap.contains((Object)attributeReference.name()) ? attributeReference.withExprId((ExprId)outputIdMap.apply((Object)attributeReference.name())) : attributeReference;
            return attributeReference2;
        }, Seq$.MODULE$.canBuildFrom());
    }

    private int countLeaves(DataType dataType) {
        int n;
        DataType dataType2;
        while ((dataType2 = dataType) instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType2;
            dataType = arrayType.elementType();
        }
        if (dataType2 instanceof MapType) {
            MapType mapType = (MapType)dataType2;
            n = this.countLeaves(mapType.keyType()) + this.countLeaves(mapType.valueType());
        } else if (dataType2 instanceof StructType) {
            StructType structType = (StructType)dataType2;
            n = BoxesRunTime.unboxToInt((Object)((TraversableOnce)structType.map((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToInteger((int)SchemaPruning$.MODULE$.countLeaves(field.dataType())), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        } else {
            n = 1;
        }
        return n;
    }

    public static final /* synthetic */ boolean $anonfun$prunePhysicalColumns$1(SchemaPruning.RootField root) {
        return !root.derivedFromAtt();
    }

    private SchemaPruning$() {
        MODULE$ = this;
    }
}

