/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.client.StreamCallbackWithID;
import org.apache.spark.network.server.BlockPushNonFatalFailure;
import org.apache.spark.network.shuffle.ErrorHandler;
import org.apache.spark.network.shuffle.ExecutorDiskUtils;
import org.apache.spark.network.shuffle.MergedBlockMeta;
import org.apache.spark.network.shuffle.MergedShuffleFileManager;
import org.apache.spark.network.shuffle.ShuffleIndexInformation;
import org.apache.spark.network.shuffle.ShuffleIndexRecord;
import org.apache.spark.network.shuffle.protocol.BlockPushReturnCode;
import org.apache.spark.network.shuffle.protocol.ExecutorShuffleInfo;
import org.apache.spark.network.shuffle.protocol.FinalizeShuffleMerge;
import org.apache.spark.network.shuffle.protocol.MergeStatuses;
import org.apache.spark.network.shuffle.protocol.PushBlockStream;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.network.util.NettyUtils;
import org.apache.spark.network.util.TransportConf;
import org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sparkproject.guava.annotations.VisibleForTesting;
import org.sparkproject.guava.base.Preconditions;
import org.sparkproject.guava.cache.CacheBuilder;
import org.sparkproject.guava.cache.CacheLoader;
import org.sparkproject.guava.cache.LoadingCache;
import org.sparkproject.guava.primitives.Ints;
import org.sparkproject.guava.primitives.Longs;

public class RemoteBlockPushResolver
implements MergedShuffleFileManager {
    private static final Logger logger = LoggerFactory.getLogger(RemoteBlockPushResolver.class);
    public static final String MERGED_SHUFFLE_FILE_NAME_PREFIX = "shuffleMerged";
    public static final String SHUFFLE_META_DELIMITER = ":";
    public static final String MERGE_DIR_KEY = "mergeDir";
    public static final String ATTEMPT_ID_KEY = "attemptId";
    private static final int UNDEFINED_ATTEMPT_ID = -1;
    private static final ErrorHandler.BlockPushErrorHandler ERROR_HANDLER = RemoteBlockPushResolver.createErrorHandler();
    private static final ByteBuffer SUCCESS_RESPONSE = new BlockPushReturnCode(BlockPushNonFatalFailure.ReturnCode.SUCCESS.id(), "").toByteBuffer().asReadOnlyBuffer();
    private final ConcurrentMap<String, AppShuffleInfo> appsShuffleInfo;
    private final Executor mergedShuffleCleaner;
    private final TransportConf conf;
    private final int minChunkSize;
    private final int ioExceptionsThresholdDuringMerge;
    private final LoadingCache<String, ShuffleIndexInformation> indexCache;

    public RemoteBlockPushResolver(TransportConf conf) {
        this.conf = conf;
        this.appsShuffleInfo = new ConcurrentHashMap<String, AppShuffleInfo>();
        this.mergedShuffleCleaner = Executors.newSingleThreadExecutor(NettyUtils.createThreadFactory((String)"spark-shuffle-merged-shuffle-directory-cleaner"));
        this.minChunkSize = conf.minChunkSizeInMergedShuffleFile();
        this.ioExceptionsThresholdDuringMerge = conf.ioExceptionsThresholdDuringMerge();
        CacheLoader<String, ShuffleIndexInformation> indexCacheLoader = new CacheLoader<String, ShuffleIndexInformation>(){

            public ShuffleIndexInformation load(String filePath) throws IOException {
                return new ShuffleIndexInformation(filePath);
            }
        };
        this.indexCache = CacheBuilder.newBuilder().maximumWeight(conf.mergedIndexCacheSize()).weigher((filePath, indexInfo) -> indexInfo.getRetainedMemorySize()).build((CacheLoader)indexCacheLoader);
    }

    @VisibleForTesting
    protected static ErrorHandler.BlockPushErrorHandler createErrorHandler() {
        return new ErrorHandler.BlockPushErrorHandler(){

            @Override
            public boolean shouldLogError(Throwable t) {
                return !(t instanceof BlockPushNonFatalFailure);
            }
        };
    }

    @VisibleForTesting
    protected AppShuffleInfo validateAndGetAppShuffleInfo(String appId) {
        AppShuffleInfo appShuffleInfo = (AppShuffleInfo)this.appsShuffleInfo.get(appId);
        Preconditions.checkArgument((appShuffleInfo != null ? 1 : 0) != 0, (Object)("application " + appId + " is not registered or NM was restarted."));
        return appShuffleInfo;
    }

    private AppShufflePartitionInfo getOrCreateAppShufflePartitionInfo(AppShuffleInfo appShuffleInfo, int shuffleId, int shuffleMergeId, int reduceId, String blockId) throws BlockPushNonFatalFailure {
        ConcurrentMap shuffles = appShuffleInfo.shuffles;
        AppShuffleMergePartitionsInfo shufflePartitionsWithMergeId = shuffles.compute(shuffleId, (id, mergePartitionsInfo) -> {
            if (mergePartitionsInfo == null) {
                logger.info("{} attempt {} shuffle {} shuffleMerge {}: creating a new shuffle merge metadata", new Object[]{appShuffleInfo.appId, appShuffleInfo.attemptId, shuffleId, shuffleMergeId});
                return new AppShuffleMergePartitionsInfo(shuffleMergeId, false);
            }
            int latestShuffleMergeId = ((AppShuffleMergePartitionsInfo)mergePartitionsInfo).shuffleMergeId;
            if (latestShuffleMergeId > shuffleMergeId) {
                throw new BlockPushNonFatalFailure(new BlockPushReturnCode(BlockPushNonFatalFailure.ReturnCode.STALE_BLOCK_PUSH.id(), blockId).toByteBuffer(), BlockPushNonFatalFailure.getErrorMsg((String)blockId, (BlockPushNonFatalFailure.ReturnCode)BlockPushNonFatalFailure.ReturnCode.STALE_BLOCK_PUSH));
            }
            if (latestShuffleMergeId < shuffleMergeId) {
                logger.info("{} attempt {} shuffle {} shuffleMerge {}: creating a new shuffle merge metadata since received shuffleMergeId is higher than latest shuffleMergeId {}", new Object[]{appShuffleInfo.appId, appShuffleInfo.attemptId, shuffleId, shuffleMergeId, latestShuffleMergeId});
                this.mergedShuffleCleaner.execute(() -> this.closeAndDeletePartitionFiles(((AppShuffleMergePartitionsInfo)mergePartitionsInfo).shuffleMergePartitions));
                return new AppShuffleMergePartitionsInfo(shuffleMergeId, false);
            }
            if (mergePartitionsInfo.isFinalized()) {
                throw new BlockPushNonFatalFailure(new BlockPushReturnCode(BlockPushNonFatalFailure.ReturnCode.TOO_LATE_BLOCK_PUSH.id(), blockId).toByteBuffer(), BlockPushNonFatalFailure.getErrorMsg((String)blockId, (BlockPushNonFatalFailure.ReturnCode)BlockPushNonFatalFailure.ReturnCode.TOO_LATE_BLOCK_PUSH));
            }
            return mergePartitionsInfo;
        });
        Map shuffleMergePartitions = shufflePartitionsWithMergeId.shuffleMergePartitions;
        return shuffleMergePartitions.computeIfAbsent(reduceId, key -> {
            File dataFile = appShuffleInfo.getMergedShuffleDataFile(shuffleId, shuffleMergeId, reduceId);
            File indexFile = new File(appShuffleInfo.getMergedShuffleIndexFilePath(shuffleId, shuffleMergeId, reduceId));
            File metaFile = appShuffleInfo.getMergedShuffleMetaFile(shuffleId, shuffleMergeId, reduceId);
            try {
                return this.newAppShufflePartitionInfo(appShuffleInfo.appId, shuffleId, shuffleMergeId, reduceId, dataFile, indexFile, metaFile);
            }
            catch (IOException e) {
                logger.error("{} attempt {} shuffle {} shuffleMerge {}: cannot create merged shuffle partition with data file {}, index file {}, and meta file {}", new Object[]{appShuffleInfo.appId, appShuffleInfo.attemptId, shuffleId, shuffleMergeId, dataFile.getAbsolutePath(), indexFile.getAbsolutePath(), metaFile.getAbsolutePath()});
                throw new RuntimeException(String.format("Cannot initialize merged shuffle partition for appId %s shuffleId %s shuffleMergeId %s reduceId %s", appShuffleInfo.appId, shuffleId, shuffleMergeId, reduceId), e);
            }
        });
    }

    @VisibleForTesting
    AppShufflePartitionInfo newAppShufflePartitionInfo(String appId, int shuffleId, int shuffleMergeId, int reduceId, File dataFile, File indexFile, File metaFile) throws IOException {
        return new AppShufflePartitionInfo(appId, shuffleId, shuffleMergeId, reduceId, dataFile, new MergeShuffleFile(indexFile), new MergeShuffleFile(metaFile));
    }

    @Override
    public MergedBlockMeta getMergedBlockMeta(String appId, int shuffleId, int shuffleMergeId, int reduceId) {
        AppShuffleInfo appShuffleInfo = this.validateAndGetAppShuffleInfo(appId);
        AppShuffleMergePartitionsInfo partitionsInfo = (AppShuffleMergePartitionsInfo)appShuffleInfo.shuffles.get(shuffleId);
        if (null != partitionsInfo && partitionsInfo.shuffleMergeId > shuffleMergeId) {
            throw new RuntimeException(String.format("MergedBlockMeta fetch for shuffle %s with shuffleMergeId %s reduceId %s is %s", shuffleId, shuffleMergeId, reduceId, "stale shuffle block fetch request as shuffle blocks of a higher shuffleMergeId for the shuffle is available"));
        }
        File indexFile = new File(appShuffleInfo.getMergedShuffleIndexFilePath(shuffleId, shuffleMergeId, reduceId));
        if (!indexFile.exists()) {
            throw new RuntimeException(String.format("Merged shuffle index file %s not found", indexFile.getPath()));
        }
        int size = (int)indexFile.length();
        int numChunks = size / 8 - 1;
        File metaFile = appShuffleInfo.getMergedShuffleMetaFile(shuffleId, shuffleMergeId, reduceId);
        if (!metaFile.exists()) {
            throw new RuntimeException(String.format("Merged shuffle meta file %s not found", metaFile.getPath()));
        }
        FileSegmentManagedBuffer chunkBitMaps = new FileSegmentManagedBuffer(this.conf, metaFile, 0L, metaFile.length());
        logger.trace("{} shuffleId {} shuffleMergeId {} reduceId {} num chunks {}", new Object[]{appId, shuffleId, shuffleMergeId, reduceId, numChunks});
        return new MergedBlockMeta(numChunks, (ManagedBuffer)chunkBitMaps);
    }

    @Override
    public ManagedBuffer getMergedBlockData(String appId, int shuffleId, int shuffleMergeId, int reduceId, int chunkId) {
        AppShuffleInfo appShuffleInfo = this.validateAndGetAppShuffleInfo(appId);
        AppShuffleMergePartitionsInfo partitionsInfo = (AppShuffleMergePartitionsInfo)appShuffleInfo.shuffles.get(shuffleId);
        if (null != partitionsInfo && partitionsInfo.shuffleMergeId > shuffleMergeId) {
            throw new RuntimeException(String.format("MergedBlockData fetch for shuffle %s with shuffleMergeId %s reduceId %s is %s", shuffleId, shuffleMergeId, reduceId, "stale shuffle block fetch request as shuffle blocks of a higher shuffleMergeId for the shuffle is available"));
        }
        File dataFile = appShuffleInfo.getMergedShuffleDataFile(shuffleId, shuffleMergeId, reduceId);
        if (!dataFile.exists()) {
            throw new RuntimeException(String.format("Merged shuffle data file %s not found", dataFile.getPath()));
        }
        String indexFilePath = appShuffleInfo.getMergedShuffleIndexFilePath(shuffleId, shuffleMergeId, reduceId);
        try {
            ShuffleIndexInformation shuffleIndexInformation = (ShuffleIndexInformation)this.indexCache.get((Object)indexFilePath);
            ShuffleIndexRecord shuffleIndexRecord = shuffleIndexInformation.getIndex(chunkId);
            return new FileSegmentManagedBuffer(this.conf, dataFile, shuffleIndexRecord.getOffset(), shuffleIndexRecord.getLength());
        }
        catch (ExecutionException e) {
            throw new RuntimeException(String.format("Failed to open merged shuffle index file %s", indexFilePath), e);
        }
    }

    @Override
    public String[] getMergedBlockDirs(String appId) {
        AppShuffleInfo appShuffleInfo = this.validateAndGetAppShuffleInfo(appId);
        return appShuffleInfo.appPathsInfo.activeLocalDirs;
    }

    @Override
    public void applicationRemoved(String appId, boolean cleanupLocalDirs) {
        logger.info("Application {} removed, cleanupLocalDirs = {}", (Object)appId, (Object)cleanupLocalDirs);
        AppShuffleInfo appShuffleInfo = (AppShuffleInfo)this.appsShuffleInfo.remove(appId);
        if (null != appShuffleInfo) {
            this.mergedShuffleCleaner.execute(() -> this.closeAndDeletePartitionFilesIfNeeded(appShuffleInfo, cleanupLocalDirs));
        }
    }

    @VisibleForTesting
    void closeAndDeletePartitionFilesIfNeeded(AppShuffleInfo appShuffleInfo, boolean cleanupLocalDirs) {
        appShuffleInfo.shuffles.forEach((shuffleId, shuffleInfo) -> ((AppShuffleMergePartitionsInfo)shuffleInfo).shuffleMergePartitions.forEach((shuffleMergeId, partitionInfo) -> {
            AppShufflePartitionInfo appShufflePartitionInfo = partitionInfo;
            synchronized (appShufflePartitionInfo) {
                partitionInfo.closeAllFilesAndDeleteIfNeeded(false);
            }
        }));
        if (cleanupLocalDirs) {
            this.deleteExecutorDirs(appShuffleInfo);
        }
    }

    @VisibleForTesting
    void closeAndDeletePartitionFiles(Map<Integer, AppShufflePartitionInfo> partitions) {
        partitions.forEach((partitionId, partitionInfo) -> {
            AppShufflePartitionInfo appShufflePartitionInfo = partitionInfo;
            synchronized (appShufflePartitionInfo) {
                partitionInfo.closeAllFilesAndDeleteIfNeeded(true);
            }
        });
    }

    @VisibleForTesting
    void deleteExecutorDirs(AppShuffleInfo appShuffleInfo) {
        Path[] dirs;
        for (Path localDir : dirs = (Path[])Arrays.stream(appShuffleInfo.appPathsInfo.activeLocalDirs).map(dir -> Paths.get(dir, new String[0])).toArray(Path[]::new)) {
            try {
                if (!Files.exists(localDir, new LinkOption[0])) continue;
                JavaUtils.deleteRecursively((File)localDir.toFile());
                logger.debug("Successfully cleaned up directory: {}", (Object)localDir);
            }
            catch (Exception e) {
                logger.error("Failed to delete directory: {}", (Object)localDir, (Object)e);
            }
        }
    }

    @Override
    public StreamCallbackWithID receiveBlockDataAsStream(PushBlockStream msg) {
        AppShufflePartitionInfo partitionInfo;
        AppShufflePartitionInfo partitionInfoBeforeCheck;
        AppShuffleInfo appShuffleInfo = this.validateAndGetAppShuffleInfo(msg.appId);
        final String streamId = "shufflePush_" + msg.shuffleId + "_" + msg.shuffleMergeId + "_" + msg.mapIndex + "_" + msg.reduceId;
        if (appShuffleInfo.attemptId != msg.appAttemptId) {
            throw new BlockPushNonFatalFailure(new BlockPushReturnCode(BlockPushNonFatalFailure.ReturnCode.TOO_OLD_ATTEMPT_PUSH.id(), streamId).toByteBuffer(), BlockPushNonFatalFailure.getErrorMsg((String)streamId, (BlockPushNonFatalFailure.ReturnCode)BlockPushNonFatalFailure.ReturnCode.TOO_OLD_ATTEMPT_PUSH));
        }
        BlockPushNonFatalFailure failure = null;
        try {
            partitionInfoBeforeCheck = this.getOrCreateAppShufflePartitionInfo(appShuffleInfo, msg.shuffleId, msg.shuffleMergeId, msg.reduceId, streamId);
        }
        catch (BlockPushNonFatalFailure bpf) {
            partitionInfoBeforeCheck = null;
            failure = bpf;
        }
        AppShufflePartitionInfo appShufflePartitionInfo = failure != null ? null : (partitionInfo = partitionInfoBeforeCheck.mapTracker.contains(msg.mapIndex) ? null : partitionInfoBeforeCheck);
        if (partitionInfo != null) {
            return new PushBlockStreamCallback(this, appShuffleInfo, streamId, partitionInfo, msg.mapIndex);
        }
        final BlockPushNonFatalFailure finalFailure = failure;
        return new StreamCallbackWithID(){

            public String getID() {
                return streamId;
            }

            public void onData(String streamId2, ByteBuffer buf) {
            }

            public void onComplete(String streamId2) {
                if (finalFailure != null) {
                    throw finalFailure;
                }
            }

            public void onFailure(String streamId2, Throwable cause) {
            }

            public ByteBuffer getCompletionResponse() {
                return SUCCESS_RESPONSE.duplicate();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MergeStatuses finalizeShuffleMerge(FinalizeShuffleMerge msg) {
        MergeStatuses mergeStatuses;
        logger.info("{} attempt {} shuffle {} shuffleMerge {}: finalize shuffle merge", new Object[]{msg.appId, msg.appAttemptId, msg.shuffleId, msg.shuffleMergeId});
        AppShuffleInfo appShuffleInfo = this.validateAndGetAppShuffleInfo(msg.appId);
        if (appShuffleInfo.attemptId != msg.appAttemptId) {
            throw new IllegalArgumentException(String.format("The attempt id %s in this FinalizeShuffleMerge message does not match with the current attempt id %s stored in shuffle service for application %s", msg.appAttemptId, appShuffleInfo.attemptId, msg.appId));
        }
        AtomicReference<Object> shuffleMergePartitionsRef = new AtomicReference<Object>(null);
        appShuffleInfo.shuffles.compute(msg.shuffleId, (shuffleId, mergePartitionsInfo) -> {
            if (null != mergePartitionsInfo) {
                if (msg.shuffleMergeId < ((AppShuffleMergePartitionsInfo)mergePartitionsInfo).shuffleMergeId || mergePartitionsInfo.isFinalized()) {
                    throw new RuntimeException(String.format("Shuffle merge finalize request for shuffle %s with shuffleMergeId %s is %s", msg.shuffleId, msg.shuffleMergeId, "stale shuffle finalize request as shuffle blocks of a higher shuffleMergeId for the shuffle is already being pushed"));
                }
                if (msg.shuffleMergeId > ((AppShuffleMergePartitionsInfo)mergePartitionsInfo).shuffleMergeId) {
                    this.mergedShuffleCleaner.execute(() -> this.closeAndDeletePartitionFiles(((AppShuffleMergePartitionsInfo)mergePartitionsInfo).shuffleMergePartitions));
                } else {
                    shuffleMergePartitionsRef.set(((AppShuffleMergePartitionsInfo)mergePartitionsInfo).shuffleMergePartitions);
                }
            }
            return new AppShuffleMergePartitionsInfo(msg.shuffleMergeId, true);
        });
        Map shuffleMergePartitions = shuffleMergePartitionsRef.get();
        if (null == shuffleMergePartitions || shuffleMergePartitions.isEmpty()) {
            mergeStatuses = new MergeStatuses(msg.shuffleId, msg.shuffleMergeId, new RoaringBitmap[0], new int[0], new long[0]);
        } else {
            ArrayList<RoaringBitmap> bitmaps = new ArrayList<RoaringBitmap>(shuffleMergePartitions.size());
            ArrayList<Integer> reduceIds = new ArrayList<Integer>(shuffleMergePartitions.size());
            ArrayList<Long> sizes = new ArrayList<Long>(shuffleMergePartitions.size());
            Iterator iterator = shuffleMergePartitions.values().iterator();
            while (iterator.hasNext()) {
                AppShufflePartitionInfo partition;
                AppShufflePartitionInfo appShufflePartitionInfo = partition = (AppShufflePartitionInfo)iterator.next();
                synchronized (appShufflePartitionInfo) {
                    try {
                        logger.debug("{} attempt {} shuffle {} shuffleMerge {}: finalizing shuffle partition {} ", new Object[]{msg.appId, msg.appAttemptId, msg.shuffleId, msg.shuffleMergeId, partition.reduceId});
                        partition.finalizePartition();
                        if (partition.mapTracker.getCardinality() > 0) {
                            bitmaps.add(partition.mapTracker);
                            reduceIds.add(partition.reduceId);
                            sizes.add(partition.getLastChunkOffset());
                            logger.debug("{} attempt {} shuffle {} shuffleMerge {}: finalization results added for partition {} data size {} index size {} meta size {}", new Object[]{msg.appId, msg.appAttemptId, msg.shuffleId, msg.shuffleMergeId, partition.reduceId, partition.getLastChunkOffset(), partition.indexFile.getPos(), partition.metaFile.getPos()});
                        }
                    }
                    catch (IOException ioe) {
                        logger.warn("{} attempt {} shuffle {} shuffleMerge {}: exception while finalizing shuffle partition {}", new Object[]{msg.appId, msg.appAttemptId, msg.shuffleId, msg.shuffleMergeId, partition.reduceId});
                    }
                    finally {
                        partition.closeAllFilesAndDeleteIfNeeded(false);
                    }
                }
            }
            mergeStatuses = new MergeStatuses(msg.shuffleId, msg.shuffleMergeId, bitmaps.toArray(new RoaringBitmap[bitmaps.size()]), Ints.toArray(reduceIds), Longs.toArray(sizes));
        }
        logger.info("{} attempt {} shuffle {} shuffleMerge {}: finalization of shuffle merge completed", new Object[]{msg.appId, msg.appAttemptId, msg.shuffleId, msg.shuffleMergeId});
        return mergeStatuses;
    }

    @Override
    public void registerExecutor(String appId, ExecutorShuffleInfo executorInfo) {
        String shuffleManagerMeta;
        if (logger.isDebugEnabled()) {
            logger.debug("register executor with RemoteBlockPushResolver {} local-dirs {} num sub-dirs {} shuffleManager {}", new Object[]{appId, Arrays.toString(executorInfo.localDirs), executorInfo.subDirsPerLocalDir, executorInfo.shuffleManager});
        }
        if ((shuffleManagerMeta = executorInfo.shuffleManager).contains(SHUFFLE_META_DELIMITER)) {
            String mergeDirInfo = shuffleManagerMeta.substring(shuffleManagerMeta.indexOf(SHUFFLE_META_DELIMITER) + 1);
            try {
                ObjectMapper mapper = new ObjectMapper();
                TypeReference<Map<String, String>> typeRef = new TypeReference<Map<String, String>>(){};
                Map metaMap = (Map)mapper.readValue(mergeDirInfo, (TypeReference)typeRef);
                String mergeDir = (String)metaMap.get(MERGE_DIR_KEY);
                int attemptId = Integer.valueOf(metaMap.getOrDefault(ATTEMPT_ID_KEY, String.valueOf(-1)));
                if (mergeDir == null) {
                    throw new IllegalArgumentException(String.format("Failed to get the merge directory information from the shuffleManagerMeta %s in executor registration message", shuffleManagerMeta));
                }
                if (attemptId == -1) {
                    this.appsShuffleInfo.computeIfAbsent(appId, id -> new AppShuffleInfo(appId, -1, new AppPathsInfo(appId, executorInfo.localDirs, mergeDir, executorInfo.subDirsPerLocalDir)));
                } else {
                    AtomicReference originalAppShuffleInfo = new AtomicReference();
                    this.appsShuffleInfo.compute(appId, (id, appShuffleInfo) -> {
                        if (appShuffleInfo == null || attemptId > ((AppShuffleInfo)appShuffleInfo).attemptId) {
                            originalAppShuffleInfo.set(appShuffleInfo);
                            appShuffleInfo = new AppShuffleInfo(appId, attemptId, new AppPathsInfo(appId, executorInfo.localDirs, mergeDir, executorInfo.subDirsPerLocalDir));
                        }
                        return appShuffleInfo;
                    });
                    if (originalAppShuffleInfo.get() != null) {
                        AppShuffleInfo appShuffleInfo2 = (AppShuffleInfo)originalAppShuffleInfo.get();
                        logger.warn("Cleanup shuffle info and merged shuffle files for {}_{} as new application attempt registered", (Object)appId, (Object)appShuffleInfo2.attemptId);
                        this.mergedShuffleCleaner.execute(() -> this.closeAndDeletePartitionFilesIfNeeded(appShuffleInfo2, true));
                    }
                }
            }
            catch (JsonProcessingException e) {
                logger.warn("Failed to get the merge directory information from ExecutorShuffleInfo: ", (Throwable)e);
            }
        } else {
            logger.warn("ExecutorShuffleInfo does not have the expected merge directory information");
        }
    }

    @VisibleForTesting
    static class MergeShuffleFile {
        private final FileChannel channel;
        private final DataOutputStream dos;
        private long pos;
        private File file;

        @VisibleForTesting
        MergeShuffleFile(File file) throws IOException {
            FileOutputStream fos = new FileOutputStream(file);
            this.channel = fos.getChannel();
            this.dos = new DataOutputStream(fos);
            this.file = file;
        }

        @VisibleForTesting
        MergeShuffleFile(FileChannel channel, DataOutputStream dos) {
            this.channel = channel;
            this.dos = dos;
            this.file = null;
        }

        private void updatePos(long numBytes) {
            this.pos += numBytes;
        }

        void close() throws IOException {
            if (this.channel.isOpen()) {
                this.dos.close();
            }
        }

        void delete() throws IOException {
            try {
                if (null != this.file) {
                    this.file.delete();
                }
            }
            finally {
                this.file = null;
            }
        }

        @VisibleForTesting
        DataOutputStream getDos() {
            return this.dos;
        }

        @VisibleForTesting
        FileChannel getChannel() {
            return this.channel;
        }

        @VisibleForTesting
        long getPos() {
            return this.pos;
        }
    }

    public static class AppShuffleInfo {
        private final String appId;
        private final int attemptId;
        private final AppPathsInfo appPathsInfo;
        private final ConcurrentMap<Integer, AppShuffleMergePartitionsInfo> shuffles;

        AppShuffleInfo(String appId, int attemptId, AppPathsInfo appPathsInfo) {
            this.appId = appId;
            this.attemptId = attemptId;
            this.appPathsInfo = appPathsInfo;
            this.shuffles = new ConcurrentHashMap<Integer, AppShuffleMergePartitionsInfo>();
        }

        @VisibleForTesting
        public ConcurrentMap<Integer, AppShuffleMergePartitionsInfo> getShuffles() {
            return this.shuffles;
        }

        private String getFilePath(String filename) {
            String targetFile = ExecutorDiskUtils.getFilePath(this.appPathsInfo.activeLocalDirs, this.appPathsInfo.subDirsPerLocalDir, filename);
            logger.debug("Get merged file {}", (Object)targetFile);
            return targetFile;
        }

        private String generateFileName(String appId, int shuffleId, int shuffleMergeId, int reduceId) {
            return String.format("%s_%s_%d_%d_%d", RemoteBlockPushResolver.MERGED_SHUFFLE_FILE_NAME_PREFIX, appId, shuffleId, shuffleMergeId, reduceId);
        }

        public File getMergedShuffleDataFile(int shuffleId, int shuffleMergeId, int reduceId) {
            String fileName = String.format("%s.data", this.generateFileName(this.appId, shuffleId, shuffleMergeId, reduceId));
            return new File(this.getFilePath(fileName));
        }

        public String getMergedShuffleIndexFilePath(int shuffleId, int shuffleMergeId, int reduceId) {
            String indexName = String.format("%s.index", this.generateFileName(this.appId, shuffleId, shuffleMergeId, reduceId));
            return this.getFilePath(indexName);
        }

        public File getMergedShuffleMetaFile(int shuffleId, int shuffleMergeId, int reduceId) {
            String metaName = String.format("%s.meta", this.generateFileName(this.appId, shuffleId, shuffleMergeId, reduceId));
            return new File(this.getFilePath(metaName));
        }
    }

    private static class AppPathsInfo {
        private final String[] activeLocalDirs;
        private final int subDirsPerLocalDir;

        private AppPathsInfo(String appId, String[] localDirs, String mergeDirectory, int subDirsPerLocalDir) {
            this.activeLocalDirs = (String[])Arrays.stream(localDirs).map(localDir -> Paths.get(localDir, new String[0]).getParent().resolve(mergeDirectory).toFile().getPath()).toArray(String[]::new);
            this.subDirsPerLocalDir = subDirsPerLocalDir;
            if (logger.isInfoEnabled()) {
                logger.info("Updated active local dirs {} and sub dirs {} for application {}", new Object[]{Arrays.toString(this.activeLocalDirs), subDirsPerLocalDir, appId});
            }
        }
    }

    public static class AppShufflePartitionInfo {
        private final String appId;
        private final int shuffleId;
        private final int shuffleMergeId;
        private final int reduceId;
        private final File dataFile;
        public final FileChannel dataChannel;
        private final MergeShuffleFile indexFile;
        private final MergeShuffleFile metaFile;
        private long dataFilePos;
        private int currentMapIndex;
        private RoaringBitmap mapTracker;
        private long lastChunkOffset;
        private int lastMergedMapIndex = -1;
        private RoaringBitmap chunkTracker;
        private int numIOExceptions = 0;
        private boolean indexMetaUpdateFailed;

        AppShufflePartitionInfo(String appId, int shuffleId, int shuffleMergeId, int reduceId, File dataFile, MergeShuffleFile indexFile, MergeShuffleFile metaFile) throws IOException {
            Preconditions.checkArgument((appId != null ? 1 : 0) != 0, (Object)"app id is null");
            this.appId = appId;
            this.shuffleId = shuffleId;
            this.shuffleMergeId = shuffleMergeId;
            this.reduceId = reduceId;
            this.dataChannel = new FileOutputStream(dataFile).getChannel();
            this.dataFile = dataFile;
            this.indexFile = indexFile;
            this.metaFile = metaFile;
            this.currentMapIndex = -1;
            this.updateChunkInfo(0L, -1);
            this.dataFilePos = 0L;
            this.mapTracker = new RoaringBitmap();
            this.chunkTracker = new RoaringBitmap();
        }

        public long getDataFilePos() {
            return this.dataFilePos;
        }

        public void setDataFilePos(long dataFilePos) {
            logger.trace("{} current pos {} update pos {}", new Object[]{this, this.dataFilePos, dataFilePos});
            this.dataFilePos = dataFilePos;
        }

        int getCurrentMapIndex() {
            return this.currentMapIndex;
        }

        void setCurrentMapIndex(int mapIndex) {
            logger.trace("{} mapIndex {} current mapIndex {}", new Object[]{this, this.currentMapIndex, mapIndex});
            this.currentMapIndex = mapIndex;
        }

        long getLastChunkOffset() {
            return this.lastChunkOffset;
        }

        void blockMerged(int mapIndex) {
            logger.debug("{} updated merging mapIndex {}", (Object)this, (Object)mapIndex);
            this.mapTracker.add(mapIndex);
            this.chunkTracker.add(mapIndex);
            this.lastMergedMapIndex = mapIndex;
        }

        void resetChunkTracker() {
            this.chunkTracker.clear();
        }

        void updateChunkInfo(long chunkOffset, int mapIndex) throws IOException {
            try {
                logger.trace("{} index current {} updated {}", new Object[]{this, this.lastChunkOffset, chunkOffset});
                if (this.indexMetaUpdateFailed) {
                    this.indexFile.getChannel().position(this.indexFile.getPos());
                }
                this.indexFile.getDos().writeLong(chunkOffset);
                this.writeChunkTracker(mapIndex);
                this.indexFile.updatePos(8L);
                this.lastChunkOffset = chunkOffset;
                this.indexMetaUpdateFailed = false;
            }
            catch (IOException ioe) {
                logger.warn("{} shuffleId {} reduceId {} update to index/meta failed", new Object[]{this.appId, this.shuffleId, this.reduceId});
                this.indexMetaUpdateFailed = true;
                throw ioe;
            }
        }

        private void writeChunkTracker(int mapIndex) throws IOException {
            if (mapIndex == -1) {
                return;
            }
            this.chunkTracker.add(mapIndex);
            logger.trace("{} mapIndex {} write chunk to meta file", (Object)this, (Object)mapIndex);
            if (this.indexMetaUpdateFailed) {
                this.metaFile.getChannel().position(this.metaFile.getPos());
            }
            this.chunkTracker.serialize((DataOutput)this.metaFile.getDos());
            this.metaFile.updatePos(this.metaFile.getChannel().position() - this.metaFile.getPos());
        }

        private void incrementIOExceptions() {
            ++this.numIOExceptions;
        }

        private boolean shouldAbort(int ioExceptionsThresholdDuringMerge) {
            return this.numIOExceptions > ioExceptionsThresholdDuringMerge;
        }

        private void finalizePartition() throws IOException {
            if (this.dataFilePos != this.lastChunkOffset) {
                try {
                    this.updateChunkInfo(this.dataFilePos, this.lastMergedMapIndex);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.dataChannel.truncate(this.lastChunkOffset);
            this.indexFile.getChannel().truncate(this.indexFile.getPos());
            this.metaFile.getChannel().truncate(this.metaFile.getPos());
        }

        void closeAllFilesAndDeleteIfNeeded(boolean delete) {
            try {
                if (this.dataChannel.isOpen()) {
                    this.dataChannel.close();
                    if (delete) {
                        this.dataFile.delete();
                    }
                }
            }
            catch (IOException ioe) {
                logger.warn("Error closing data channel for {} shuffleId {} shuffleMergeId {} reduceId {}", new Object[]{this.appId, this.shuffleId, this.shuffleMergeId, this.reduceId});
            }
            try {
                this.metaFile.close();
                if (delete) {
                    this.metaFile.delete();
                }
            }
            catch (IOException ioe) {
                logger.warn("Error closing meta file for {} shuffleId {} shuffleMergeId {} reduceId {}", new Object[]{this.appId, this.shuffleId, this.shuffleMergeId, this.reduceId});
            }
            try {
                this.indexFile.close();
                if (delete) {
                    this.indexFile.delete();
                }
            }
            catch (IOException ioe) {
                logger.warn("Error closing index file for {} shuffleId {} shuffleMergeId {} reduceId {}", new Object[]{this.appId, this.shuffleId, this.shuffleMergeId, this.reduceId});
            }
        }

        public String toString() {
            return String.format("Application %s shuffleId %s shuffleMergeId %s reduceId %s", this.appId, this.shuffleId, this.shuffleMergeId, this.reduceId);
        }

        protected void finalize() throws Throwable {
            this.closeAllFilesAndDeleteIfNeeded(false);
        }

        @VisibleForTesting
        MergeShuffleFile getIndexFile() {
            return this.indexFile;
        }

        @VisibleForTesting
        MergeShuffleFile getMetaFile() {
            return this.metaFile;
        }

        @VisibleForTesting
        FileChannel getDataChannel() {
            return this.dataChannel;
        }

        @VisibleForTesting
        int getNumIOExceptions() {
            return this.numIOExceptions;
        }
    }

    public static class AppShuffleMergePartitionsInfo {
        private static final Map<Integer, AppShufflePartitionInfo> SHUFFLE_FINALIZED_MARKER = Collections.emptyMap();
        private final int shuffleMergeId;
        private final Map<Integer, AppShufflePartitionInfo> shuffleMergePartitions;

        public AppShuffleMergePartitionsInfo(int shuffleMergeId, boolean shuffleFinalized) {
            this.shuffleMergeId = shuffleMergeId;
            this.shuffleMergePartitions = shuffleFinalized ? SHUFFLE_FINALIZED_MARKER : new ConcurrentHashMap();
        }

        @VisibleForTesting
        public Map<Integer, AppShufflePartitionInfo> getShuffleMergePartitions() {
            return this.shuffleMergePartitions;
        }

        public boolean isFinalized() {
            return this.shuffleMergePartitions == SHUFFLE_FINALIZED_MARKER;
        }
    }

    static class PushBlockStreamCallback
    implements StreamCallbackWithID {
        private final RemoteBlockPushResolver mergeManager;
        private final AppShuffleInfo appShuffleInfo;
        private final String streamId;
        private final int mapIndex;
        private final AppShufflePartitionInfo partitionInfo;
        private int length = 0;
        private boolean isWriting = false;
        private List<ByteBuffer> deferredBufs;

        private PushBlockStreamCallback(RemoteBlockPushResolver mergeManager, AppShuffleInfo appShuffleInfo, String streamId, AppShufflePartitionInfo partitionInfo, int mapIndex) {
            Preconditions.checkArgument((mergeManager != null ? 1 : 0) != 0);
            this.mergeManager = mergeManager;
            Preconditions.checkArgument((appShuffleInfo != null ? 1 : 0) != 0);
            this.appShuffleInfo = appShuffleInfo;
            this.streamId = streamId;
            Preconditions.checkArgument((partitionInfo != null ? 1 : 0) != 0);
            this.partitionInfo = partitionInfo;
            this.mapIndex = mapIndex;
            this.abortIfNecessary();
        }

        public String getID() {
            return this.streamId;
        }

        public ByteBuffer getCompletionResponse() {
            return SUCCESS_RESPONSE.duplicate();
        }

        private void writeBuf(ByteBuffer buf) throws IOException {
            while (buf.hasRemaining()) {
                long updatedPos = this.partitionInfo.getDataFilePos() + (long)this.length;
                logger.debug("{} current pos {} updated pos {}", new Object[]{this.partitionInfo, this.partitionInfo.getDataFilePos(), updatedPos});
                this.length += this.partitionInfo.dataChannel.write(buf, updatedPos);
            }
        }

        private boolean allowedToWrite() {
            return this.partitionInfo.getCurrentMapIndex() < 0 || this.partitionInfo.getCurrentMapIndex() == this.mapIndex;
        }

        private boolean isDuplicateBlock() {
            return this.partitionInfo.getCurrentMapIndex() == this.mapIndex && this.length == 0 || this.partitionInfo.mapTracker.contains(this.mapIndex);
        }

        private void writeDeferredBufs() throws IOException {
            for (ByteBuffer deferredBuf : this.deferredBufs) {
                this.writeBuf(deferredBuf);
            }
            this.deferredBufs = null;
        }

        private void abortIfNecessary() {
            if (this.partitionInfo.shouldAbort(this.mergeManager.ioExceptionsThresholdDuringMerge)) {
                this.deferredBufs = null;
                throw new RuntimeException(String.format("%s when merging %s", "IOExceptions exceeded the threshold", this.streamId));
            }
        }

        private void incrementIOExceptionsAndAbortIfNecessary() {
            this.partitionInfo.incrementIOExceptions();
            this.abortIfNecessary();
        }

        private boolean isStale(AppShuffleMergePartitionsInfo appShuffleMergePartitionsInfo, int shuffleMergeId) {
            return appShuffleMergePartitionsInfo.shuffleMergeId > shuffleMergeId;
        }

        private boolean isTooLate(AppShuffleMergePartitionsInfo appShuffleMergePartitionsInfo, int reduceId) {
            return null == appShuffleMergePartitionsInfo || appShuffleMergePartitionsInfo.isFinalized() || !appShuffleMergePartitionsInfo.shuffleMergePartitions.containsKey(reduceId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onData(String streamId, ByteBuffer buf) throws IOException {
            AppShufflePartitionInfo appShufflePartitionInfo = this.partitionInfo;
            synchronized (appShufflePartitionInfo) {
                AppShuffleMergePartitionsInfo info = (AppShuffleMergePartitionsInfo)this.appShuffleInfo.shuffles.get(this.partitionInfo.shuffleId);
                if (this.isStale(info, this.partitionInfo.shuffleMergeId) || this.isTooLate(info, this.partitionInfo.reduceId)) {
                    this.deferredBufs = null;
                    return;
                }
                if (this.allowedToWrite()) {
                    if (this.isDuplicateBlock()) {
                        this.deferredBufs = null;
                        return;
                    }
                    this.abortIfNecessary();
                    logger.trace("{} onData writable", (Object)this.partitionInfo);
                    if (this.partitionInfo.getCurrentMapIndex() < 0) {
                        this.partitionInfo.setCurrentMapIndex(this.mapIndex);
                    }
                    this.isWriting = true;
                    try {
                        if (this.deferredBufs != null && !this.deferredBufs.isEmpty()) {
                            this.writeDeferredBufs();
                        }
                        this.writeBuf(buf);
                    }
                    catch (IOException ioe) {
                        this.incrementIOExceptionsAndAbortIfNecessary();
                        throw ioe;
                    }
                } else {
                    logger.trace("{} onData deferred", (Object)this.partitionInfo);
                    if (this.deferredBufs == null) {
                        this.deferredBufs = new ArrayList<ByteBuffer>();
                    }
                    ByteBuffer deferredBuf = ByteBuffer.allocate(buf.remaining());
                    deferredBuf.put(buf);
                    deferredBuf.flip();
                    this.deferredBufs.add(deferredBuf);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onComplete(String streamId) throws IOException {
            AppShufflePartitionInfo appShufflePartitionInfo = this.partitionInfo;
            synchronized (appShufflePartitionInfo) {
                logger.trace("{} onComplete invoked", (Object)this.partitionInfo);
                AppShuffleMergePartitionsInfo info = (AppShuffleMergePartitionsInfo)this.appShuffleInfo.shuffles.get(this.partitionInfo.shuffleId);
                if (this.isTooLate(info, this.partitionInfo.reduceId)) {
                    this.deferredBufs = null;
                    throw new BlockPushNonFatalFailure(new BlockPushReturnCode(BlockPushNonFatalFailure.ReturnCode.TOO_LATE_BLOCK_PUSH.id(), streamId).toByteBuffer(), BlockPushNonFatalFailure.getErrorMsg((String)streamId, (BlockPushNonFatalFailure.ReturnCode)BlockPushNonFatalFailure.ReturnCode.TOO_LATE_BLOCK_PUSH));
                }
                if (this.isStale(info, this.partitionInfo.shuffleMergeId)) {
                    this.deferredBufs = null;
                    throw new BlockPushNonFatalFailure(new BlockPushReturnCode(BlockPushNonFatalFailure.ReturnCode.STALE_BLOCK_PUSH.id(), streamId).toByteBuffer(), BlockPushNonFatalFailure.getErrorMsg((String)streamId, (BlockPushNonFatalFailure.ReturnCode)BlockPushNonFatalFailure.ReturnCode.STALE_BLOCK_PUSH));
                }
                if (this.allowedToWrite()) {
                    if (this.isDuplicateBlock()) {
                        this.deferredBufs = null;
                        return;
                    }
                    if (this.partitionInfo.getCurrentMapIndex() < 0) {
                        try {
                            if (this.deferredBufs != null && !this.deferredBufs.isEmpty()) {
                                this.abortIfNecessary();
                                this.isWriting = true;
                                this.writeDeferredBufs();
                            }
                        }
                        catch (IOException ioe) {
                            this.incrementIOExceptionsAndAbortIfNecessary();
                            throw ioe;
                        }
                    }
                    long updatedPos = this.partitionInfo.getDataFilePos() + (long)this.length;
                    boolean indexUpdated = false;
                    if (updatedPos - this.partitionInfo.getLastChunkOffset() >= (long)this.mergeManager.minChunkSize) {
                        try {
                            this.partitionInfo.updateChunkInfo(updatedPos, this.mapIndex);
                            indexUpdated = true;
                        }
                        catch (IOException ioe) {
                            this.incrementIOExceptionsAndAbortIfNecessary();
                        }
                    }
                    this.partitionInfo.setDataFilePos(updatedPos);
                    this.partitionInfo.setCurrentMapIndex(-1);
                    this.partitionInfo.blockMerged(this.mapIndex);
                    if (indexUpdated) {
                        this.partitionInfo.resetChunkTracker();
                    }
                } else {
                    this.deferredBufs = null;
                    throw new BlockPushNonFatalFailure(new BlockPushReturnCode(BlockPushNonFatalFailure.ReturnCode.BLOCK_APPEND_COLLISION_DETECTED.id(), streamId).toByteBuffer(), BlockPushNonFatalFailure.getErrorMsg((String)streamId, (BlockPushNonFatalFailure.ReturnCode)BlockPushNonFatalFailure.ReturnCode.BLOCK_APPEND_COLLISION_DETECTED));
                }
            }
            this.isWriting = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onFailure(String streamId, Throwable throwable) throws IOException {
            if (ERROR_HANDLER.shouldLogError(throwable)) {
                logger.error("Encountered issue when merging {}", (Object)streamId, (Object)throwable);
            } else {
                logger.debug("Encountered issue when merging {}", (Object)streamId, (Object)throwable);
            }
            if (this.isWriting) {
                AppShufflePartitionInfo appShufflePartitionInfo = this.partitionInfo;
                synchronized (appShufflePartitionInfo) {
                    AppShuffleMergePartitionsInfo info = (AppShuffleMergePartitionsInfo)this.appShuffleInfo.shuffles.get(this.partitionInfo.shuffleId);
                    if (!this.isTooLate(info, this.partitionInfo.reduceId) && !this.isStale(info, this.partitionInfo.shuffleMergeId)) {
                        logger.debug("{} encountered failure", (Object)this.partitionInfo);
                        this.partitionInfo.setCurrentMapIndex(-1);
                    }
                }
            }
            this.isWriting = false;
        }

        @VisibleForTesting
        AppShufflePartitionInfo getPartitionInfo() {
            return this.partitionInfo;
        }
    }
}

