% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQLContext.R
\name{read.text}
\alias{read.text}
\title{Create a SparkDataFrame from a text file.}
\usage{
read.text(path, ...)
}
\arguments{
\item{path}{Path of file to read. A vector of multiple paths is allowed.}

\item{...}{additional external data source specific named properties.
You can find the text-specific options for reading text files in
\url{
https://spark.apache.org/docs/latest/sql-data-sources-text.html#data-source-option}{
Data Source Option} in the version you use.}
}
\value{
SparkDataFrame
}
\description{
Loads text files and returns a SparkDataFrame whose schema starts with
a string column named "value", and followed by partitioned columns if
there are any. The text files must be encoded as UTF-8.
}
\details{
Each line in the text file is a new row in the resulting SparkDataFrame.
}
\note{
read.text since 1.6.1
}
\examples{
\dontrun{
sparkR.session()
path <- "path/to/file.txt"
df <- read.text(path)
}
}
