/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.MakeTimestamp;
import org.apache.spark.sql.catalyst.expressions.MakeTimestamp$;
import org.apache.spark.sql.catalyst.expressions.MakeTimestampLTZ$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple9;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(year, month, day, hour, min, sec[, timezone]) - Create the current timestamp with local time zone from year, month, day, hour, min, sec and timezone fields. ", arguments="\n    Arguments:\n      * year - the year to represent, from 1 to 9999\n      * month - the month-of-year to represent, from 1 (January) to 12 (December)\n      * day - the day-of-month to represent, from 1 to 31\n      * hour - the hour-of-day to represent, from 0 to 23\n      * min - the minute-of-hour to represent, from 0 to 59\n      * sec - the second-of-minute and its micro-fraction to represent, from\n              0 to 60. If the sec argument equals to 60, the seconds field is set\n              to 0 and 1 minute is added to the final timestamp.\n      * timezone - the time zone identifier. For example, CET, UTC and etc.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887);\n       2014-12-28 06:30:45.887\n      > SELECT _FUNC_(2014, 12, 28, 6, 30, 45.887, 'CET');\n       2014-12-27 21:30:45.887\n      > SELECT _FUNC_(2019, 6, 30, 23, 59, 60);\n       2019-07-01 00:00:00\n      > SELECT _FUNC_(2019, 13, 1, 10, 11, 12, 'PST');\n       NULL\n      > SELECT _FUNC_(null, 7, 22, 15, 30, 0);\n       NULL\n  ", group="datetime_funcs", since="3.3.0")
@ScalaSignature(bytes="\u0006\u0001\t-c\u0001\u0002\u001a4\u0001\u0002C\u0001\"\u0015\u0001\u0003\u0016\u0004%\tA\u0015\u0005\t-\u0002\u0011\t\u0012)A\u0005'\"Aq\u000b\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005Y\u0001\tE\t\u0015!\u0003T\u0011!I\u0006A!f\u0001\n\u0003\u0011\u0006\u0002\u0003.\u0001\u0005#\u0005\u000b\u0011B*\t\u0011m\u0003!Q3A\u0005\u0002IC\u0001\u0002\u0018\u0001\u0003\u0012\u0003\u0006Ia\u0015\u0005\t;\u0002\u0011)\u001a!C\u0001%\"Aa\f\u0001B\tB\u0003%1\u000b\u0003\u0005`\u0001\tU\r\u0011\"\u0001S\u0011!\u0001\u0007A!E!\u0002\u0013\u0019\u0006\u0002C1\u0001\u0005+\u0007I\u0011\u00012\t\u0011\u0019\u0004!\u0011#Q\u0001\n\rD\u0001b\u001a\u0001\u0003\u0016\u0004%\t\u0001\u001b\u0005\tY\u0002\u0011\t\u0012)A\u0005S\"AQ\u000e\u0001BK\u0002\u0013\u0005!\u000b\u0003\u0005o\u0001\tE\t\u0015!\u0003T\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u0015y\u0007\u0001\"\u0001|\u0011\u0019y\u0007\u0001\"\u0001\u0002\u0006!9\u0011Q\u0003\u0001\u0005B\u0005]\u0001bBA\u0018\u0001\u0011\u0005\u0013\u0011\u0007\u0005\b\u0003\u000b\u0002A\u0011KA$\u0011%\ti\u0005AA\u0001\n\u0003\ty\u0005C\u0005\u0002d\u0001\t\n\u0011\"\u0001\u0002f!I\u00111\u0010\u0001\u0012\u0002\u0013\u0005\u0011Q\r\u0005\n\u0003{\u0002\u0011\u0013!C\u0001\u0003KB\u0011\"a \u0001#\u0003%\t!!\u001a\t\u0013\u0005\u0005\u0005!%A\u0005\u0002\u0005\u0015\u0004\"CAB\u0001E\u0005I\u0011AA3\u0011%\t)\tAI\u0001\n\u0003\t9\tC\u0005\u0002\f\u0002\t\n\u0011\"\u0001\u0002\u000e\"I\u0011\u0011\u0013\u0001\u0012\u0002\u0013\u0005\u0011Q\r\u0005\n\u0003'\u0003\u0011\u0011!C!\u0003+C\u0011\"!*\u0001\u0003\u0003%\t!a*\t\u0013\u0005=\u0006!!A\u0005\u0002\u0005E\u0006\"CA_\u0001\u0005\u0005I\u0011IA`\u0011%\ti\rAA\u0001\n\u0003\ty\rC\u0005\u0002T\u0002\t\t\u0011\"\u0011\u0002V\u001eI\u0011q`\u001a\u0002\u0002#\u0005!\u0011\u0001\u0004\teM\n\t\u0011#\u0001\u0003\u0004!1qN\u000bC\u0001\u0005#A\u0011Ba\u0005+\u0003\u0003%)E!\u0006\t\u0013\t]!&!A\u0005\u0002\ne\u0001\"\u0003B\u0017UE\u0005I\u0011AAG\u0011%\u0011yCKA\u0001\n\u0003\u0013\t\u0004C\u0005\u0003@)\n\n\u0011\"\u0001\u0002\u000e\"I!\u0011\t\u0016\u0002\u0002\u0013%!1\t\u0002\u0011\u001b\u0006\\W\rV5nKN$\u0018-\u001c9M)jS!\u0001N\u001b\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003m]\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003qe\n1a]9m\u0015\tQ4(A\u0003ta\u0006\u00148N\u0003\u0002={\u00051\u0011\r]1dQ\u0016T\u0011AP\u0001\u0004_J<7\u0001A\n\u0006\u0001\u0005+\u0005J\u0014\t\u0003\u0005\u000ek\u0011aM\u0005\u0003\tN\u0012q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003\u0005\u001aK!aR\u001a\u0003%I+h\u000e^5nKJ+\u0007\u000f\\1dK\u0006\u0014G.\u001a\t\u0003\u00132k\u0011A\u0013\u0006\u0002\u0017\u0006)1oY1mC&\u0011QJ\u0013\u0002\b!J|G-^2u!\tIu*\u0003\u0002Q\u0015\na1+\u001a:jC2L'0\u00192mK\u0006!\u00110Z1s+\u0005\u0019\u0006C\u0001\"U\u0013\t)6G\u0001\u0006FqB\u0014Xm]:j_:\fQ!_3be\u0002\nQ!\\8oi\"\fa!\\8oi\"\u0004\u0013a\u00013bs\u0006!A-Y=!\u0003\u0011Aw.\u001e:\u0002\u000b!|WO\u001d\u0011\u0002\u00075Lg.\u0001\u0003nS:\u0004\u0013aA:fG\u0006!1/Z2!\u0003!!\u0018.\\3{_:,W#A2\u0011\u0007%#7+\u0003\u0002f\u0015\n1q\n\u001d;j_:\f\u0011\u0002^5nKj|g.\u001a\u0011\u0002\u0017\u0019\f\u0017\u000e\\(o\u000bJ\u0014xN]\u000b\u0002SB\u0011\u0011J[\u0005\u0003W*\u0013qAQ8pY\u0016\fg.\u0001\u0007gC&dwJ\\#se>\u0014\b%A\u0003dQ&dG-\u0001\u0004dQ&dG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0015E\u00148\u000f^;wobL(\u0010\u0005\u0002C\u0001!)\u0011k\u0005a\u0001'\")qk\u0005a\u0001'\")\u0011l\u0005a\u0001'\")1l\u0005a\u0001'\")Ql\u0005a\u0001'\")ql\u0005a\u0001'\")\u0011m\u0005a\u0001G\"9qm\u0005I\u0001\u0002\u0004I\u0007\"B7\u0014\u0001\u0004\u0019F#C9}{z|\u0018\u0011AA\u0002\u0011\u0015\tF\u00031\u0001T\u0011\u00159F\u00031\u0001T\u0011\u0015IF\u00031\u0001T\u0011\u0015YF\u00031\u0001T\u0011\u0015iF\u00031\u0001T\u0011\u0015yF\u00031\u0001T)=\t\u0018qAA\u0005\u0003\u0017\ti!a\u0004\u0002\u0012\u0005M\u0001\"B)\u0016\u0001\u0004\u0019\u0006\"B,\u0016\u0001\u0004\u0019\u0006\"B-\u0016\u0001\u0004\u0019\u0006\"B.\u0016\u0001\u0004\u0019\u0006\"B/\u0016\u0001\u0004\u0019\u0006\"B0\u0016\u0001\u0004\u0019\u0006\"B1\u0016\u0001\u0004\u0019\u0016A\u00039sKR$\u0018PT1nKV\u0011\u0011\u0011\u0004\t\u0005\u00037\tIC\u0004\u0003\u0002\u001e\u0005\u0015\u0002cAA\u0010\u00156\u0011\u0011\u0011\u0005\u0006\u0004\u0003Gy\u0014A\u0002\u001fs_>$h(C\u0002\u0002()\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0016\u0003[\u0011aa\u0015;sS:<'bAA\u0014\u0015\u0006iQ\r\u001f9sgJ+\u0007\u000f\\1dK\u0012,\"!a\r\u0011\u000b\u0005U\u0012qH*\u000f\t\u0005]\u00121\b\b\u0005\u0003?\tI$C\u0001L\u0013\r\tiDS\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t%a\u0011\u0003\u0007M+\u0017OC\u0002\u0002>)\u000bAc^5uQ:+wo\u00115jY\u0012Le\u000e^3s]\u0006dGcA*\u0002J!1\u00111\n\rA\u0002M\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\u0005G>\u0004\u0018\u0010F\nr\u0003#\n\u0019&!\u0016\u0002X\u0005e\u00131LA/\u0003?\n\t\u0007C\u0004R3A\u0005\t\u0019A*\t\u000f]K\u0002\u0013!a\u0001'\"9\u0011,\u0007I\u0001\u0002\u0004\u0019\u0006bB.\u001a!\u0003\u0005\ra\u0015\u0005\b;f\u0001\n\u00111\u0001T\u0011\u001dy\u0016\u0004%AA\u0002MCq!Y\r\u0011\u0002\u0003\u00071\rC\u0004h3A\u0005\t\u0019A5\t\u000f5L\u0002\u0013!a\u0001'\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA4U\r\u0019\u0016\u0011N\u0016\u0003\u0003W\u0002B!!\u001c\u0002x5\u0011\u0011q\u000e\u0006\u0005\u0003c\n\u0019(A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u000f&\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002z\u0005=$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU\nabY8qs\u0012\"WMZ1vYR$c'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001c\u0016\u0005\u0005%%fA2\u0002j\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012BTCAAHU\rI\u0017\u0011N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u0013:\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0013\t\u0005\u00033\u000b\u0019+\u0004\u0002\u0002\u001c*!\u0011QTAP\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0016\u0001\u00026bm\u0006LA!a\u000b\u0002\u001c\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\u0016\t\u0004\u0013\u0006-\u0016bAAW\u0015\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111WA]!\rI\u0015QW\u0005\u0004\u0003oS%aA!os\"I\u00111X\u0013\u0002\u0002\u0003\u0007\u0011\u0011V\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0005\u0007CBAb\u0003\u0013\f\u0019,\u0004\u0002\u0002F*\u0019\u0011q\u0019&\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002L\u0006\u0015'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2![Ai\u0011%\tYlJA\u0001\u0002\u0004\t\u0019,\u0001\u0004fcV\fGn\u001d\u000b\u0004S\u0006]\u0007\"CA^Q\u0005\u0005\t\u0019AAZQ]\u0001\u00111\\Aq\u0003G\f9/!;\u0002n\u0006=\u00181_A{\u0003s\fY\u0010E\u0002C\u0003;L1!a84\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!:\u0002\u0003\u0013zf)\u0016(D?\"JX-\u0019:-A5|g\u000e\u001e5-A\u0011\f\u0017\u0010\f\u0011i_V\u0014H\u0006I7j]2\u00023/Z2\\Y\u0001\"\u0018.\\3{_:,W,\u000b\u0011.A\r\u0013X-\u0019;fAQDW\rI2veJ,g\u000e\u001e\u0011uS6,7\u000f^1na\u0002:\u0018\u000e\u001e5!Y>\u001c\u0017\r\u001c\u0011uS6,\u0007E_8oK\u00022'o\\7!s\u0016\f'\u000f\f\u0011n_:$\b\u000e\f\u0011eCfd\u0003\u0005[8ve2\u0002S.\u001b8-AM,7\rI1oI\u0002\"\u0018.\\3{_:,\u0007EZ5fY\u0012\u001ch\u0006I\u0001\nCJ<W/\\3oiN\f#!a;\u0002\tWT\u0001\u0005\t\u0011!\u0003J<W/\\3oiNT$\u0002\t\u0011!A\u0001\u0002#\u0006I=fCJ\u0004S\u0006\t;iK\u0002JX-\u0019:!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|W\u000eI\u0019!i>\u0004\u0013(O\u001d:\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001jwN\u001c;iA5\u0002C\u000f[3![>tG\u000f[\u0017pM6JX-\u0019:!i>\u0004#/\u001a9sKN,g\u000e\u001e\u0017!MJ|W\u000eI\u0019!Q)\u000bg.^1ss&\u0002Co\u001c\u00112e\u0001BC)Z2f[\n,'/\u000b\u0006!A\u0001\u0002\u0003\u0005\t\u0016!I\u0006L\b%\f\u0011uQ\u0016\u0004C-Y=._\u001alSn\u001c8uQ\u0002\"x\u000e\t:faJ,7/\u001a8uY\u00012'o\\7!c\u0001\"x\u000eI\u001a2\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001Bw.\u001e:![\u0001\"\b.\u001a\u0011i_V\u0014Xf\u001c4.I\u0006L\b\u0005^8!e\u0016\u0004(/Z:f]Rd\u0003E\u001a:p[\u0002\u0002\u0004\u0005^8!eMR\u0001\u0005\t\u0011!A\u0001R\u0003%\\5oA5\u0002C\u000f[3![&tW\u000f^3._\u001al\u0003n\\;sAQ|\u0007E]3qe\u0016\u001cXM\u001c;-A\u0019\u0014x.\u001c\u00111AQ|\u0007%N\u001d\u000bA\u0001\u0002\u0003\u0005\t\u0011+AM,7\rI\u0017!i\",\u0007e]3d_:$Wf\u001c4.[&tW\u000f^3!C:$\u0007%\u001b;tA5L7M]8.MJ\f7\r^5p]\u0002\"x\u000e\t:faJ,7/\u001a8uY\u00012'o\\7\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!a\u0001\"x\u000e\t\u001c1]\u0001Je\r\t;iK\u0002\u001aXm\u0019\u0011be\u001e,X.\u001a8uA\u0015\fX/\u00197tAQ|\u0007E\u000e\u0019-AQDW\rI:fG>tGm\u001d\u0011gS\u0016dG\rI5tAM,GO\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t;pAA\u0002\u0013M\u001c3!c\u0001j\u0017N\\;uK\u0002J7\u000fI1eI\u0016$\u0007\u0005^8!i\",\u0007EZ5oC2\u0004C/[7fgR\fW\u000e\u001d\u0018\u000bA\u0001\u0002\u0003\u0005\t\u0011+AQLW.\u001a>p]\u0016\u0004S\u0006\t;iK\u0002\"\u0018.\\3!u>tW\rI5eK:$\u0018NZ5fe:\u0002ci\u001c:!Kb\fW\u000e\u001d7fY\u0001\u001aU\t\u0016\u0017!+R\u001b\u0005%\u00198eA\u0015$8M\f\u0006!A\u0005AQ\r_1na2,7/\t\u0002\u0002r\u0006\u0019yA\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00153aE\"D\u0006I\u00193Y\u0001\u0012\u0004\b\f\u00117Y\u0001\u001a\u0004\u0007\f\u00115k9B\u0004hN\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AI\u0002\u0014\u0007N\u00172e5\u0012\u0004\b\t\u00197uM\u0002$\bN\u001b/qa:$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b\u001a1cQb\u0003%\r\u001a-AIBD\u0006\t\u001c-AM\u0002D\u0006\t\u001b6]aBt\u0007\f\u0011(\u0007\u0016#v%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\nD'L\u00193[I:\u0004EM\u0019;gARD'\u000e\u00189q]R\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006F\r\u00192s1\u0002c\u0007\f\u00114a1\u0002#g\r\u0017!keb\u0003E\u000e\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001\u0012\u0004'M\u001d.a]j\u0003'\r\u00111ai\u0002\u0004G\u000f\u00191\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\u0012\u0004'M\u001d-AE\u001aD\u0006I\u0019-AE\u0002D\u0006I\u00192Y\u0001\n$\u0007\f\u0011(!N#v%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!\u001dVcEJ\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015ok2dG\u0006I\u001c-AI\u0012D\u0006I\u00196Y\u0001\u001a\u0004\u0007\f\u00111SmR\u0001\u0005\t\u0011!A\u0001\u0002c*\u0016'M\u0015\u0001\u0002\u0013!B4s_V\u0004\u0018EAA|\u00039!\u0017\r^3uS6,wLZ;oGN\fQa]5oG\u0016\f#!!@\u0002\u000bMr3G\f\u0019\u0002!5\u000b7.\u001a+j[\u0016\u001cH/Y7q\u0019RS\u0006C\u0001\"+'\u0011Q#Q\u0001(\u0011\u001d\t\u001d!QB*T'N\u001b6kY5Tc6\u0011!\u0011\u0002\u0006\u0004\u0005\u0017Q\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005\u001f\u0011IAA\tBEN$(/Y2u\rVt7\r^5p]f\"\"A!\u0001\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a&\u0002\u000b\u0005\u0004\b\u000f\\=\u0015'E\u0014YB!\b\u0003 \t\u0005\"1\u0005B\u0013\u0005O\u0011ICa\u000b\t\u000bEk\u0003\u0019A*\t\u000b]k\u0003\u0019A*\t\u000bek\u0003\u0019A*\t\u000bmk\u0003\u0019A*\t\u000buk\u0003\u0019A*\t\u000b}k\u0003\u0019A*\t\u000b\u0005l\u0003\u0019A2\t\u000f\u001dl\u0003\u0013!a\u0001S\")Q.\fa\u0001'\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$\u0003(A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tM\"1\b\t\u0005\u0013\u0012\u0014)\u0004\u0005\u0007J\u0005o\u00196kU*T'\u000eL7+C\u0002\u0003:)\u0013a\u0001V;qY\u0016L\u0004\u0002\u0003B\u001f_\u0005\u0005\t\u0019A9\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005O\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003FA!\u0011\u0011\u0014B$\u0013\u0011\u0011I%a'\u0003\r=\u0013'.Z2u\u0001")
public class MakeTimestampLTZ
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression year;
    private final Expression month;
    private final Expression day;
    private final Expression hour;
    private final Expression min;
    private final Expression sec;
    private final Option<Expression> timezone;
    private final boolean failOnError;
    private final Expression child;
    private Expression canonicalized;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static boolean $lessinit$greater$default$8() {
        return MakeTimestampLTZ$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<Tuple9<Expression, Expression, Expression, Expression, Expression, Expression, Option<Expression>, Object, Expression>> unapply(MakeTimestampLTZ makeTimestampLTZ) {
        return MakeTimestampLTZ$.MODULE$.unapply(makeTimestampLTZ);
    }

    public static boolean apply$default$8() {
        return MakeTimestampLTZ$.MODULE$.apply$default$8();
    }

    public static Function1<Tuple9<Expression, Expression, Expression, Expression, Expression, Expression, Option<Expression>, Object, Expression>, MakeTimestampLTZ> tupled() {
        return MakeTimestampLTZ$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Expression, Function1<Option<Expression>, Function1<Object, Function1<Expression, MakeTimestampLTZ>>>>>>>>> curried() {
        return MakeTimestampLTZ$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public String sql() {
        return RuntimeReplaceable.sql$(this);
    }

    @Override
    public String mkString(Seq<String> childrenString) {
        return RuntimeReplaceable.mkString$(this, childrenString);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        MakeTimestampLTZ makeTimestampLTZ = this;
        synchronized (makeTimestampLTZ) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$RuntimeReplaceable$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Expression year() {
        return this.year;
    }

    public Expression month() {
        return this.month;
    }

    public Expression day() {
        return this.day;
    }

    public Expression hour() {
        return this.hour;
    }

    public Expression min() {
        return this.min;
    }

    public Expression sec() {
        return this.sec;
    }

    public Option<Expression> timezone() {
        return this.timezone;
    }

    public boolean failOnError() {
        return this.failOnError;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public String prettyName() {
        return "make_timestamp_ltz";
    }

    @Override
    public Seq<Expression> exprsReplaced() {
        return (Seq)new .colon.colon((Object)this.year(), (List)new .colon.colon((Object)this.month(), (List)new .colon.colon((Object)this.day(), (List)new .colon.colon((Object)this.hour(), (List)new .colon.colon((Object)this.min(), (List)new .colon.colon((Object)this.sec(), (List)Nil$.MODULE$))))));
    }

    @Override
    public Expression withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Expression x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        Expression x$4 = this.copy$default$3();
        Expression x$5 = this.copy$default$4();
        Expression x$6 = this.copy$default$5();
        Expression x$7 = this.copy$default$6();
        Option<Expression> x$8 = this.copy$default$7();
        boolean x$9 = this.copy$default$8();
        return this.copy(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$1);
    }

    public MakeTimestampLTZ copy(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Option<Expression> timezone, boolean failOnError, Expression child) {
        return new MakeTimestampLTZ(year, month, day, hour, min, sec, timezone, failOnError, child);
    }

    public Expression copy$default$1() {
        return this.year();
    }

    public Expression copy$default$2() {
        return this.month();
    }

    public Expression copy$default$3() {
        return this.day();
    }

    public Expression copy$default$4() {
        return this.hour();
    }

    public Expression copy$default$5() {
        return this.min();
    }

    public Expression copy$default$6() {
        return this.sec();
    }

    public Option<Expression> copy$default$7() {
        return this.timezone();
    }

    public boolean copy$default$8() {
        return this.failOnError();
    }

    public Expression copy$default$9() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "MakeTimestampLTZ";
    }

    public int productArity() {
        return 9;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.year();
                break;
            }
            case 1: {
                object = this.month();
                break;
            }
            case 2: {
                object = this.day();
                break;
            }
            case 3: {
                object = this.hour();
                break;
            }
            case 4: {
                object = this.min();
                break;
            }
            case 5: {
                object = this.sec();
                break;
            }
            case 6: {
                object = this.timezone();
                break;
            }
            case 7: {
                object = BoxesRunTime.boxToBoolean((boolean)this.failOnError());
                break;
            }
            case 8: {
                object = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MakeTimestampLTZ;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MakeTimestampLTZ)) return false;
        boolean bl = true;
        if (!bl) return false;
        MakeTimestampLTZ makeTimestampLTZ = (MakeTimestampLTZ)x$1;
        Expression expression = this.year();
        Expression expression2 = makeTimestampLTZ.year();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.month();
        Expression expression4 = makeTimestampLTZ.month();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.day();
        Expression expression6 = makeTimestampLTZ.day();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        Expression expression7 = this.hour();
        Expression expression8 = makeTimestampLTZ.hour();
        if (expression7 == null) {
            if (expression8 != null) {
                return false;
            }
        } else if (!expression7.equals(expression8)) return false;
        Expression expression9 = this.min();
        Expression expression10 = makeTimestampLTZ.min();
        if (expression9 == null) {
            if (expression10 != null) {
                return false;
            }
        } else if (!expression9.equals(expression10)) return false;
        Expression expression11 = this.sec();
        Expression expression12 = makeTimestampLTZ.sec();
        if (expression11 == null) {
            if (expression12 != null) {
                return false;
            }
        } else if (!expression11.equals(expression12)) return false;
        Option<Expression> option = this.timezone();
        Option<Expression> option2 = makeTimestampLTZ.timezone();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (this.failOnError() != makeTimestampLTZ.failOnError()) return false;
        Expression expression13 = this.child();
        Expression expression14 = makeTimestampLTZ.child();
        if (expression13 == null) {
            if (expression14 != null) {
                return false;
            }
        } else if (!expression13.equals(expression14)) return false;
        if (!makeTimestampLTZ.canEqual(this)) return false;
        return true;
    }

    public MakeTimestampLTZ(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Option<Expression> timezone, boolean failOnError, Expression child) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.min = min;
        this.sec = sec;
        this.timezone = timezone;
        this.failOnError = failOnError;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
    }

    public MakeTimestampLTZ(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec) {
        Expression x$1 = year;
        Expression x$2 = month;
        Expression x$3 = day;
        Expression x$4 = hour;
        Expression x$5 = min;
        Expression x$6 = sec;
        TimestampType$ x$7 = TimestampType$.MODULE$;
        Option<Expression> x$8 = MakeTimestamp$.MODULE$.apply$default$7();
        Option<String> x$9 = MakeTimestamp$.MODULE$.apply$default$8();
        boolean x$10 = MakeTimestamp$.MODULE$.apply$default$9();
        this(year, month, day, hour, min, sec, (Option<Expression>)None$.MODULE$, SQLConf$.MODULE$.get().ansiEnabled(), new MakeTimestamp(x$1, x$2, x$3, x$4, x$5, x$6, x$8, x$9, x$10, x$7));
    }

    public MakeTimestampLTZ(Expression year, Expression month, Expression day, Expression hour, Expression min, Expression sec, Expression timezone) {
        Expression x$1 = year;
        Expression x$2 = month;
        Expression x$3 = day;
        Expression x$4 = hour;
        Expression x$5 = min;
        Expression x$6 = sec;
        Some x$7 = new Some((Object)timezone);
        TimestampType$ x$8 = TimestampType$.MODULE$;
        Option<String> x$9 = MakeTimestamp$.MODULE$.apply$default$8();
        boolean x$10 = MakeTimestamp$.MODULE$.apply$default$9();
        this(year, month, day, hour, min, sec, (Option<Expression>)new Some((Object)timezone), SQLConf$.MODULE$.get().ansiEnabled(), new MakeTimestamp(x$1, x$2, x$3, x$4, x$5, x$6, (Option<Expression>)x$7, x$9, x$10, x$8));
    }
}

