/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.sql.streaming;

import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.streaming.StreamingQuery;
import scala.Predef$;
import scala.StringContext;
import scala.Symbol;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.SymbolLiteral;

public final class StructuredSessionization$ {
    public static StructuredSessionization$ MODULE$;

    static {
        new StructuredSessionization$();
    }

    public void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: StructuredSessionization <hostname> <port>");
            System.exit(1);
        }
        String host = args[0];
        int port = new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt();
        SparkSession spark = SparkSession$.MODULE$.builder().appName("StructuredSessionization").getOrCreate();
        Dataset lines = spark.readStream().format("socket").option("host", host).option("port", (long)port).option("includeTimestamp", true).load();
        Dataset events = lines.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"explode(split(value, ' ')) AS sessionId", "timestamp AS eventTime"}));
        Dataset sessionUpdates = events.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.session_window((Column)spark.implicits().StringToColumn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"eventTime"}))).$((Seq)Nil$.MODULE$), "10 seconds").as((Symbol)SymbolLiteral.bootstrap("apply", "session")), spark.implicits().symbolToColumn((Symbol)SymbolLiteral.bootstrap("apply", "sessionId"))})).agg(functions$.MODULE$.count("*").as("numEvents"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sessionId", "CAST(session.start AS LONG)", "CAST(session.end AS LONG)", "CAST(session.end AS LONG) - CAST(session.start AS LONG) AS durationMs", "numEvents"}));
        StreamingQuery query = sessionUpdates.writeStream().outputMode("update").format("console").start();
        query.awaitTermination();
    }

    private StructuredSessionization$() {
        MODULE$ = this;
    }
}

