% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/DataFrame.R
\name{write.jdbc}
\alias{write.jdbc}
\alias{write.jdbc,SparkDataFrame,character,character-method}
\title{Save the content of SparkDataFrame to an external database table via JDBC.}
\usage{
write.jdbc(x, url, tableName, mode = "error", ...)

\S4method{write.jdbc}{SparkDataFrame,character,character}(x, url, tableName, mode = "error", ...)
}
\arguments{
\item{x}{a SparkDataFrame.}

\item{url}{JDBC database url of the form \code{jdbc:subprotocol:subname}.}

\item{tableName}{the name of the table in the external database.}

\item{mode}{one of 'append', 'overwrite', 'error', 'errorifexists', 'ignore'
save mode (it is 'error' by default)}

\item{...}{additional JDBC database connection properties.}
}
\description{
Save the content of the SparkDataFrame to an external database table via JDBC. Additional JDBC
database connection properties can be set (...)
You can find the JDBC-specific option and parameter documentation for writing tables via JDBC in
\url{https://spark.apache.org/docs/latest/sql-data-sources-jdbc.html#data-source-option}{
Data Source Option} in the version you use.
}
\details{
Also, mode is used to specify the behavior of the save operation when
data already exists in the data source. There are four modes:
\itemize{
  \item 'append': Contents of this SparkDataFrame are expected to be appended to existing data.
  \item 'overwrite': Existing data is expected to be overwritten by the contents of this
        SparkDataFrame.
  \item 'error' or 'errorifexists': An exception is expected to be thrown.
  \item 'ignore': The save operation is expected to not save the contents of the SparkDataFrame
        and to not change the existing data.
}
}
\note{
write.jdbc since 2.0.0
}
\examples{
\dontrun{
sparkR.session()
jdbcUrl <- "jdbc:mysql://localhost:3306/databasename"
write.jdbc(df, jdbcUrl, "table", user = "username", password = "password")
}
}
\seealso{
Other SparkDataFrame functions: 
\code{\link{SparkDataFrame-class}},
\code{\link{agg}()},
\code{\link{alias}()},
\code{\link{arrange}()},
\code{\link{as.data.frame}()},
\code{\link{attach,SparkDataFrame-method}},
\code{\link{broadcast}()},
\code{\link{cache}()},
\code{\link{checkpoint}()},
\code{\link{coalesce}()},
\code{\link{collect}()},
\code{\link{colnames}()},
\code{\link{coltypes}()},
\code{\link{createOrReplaceTempView}()},
\code{\link{crossJoin}()},
\code{\link{cube}()},
\code{\link{dapplyCollect}()},
\code{\link{dapply}()},
\code{\link{describe}()},
\code{\link{dim}()},
\code{\link{distinct}()},
\code{\link{dropDuplicates}()},
\code{\link{dropna}()},
\code{\link{drop}()},
\code{\link{dtypes}()},
\code{\link{exceptAll}()},
\code{\link{except}()},
\code{\link{explain}()},
\code{\link{filter}()},
\code{\link{first}()},
\code{\link{gapplyCollect}()},
\code{\link{gapply}()},
\code{\link{getNumPartitions}()},
\code{\link{group_by}()},
\code{\link{head}()},
\code{\link{hint}()},
\code{\link{histogram}()},
\code{\link{insertInto}()},
\code{\link{intersectAll}()},
\code{\link{intersect}()},
\code{\link{isLocal}()},
\code{\link{isStreaming}()},
\code{\link{join}()},
\code{\link{limit}()},
\code{\link{localCheckpoint}()},
\code{\link{merge}()},
\code{\link{mutate}()},
\code{\link{ncol}()},
\code{\link{nrow}()},
\code{\link{persist}()},
\code{\link{printSchema}()},
\code{\link{randomSplit}()},
\code{\link{rbind}()},
\code{\link{rename}()},
\code{\link{repartitionByRange}()},
\code{\link{repartition}()},
\code{\link{rollup}()},
\code{\link{sample}()},
\code{\link{saveAsTable}()},
\code{\link{schema}()},
\code{\link{selectExpr}()},
\code{\link{select}()},
\code{\link{showDF}()},
\code{\link{show}()},
\code{\link{storageLevel}()},
\code{\link{str}()},
\code{\link{subset}()},
\code{\link{summary}()},
\code{\link{take}()},
\code{\link{toJSON}()},
\code{\link{unionAll}()},
\code{\link{unionByName}()},
\code{\link{union}()},
\code{\link{unpersist}()},
\code{\link{withColumn}()},
\code{\link{withWatermark}()},
\code{\link{with}()},
\code{\link{write.df}()},
\code{\link{write.json}()},
\code{\link{write.orc}()},
\code{\link{write.parquet}()},
\code{\link{write.stream}()},
\code{\link{write.text}()}
}
\concept{SparkDataFrame functions}
