% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SQLContext.R
\name{read.json}
\alias{read.json}
\title{Create a SparkDataFrame from a JSON file.}
\usage{
read.json(path, ...)
}
\arguments{
\item{path}{Path of file to read. A vector of multiple paths is allowed.}

\item{...}{additional external data source specific named properties.
You can find the JSON-specific options for reading JSON files in
\url{
https://spark.apache.org/docs/latest/sql-data-sources-json.html#data-source-option}{
Data Source Option} in the version you use.}
}
\value{
SparkDataFrame
}
\description{
Loads a JSON file, returning the result as a SparkDataFrame
By default, (\href{https://jsonlines.org/}{JSON Lines text format or newline-delimited JSON}
) is supported. For JSON (one record per file), set a named property \code{multiLine} to
\code{TRUE}.
It goes through the entire dataset once to determine the schema.
}
\note{
read.json since 1.6.0
}
\examples{
\dontrun{
sparkR.session()
path <- "path/to/file.json"
df <- read.json(path)
df <- read.json(path, multiLine = TRUE)
}
}
