% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/column.R, R/DataFrame.R
\name{alias}
\alias{alias}
\alias{alias,Column-method}
\alias{alias,SparkDataFrame-method}
\title{alias}
\usage{
\S4method{alias}{Column}(object, data)

\S4method{alias}{SparkDataFrame}(object, data)
}
\arguments{
\item{object}{x a SparkDataFrame or a Column}

\item{data}{new name to use}
}
\value{
a SparkDataFrame or a Column
}
\description{
Returns a new SparkDataFrame or a Column with an alias set. Equivalent to SQL "AS" keyword.
}
\note{
alias(Column) since 1.4.0

alias(SparkDataFrame) since 2.3.0
}
\examples{
\dontrun{
df <- createDataFrame(iris)

head(select(
  df, alias(df$Sepal_Length, "slength"), alias(df$Petal_Length, "plength")
))
}
\dontrun{
df <- alias(createDataFrame(mtcars), "mtcars")
avg_mpg <- alias(agg(groupBy(df, df$cyl), avg(df$mpg)), "avg_mpg")

head(select(df, column("mtcars.mpg")))
head(join(df, avg_mpg, column("mtcars.cyl") == column("avg_mpg.cyl")))
}
}
\seealso{
Other column_func: 
\code{\link{between}()},
\code{\link{cast}()},
\code{\link{endsWith}()},
\code{\link{otherwise}()},
\code{\link{over}()},
\code{\link{startsWith}()},
\code{\link{substr}()}

Other SparkDataFrame functions: 
\code{\link{SparkDataFrame-class}},
\code{\link{agg}()},
\code{\link{arrange}()},
\code{\link{as.data.frame}()},
\code{\link{attach,SparkDataFrame-method}},
\code{\link{broadcast}()},
\code{\link{cache}()},
\code{\link{checkpoint}()},
\code{\link{coalesce}()},
\code{\link{collect}()},
\code{\link{colnames}()},
\code{\link{coltypes}()},
\code{\link{createOrReplaceTempView}()},
\code{\link{crossJoin}()},
\code{\link{cube}()},
\code{\link{dapplyCollect}()},
\code{\link{dapply}()},
\code{\link{describe}()},
\code{\link{dim}()},
\code{\link{distinct}()},
\code{\link{dropDuplicates}()},
\code{\link{dropna}()},
\code{\link{drop}()},
\code{\link{dtypes}()},
\code{\link{exceptAll}()},
\code{\link{except}()},
\code{\link{explain}()},
\code{\link{filter}()},
\code{\link{first}()},
\code{\link{gapplyCollect}()},
\code{\link{gapply}()},
\code{\link{getNumPartitions}()},
\code{\link{group_by}()},
\code{\link{head}()},
\code{\link{hint}()},
\code{\link{histogram}()},
\code{\link{insertInto}()},
\code{\link{intersectAll}()},
\code{\link{intersect}()},
\code{\link{isLocal}()},
\code{\link{isStreaming}()},
\code{\link{join}()},
\code{\link{limit}()},
\code{\link{localCheckpoint}()},
\code{\link{merge}()},
\code{\link{mutate}()},
\code{\link{ncol}()},
\code{\link{nrow}()},
\code{\link{persist}()},
\code{\link{printSchema}()},
\code{\link{randomSplit}()},
\code{\link{rbind}()},
\code{\link{rename}()},
\code{\link{repartitionByRange}()},
\code{\link{repartition}()},
\code{\link{rollup}()},
\code{\link{sample}()},
\code{\link{saveAsTable}()},
\code{\link{schema}()},
\code{\link{selectExpr}()},
\code{\link{select}()},
\code{\link{showDF}()},
\code{\link{show}()},
\code{\link{storageLevel}()},
\code{\link{str}()},
\code{\link{subset}()},
\code{\link{summary}()},
\code{\link{take}()},
\code{\link{toJSON}()},
\code{\link{unionAll}()},
\code{\link{unionByName}()},
\code{\link{union}()},
\code{\link{unpersist}()},
\code{\link{withColumn}()},
\code{\link{withWatermark}()},
\code{\link{with}()},
\code{\link{write.df}()},
\code{\link{write.jdbc}()},
\code{\link{write.json}()},
\code{\link{write.orc}()},
\code{\link{write.parquet}()},
\code{\link{write.stream}()},
\code{\link{write.text}()}
}
\concept{SparkDataFrame functions}
\concept{column_func}
