/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.util.Locale;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkUpgradeException;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.util.RebaseDateTime$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.parquet.ParquetOptions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.package$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.util.Utils$;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenSetLike;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class DataSourceUtils$ {
    public static DataSourceUtils$ MODULE$;
    private final String PARTITIONING_COLUMNS_KEY;
    private final Formats formats;

    static {
        new DataSourceUtils$();
    }

    public String PARTITIONING_COLUMNS_KEY() {
        return this.PARTITIONING_COLUMNS_KEY;
    }

    private Formats formats() {
        return this.formats;
    }

    public String encodePartitioningColumns(Seq<String> columns) {
        return Serialization$.MODULE$.write(columns, this.formats());
    }

    public Seq<String> decodePartitioningColumns(String str) {
        return (Seq)Serialization$.MODULE$.read(str, this.formats(), ManifestFactory$.MODULE$.classType(Seq.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
    }

    public void checkFieldNames(FileFormat format, StructType schema) {
        schema.foreach((Function1 & Serializable & scala.Serializable)field -> {
            DataSourceUtils$.$anonfun$checkFieldNames$1(format, field);
            return BoxedUnit.UNIT;
        });
    }

    public void verifySchema(FileFormat format, StructType schema) {
        schema.foreach((Function1 & Serializable & scala.Serializable)field -> {
            DataSourceUtils$.$anonfun$verifySchema$1(format, field);
            return BoxedUnit.UNIT;
        });
        this.checkFieldNames(format, schema);
    }

    public boolean isDataPath(Path path) {
        return this.isDataFile(path.getName());
    }

    public boolean isDataFile(String fileName) {
        return !fileName.startsWith("_") && !fileName.startsWith(".");
    }

    public boolean supportNestedPredicatePushdown(BaseRelation relation) {
        boolean bl;
        BaseRelation baseRelation = relation;
        if (baseRelation instanceof HadoopFsRelation) {
            HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
            Seq supportedDatasources = Utils$.MODULE$.stringToSeq(((String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.NESTED_PREDICATE_PUSHDOWN_FILE_SOURCE_LIST())).toLowerCase(Locale.ROOT));
            bl = supportedDatasources.contains((Object)hadoopFsRelation.toString());
        } else {
            bl = false;
        }
        return bl;
    }

    public Enumeration.Value datetimeRebaseMode(Function1<String, String> lookupFileMeta, String modeByConfig) {
        if (Utils$.MODULE$.isTesting()) {
            String string = SQLConf$.MODULE$.get().getConfString("spark.test.forceNoRebase", "");
            String string2 = "true";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
            }
        }
        return (Enumeration.Value)Option$.MODULE$.apply(lookupFileMeta.apply((Object)package$.MODULE$.SPARK_VERSION_METADATA_KEY())).map((Function1 & Serializable & scala.Serializable)version -> new StringOps(Predef$.MODULE$.augmentString(version)).$less((Object)"3.0.0") || lookupFileMeta.apply((Object)package$.MODULE$.SPARK_LEGACY_DATETIME()) != null ? SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY() : SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED()).getOrElse((Function0 & Serializable & scala.Serializable)() -> SQLConf.LegacyBehaviorPolicy$.MODULE$.withName(modeByConfig));
    }

    public Enumeration.Value int96RebaseMode(Function1<String, String> lookupFileMeta, String modeByConfig) {
        if (Utils$.MODULE$.isTesting()) {
            String string = SQLConf$.MODULE$.get().getConfString("spark.test.forceNoRebase", "");
            String string2 = "true";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
            }
        }
        return (Enumeration.Value)Option$.MODULE$.apply(lookupFileMeta.apply((Object)package$.MODULE$.SPARK_VERSION_METADATA_KEY())).map((Function1 & Serializable & scala.Serializable)version -> new StringOps(Predef$.MODULE$.augmentString(version)).$less((Object)"3.1.0") || lookupFileMeta.apply((Object)package$.MODULE$.SPARK_LEGACY_INT96()) != null ? SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY() : SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED()).getOrElse((Function0 & Serializable & scala.Serializable)() -> SQLConf.LegacyBehaviorPolicy$.MODULE$.withName(modeByConfig));
    }

    public SparkUpgradeException newRebaseExceptionInRead(String format) {
        Tuple2 tuple2;
        String string = format;
        if ("Parquet INT96".equals(string)) {
            tuple2 = new Tuple2((Object)SQLConf$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_READ().key(), (Object)ParquetOptions$.MODULE$.INT96_REBASE_MODE());
        } else if ("Parquet".equals(string)) {
            tuple2 = new Tuple2((Object)SQLConf$.MODULE$.PARQUET_REBASE_MODE_IN_READ().key(), (Object)ParquetOptions$.MODULE$.DATETIME_REBASE_MODE());
        } else if ("Avro".equals(string)) {
            tuple2 = new Tuple2((Object)SQLConf$.MODULE$.AVRO_REBASE_MODE_IN_READ().key(), (Object)"datetimeRebaseMode");
        } else {
            throw QueryExecutionErrors$.MODULE$.unrecognizedFileFormatError(format);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        String config = (String)tuple22._1();
        String option = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)config, (Object)option);
        Tuple2 tuple24 = tuple23;
        String config2 = (String)tuple24._1();
        String option2 = (String)tuple24._2();
        return QueryExecutionErrors$.MODULE$.sparkUpgradeInReadingDatesError(format, config2, option2);
    }

    public SparkUpgradeException newRebaseExceptionInWrite(String format) {
        String string;
        String string2 = format;
        if ("Parquet INT96".equals(string2)) {
            string = SQLConf$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_WRITE().key();
        } else if ("Parquet".equals(string2)) {
            string = SQLConf$.MODULE$.PARQUET_REBASE_MODE_IN_WRITE().key();
        } else if ("Avro".equals(string2)) {
            string = SQLConf$.MODULE$.AVRO_REBASE_MODE_IN_WRITE().key();
        } else {
            throw QueryExecutionErrors$.MODULE$.unrecognizedFileFormatError(format);
        }
        String config = string;
        return QueryExecutionErrors$.MODULE$.sparkUpgradeInWritingDatesError(format, config);
    }

    public Function1<Object, Object> creteDateRebaseFuncInRead(Enumeration.Value rebaseMode, String format) {
        JFunction1.mcII.sp & Serializable & scala.Serializable intersect;
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (JFunction1.mcII.sp & Serializable & scala.Serializable)days -> {
                if (days < RebaseDateTime$.MODULE$.lastSwitchJulianDay()) {
                    throw MODULE$.newRebaseExceptionInRead(format);
                }
                return days;
            };
        } else {
            Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (JFunction1.mcII.sp & Serializable & scala.Serializable)days -> RebaseDateTime$.MODULE$.rebaseJulianToGregorianDays(days);
            } else {
                Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (JFunction1.mcII.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return intersect;
    }

    public Function1<Object, Object> creteDateRebaseFuncInWrite(Enumeration.Value rebaseMode, String format) {
        JFunction1.mcII.sp & Serializable & scala.Serializable intersect;
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (JFunction1.mcII.sp & Serializable & scala.Serializable)days -> {
                if (days < RebaseDateTime$.MODULE$.lastSwitchGregorianDay()) {
                    throw MODULE$.newRebaseExceptionInWrite(format);
                }
                return days;
            };
        } else {
            Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (JFunction1.mcII.sp & Serializable & scala.Serializable)days -> RebaseDateTime$.MODULE$.rebaseGregorianToJulianDays(days);
            } else {
                Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (JFunction1.mcII.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return intersect;
    }

    public Function1<Object, Object> creteTimestampRebaseFuncInRead(Enumeration.Value rebaseMode, String format) {
        JFunction1.mcJJ.sp & Serializable & scala.Serializable intersect;
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)micros -> {
                if (micros < RebaseDateTime$.MODULE$.lastSwitchJulianTs()) {
                    throw MODULE$.newRebaseExceptionInRead(format);
                }
                return micros;
            };
        } else {
            Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)micros -> RebaseDateTime$.MODULE$.rebaseJulianToGregorianMicros(micros);
            } else {
                Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return intersect;
    }

    public Function1<Object, Object> creteTimestampRebaseFuncInWrite(Enumeration.Value rebaseMode, String format) {
        JFunction1.mcJJ.sp & Serializable & scala.Serializable intersect;
        Enumeration.Value value = rebaseMode;
        Enumeration.Value value2 = SQLConf.LegacyBehaviorPolicy$.MODULE$.EXCEPTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            intersect = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)micros -> {
                if (micros < RebaseDateTime$.MODULE$.lastSwitchGregorianTs()) {
                    throw MODULE$.newRebaseExceptionInWrite(format);
                }
                return micros;
            };
        } else {
            Enumeration.Value value4 = SQLConf.LegacyBehaviorPolicy$.MODULE$.LEGACY();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                intersect = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)micros -> RebaseDateTime$.MODULE$.rebaseGregorianToJulianMicros(micros);
            } else {
                Enumeration.Value value6 = SQLConf.LegacyBehaviorPolicy$.MODULE$.CORRECTED();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    intersect = (JFunction1.mcJJ.sp & Serializable & scala.Serializable)x -> BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToLong((long)x)));
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        return intersect;
    }

    public Map<String, String> generateDatasourceOptions(CaseInsensitiveStringMap extraOptions, CatalogTable table) {
        Map map;
        Option pathOption = table.storage().locationUri().map((Function1 & Serializable & scala.Serializable)x$2 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)CatalogUtils$.MODULE$.URIToString(x$2)));
        Map options = table.storage().properties().$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(pathOption));
        if (!BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_EXTRA_OPTIONS_BEHAVIOR()))) {
            table.storage().properties().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DataSourceUtils$.$anonfun$generateDatasourceOptions$2(extraOptions, table, x0$1);
                return BoxedUnit.UNIT;
            });
            Set lowerCasedDuplicatedKeys = (Set)((GenSetLike)table.storage().properties().keySet().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toLowerCase(Locale.ROOT), Set$.MODULE$.canBuildFrom())).intersect((GenSet)JavaConverters$.MODULE$.asScalaSetConverter(extraOptions.keySet()).asScala());
            map = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(extraOptions.asCaseSensitiveMap()).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DataSourceUtils$.$anonfun$generateDatasourceOptions$4(lowerCasedDuplicatedKeys, x0$2))).toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)options);
        } else {
            map = options;
        }
        return map;
    }

    public static final /* synthetic */ void $anonfun$checkFieldNames$1(FileFormat format$1, StructField field) {
        if (!format$1.supportFieldName(field.name())) {
            throw QueryCompilationErrors$.MODULE$.columnNameContainsInvalidCharactersError(field.name());
        }
        DataType dataType = field.dataType();
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            MODULE$.checkFieldNames(format$1, structType);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$verifySchema$1(FileFormat format$2, StructField field) {
        if (!format$2.supportDataType(field.dataType())) {
            throw QueryCompilationErrors$.MODULE$.dataTypeUnsupportedByDataSourceError(format$2.toString(), field);
        }
    }

    public static final /* synthetic */ void $anonfun$generateDatasourceOptions$2(CaseInsensitiveStringMap extraOptions$1, CatalogTable table$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            if (extraOptions$1.containsKey((Object)k)) {
                String string = extraOptions$1.get((Object)k);
                String string2 = v;
                if (string == null ? string2 != null : !string.equals(string2)) {
                    throw QueryCompilationErrors$.MODULE$.failToResolveDataSourceForTableError(table$1, k);
                }
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$generateDatasourceOptions$4(Set lowerCasedDuplicatedKeys$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        boolean bl = lowerCasedDuplicatedKeys$1.contains((Object)k.toLowerCase(Locale.ROOT));
        return bl;
    }

    private DataSourceUtils$() {
        MODULE$ = this;
        this.PARTITIONING_COLUMNS_KEY = "__partition_columns";
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
    }
}

