/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayBinaryLike;
import org.apache.spark.sql.catalyst.expressions.ArrayIntersect$;
import org.apache.spark.sql.catalyst.expressions.ArraySetLike;
import org.apache.spark.sql.catalyst.expressions.BinaryArrayExpressionWithImplicitCast;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ComplexTypeMergingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.util.SQLOpenHashSet;
import org.apache.spark.sql.util.SQLOpenHashSet$;
import org.apache.spark.unsafe.array.ByteArrayMethods;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n  _FUNC_(array1, array2) - Returns an array of the elements in the intersection of array1 and\n    array2, without duplicates.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(1, 2, 3), array(1, 3, 5));\n       [1,3]\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005]g\u0001\u0002\u000f\u001e\u0001*B\u0001B\u0010\u0001\u0003\u0016\u0004%\ta\u0010\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005\u0001\"AA\t\u0001BK\u0002\u0013\u0005q\b\u0003\u0005F\u0001\tE\t\u0015!\u0003A\u0011\u00151\u0005\u0001\"\u0001H\u0011!Y\u0005\u0001#b\u0001\n\u0013a\u0005\"B*\u0001\t\u0003b\u0005\u0002\u0003+\u0001\u0011\u000b\u0007I\u0011A+\t\u000b\r\u0004A\u0011\t3\t\u000b1\u0004A\u0011I7\t\u000bm\u0004A\u0011\t?\t\u0013\u0005E\u0001!!A\u0005\u0002\u0005M\u0001\"CA\r\u0001E\u0005I\u0011AA\u000e\u0011%\t\t\u0004AI\u0001\n\u0003\tY\u0002C\u0005\u00024\u0001\t\t\u0011\"\u0011\u00026!I\u0011Q\t\u0001\u0002\u0002\u0013\u0005\u0011q\t\u0005\n\u0003\u001f\u0002\u0011\u0011!C\u0001\u0003#B\u0011\"a\u0016\u0001\u0003\u0003%\t%!\u0017\t\u0013\u0005\u001d\u0004!!A\u0005\u0002\u0005%\u0004\"CA:\u0001\u0005\u0005I\u0011IA;\u000f%\tI*HA\u0001\u0012\u0003\tYJ\u0002\u0005\u001d;\u0005\u0005\t\u0012AAO\u0011\u00191e\u0003\"\u0001\u0002,\"I\u0011Q\u0016\f\u0002\u0002\u0013\u0015\u0013q\u0016\u0005\n\u0003c3\u0012\u0011!CA\u0003gC\u0011\"!/\u0017\u0003\u0003%\t)a/\t\u0013\u00055g#!A\u0005\n\u0005='AD!se\u0006L\u0018J\u001c;feN,7\r\u001e\u0006\u0003=}\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0001%I\u0001\tG\u0006$\u0018\r\\=ti*\u0011!eI\u0001\u0004gFd'B\u0001\u0013&\u0003\u0015\u0019\b/\u0019:l\u0015\t1s%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0005\u0019qN]4\u0004\u0001M1\u0001aK\u00183km\u0002\"\u0001L\u0017\u000e\u0003uI!AL\u000f\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u00171\u0013\t\tTDA\bBeJ\f\u0017PQ5oCJLH*[6f!\ta3'\u0003\u00025;\ta2i\\7qY\u0016DH+\u001f9f\u001b\u0016\u0014x-\u001b8h\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$a\u0002)s_\u0012,8\r\u001e\t\u0003mqJ!!P\u001c\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\t1,g\r^\u000b\u0002\u0001B\u0011A&Q\u0005\u0003\u0005v\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u00051A(\u001b8jiz\"2\u0001S%K!\ta\u0003\u0001C\u0003?\u000b\u0001\u0007\u0001\tC\u0003E\u000b\u0001\u0007\u0001)\u0001\tj]R,'O\\1m\t\u0006$\u0018\rV=qKV\tQ\n\u0005\u0002O#6\tqJ\u0003\u0002QC\u0005)A/\u001f9fg&\u0011!k\u0014\u0002\t\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-A\u0007fm\u0006d\u0017J\u001c;feN,7\r^\u000b\u0002-B)agV-Z3&\u0011\u0001l\u000e\u0002\n\rVt7\r^5p]J\u0002\"AW/\u000e\u0003mS!\u0001X\u0010\u0002\tU$\u0018\u000e\\\u0005\u0003=n\u0013\u0011\"\u0011:sCf$\u0015\r^1)\u0005!\u0001\u0007C\u0001\u001cb\u0013\t\u0011wGA\u0005ue\u0006t7/[3oi\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0019Q\r\u001b6\u0011\u0005Y2\u0017BA48\u0005\r\te.\u001f\u0005\u0006S&\u0001\r!Z\u0001\u0007S:\u0004X\u000f^\u0019\t\u000b-L\u0001\u0019A3\u0002\r%t\u0007/\u001e;3\u0003%!wnR3o\u0007>$W\rF\u0002oif\u0004\"a\u001c:\u000e\u0003AT!!]\u000f\u0002\u000f\r|G-Z4f]&\u00111\u000f\u001d\u0002\t\u000bb\u0004(oQ8eK\")QO\u0003a\u0001m\u0006\u00191\r\u001e=\u0011\u0005=<\u0018B\u0001=q\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQA\u001f\u0006A\u00029\f!!\u001a<\u0002\u0015A\u0014X\r\u001e;z\u001d\u0006lW-F\u0001~!\rq\u00181\u0002\b\u0004\u007f\u0006\u001d\u0001cAA\u0001o5\u0011\u00111\u0001\u0006\u0004\u0003\u000bI\u0013A\u0002\u001fs_>$h(C\u0002\u0002\n]\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0007\u0003\u001f\u0011aa\u0015;sS:<'bAA\u0005o\u0005!1m\u001c9z)\u0015A\u0015QCA\f\u0011\u001dqD\u0002%AA\u0002\u0001Cq\u0001\u0012\u0007\u0011\u0002\u0003\u0007\u0001)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005u!f\u0001!\u0002 -\u0012\u0011\u0011\u0005\t\u0005\u0003G\ti#\u0004\u0002\u0002&)!\u0011qEA\u0015\u0003%)hn\u00195fG.,GMC\u0002\u0002,]\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty#!\n\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\u0004\u0005\u0003\u0002:\u0005\rSBAA\u001e\u0015\u0011\ti$a\u0010\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0003\nAA[1wC&!\u0011QBA\u001e\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tI\u0005E\u00027\u0003\u0017J1!!\u00148\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r)\u00171\u000b\u0005\n\u0003+\n\u0012\u0011!a\u0001\u0003\u0013\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA.!\u0015\ti&a\u0019f\u001b\t\tyFC\u0002\u0002b]\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)'a\u0018\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003W\n\t\bE\u00027\u0003[J1!a\u001c8\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u0016\u0014\u0003\u0003\u0005\r!Z\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005-\u0014q\u000f\u0005\t\u0003+\"\u0012\u0011!a\u0001K\"\u001a\u0002!a\u001f\u0002\u0002\u0006\r\u0015qQAE\u0003\u001b\u000by)a%\u0002\u0016B\u0019A&! \n\u0007\u0005}TDA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u0015\u0015!a\u0001\u000bA\u0001zf)\u0016(D?\"\n'O]1zc1\u0002\u0013M\u001d:bsJJ\u0003%\f\u0011SKR,(O\\:!C:\u0004\u0013M\u001d:bs\u0002zg\r\t;iK\u0002*G.Z7f]R\u001c\b%\u001b8!i\",\u0007%\u001b8uKJ\u001cXm\u0019;j_:\u0004sN\u001a\u0011beJ\f\u00170\r\u0011b]\u0012T\u0001\u0005\t\u0011!CJ\u0014\u0018-\u001f\u001a-A]LG\u000f[8vi\u0002\"W\u000f\u001d7jG\u0006$Xm\u001d\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u0017\u000bQK\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u0019-AIb\u0003eM\u0015-A\u0005\u0014(/Y=)c1\u00023\u0007\f\u00116S%Z$\u0002\t\u0011!A\u0001\u0002\u0003eW\u0019-guS\u0001\u0005I\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003#\u000b1\"\u0019:sCf|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011qS\u0001\u0006e9\"d\u0006M\u0001\u000f\u0003J\u0014\u0018-_%oi\u0016\u00148/Z2u!\tacc\u0005\u0003\u0017\u0003?[\u0004cBAQ\u0003O\u0003\u0005\tS\u0007\u0003\u0003GS1!!*8\u0003\u001d\u0011XO\u001c;j[\u0016LA!!+\u0002$\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\u0005m\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0012!B1qa2LH#\u0002%\u00026\u0006]\u0006\"\u0002 \u001a\u0001\u0004\u0001\u0005\"\u0002#\u001a\u0001\u0004\u0001\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003{\u000bI\rE\u00037\u0003\u007f\u000b\u0019-C\u0002\u0002B^\u0012aa\u00149uS>t\u0007#\u0002\u001c\u0002F\u0002\u0003\u0015bAAdo\t1A+\u001e9mKJB\u0001\"a3\u001b\u0003\u0003\u0005\r\u0001S\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!5\u0011\t\u0005e\u00121[\u0005\u0005\u0003+\fYD\u0001\u0004PE*,7\r\u001e")
public class ArrayIntersect
extends BinaryExpression
implements ArrayBinaryLike,
ComplexTypeMergingExpression,
scala.Serializable {
    private DataType internalDataType;
    private transient Function2<ArrayData, ArrayData, ArrayData> evalIntersect;
    private final Expression left;
    private final Expression right;
    private transient Seq<DataType> inputTypesForMerging;
    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    private transient boolean canUseSpecializedHashSet;
    private transient Ordering<Object> ordering;
    private Tuple2<String, String> org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$73;
    private transient String hsPostFix;
    private transient String hsTypeName;
    private transient String hsValueCast;
    private transient String nullValueHolder;
    private transient DataType elementType;
    private volatile transient int bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayIntersect arrayIntersect) {
        return ArrayIntersect$.MODULE$.unapply(arrayIntersect);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayIntersect> tupled() {
        return ArrayIntersect$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayIntersect>> curried() {
        return ArrayIntersect$.MODULE$.curried();
    }

    @Override
    public void dataTypeCheck() {
        ComplexTypeMergingExpression.dataTypeCheck$(this);
    }

    @Override
    public /* synthetic */ TypeCheckResult org$apache$spark$sql$catalyst$expressions$ArrayBinaryLike$$super$checkInputDataTypes() {
        return BinaryArrayExpressionWithImplicitCast.checkInputDataTypes$(this);
    }

    @Override
    public DataType dt() {
        return ArrayBinaryLike.dt$(this);
    }

    @Override
    public DataType et() {
        return ArrayBinaryLike.et$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ArrayBinaryLike.checkInputDataTypes$(this);
    }

    @Override
    public String genGetValue(String array, String i) {
        return ArraySetLike.genGetValue$(this, array, i);
    }

    @Override
    public String withResultArrayNullCheck(String body, String value, String nullElementIndex) {
        return ArraySetLike.withResultArrayNullCheck$(this, body, value, nullElementIndex);
    }

    @Override
    public String buildResultArray(String builder, String value, String size, String nullElementIndex) {
        return ArraySetLike.buildResultArray$(this, builder, value, size, nullElementIndex);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return BinaryArrayExpressionWithImplicitCast.inputTypes$(this);
    }

    private Seq<DataType> inputTypesForMerging$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 2) == 0) {
                this.inputTypesForMerging = ComplexTypeMergingExpression.inputTypesForMerging$(this);
                this.bitmap$trans$0 |= 2;
            }
        }
        return this.inputTypesForMerging;
    }

    @Override
    public Seq<DataType> inputTypesForMerging() {
        return (this.bitmap$trans$0 & 2) == 0 ? this.inputTypesForMerging$lzycompute() : this.inputTypesForMerging;
    }

    private DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType = ComplexTypeMergingExpression.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    @Override
    public DataType org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ComplexTypeMergingExpression$$internalDataType;
    }

    private boolean canUseSpecializedHashSet$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 4) == 0) {
                this.canUseSpecializedHashSet = ArraySetLike.canUseSpecializedHashSet$(this);
                this.bitmap$trans$0 |= 4;
            }
        }
        return this.canUseSpecializedHashSet;
    }

    @Override
    public boolean canUseSpecializedHashSet() {
        return (this.bitmap$trans$0 & 4) == 0 ? this.canUseSpecializedHashSet$lzycompute() : this.canUseSpecializedHashSet;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 8) == 0) {
                this.ordering = ArraySetLike.ordering$(this);
                this.bitmap$trans$0 |= 8;
            }
        }
        return this.ordering;
    }

    @Override
    public Ordering<Object> ordering() {
        return (this.bitmap$trans$0 & 8) == 0 ? this.ordering$lzycompute() : this.ordering;
    }

    private Tuple2<String, String> org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$73$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$73 = ArraySetLike.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$73$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$73;
    }

    @Override
    public /* synthetic */ Tuple2 org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$73() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$73$lzycompute() : this.org$apache$spark$sql$catalyst$expressions$ArraySetLike$$x$73;
    }

    private String hsPostFix$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x10) == 0) {
                this.hsPostFix = ArraySetLike.hsPostFix$(this);
                this.bitmap$trans$0 |= 0x10;
            }
        }
        return this.hsPostFix;
    }

    @Override
    public String hsPostFix() {
        return (this.bitmap$trans$0 & 0x10) == 0 ? this.hsPostFix$lzycompute() : this.hsPostFix;
    }

    private String hsTypeName$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x20) == 0) {
                this.hsTypeName = ArraySetLike.hsTypeName$(this);
                this.bitmap$trans$0 |= 0x20;
            }
        }
        return this.hsTypeName;
    }

    @Override
    public String hsTypeName() {
        return (this.bitmap$trans$0 & 0x20) == 0 ? this.hsTypeName$lzycompute() : this.hsTypeName;
    }

    private String hsValueCast$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x40) == 0) {
                this.hsValueCast = ArraySetLike.hsValueCast$(this);
                this.bitmap$trans$0 |= 0x40;
            }
        }
        return this.hsValueCast;
    }

    @Override
    public String hsValueCast() {
        return (this.bitmap$trans$0 & 0x40) == 0 ? this.hsValueCast$lzycompute() : this.hsValueCast;
    }

    private String nullValueHolder$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x80) == 0) {
                this.nullValueHolder = ArraySetLike.nullValueHolder$(this);
                this.bitmap$trans$0 |= 0x80;
            }
        }
        return this.nullValueHolder;
    }

    @Override
    public String nullValueHolder() {
        return (this.bitmap$trans$0 & 0x80) == 0 ? this.nullValueHolder$lzycompute() : this.nullValueHolder;
    }

    private DataType elementType$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 0x100) == 0) {
                this.elementType = BinaryArrayExpressionWithImplicitCast.elementType$(this);
                this.bitmap$trans$0 |= 0x100;
            }
        }
        return this.elementType;
    }

    @Override
    public DataType elementType() {
        return (this.bitmap$trans$0 & 0x100) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private DataType internalDataType$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.dataTypeCheck();
                this.internalDataType = new ArrayType(this.elementType(), ((ArrayType)this.left().dataType()).containsNull() && ((ArrayType)this.right().dataType()).containsNull());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.internalDataType;
    }

    private DataType internalDataType() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.internalDataType$lzycompute() : this.internalDataType;
    }

    @Override
    public DataType dataType() {
        return this.internalDataType();
    }

    private Function2<ArrayData, ArrayData, ArrayData> evalIntersect$lzycompute() {
        ArrayIntersect arrayIntersect = this;
        synchronized (arrayIntersect) {
            if ((this.bitmap$trans$0 & 1) == 0) {
                this.evalIntersect = TypeUtils$.MODULE$.typeWithProperEquals(this.elementType()) ? (Function2 & Serializable & scala.Serializable)(array1, array2) -> {
                    GenericArrayData genericArrayData;
                    if (array1.numElements() != 0 && array2.numElements() != 0) {
                        int i;
                        SQLOpenHashSet<Object> hs = new SQLOpenHashSet<Object>(ClassTag$.MODULE$.Any());
                        SQLOpenHashSet<Object> hsResult = new SQLOpenHashSet<Object>(ClassTag$.MODULE$.Any());
                        ArrayBuffer arrayBuffer = new ArrayBuffer();
                        Function1<Object, BoxedUnit> withArray2NaNCheckFunc = SQLOpenHashSet$.MODULE$.withNaNCheckFunc(this.elementType(), hs, (Function1<Object, BoxedUnit>)(Function1 & Serializable & scala.Serializable)value -> {
                            hs.add(value);
                            return BoxedUnit.UNIT;
                        }, (Function1<Object, BoxedUnit>)(Function1 & Serializable & scala.Serializable)valueNaN -> {
                            ArrayIntersect.$anonfun$evalIntersect$3(valueNaN);
                            return BoxedUnit.UNIT;
                        });
                        Function1<Object, BoxedUnit> withArray1NaNCheckFunc = SQLOpenHashSet$.MODULE$.withNaNCheckFunc(this.elementType(), hsResult, (Function1<Object, BoxedUnit>)(Function1 & Serializable & scala.Serializable)value -> {
                            ArrayIntersect.$anonfun$evalIntersect$4(hs, hsResult, arrayBuffer, value);
                            return BoxedUnit.UNIT;
                        }, (Function1<Object, BoxedUnit>)(Function1 & Serializable & scala.Serializable)valueNaN -> {
                            ArrayIntersect.$anonfun$evalIntersect$5(hs, arrayBuffer, valueNaN);
                            return BoxedUnit.UNIT;
                        });
                        for (i = 0; i < array2.numElements(); ++i) {
                            Object object;
                            if (array2.isNullAt(i)) {
                                hs.addNull();
                                object = BoxedUnit.UNIT;
                                continue;
                            }
                            Object elem = array2.get(i, this.elementType());
                            object = withArray2NaNCheckFunc.apply(elem);
                        }
                        for (i = 0; i < array1.numElements(); ++i) {
                            Object object;
                            if (array1.isNullAt(i)) {
                                if (hs.containsNull() && !hsResult.containsNull()) {
                                    arrayBuffer.$plus$eq(null);
                                    hsResult.addNull();
                                }
                                object = BoxedUnit.UNIT;
                                continue;
                            }
                            Object elem = array1.get(i, this.elementType());
                            object = withArray1NaNCheckFunc.apply(elem);
                        }
                        genericArrayData = new GenericArrayData((Seq<Object>)arrayBuffer.toSeq());
                    } else {
                        genericArrayData = new GenericArrayData((Object)Array$.MODULE$.emptyObjectArray());
                    }
                    return genericArrayData;
                } : (Function2 & Serializable & scala.Serializable)(array1, array2) -> {
                    GenericArrayData genericArrayData;
                    if (array1.numElements() != 0 && array2.numElements() != 0) {
                        ArrayBuffer arrayBuffer = new ArrayBuffer();
                        boolean alreadySeenNull = false;
                        for (int i = 0; i < array1.numElements(); ++i) {
                            boolean found = false;
                            Object elem1 = array1.get(i, this.elementType());
                            if (array1.isNullAt(i)) {
                                if (!alreadySeenNull) {
                                    for (int j = 0; !found && j < array2.numElements(); ++j) {
                                        found = array2.isNullAt(j);
                                    }
                                    alreadySeenNull = true;
                                }
                            } else {
                                for (int j = 0; !found && j < array2.numElements(); ++j) {
                                    if (array2.isNullAt(j)) continue;
                                    Object elem2 = array2.get(j, this.elementType());
                                    if (!this.ordering().equiv(elem1, elem2)) continue;
                                    boolean foundArrayBuffer = false;
                                    for (int k = 0; !foundArrayBuffer && k < arrayBuffer.size(); ++k) {
                                        Object va = arrayBuffer.apply(k);
                                        foundArrayBuffer = va != null && this.ordering().equiv(va, elem1);
                                    }
                                    found = !foundArrayBuffer;
                                }
                            }
                            Object object = found ? arrayBuffer.$plus$eq(elem1) : BoxedUnit.UNIT;
                        }
                        genericArrayData = new GenericArrayData((Seq<Object>)arrayBuffer.toSeq());
                    } else {
                        genericArrayData = new GenericArrayData((Object)Array$.MODULE$.emptyObjectArray());
                    }
                    return genericArrayData;
                };
                this.bitmap$trans$0 |= 1;
            }
        }
        return this.evalIntersect;
    }

    public Function2<ArrayData, ArrayData, ArrayData> evalIntersect() {
        return (this.bitmap$trans$0 & 1) == 0 ? this.evalIntersect$lzycompute() : this.evalIntersect;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        ArrayData array1 = (ArrayData)input1;
        ArrayData array2 = (ArrayData)input2;
        return this.evalIntersect().apply((Object)array1, (Object)array2);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode exprCode;
        String i = ctx.freshName("i");
        String value = ctx.freshName("value");
        String size = ctx.freshName("size");
        if (this.canUseSpecializedHashSet()) {
            String jt = CodeGenerator$.MODULE$.javaType(this.elementType());
            String ptName = CodeGenerator$.MODULE$.primitiveTypeName(jt);
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(array1, array2) -> {
                String nullElementIndex = ctx.freshName("nullElementIndex");
                String builder = ctx.freshName("builder");
                String openHashSet = SQLOpenHashSet.class.getName();
                String classTag = new StringBuilder(34).append("scala.reflect.ClassTag$.MODULE$.").append(this.hsTypeName()).append("()").toString();
                String hashSet = ctx.freshName("hashSet");
                String hashSetResult = ctx.freshName("hashSetResult");
                String arrayBuilder = ArrayBuilder.class.getName();
                String arrayBuilderClass = new StringBuilder(3).append(arrayBuilder).append("$of").append(ptName).toString();
                String writeArray2ToHashSet = this.withArray2NullCheck$1(new StringBuilder(5).append(jt).append(" ").append(value).append(" = ").append(this.genGetValue((String)array2, i)).append(";").append(SQLOpenHashSet$.MODULE$.withNaNCheckCode(this.elementType(), value, hashSet, new StringBuilder(7).append(hashSet).append(".add").append(this.hsPostFix()).append("(").append(this.hsValueCast()).append(value).append(");").toString(), (Function1<String, String>)(Function1 & Serializable & scala.Serializable)valueNaN -> "")).toString(), (String)array2, i, hashSet);
                String body = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(220).append("\n             |if (").append(hashSet).append(".contains(").append(this.hsValueCast()).append(value).append(") &&\n             |    !").append(hashSetResult).append(".contains(").append(this.hsValueCast()).append(value).append(")) {\n             |  if (++").append(size).append(" > ").append(ByteArrayMethods.MAX_ROUNDED_ARRAY_LENGTH).append(") {\n             |    break;\n             |  }\n             |  ").append(hashSetResult).append(".add").append(this.hsPostFix()).append("(").append(this.hsValueCast()).append(value).append(");\n             |  ").append(builder).append(".$plus$eq(").append(value).append(");\n             |}\n           ").toString())).stripMargin();
                String processArray1 = this.withArray1NullAssignment$1(new StringBuilder(5).append(jt).append(" ").append(value).append(" = ").append(this.genGetValue((String)array1, i)).append(";").append(SQLOpenHashSet$.MODULE$.withNaNCheckCode(this.elementType(), value, hashSetResult, body, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)valueNaN -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n                   |if (").append(hashSet).append(".containsNaN()) {\n                   |  ++").append(size).append(";\n                   |  ").append(builder).append(".$plus$eq(").append(valueNaN).append(");\n                   |}\n                 ").toString())).stripMargin())).toString(), (String)array1, i, hashSet, hashSetResult, nullElementIndex, size, builder);
                String declareNullTrackVariables = ((ArrayType)this.dataType()).containsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(37).append("\n             |int ").append(nullElementIndex).append(" = -1;\n           ").toString())).stripMargin() : "";
                return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(292).append("\n           |").append(openHashSet).append(" ").append(hashSet).append(" = new ").append(openHashSet).append(this.hsPostFix()).append("(").append(classTag).append(");\n           |").append(openHashSet).append(" ").append(hashSetResult).append(" = new ").append(openHashSet).append(this.hsPostFix()).append("(").append(classTag).append(");\n           |").append(declareNullTrackVariables).append("\n           |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)array2).append(".numElements(); ").append(i).append("++) {\n           |  ").append(writeArray2ToHashSet).append("\n           |}\n           |").append(arrayBuilderClass).append(" ").append(builder).append(" = new ").append(arrayBuilderClass).append("();\n           |int ").append(size).append(" = 0;\n           |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)array1).append(".numElements(); ").append(i).append("++) {\n           |  ").append(processArray1).append("\n           |}\n           |").append(this.buildResultArray(builder, ExprValue$.MODULE$.exprValueToString(ev.value()), size, nullElementIndex)).append("\n         ").toString())).stripMargin();
            });
        } else {
            exprCode = this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(array1, array2) -> {
                String expr = ctx.addReferenceObj("arrayIntersectExpr", this, ctx.addReferenceObj$default$3());
                return new StringBuilder(32).append(ev.value()).append(" = (ArrayData)").append(expr).append(".nullSafeEval(").append((String)array1).append(", ").append((String)array2).append(");").toString();
            });
        }
        return exprCode;
    }

    @Override
    public String prettyName() {
        return "array_intersect";
    }

    public ArrayIntersect copy(Expression left, Expression right) {
        return new ArrayIntersect(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayIntersect";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayIntersect;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayIntersect)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayIntersect arrayIntersect = (ArrayIntersect)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayIntersect.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayIntersect.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayIntersect.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$evalIntersect$3(Object valueNaN) {
    }

    public static final /* synthetic */ void $anonfun$evalIntersect$4(SQLOpenHashSet hs$3, SQLOpenHashSet hsResult$1, ArrayBuffer arrayBuffer$6, Object value) {
        block0: {
            if (!hs$3.contains(value) || hsResult$1.contains(value)) break block0;
            arrayBuffer$6.$plus$eq(value);
            hsResult$1.add(value);
        }
    }

    public static final /* synthetic */ void $anonfun$evalIntersect$5(SQLOpenHashSet hs$3, ArrayBuffer arrayBuffer$6, Object valueNaN) {
        block0: {
            if (!hs$3.containsNaN()) break block0;
            arrayBuffer$6.$plus$eq(valueNaN);
        }
    }

    private final String withArray2NullCheck$1(String body, String array2$1, String i$5, String hashSet$3) {
        return ((ArrayType)this.right().dataType()).containsNull() ? (((ArrayType)this.left().dataType()).containsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(153).append("\n                 |if (").append(array2$1).append(".isNullAt(").append(i$5).append(")) {\n                 |  ").append(hashSet$3).append(".addNull();\n                 |} else {\n                 |  ").append(body).append("\n                 |}\n               ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(95).append("\n                 |if (!").append(array2$1).append(".isNullAt(").append(i$5).append(")) {\n                 |  ").append(body).append("\n                 |}\n               ").toString())).stripMargin()) : body;
    }

    private final String withArray1NullAssignment$1(String body, String array1$1, String i$5, String hashSet$3, String hashSetResult$1, String nullElementIndex$3, String size$3, String builder$3) {
        return ((ArrayType)this.left().dataType()).containsNull() ? (((ArrayType)this.right().dataType()).containsNull() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(328).append("\n                 |if (").append(array1$1).append(".isNullAt(").append(i$5).append(")) {\n                 |  if (").append(hashSet$3).append(".containsNull() && !").append(hashSetResult$1).append(".containsNull()) {\n                 |    ").append(nullElementIndex$3).append(" = ").append(size$3).append(";\n                 |    ").append(hashSetResult$1).append(".addNull();\n                 |    ").append(size$3).append("++;\n                 |    ").append(builder$3).append(".$plus$eq(").append(this.nullValueHolder()).append(");\n                 |  }\n                 |} else {\n                 |  ").append(body).append("\n                 |}\n               ").toString())).stripMargin() : new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(95).append("\n                 |if (!").append(array1$1).append(".isNullAt(").append(i$5).append(")) {\n                 |  ").append(body).append("\n                 |}\n               ").toString())).stripMargin()) : body;
    }

    public ArrayIntersect(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
        BinaryArrayExpressionWithImplicitCast.$init$(this);
        ArraySetLike.$init$(this);
        ArrayBinaryLike.$init$(this);
        ComplexTypeMergingExpression.$init$(this);
    }
}

