/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pyro;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.razorvine.pyro.Config;
import net.razorvine.pyro.IOUtil;
import net.razorvine.pyro.PyroException;

public class Message {
    private static final int CHECKSUM_MAGIC = 13545;
    public static final int HEADER_SIZE = 24;
    public static final int MSG_CONNECT = 1;
    public static final int MSG_CONNECTOK = 2;
    public static final int MSG_CONNECTFAIL = 3;
    public static final int MSG_INVOKE = 4;
    public static final int MSG_RESULT = 5;
    public static final int MSG_PING = 6;
    public static final int FLAGS_EXCEPTION = 1;
    public static final int FLAGS_COMPRESSED = 2;
    public static final int FLAGS_ONEWAY = 4;
    public static final int FLAGS_BATCH = 8;
    public static final int FLAGS_META_ON_CONNECT = 16;
    public static final int FLAGS_ITEMSTREAMRESULT = 32;
    public static final int SERIALIZER_SERPENT = 1;
    public static final int SERIALIZER_JSON = 2;
    public static final int SERIALIZER_MARSHAL = 3;
    public static final int SERIALIZER_PICKLE = 4;
    public int type;
    public int flags;
    public byte[] data;
    public int data_size;
    public int annotations_size;
    public int serializer_id;
    public int seq;
    public SortedMap<String, byte[]> annotations;

    public Message(int msgType, int serializer_id, int flags, int seq) {
        this.type = msgType;
        this.flags = flags;
        this.seq = seq;
        this.serializer_id = serializer_id;
    }

    public Message(int msgType, byte[] databytes, int serializer_id, int flags, int seq, SortedMap<String, byte[]> annotations, byte[] hmac) {
        this(msgType, serializer_id, flags, seq);
        this.data = databytes;
        this.data_size = databytes.length;
        this.annotations = annotations;
        if (null == annotations) {
            this.annotations = new TreeMap<String, byte[]>();
        }
        if (hmac != null) {
            this.annotations.put("HMAC", this.hmac(hmac));
        }
        this.annotations_size = 0;
        for (Map.Entry<String, byte[]> a : this.annotations.entrySet()) {
            this.annotations_size += a.getValue().length + 6;
        }
    }

    public byte[] hmac(byte[] key) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, "HmacSHA1");
            Mac hmac_algo = Mac.getInstance("HmacSHA1");
            hmac_algo.init(secretKey);
            hmac_algo.update(this.data);
            for (Map.Entry<String, byte[]> a : this.annotations.entrySet()) {
                if (a.getKey().equals("HMAC")) continue;
                hmac_algo.update(a.getValue());
            }
            return hmac_algo.doFinal();
        }
        catch (NoSuchAlgorithmException e) {
            throw new PyroException("invalid hmac algorithm", e);
        }
        catch (InvalidKeyException e) {
            throw new PyroException("invalid hmac key", e);
        }
    }

    public byte[] to_bytes() {
        byte[] header_bytes = this.get_header_bytes();
        byte[] annotations_bytes = this.get_annotations_bytes();
        byte[] result = new byte[header_bytes.length + annotations_bytes.length + this.data.length];
        System.arraycopy(header_bytes, 0, result, 0, header_bytes.length);
        System.arraycopy(annotations_bytes, 0, result, header_bytes.length, annotations_bytes.length);
        System.arraycopy(this.data, 0, result, header_bytes.length + annotations_bytes.length, this.data.length);
        return result;
    }

    public byte[] get_header_bytes() {
        int checksum = this.type + 48 + this.data_size + this.annotations_size + this.serializer_id + this.flags + this.seq + 13545 & 0xFFFF;
        byte[] header = new byte[]{80, 89, 82, 79, 0, 48, (byte)(this.type >> 8), (byte)(this.type & 0xFF), (byte)(this.flags >> 8), (byte)(this.flags & 0xFF), (byte)(this.seq >> 8), (byte)(this.seq & 0xFF), (byte)(this.data_size >> 24 & 0xFF), (byte)(this.data_size >> 16 & 0xFF), (byte)(this.data_size >> 8 & 0xFF), (byte)(this.data_size & 0xFF), (byte)(this.serializer_id >> 8), (byte)(this.serializer_id & 0xFF), (byte)(this.annotations_size >> 8 & 0xFF), (byte)(this.annotations_size & 0xFF), 0, 0, (byte)(checksum >> 8 & 0xFF), (byte)(checksum & 0xFF)};
        return header;
    }

    public byte[] get_annotations_bytes() {
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        int total_size = 0;
        for (Map.Entry<String, byte[]> ann : this.annotations.entrySet()) {
            String key = ann.getKey();
            byte[] value = ann.getValue();
            if (key.length() != 4) {
                throw new IllegalArgumentException("annotation key must be length 4");
            }
            chunks.add(key.getBytes());
            byte[] size_bytes = new byte[]{(byte)(value.length >> 8 & 0xFF), (byte)(value.length & 0xFF)};
            chunks.add(size_bytes);
            chunks.add(value);
            total_size += 6 + value.length;
        }
        byte[] result = new byte[total_size];
        int index = 0;
        for (byte[] chunk : chunks) {
            System.arraycopy(chunk, 0, result, index, chunk.length);
            index += chunk.length;
        }
        return result;
    }

    public static Message from_header(byte[] header) {
        if (header == null || header.length != 24) {
            throw new PyroException("header data size mismatch");
        }
        if (header[0] != 80 || header[1] != 89 || header[2] != 82 || header[3] != 79) {
            throw new PyroException("invalid message");
        }
        int version = (header[4] & 0xFF) << 8 | header[5] & 0xFF;
        if (version != 48) {
            throw new PyroException("invalid protocol version: " + version);
        }
        int msg_type = (header[6] & 0xFF) << 8 | header[7] & 0xFF;
        int flags = (header[8] & 0xFF) << 8 | header[9] & 0xFF;
        int seq = (header[10] & 0xFF) << 8 | header[11] & 0xFF;
        int data_size = header[12] & 0xFF;
        data_size <<= 8;
        data_size |= header[13] & 0xFF;
        data_size <<= 8;
        data_size |= header[14] & 0xFF;
        data_size <<= 8;
        int checksum = (header[22] & 0xFF) << 8 | header[23] & 0xFF;
        int annotations_size = (header[18] & 0xFF) << 8 | header[19] & 0xFF;
        int serializer_id = (header[16] & 0xFF) << 8 | header[17] & 0xFF;
        int actual_checksum = msg_type + version + (data_size |= header[15] & 0xFF) + annotations_size + flags + serializer_id + seq + 13545 & 0xFFFF;
        if (checksum != actual_checksum) {
            throw new PyroException("header checksum mismatch");
        }
        Message msg = new Message(msg_type, serializer_id, flags, seq);
        msg.data_size = data_size;
        msg.annotations_size = annotations_size;
        return msg;
    }

    public static Message recv(InputStream connection, int[] requiredMsgTypes, byte[] hmac) throws IOException {
        byte[] header_data = IOUtil.recv(connection, 24);
        Message msg = Message.from_header(header_data);
        if (requiredMsgTypes != null) {
            boolean found = false;
            for (int req : requiredMsgTypes) {
                if (req != msg.type) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new PyroException(String.format("invalid msg type %d received", msg.type));
            }
        }
        byte[] annotations_data = null;
        msg.annotations = new TreeMap<String, byte[]>();
        if (msg.annotations_size > 0) {
            int length;
            annotations_data = IOUtil.recv(connection, msg.annotations_size);
            for (int i = 0; i < msg.annotations_size; i += 6 + length) {
                String anno = new String(annotations_data, i, 4);
                length = annotations_data[i + 4] << 8 | annotations_data[i + 5];
                byte[] annotations_bytes = new byte[length];
                System.arraycopy(annotations_data, i + 6, annotations_bytes, 0, length);
                msg.annotations.put(anno, annotations_bytes);
            }
        }
        msg.data = IOUtil.recv(connection, msg.data_size);
        if (Config.MSG_TRACE_DIR != null) {
            Message.TraceMessageRecv(msg.seq, header_data, annotations_data, msg.data);
        }
        if (msg.annotations.containsKey("HMAC") && hmac != null) {
            if (!Arrays.equals((byte[])msg.annotations.get("HMAC"), msg.hmac(hmac))) {
                throw new PyroException("message hmac mismatch");
            }
        } else if (msg.annotations.containsKey("HMAC") != (hmac != null)) {
            throw new PyroException("hmac key config not symmetric");
        }
        return msg;
    }

    public static void TraceMessageSend(int sequenceNr, byte[] headerdata, byte[] annotations, byte[] data) throws IOException {
        String filename = String.format("%s%s%05d-a-send-header.dat", Config.MSG_TRACE_DIR, File.separator, sequenceNr);
        FileOutputStream fos = new FileOutputStream(filename);
        fos.write(headerdata);
        if (annotations != null) {
            fos.write(annotations);
        }
        fos.close();
        filename = String.format("%s%s%05d-a-send-message.dat", Config.MSG_TRACE_DIR, File.separator, sequenceNr);
        fos = new FileOutputStream(filename);
        fos.write(data);
        fos.close();
    }

    public static void TraceMessageRecv(int sequenceNr, byte[] headerdata, byte[] annotations, byte[] data) throws IOException {
        String filename = String.format("%s%s%05d-b-recv-header.dat", Config.MSG_TRACE_DIR, File.separator, sequenceNr);
        FileOutputStream fos = new FileOutputStream(filename);
        fos.write(headerdata);
        if (annotations != null) {
            fos.write(annotations);
        }
        fos.close();
        filename = String.format("%s%s%05d-b-recv-message.dat", Config.MSG_TRACE_DIR, File.separator, sequenceNr);
        fos = new FileOutputStream(filename);
        fos.write(data);
        fos.close();
    }
}

