/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.Final$;
import org.apache.spark.sql.catalyst.expressions.aggregate.PartialMerge$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.ExpandExec;
import org.apache.spark.sql.execution.FilterExec;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.TakeOrderedAndProjectExec;
import org.apache.spark.sql.execution.aggregate.BaseAggregateExec;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanExecBase;
import org.apache.spark.sql.execution.joins.BaseJoinExec;
import org.apache.spark.sql.execution.window.WindowExec;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;

public final class RemoveRedundantProjects$
extends Rule<SparkPlan> {
    public static RemoveRedundantProjects$ MODULE$;

    static {
        new RemoveRedundantProjects$();
    }

    public SparkPlan apply(SparkPlan plan) {
        return !BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(SQLConf$.MODULE$.REMOVE_REDUNDANT_PROJECTS_ENABLED())) ? plan : this.removeProject(plan, true);
    }

    private SparkPlan removeProject(SparkPlan plan, boolean requireOrdering) {
        SparkPlan sparkPlan;
        SparkPlan sparkPlan2 = plan;
        if (sparkPlan2 instanceof ProjectExec) {
            SparkPlan sparkPlan3;
            ProjectExec projectExec = (ProjectExec)sparkPlan2;
            SparkPlan child = projectExec.child();
            if (this.isRedundant(projectExec, child, requireOrdering) && this.canRemove(projectExec, child)) {
                SparkPlan newPlan = this.removeProject(child, requireOrdering);
                newPlan.setLogicalLink((LogicalPlan)child.logicalLink().get());
                sparkPlan3 = newPlan;
            } else {
                sparkPlan3 = (SparkPlan)projectExec.mapChildren((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.removeProject((SparkPlan)((Object)x$1), false));
            }
            sparkPlan = sparkPlan3;
        } else if (sparkPlan2 instanceof TakeOrderedAndProjectExec) {
            TakeOrderedAndProjectExec takeOrderedAndProjectExec = (TakeOrderedAndProjectExec)sparkPlan2;
            sparkPlan = (SparkPlan)takeOrderedAndProjectExec.mapChildren((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.removeProject((SparkPlan)((Object)x$2), false));
        } else if (sparkPlan2 instanceof BaseAggregateExec) {
            BaseAggregateExec baseAggregateExec = (BaseAggregateExec)((Object)sparkPlan2);
            boolean keepOrdering = baseAggregateExec.aggregateExpressions().exists((Function1 & Serializable & scala.Serializable)ae -> BoxesRunTime.boxToBoolean((boolean)RemoveRedundantProjects$.$anonfun$removeProject$3(ae)));
            sparkPlan = (SparkPlan)((TreeNode)baseAggregateExec).mapChildren((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.removeProject((SparkPlan)((Object)x$3), keepOrdering));
        } else {
            boolean required = this.canPassThrough(sparkPlan2) ? requireOrdering : true;
            sparkPlan = (SparkPlan)sparkPlan2.mapChildren((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.removeProject((SparkPlan)((Object)x$4), required));
        }
        return sparkPlan;
    }

    private boolean canPassThrough(SparkPlan plan) {
        SparkPlan sparkPlan = plan;
        boolean bl = sparkPlan instanceof FilterExec ? true : (sparkPlan instanceof BaseJoinExec ? true : (sparkPlan instanceof WindowExec ? true : sparkPlan instanceof ExpandExec));
        return bl;
    }

    private boolean checkNullability(Seq<Attribute> output, Seq<Attribute> childOutput) {
        return ((IterableLike)output.zip(childOutput, Seq$.MODULE$.canBuildFrom())).forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RemoveRedundantProjects$.$anonfun$checkNullability$1(x0$1)));
    }

    private boolean isRedundant(ProjectExec project, SparkPlan child, boolean requireOrdering) {
        DataSourceV2ScanExecBase dataSourceV2ScanExecBase;
        FilterExec filterExec;
        SparkPlan d;
        boolean bl;
        DataSourceV2ScanExecBase dataSourceV2ScanExecBase2;
        SparkPlan sparkPlan = child;
        if (sparkPlan instanceof DataSourceV2ScanExecBase && !(dataSourceV2ScanExecBase2 = (DataSourceV2ScanExecBase)((Object)sparkPlan)).supportsColumnar()) {
            bl = false;
        } else if (sparkPlan instanceof FilterExec && (d = (filterExec = (FilterExec)sparkPlan).child()) instanceof DataSourceV2ScanExecBase && !(dataSourceV2ScanExecBase = (DataSourceV2ScanExecBase)((Object)d)).supportsColumnar()) {
            bl = false;
        } else {
            boolean bl2;
            if (requireOrdering) {
                bl2 = BoxesRunTime.equals((Object)project.output().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)RemoveRedundantProjects$.$anonfun$isRedundant$1(x$5)), Seq$.MODULE$.canBuildFrom()), (Object)child.output().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)RemoveRedundantProjects$.$anonfun$isRedundant$2(x$6)), Seq$.MODULE$.canBuildFrom())) && this.checkNullability(project.output(), (Seq<Attribute>)child.output());
            } else {
                Seq orderedProjectOutput = (Seq)project.output().sortBy((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)RemoveRedundantProjects$.$anonfun$isRedundant$3(x$7)), (Ordering)Ordering.Long$.MODULE$);
                Seq orderedChildOutput = (Seq)child.output().sortBy((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)RemoveRedundantProjects$.$anonfun$isRedundant$4(x$8)), (Ordering)Ordering.Long$.MODULE$);
                bl2 = BoxesRunTime.equals((Object)orderedProjectOutput.map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)RemoveRedundantProjects$.$anonfun$isRedundant$5(x$9)), Seq$.MODULE$.canBuildFrom()), (Object)orderedChildOutput.map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)RemoveRedundantProjects$.$anonfun$isRedundant$6(x$10)), Seq$.MODULE$.canBuildFrom())) && this.checkNullability((Seq<Attribute>)orderedProjectOutput, (Seq<Attribute>)orderedChildOutput);
            }
            bl = bl2;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canRemove(ProjectExec project, SparkPlan child) {
        if (project.logicalLink().isEmpty()) return true;
        Option<LogicalPlan> option = child.logicalLink();
        if (!project.logicalLink().exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)option.contains(elem)))) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$removeProject$3(AggregateExpression ae) {
        return ae.mode().equals(Final$.MODULE$) || ae.mode().equals(PartialMerge$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$checkNullability$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Attribute attr1 = (Attribute)tuple2._1();
        Attribute attr2 = (Attribute)tuple2._2();
        boolean bl = attr1.nullable() || !attr2.nullable();
        return bl;
    }

    public static final /* synthetic */ long $anonfun$isRedundant$1(Attribute x$5) {
        return x$5.exprId().id();
    }

    public static final /* synthetic */ long $anonfun$isRedundant$2(Attribute x$6) {
        return x$6.exprId().id();
    }

    public static final /* synthetic */ long $anonfun$isRedundant$3(Attribute x$7) {
        return x$7.exprId().id();
    }

    public static final /* synthetic */ long $anonfun$isRedundant$4(Attribute x$8) {
        return x$8.exprId().id();
    }

    public static final /* synthetic */ long $anonfun$isRedundant$5(Attribute x$9) {
        return x$9.exprId().id();
    }

    public static final /* synthetic */ long $anonfun$isRedundant$6(Attribute x$10) {
        return x$10.exprId().id();
    }

    private RemoveRedundantProjects$() {
        MODULE$ = this;
    }
}

