/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.resource;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Python$;
import org.apache.spark.resource.ExecutorResourceRequest;
import org.apache.spark.resource.ExecutorResourceRequests;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceRequest;
import org.apache.spark.resource.ResourceUtils$;
import org.apache.spark.resource.TaskResourceRequest;
import org.apache.spark.resource.TaskResourceRequests;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

public final class ResourceProfile$
implements Logging,
scala.Serializable {
    public static ResourceProfile$ MODULE$;
    private AtomicInteger nextProfileId;
    private final String CPUS;
    private final String CORES;
    private final String MEMORY;
    private final String OFFHEAP_MEM;
    private final String OVERHEAD_MEM;
    private final String PYSPARK_MEM;
    private final int UNKNOWN_RESOURCE_PROFILE_ID;
    private final int DEFAULT_RESOURCE_PROFILE_ID;
    private final long MEMORY_OVERHEAD_MIN_MIB;
    private final Object DEFAULT_PROFILE_LOCK;
    @GuardedBy(value="DEFAULT_PROFILE_LOCK")
    private Option<ResourceProfile> defaultProfile;
    private Option<ResourceProfile.DefaultProfileExecutorResources> defaultProfileExecutorResources;
    private final String PYSPARK_MEMORY_LOCAL_PROPERTY;
    private final String EXECUTOR_CORES_LOCAL_PROPERTY;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new ResourceProfile$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String CPUS() {
        return this.CPUS;
    }

    public String CORES() {
        return this.CORES;
    }

    public String MEMORY() {
        return this.MEMORY;
    }

    public String OFFHEAP_MEM() {
        return this.OFFHEAP_MEM;
    }

    public String OVERHEAD_MEM() {
        return this.OVERHEAD_MEM;
    }

    public String PYSPARK_MEM() {
        return this.PYSPARK_MEM;
    }

    public String[] allSupportedExecutorResources() {
        return (String[])((Object[])new String[]{this.CORES(), this.MEMORY(), this.OVERHEAD_MEM(), this.PYSPARK_MEM(), this.OFFHEAP_MEM()});
    }

    public int UNKNOWN_RESOURCE_PROFILE_ID() {
        return this.UNKNOWN_RESOURCE_PROFILE_ID;
    }

    public int DEFAULT_RESOURCE_PROFILE_ID() {
        return this.DEFAULT_RESOURCE_PROFILE_ID;
    }

    public long MEMORY_OVERHEAD_MIN_MIB() {
        return this.MEMORY_OVERHEAD_MIN_MIB;
    }

    private AtomicInteger nextProfileId$lzycompute() {
        ResourceProfile$ resourceProfile$ = this;
        synchronized (resourceProfile$) {
            if (!this.bitmap$0) {
                this.nextProfileId = new AtomicInteger(0);
                this.bitmap$0 = true;
            }
        }
        return this.nextProfileId;
    }

    private AtomicInteger nextProfileId() {
        return !this.bitmap$0 ? this.nextProfileId$lzycompute() : this.nextProfileId;
    }

    private Object DEFAULT_PROFILE_LOCK() {
        return this.DEFAULT_PROFILE_LOCK;
    }

    private Option<ResourceProfile> defaultProfile() {
        return this.defaultProfile;
    }

    private void defaultProfile_$eq(Option<ResourceProfile> x$1) {
        this.defaultProfile = x$1;
    }

    private Option<ResourceProfile.DefaultProfileExecutorResources> defaultProfileExecutorResources() {
        return this.defaultProfileExecutorResources;
    }

    private void defaultProfileExecutorResources_$eq(Option<ResourceProfile.DefaultProfileExecutorResources> x$1) {
        this.defaultProfileExecutorResources = x$1;
    }

    public int getNextProfileId() {
        return this.nextProfileId().getAndIncrement();
    }

    public ResourceProfile getOrCreateDefaultProfile(SparkConf conf) {
        ResourceProfile resourceProfile;
        Object object = this.DEFAULT_PROFILE_LOCK();
        synchronized (object) {
            ResourceProfile resourceProfile2;
            Option<ResourceProfile> option = this.defaultProfile();
            if (option instanceof Some) {
                ResourceProfile prof;
                Some some = (Some)option;
                resourceProfile2 = prof = (ResourceProfile)some.value();
            } else if (None$.MODULE$.equals(option)) {
                Map<String, TaskResourceRequest> taskResources = this.getDefaultTaskResources(conf);
                Map<String, ExecutorResourceRequest> executorResources = this.getDefaultExecutorResources(conf);
                ResourceProfile defProf = new ResourceProfile(executorResources, taskResources);
                defProf.setToDefaultProfile();
                this.defaultProfile_$eq((Option<ResourceProfile>)new Some((Object)defProf));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Default ResourceProfile created, executor resources: ").append(defProf.executorResources()).append(", task resources: ").append(defProf.taskResources()).toString());
                resourceProfile2 = defProf;
            } else {
                throw new MatchError(option);
            }
            resourceProfile = resourceProfile2;
        }
        return resourceProfile;
    }

    public ResourceProfile.DefaultProfileExecutorResources getDefaultProfileExecutorResources(SparkConf conf) {
        return (ResourceProfile.DefaultProfileExecutorResources)this.defaultProfileExecutorResources().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            MODULE$.getOrCreateDefaultProfile(conf);
            return (ResourceProfile.DefaultProfileExecutorResources)MODULE$.defaultProfileExecutorResources().get();
        });
    }

    private Map<String, TaskResourceRequest> getDefaultTaskResources(SparkConf conf) {
        int cpusPerTask = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.CPUS_PER_TASK()));
        TaskResourceRequests treqs = new TaskResourceRequests().cpus(cpusPerTask);
        ResourceUtils$.MODULE$.addTaskResourceRequests(conf, treqs);
        return treqs.requests();
    }

    private Map<String, ExecutorResourceRequest> getDefaultExecutorResources(SparkConf conf) {
        ExecutorResourceRequests ereqs = new ExecutorResourceRequests();
        int cores = BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_CORES()));
        ereqs.cores(cores);
        long memory = BoxesRunTime.unboxToLong((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY()));
        ereqs.memory(((Object)BoxesRunTime.boxToLong((long)memory)).toString());
        Option overheadMem = (Option)conf.get(org.apache.spark.internal.config.package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD());
        overheadMem.map((Function1 & Serializable & scala.Serializable)mem -> ereqs.memoryOverhead(((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)mem))).toString()));
        Option pysparkMem = (Option)conf.get(Python$.MODULE$.PYSPARK_EXECUTOR_MEMORY());
        pysparkMem.map((Function1 & Serializable & scala.Serializable)mem -> ereqs.pysparkMemory(((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)mem))).toString()));
        int offheapMem = Utils$.MODULE$.executorOffHeapMemorySizeAsMb(conf);
        ereqs.offHeapMemory(((Object)BoxesRunTime.boxToInteger((int)offheapMem)).toString());
        Seq<ResourceRequest> execReq = ResourceUtils$.MODULE$.parseAllResourceRequests(conf, org.apache.spark.internal.config.package$.MODULE$.SPARK_EXECUTOR_PREFIX());
        execReq.foreach((Function1 & Serializable & scala.Serializable)req -> ereqs.resource(req.id().resourceName(), req.amount(), req.discoveryScript().orElse(""), req.vendor().orElse("")));
        Set customResourceNames = ((TraversableOnce)execReq.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.id().resourceName(), Seq$.MODULE$.canBuildFrom())).toSet();
        Map customResources = (Map)ereqs.requests().filter((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToBoolean((boolean)customResourceNames.contains(v._1())));
        this.defaultProfileExecutorResources_$eq((Option<ResourceProfile.DefaultProfileExecutorResources>)new Some((Object)new ResourceProfile.DefaultProfileExecutorResources(cores, memory, offheapMem, (Option<Object>)pysparkMem, (Option<Object>)overheadMem, (Map<String, ExecutorResourceRequest>)customResources)));
        return ereqs.requests();
    }

    public void reInitDefaultProfile(SparkConf conf) {
        this.clearDefaultProfile();
        this.getOrCreateDefaultProfile(conf);
    }

    public void clearDefaultProfile() {
        Object object = this.DEFAULT_PROFILE_LOCK();
        synchronized (object) {
            this.defaultProfile_$eq((Option<ResourceProfile>)None$.MODULE$);
            this.defaultProfileExecutorResources_$eq((Option<ResourceProfile.DefaultProfileExecutorResources>)None$.MODULE$);
        }
    }

    public Map<String, TaskResourceRequest> getCustomTaskResources(ResourceProfile rp) {
        return rp.taskResources().filterKeys((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)ResourceProfile$.$anonfun$getCustomTaskResources$1(k))).toMap(Predef$.MODULE$.$conforms());
    }

    public Map<String, ExecutorResourceRequest> getCustomExecutorResources(ResourceProfile rp) {
        return rp.executorResources().filterKeys((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)ResourceProfile$.$anonfun$getCustomExecutorResources$1(k))).toMap(Predef$.MODULE$.$conforms());
    }

    public int getTaskCpusOrDefaultForProfile(ResourceProfile rp, SparkConf conf) {
        return BoxesRunTime.unboxToInt((Object)rp.getTaskCpus().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)conf.get(org.apache.spark.internal.config.package$.MODULE$.CPUS_PER_TASK()))));
    }

    public long executorOffHeapMemorySizeAsMb(SparkConf sparkConf, ExecutorResourceRequest execRequest) {
        return Utils$.MODULE$.checkOffHeapEnabled(sparkConf, execRequest.amount());
    }

    public long calculateOverHeadMemory(Option<Object> overHeadMemFromConf, long executorMemoryMiB, double overheadFactor) {
        return BoxesRunTime.unboxToLong((Object)overHeadMemFromConf.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> package$.MODULE$.max((long)((int)(overheadFactor * (double)executorMemoryMiB)), MODULE$.MEMORY_OVERHEAD_MIN_MIB())));
    }

    public ResourceProfile.ExecutorResourcesOrDefaults getResourcesForClusterManager(int rpId, Map<String, ExecutorResourceRequest> execResources, double overheadFactor, SparkConf conf, boolean isPythonApp, Map<String, String> resourceMappings) {
        Map map;
        ResourceProfile.DefaultProfileExecutorResources defaultResources = this.getDefaultProfileExecutorResources(conf);
        IntRef cores = IntRef.create((int)defaultResources.cores());
        LongRef executorMemoryMiB = LongRef.create((long)defaultResources.executorMemoryMiB());
        LongRef memoryOffHeapMiB = LongRef.create((long)defaultResources.memoryOffHeapMiB());
        LongRef pysparkMemoryMiB = LongRef.create((long)BoxesRunTime.unboxToLong((Object)defaultResources.pysparkMemoryMiB().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        LongRef memoryOverheadMiB = LongRef.create((long)this.calculateOverHeadMemory(defaultResources.memoryOverheadMiB(), executorMemoryMiB.elem, overheadFactor));
        if (rpId != this.DEFAULT_RESOURCE_PROFILE_ID()) {
            HashMap customResources = new HashMap();
            execResources.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ResourceProfile$.$anonfun$getResourcesForClusterManager$2(executorMemoryMiB, memoryOverheadMiB, pysparkMemoryMiB, memoryOffHeapMiB, conf, cores, resourceMappings, customResources, x0$1);
                return BoxedUnit.UNIT;
            });
            map = customResources.toMap(Predef$.MODULE$.$conforms());
        } else {
            map = (Map)defaultResources.customResources().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String rName = (String)tuple2._1();
                ExecutorResourceRequest execReq = (ExecutorResourceRequest)tuple2._2();
                String nameToUse = (String)resourceMappings.get((Object)rName).getOrElse((Function0 & Serializable & scala.Serializable)() -> rName);
                Tuple2 tuple22 = new Tuple2((Object)nameToUse, (Object)execReq);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
        }
        Map finalCustomResources = map;
        long pysparkMemToUseMiB = isPythonApp ? pysparkMemoryMiB.elem : 0L;
        long totalMemMiB = executorMemoryMiB.elem + memoryOverheadMiB.elem + memoryOffHeapMiB.elem + pysparkMemToUseMiB;
        return new ResourceProfile.ExecutorResourcesOrDefaults(cores.elem, executorMemoryMiB.elem, memoryOffHeapMiB.elem, pysparkMemToUseMiB, memoryOverheadMiB.elem, totalMemMiB, (Map<String, ExecutorResourceRequest>)finalCustomResources);
    }

    public String PYSPARK_MEMORY_LOCAL_PROPERTY() {
        return this.PYSPARK_MEMORY_LOCAL_PROPERTY;
    }

    public String EXECUTOR_CORES_LOCAL_PROPERTY() {
        return this.EXECUTOR_CORES_LOCAL_PROPERTY;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$getCustomTaskResources$1(String k) {
        return !k.equals(MODULE$.CPUS());
    }

    public static final /* synthetic */ boolean $anonfun$getCustomExecutorResources$1(String k) {
        return !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MODULE$.allSupportedExecutorResources())).contains((Object)k);
    }

    public static final /* synthetic */ void $anonfun$getResourcesForClusterManager$2(LongRef executorMemoryMiB$2, LongRef memoryOverheadMiB$1, LongRef pysparkMemoryMiB$1, LongRef memoryOffHeapMiB$1, SparkConf conf$3, IntRef cores$1, Map resourceMappings$1, HashMap customResources$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String r = (String)tuple2._1();
            ExecutorResourceRequest execReq = (ExecutorResourceRequest)tuple2._2();
            String string = r;
            String string2 = MODULE$.MEMORY();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                executorMemoryMiB$2.elem = execReq.amount();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                String string4 = MODULE$.OVERHEAD_MEM();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    memoryOverheadMiB$1.elem = execReq.amount();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    String string6 = MODULE$.PYSPARK_MEM();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        pysparkMemoryMiB$1.elem = execReq.amount();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        String string8 = MODULE$.OFFHEAP_MEM();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            memoryOffHeapMiB$1.elem = MODULE$.executorOffHeapMemorySizeAsMb(conf$3, execReq);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            String string10 = MODULE$.CORES();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                cores$1.elem = (int)execReq.amount();
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                String nameToUse = (String)resourceMappings$1.get((Object)string).getOrElse((Function0 & Serializable & scala.Serializable)() -> string);
                                customResources$1.update((Object)nameToUse, (Object)execReq);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                    }
                }
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private ResourceProfile$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.CPUS = "cpus";
        this.CORES = "cores";
        this.MEMORY = "memory";
        this.OFFHEAP_MEM = "offHeap";
        this.OVERHEAD_MEM = "memoryOverhead";
        this.PYSPARK_MEM = "pyspark.memory";
        this.UNKNOWN_RESOURCE_PROFILE_ID = -1;
        this.DEFAULT_RESOURCE_PROFILE_ID = 0;
        this.MEMORY_OVERHEAD_MIN_MIB = 384L;
        this.DEFAULT_PROFILE_LOCK = new Object();
        this.defaultProfile = None$.MODULE$;
        this.defaultProfileExecutorResources = None$.MODULE$;
        this.PYSPARK_MEMORY_LOCAL_PROPERTY = "resource.pyspark.memory";
        this.EXECUTOR_CORES_LOCAL_PROPERTY = "resource.executor.cores";
    }
}

