/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics.sink;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SecurityManager;
import org.apache.spark.metrics.MetricsSystem$;
import org.apache.spark.metrics.sink.Sink;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q4Q\u0001G\r\u0001;\rB\u0001B\f\u0001\u0003\u0006\u0004%\t\u0001\r\u0005\ts\u0001\u0011\t\u0011)A\u0005c!A!\b\u0001BC\u0002\u0013\u00051\b\u0003\u0005F\u0001\t\u0005\t\u0015!\u0003=\u0011!1\u0005A!A!\u0002\u00139\u0005\"B&\u0001\t\u0003a\u0005bB)\u0001\u0005\u0004%\tA\u0015\u0005\u0007-\u0002\u0001\u000b\u0011B*\t\u000f]\u0003!\u0019!C\u00011\"1q\f\u0001Q\u0001\neCq\u0001\u0019\u0001C\u0002\u0013\u0005\u0001\f\u0003\u0004b\u0001\u0001\u0006I!\u0017\u0005\bE\u0002\u0011\r\u0011\"\u0001Y\u0011\u0019\u0019\u0007\u0001)A\u00053\"9A\r\u0001b\u0001\n\u0003\u0011\u0006BB3\u0001A\u0003%1\u000bC\u0004g\u0001\t\u0007I\u0011A4\t\r9\u0004\u0001\u0015!\u0003i\u0011\u001dy\u0007A1A\u0005\u0002ADa\u0001\u001e\u0001!\u0002\u0013\t\b\"B;\u0001\t\u00032\b\"\u0002>\u0001\t\u00032\b\"B>\u0001\t\u00032(!C*mMRR7+\u001b8l\u0015\tQ2$\u0001\u0003tS:\\'B\u0001\u000f\u001e\u0003\u001diW\r\u001e:jGNT!AH\u0010\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0001\n\u0013AB1qC\u000eDWMC\u0001#\u0003\ry'oZ\n\u0004\u0001\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g\r\u0005\u0002,Y5\t\u0011$\u0003\u0002.3\t!1+\u001b8l\u0003!\u0001(o\u001c9feRL8\u0001A\u000b\u0002cA\u0011!gN\u0007\u0002g)\u0011A'N\u0001\u0005kRLGNC\u00017\u0003\u0011Q\u0017M^1\n\u0005a\u001a$A\u0003)s_B,'\u000f^5fg\u0006I\u0001O]8qKJ$\u0018\u0010I\u0001\te\u0016<\u0017n\u001d;ssV\tA\b\u0005\u0002>\u00076\taH\u0003\u0002\u001d\u007f)\u0011\u0001)Q\u0001\tG>$\u0017\r[1mK*\t!)A\u0002d_6L!\u0001\u0012 \u0003\u001d5+GO]5d%\u0016<\u0017n\u001d;ss\u0006I!/Z4jgR\u0014\u0018\u0010I\u0001\fg\u0016\u001cWO]5us6;'\u000f\u0005\u0002I\u00136\tQ$\u0003\u0002K;\ty1+Z2ve&$\u00180T1oC\u001e,'/\u0001\u0004=S:LGO\u0010\u000b\u0005\u001b:{\u0005\u000b\u0005\u0002,\u0001!)aF\u0002a\u0001c!)!H\u0002a\u0001y!)aI\u0002a\u0001\u000f\u0006!2\u000b\u0014$5\u0015~#UIR!V\u0019R{\u0006+\u0012*J\u001f\u0012+\u0012a\u0015\t\u0003KQK!!\u0016\u0014\u0003\u0007%sG/A\u000bT\u0019\u001a#$j\u0018#F\r\u0006+F\nV0Q\u000bJKu\n\u0012\u0011\u0002%Mce\t\u000e&`\t\u00163\u0015)\u0016'U?Vs\u0015\nV\u000b\u00023B\u0011!,X\u0007\u00027*\u0011A,N\u0001\u0005Y\u0006tw-\u0003\u0002_7\n11\u000b\u001e:j]\u001e\f1c\u0015'Gi){F)\u0012$B+2#v,\u0016(J)\u0002\n\u0001c\u0015'Gi){6*R-`!\u0016\u0013\u0016j\u0014#\u0002#Mce\t\u000e&`\u0017\u0016Kv\fU#S\u0013>#\u0005%\u0001\bT\u0019\u001a#$jX&F3~+f*\u0013+\u0002\u001fMce\t\u000e&`\u0017\u0016Kv,\u0016(J)\u0002\n!\u0002]8mYB+'/[8e\u0003-\u0001x\u000e\u001c7QKJLw\u000e\u001a\u0011\u0002\u0011A|G\u000e\\+oSR,\u0012\u0001\u001b\t\u0003S2l\u0011A\u001b\u0006\u0003WN\n!bY8oGV\u0014(/\u001a8u\u0013\ti'N\u0001\u0005US6,WK\\5u\u0003%\u0001x\u000e\u001c7V]&$\b%\u0001\u0005sKB|'\u000f^3s+\u0005\t\bCA\u001fs\u0013\t\u0019hHA\u0007TY\u001a$$NU3q_J$XM]\u0001\ne\u0016\u0004xN\u001d;fe\u0002\nQa\u001d;beR$\u0012a\u001e\t\u0003KaL!!\u001f\u0014\u0003\tUs\u0017\u000e^\u0001\u0005gR|\u0007/\u0001\u0004sKB|'\u000f\u001e")
public class Slf4jSink
implements Sink {
    private final Properties property;
    private final MetricRegistry registry;
    private final int SLF4J_DEFAULT_PERIOD;
    private final String SLF4J_DEFAULT_UNIT;
    private final String SLF4J_KEY_PERIOD;
    private final String SLF4J_KEY_UNIT;
    private final int pollPeriod;
    private final TimeUnit pollUnit;
    private final Slf4jReporter reporter;

    public Properties property() {
        return this.property;
    }

    public MetricRegistry registry() {
        return this.registry;
    }

    public int SLF4J_DEFAULT_PERIOD() {
        return this.SLF4J_DEFAULT_PERIOD;
    }

    public String SLF4J_DEFAULT_UNIT() {
        return this.SLF4J_DEFAULT_UNIT;
    }

    public String SLF4J_KEY_PERIOD() {
        return this.SLF4J_KEY_PERIOD;
    }

    public String SLF4J_KEY_UNIT() {
        return this.SLF4J_KEY_UNIT;
    }

    public int pollPeriod() {
        return this.pollPeriod;
    }

    public TimeUnit pollUnit() {
        return this.pollUnit;
    }

    public Slf4jReporter reporter() {
        return this.reporter;
    }

    @Override
    public void start() {
        this.reporter().start((long)this.pollPeriod(), this.pollUnit());
    }

    @Override
    public void stop() {
        this.reporter().stop();
    }

    @Override
    public void report() {
        this.reporter().report();
    }

    public Slf4jSink(Properties property, MetricRegistry registry, SecurityManager securityMgr) {
        TimeUnit timeUnit;
        int n;
        this.property = property;
        this.registry = registry;
        this.SLF4J_DEFAULT_PERIOD = 10;
        this.SLF4J_DEFAULT_UNIT = "SECONDS";
        this.SLF4J_KEY_PERIOD = "period";
        this.SLF4J_KEY_UNIT = "unit";
        Option option = Option$.MODULE$.apply((Object)property.getProperty(this.SLF4J_KEY_PERIOD()));
        if (option instanceof Some) {
            Some some = (Some)option;
            String s = (String)some.value();
            n = new StringOps(Predef$.MODULE$.augmentString(s)).toInt();
        } else if (None$.MODULE$.equals(option)) {
            n = this.SLF4J_DEFAULT_PERIOD();
        } else {
            throw new MatchError((Object)option);
        }
        this.pollPeriod = n;
        Option option2 = Option$.MODULE$.apply((Object)property.getProperty(this.SLF4J_KEY_UNIT()));
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String s = (String)some.value();
            timeUnit = TimeUnit.valueOf(s.toUpperCase(Locale.ROOT));
        } else if (None$.MODULE$.equals(option2)) {
            timeUnit = TimeUnit.valueOf(this.SLF4J_DEFAULT_UNIT());
        } else {
            throw new MatchError((Object)option2);
        }
        this.pollUnit = timeUnit;
        MetricsSystem$.MODULE$.checkMinimalPollingPeriod(this.pollUnit(), this.pollPeriod());
        this.reporter = Slf4jReporter.forRegistry((MetricRegistry)registry).convertDurationsTo(TimeUnit.MILLISECONDS).convertRatesTo(TimeUnit.SECONDS).build();
    }
}

