/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.net.URI;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTablePartition;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.execution.command.AlterTableSetLocationCommand$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.util.PartitioningUtils$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005-g\u0001\u0002\u000e\u001c\u0001\"B\u0001\u0002\u0011\u0001\u0003\u0016\u0004%\t!\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0005\"Aq\t\u0001BK\u0002\u0013\u0005\u0001\n\u0003\u0005e\u0001\tE\t\u0015!\u0003J\u0011!)\u0007A!f\u0001\n\u00031\u0007\u0002C8\u0001\u0005#\u0005\u000b\u0011B4\t\u000bA\u0004A\u0011A9\t\u000bY\u0004A\u0011I<\t\u0013\u0005U\u0001!!A\u0005\u0002\u0005]\u0001\"CA\u0010\u0001E\u0005I\u0011AA\u0011\u0011%\t9\u0004AI\u0001\n\u0003\tI\u0004C\u0005\u0002>\u0001\t\n\u0011\"\u0001\u0002@!I\u00111\t\u0001\u0002\u0002\u0013\u0005\u0013Q\t\u0005\n\u0003+\u0002\u0011\u0011!C\u0001\u0003/B\u0011\"a\u0018\u0001\u0003\u0003%\t!!\u0019\t\u0013\u00055\u0004!!A\u0005B\u0005=\u0004\"CA?\u0001\u0005\u0005I\u0011AA@\u0011%\tI\tAA\u0001\n\u0003\nYiB\u0005\u0002\u0010n\t\t\u0011#\u0001\u0002\u0012\u001aA!dGA\u0001\u0012\u0003\t\u0019\n\u0003\u0004q)\u0011\u0005\u0011\u0011\u0015\u0005\n\u0003G#\u0012\u0011!C#\u0003KC\u0011\"a*\u0015\u0003\u0003%\t)!+\t\u0013\u0005EF#!A\u0005\u0002\u0006M\u0006\"CAa)\u0005\u0005I\u0011BAb\u0005q\tE\u000e^3s)\u0006\u0014G.Z*fi2{7-\u0019;j_:\u001cu.\\7b]\u0012T!\u0001H\u000f\u0002\u000f\r|W.\\1oI*\u0011adH\u0001\nKb,7-\u001e;j_:T!\u0001I\u0011\u0002\u0007M\fHN\u0003\u0002#G\u0005)1\u000f]1sW*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u00154ou\u0002\"AK\u0019\u000e\u0003-R!\u0001L\u0017\u0002\u000f1|w-[2bY*\u0011afL\u0001\u0006a2\fgn\u001d\u0006\u0003a}\t\u0001bY1uC2L8\u000f^\u0005\u0003e-\u00121\u0002T8hS\u000e\fG\u000e\u00157b]B\u0011A'N\u0007\u00027%\u0011ag\u0007\u0002\u0010%Vtg.\u00192mK\u000e{W.\\1oIB\u0011\u0001hO\u0007\u0002s)\t!(A\u0003tG\u0006d\u0017-\u0003\u0002=s\t9\u0001K]8ek\u000e$\bC\u0001\u001d?\u0013\ty\u0014H\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0005uC\ndWMT1nKV\t!\t\u0005\u0002D\t6\tq&\u0003\u0002F_\tyA+\u00192mK&#WM\u001c;jM&,'/\u0001\u0006uC\ndWMT1nK\u0002\nQ\u0002]1si&$\u0018n\u001c8Ta\u0016\u001cW#A%\u0011\u0007aRE*\u0003\u0002Ls\t1q\n\u001d;j_:\u0004\"!T1\u000f\u00059sfBA(]\u001d\t\u00016L\u0004\u0002R5:\u0011!+\u0017\b\u0003'bs!\u0001V,\u000e\u0003US!AV\u0014\u0002\rq\u0012xn\u001c;?\u0013\u00051\u0013B\u0001\u0013&\u0013\t\u00113%\u0003\u0002!C%\u0011\u0001gH\u0005\u0003;>\nqaY1uC2|w-\u0003\u0002`A\u0006a1)\u0019;bY><G+\u001f9fg*\u0011QlL\u0005\u0003E\u000e\u0014!\u0003V1cY\u0016\u0004\u0016M\u001d;ji&|gn\u00159fG*\u0011q\fY\u0001\u000fa\u0006\u0014H/\u001b;j_:\u001c\u0006/Z2!\u0003!awnY1uS>tW#A4\u0011\u0005!dgBA5k!\t!\u0016(\u0003\u0002ls\u00051\u0001K]3eK\u001aL!!\u001c8\u0003\rM#(/\u001b8h\u0015\tY\u0017(A\u0005m_\u000e\fG/[8oA\u00051A(\u001b8jiz\"BA]:ukB\u0011A\u0007\u0001\u0005\u0006\u0001\u001e\u0001\rA\u0011\u0005\u0006\u000f\u001e\u0001\r!\u0013\u0005\u0006K\u001e\u0001\raZ\u0001\u0004eVtGc\u0001=\u0002\fA!\u0011P`A\u0002\u001d\tQHP\u0004\u0002Uw&\t!(\u0003\u0002~s\u00059\u0001/Y2lC\u001e,\u0017bA@\u0002\u0002\t\u00191+Z9\u000b\u0005uL\u0004\u0003BA\u0003\u0003\u000fi\u0011aH\u0005\u0004\u0003\u0013y\"a\u0001*po\"9\u0011Q\u0002\u0005A\u0002\u0005=\u0011\u0001D:qCJ\\7+Z:tS>t\u0007\u0003BA\u0003\u0003#I1!a\u0005 \u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0011\u0019w\u000e]=\u0015\u000fI\fI\"a\u0007\u0002\u001e!9\u0001)\u0003I\u0001\u0002\u0004\u0011\u0005bB$\n!\u0003\u0005\r!\u0013\u0005\bK&\u0001\n\u00111\u0001h\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a\t+\u0007\t\u000b)c\u000b\u0002\u0002(A!\u0011\u0011FA\u001a\u001b\t\tYC\u0003\u0003\u0002.\u0005=\u0012!C;oG\",7m[3e\u0015\r\t\t$O\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001b\u0003W\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u000f+\u0007%\u000b)#\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0005#fA4\u0002&\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0012\u0011\t\u0005%\u00131K\u0007\u0003\u0003\u0017RA!!\u0014\u0002P\u0005!A.\u00198h\u0015\t\t\t&\u0001\u0003kCZ\f\u0017bA7\u0002L\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011\u0011\f\t\u0004q\u0005m\u0013bAA/s\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u00111MA5!\rA\u0014QM\u0005\u0004\u0003OJ$aA!os\"I\u00111N\b\u0002\u0002\u0003\u0007\u0011\u0011L\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005E\u0004CBA:\u0003s\n\u0019'\u0004\u0002\u0002v)\u0019\u0011qO\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002|\u0005U$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!!\u0002\bB\u0019\u0001(a!\n\u0007\u0005\u0015\u0015HA\u0004C_>dW-\u00198\t\u0013\u0005-\u0014#!AA\u0002\u0005\r\u0014AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0002\u00065\u0005\"CA6%\u0005\u0005\t\u0019AA2\u0003q\tE\u000e^3s)\u0006\u0014G.Z*fi2{7-\u0019;j_:\u001cu.\\7b]\u0012\u0004\"\u0001\u000e\u000b\u0014\tQ\t)*\u0010\t\t\u0003/\u000biJQ%he6\u0011\u0011\u0011\u0014\u0006\u0004\u00037K\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003?\u000bIJA\tBEN$(/Y2u\rVt7\r^5p]N\"\"!!%\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0012\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fI\fY+!,\u00020\")\u0001i\u0006a\u0001\u0005\")qi\u0006a\u0001\u0013\")Qm\u0006a\u0001O\u00069QO\\1qa2LH\u0003BA[\u0003{\u0003B\u0001\u000f&\u00028B1\u0001(!/C\u0013\u001eL1!a/:\u0005\u0019!V\u000f\u001d7fg!A\u0011q\u0018\r\u0002\u0002\u0003\u0007!/A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0019\t\u0005\u0003\u0013\n9-\u0003\u0003\u0002J\u0006-#AB(cU\u0016\u001cG\u000f")
public class AlterTableSetLocationCommand
extends LogicalPlan
implements RunnableCommand,
Serializable {
    private final TableIdentifier tableName;
    private final Option<Map<String, String>> partitionSpec;
    private final String location;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, Option<Map<String, String>>, String>> unapply(AlterTableSetLocationCommand alterTableSetLocationCommand) {
        return AlterTableSetLocationCommand$.MODULE$.unapply(alterTableSetLocationCommand);
    }

    public static Function1<Tuple3<TableIdentifier, Option<Map<String, String>>, String>, AlterTableSetLocationCommand> tupled() {
        return AlterTableSetLocationCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Option<Map<String, String>>, Function1<String, AlterTableSetLocationCommand>>> curried() {
        return AlterTableSetLocationCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableSetLocationCommand alterTableSetLocationCommand = this;
        synchronized (alterTableSetLocationCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public Option<Map<String, String>> partitionSpec() {
        return this.partitionSpec;
    }

    public String location() {
        return this.location;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable table = catalog.getTableMetadata(this.tableName());
        URI locUri = CatalogUtils$.MODULE$.stringToURI(this.location());
        DDLUtils$.MODULE$.verifyAlterTableType(catalog, table, false);
        Option<Map<String, String>> option = this.partitionSpec();
        if (option instanceof Some) {
            Some some = (Some)option;
            Map spec = (Map)some.value();
            DDLUtils$.MODULE$.verifyPartitionProviderIsHive(sparkSession, table, "ALTER TABLE ... SET LOCATION");
            Map normalizedSpec = PartitioningUtils$.MODULE$.normalizePartitionSpec(spec, table.partitionSchema(), table.identifier().quotedString(), sparkSession.sessionState().conf().resolver());
            CatalogTablePartition part = catalog.getPartition(table.identifier(), normalizedSpec);
            CatalogStorageFormat x$1 = part.storage().copy((Option)new Some((Object)locUri), part.storage().copy$default$2(), part.storage().copy$default$3(), part.storage().copy$default$4(), part.storage().copy$default$5(), part.storage().copy$default$6());
            Map x$2 = part.copy$default$1();
            Map x$3 = part.copy$default$3();
            long x$4 = part.copy$default$4();
            long x$5 = part.copy$default$5();
            Option x$6 = part.copy$default$6();
            CatalogTablePartition newPart = part.copy(x$2, x$1, x$3, x$4, x$5, x$6);
            catalog.alterPartitions(table.identifier(), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CatalogTablePartition[]{newPart})));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            catalog.alterTable(table.withNewStorage((Option)new Some((Object)locUri), table.withNewStorage$default$2(), table.withNewStorage$default$3(), table.withNewStorage$default$4(), table.withNewStorage$default$5(), table.withNewStorage$default$6()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        sparkSession.catalog().refreshTable(table.identifier().quotedString());
        CommandUtils$.MODULE$.updateTableStats(sparkSession, table);
        return (Seq)Seq$.MODULE$.empty();
    }

    public AlterTableSetLocationCommand copy(TableIdentifier tableName, Option<Map<String, String>> partitionSpec, String location) {
        return new AlterTableSetLocationCommand(tableName, partitionSpec, location);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public Option<Map<String, String>> copy$default$2() {
        return this.partitionSpec();
    }

    public String copy$default$3() {
        return this.location();
    }

    public String productPrefix() {
        return "AlterTableSetLocationCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tableName();
                break;
            }
            case 1: {
                object = this.partitionSpec();
                break;
            }
            case 2: {
                object = this.location();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableSetLocationCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableSetLocationCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableSetLocationCommand alterTableSetLocationCommand = (AlterTableSetLocationCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableSetLocationCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Option<Map<String, String>> option = this.partitionSpec();
        Option<Map<String, String>> option2 = alterTableSetLocationCommand.partitionSpec();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        String string = this.location();
        String string2 = alterTableSetLocationCommand.location();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!alterTableSetLocationCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableSetLocationCommand(TableIdentifier tableName, Option<Map<String, String>> partitionSpec, String location) {
        this.tableName = tableName;
        this.partitionSpec = partitionSpec;
        this.location = location;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

