/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.input;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class CombineFileRecordReaderWrapper<K, V>
extends RecordReader<K, V> {
    private final FileSplit fileSplit;
    private final RecordReader<K, V> delegate;

    protected CombineFileRecordReaderWrapper(FileInputFormat<K, V> inputFormat, CombineFileSplit split, TaskAttemptContext context, Integer idx) throws IOException, InterruptedException {
        this.fileSplit = new FileSplit(split.getPath(idx), split.getOffset(idx), split.getLength(idx), split.getLocations());
        this.delegate = inputFormat.createRecordReader(this.fileSplit, context);
    }

    @Override
    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        assert (this.fileSplitIsValid(context));
        this.delegate.initialize(this.fileSplit, context);
    }

    private boolean fileSplitIsValid(TaskAttemptContext context) {
        Configuration conf = context.getConfiguration();
        long offset = conf.getLong("mapreduce.map.input.start", 0L);
        if (this.fileSplit.getStart() != offset) {
            return false;
        }
        long length = conf.getLong("mapreduce.map.input.length", 0L);
        if (this.fileSplit.getLength() != length) {
            return false;
        }
        String path = conf.get("mapreduce.map.input.file");
        return this.fileSplit.getPath().toString().equals(path);
    }

    @Override
    public boolean nextKeyValue() throws IOException, InterruptedException {
        return this.delegate.nextKeyValue();
    }

    @Override
    public K getCurrentKey() throws IOException, InterruptedException {
        return this.delegate.getCurrentKey();
    }

    @Override
    public V getCurrentValue() throws IOException, InterruptedException {
        return this.delegate.getCurrentValue();
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.delegate.getProgress();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

