/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Reverse$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(array) - Returns a reversed string or an array with reverse order of elements.", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL');\n       LQS krapS\n      > SELECT _FUNC_(array(2, 1, 4, 3));\n       [3,4,1,2]\n  ", group="array_funcs", since="1.5.0", note="\n    Reverse logic for arrays is available since 2.4.0.\n  ")
@ScalaSignature(bytes="\u0006\u0001\u00055h\u0001B\u000e\u001d\u0001&B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0007\")q\t\u0001C\u0001\u0011\")1\n\u0001C!\u0019\")a\f\u0001C!?\")1\r\u0001C!I\"A!\u000e\u0001EC\u0002\u0013%1\u000eC\u0003t\u0001\u0011\u0005C\u000fC\u0004\u0002\u0006\u0001!I!a\u0002\t\u000f\u0005}\u0001\u0001\"\u0003\u0002\"!9\u0011\u0011\u0006\u0001\u0005B\u0005-\u0002\"CA\u0017\u0001\u0005\u0005I\u0011AA\u0018\u0011%\t\u0019\u0004AI\u0001\n\u0003\t)\u0004C\u0005\u0002L\u0001\t\t\u0011\"\u0011\u0002N!I\u0011Q\f\u0001\u0002\u0002\u0013\u0005\u0011q\f\u0005\n\u0003O\u0002\u0011\u0011!C\u0001\u0003SB\u0011\"a\u001c\u0001\u0003\u0003%\t%!\u001d\t\u0013\u0005}\u0004!!A\u0005\u0002\u0005\u0005\u0005\"CAF\u0001\u0005\u0005I\u0011IAG\u000f%\t9\fHA\u0001\u0012\u0003\tIL\u0002\u0005\u001c9\u0005\u0005\t\u0012AA^\u0011\u00199U\u0003\"\u0001\u0002J\"I\u00111Z\u000b\u0002\u0002\u0013\u0015\u0013Q\u001a\u0005\n\u0003\u001f,\u0012\u0011!CA\u0003#D\u0011\"!6\u0016\u0003\u0003%\t)a6\t\u0013\u0005\rX#!A\u0005\n\u0005\u0015(a\u0002*fm\u0016\u00148/\u001a\u0006\u0003;y\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0004I\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011EI\u0001\u0004gFd'BA\u0012%\u0003\u0015\u0019\b/\u0019:l\u0015\t)c%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002O\u0005\u0019qN]4\u0004\u0001M1\u0001A\u000b\u00182qy\u0002\"a\u000b\u0017\u000e\u0003qI!!\f\u000f\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"aK\u0018\n\u0005Ab\"AF%na2L7-\u001b;DCN$\u0018J\u001c9viRK\b/Z:\u0011\u0005I*dBA\u00164\u0013\t!D$A\u0004qC\u000e\\\u0017mZ3\n\u0005Y:$A\u0004(vY2Le\u000e^8mKJ\fg\u000e\u001e\u0006\u0003iq\u0001\"!\u000f\u001f\u000e\u0003iR\u0011aO\u0001\u0006g\u000e\fG.Y\u0005\u0003{i\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002:\u007f%\u0011\u0001I\u000f\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006G\"LG\u000eZ\u000b\u0002\u0007B\u00111\u0006R\u0005\u0003\u000br\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0019\u0019\u0007.\u001b7eA\u00051A(\u001b8jiz\"\"!\u0013&\u0011\u0005-\u0002\u0001\"B!\u0004\u0001\u0004\u0019\u0015AC5oaV$H+\u001f9fgV\tQ\nE\u0002O+bs!a\u0014+\u000f\u0005A\u001bV\"A)\u000b\u0005IC\u0013A\u0002\u001fs_>$h(C\u0001<\u0013\t!$(\u0003\u0002W/\n\u00191+Z9\u000b\u0005QR\u0004CA-]\u001b\u0005Q&BA.!\u0003\u0015!\u0018\u0010]3t\u0013\ti&L\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001a!\tI\u0016-\u0003\u0002c5\nAA)\u0019;b)f\u0004X-\u0001\u0007ok2d7+\u00194f\u000bZ\fG\u000e\u0006\u0002fQB\u0011\u0011HZ\u0005\u0003Oj\u00121!\u00118z\u0011\u0015Ig\u00011\u0001f\u0003\u0015Ig\u000e];u\u0003%!wNU3wKJ\u001cX-F\u0001m!\u0011IT.Z3\n\u00059T$!\u0003$v]\u000e$\u0018n\u001c82Q\t9\u0001\u000f\u0005\u0002:c&\u0011!O\u000f\u0002\niJ\fgn]5f]R\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\tU\\\u0018\u0011\u0001\t\u0003mfl\u0011a\u001e\u0006\u0003qr\tqaY8eK\u001e,g.\u0003\u0002{o\nAQ\t\u001f9s\u0007>$W\rC\u0003}\u0011\u0001\u0007Q0A\u0002dib\u0004\"A\u001e@\n\u0005}<(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0007\u0003\u0007A\u0001\u0019A;\u0002\u0005\u00154\u0018!D:ue&twmQ8eK\u001e+g\u000e\u0006\u0004\u0002\n\u0005e\u00111\u0004\t\u0005\u0003\u0017\t\u0019B\u0004\u0003\u0002\u000e\u0005=\u0001C\u0001);\u0013\r\t\tBO\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0011q\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005E!\b\u0003\u0004\u0002\u0004%\u0001\r!\u001e\u0005\b\u0003;I\u0001\u0019AA\u0005\u0003%\u0019\u0007.\u001b7e\u001d\u0006lW-\u0001\u0007beJ\f\u0017pQ8eK\u001e+g\u000e\u0006\u0005\u0002\n\u0005\r\u0012QEA\u0014\u0011\u0015a(\u00021\u0001~\u0011\u0019\t\u0019A\u0003a\u0001k\"9\u0011Q\u0004\u0006A\u0002\u0005%\u0011A\u00039sKR$\u0018PT1nKV\u0011\u0011\u0011B\u0001\u0005G>\u0004\u0018\u0010F\u0002J\u0003cAq!\u0011\u0007\u0011\u0002\u0003\u00071)\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005]\"fA\"\u0002:-\u0012\u00111\b\t\u0005\u0003{\t9%\u0004\u0002\u0002@)!\u0011\u0011IA\"\u0003%)hn\u00195fG.,GMC\u0002\u0002Fi\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI%a\u0010\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003\u001f\u0002B!!\u0015\u0002\\5\u0011\u00111\u000b\u0006\u0005\u0003+\n9&\u0001\u0003mC:<'BAA-\u0003\u0011Q\u0017M^1\n\t\u0005U\u00111K\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003C\u00022!OA2\u0013\r\t)G\u000f\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004K\u0006-\u0004\"CA7!\u0005\u0005\t\u0019AA1\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u000f\t\u0006\u0003k\nY(Z\u0007\u0003\u0003oR1!!\u001f;\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003{\n9H\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAB\u0003\u0013\u00032!OAC\u0013\r\t9I\u000f\u0002\b\u0005>|G.Z1o\u0011!\tiGEA\u0001\u0002\u0004)\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0004\u0006=\u0005\u0002CA7'\u0005\u0005\t\u0019A3)/\u0001\t\u0019*!'\u0002\u001c\u0006}\u0015\u0011UAS\u0003O\u000bY+!,\u00022\u0006M\u0006cA\u0016\u0002\u0016&\u0019\u0011q\u0013\u000f\u0003+\u0015C\bO]3tg&|g\u000eR3tGJL\u0007\u000f^5p]\u0006)Qo]1hK\u0006\u0012\u0011QT\u0001V?\u001a+fjQ0)CJ\u0014\u0018-_\u0015![\u0001\u0012V\r^;s]N\u0004\u0013\r\t:fm\u0016\u00148/\u001a3!gR\u0014\u0018N\\4!_J\u0004\u0013M\u001c\u0011beJ\f\u0017\u0010I<ji\"\u0004#/\u001a<feN,\u0007e\u001c:eKJ\u0004sN\u001a\u0011fY\u0016lWM\u001c;t]\u0005AQ\r_1na2,7/\t\u0002\u0002$\u0006\t\u0019A\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015('B\f'o\u001b\u0011T#2;\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011M#N\u00033N]1q'*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\"\u0012D\u0006I\u0019-AQb\u0003eM\u0015*w)\u0001\u0003\u0005\t\u0011!A\u0001Z6\u0007\f\u001b-c1\u0012TL\u0003\u0011!\u0003\u00159'o\\;qC\t\tI+A\u0006beJ\f\u0017p\u00184v]\u000e\u001c\u0018!B:j]\u000e,\u0017EAAX\u0003\u0015\td&\u000e\u00181\u0003\u0011qw\u000e^3\"\u0005\u0005U\u0016A\u000f\u0006!A\u0001\u0002#+\u001a<feN,\u0007\u0005\\8hS\u000e\u0004cm\u001c:!CJ\u0014\u0018-_:!SN\u0004\u0013M^1jY\u0006\u0014G.\u001a\u0011tS:\u001cW\r\t\u001a/i9\u0002dF\u0003\u0011!\u0003\u001d\u0011VM^3sg\u0016\u0004\"aK\u000b\u0014\tU\tiL\u0010\t\u0007\u0003\u007f\u000b)mQ%\u000e\u0005\u0005\u0005'bAAbu\u00059!/\u001e8uS6,\u0017\u0002BAd\u0003\u0003\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c82)\t\tI,\u0001\u0005u_N#(/\u001b8h)\t\ty%A\u0003baBd\u0017\u0010F\u0002J\u0003'DQ!\u0011\rA\u0002\r\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002Z\u0006}\u0007\u0003B\u001d\u0002\\\u000eK1!!8;\u0005\u0019y\u0005\u000f^5p]\"A\u0011\u0011]\r\u0002\u0002\u0003\u0007\u0011*A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u001d\t\u0005\u0003#\nI/\u0003\u0003\u0002l\u0006M#AB(cU\u0016\u001cG\u000f")
public class Reverse
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private transient Function1<Object, Object> doReverse;
    private final Expression child;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Expression> unapply(Reverse reverse) {
        return Reverse$.MODULE$.unapply(reverse);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Reverse, A> function1) {
        return Reverse$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Reverse> compose(Function1<A, Expression> function1) {
        return Reverse$.MODULE$.compose(function1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringType$.MODULE$, ArrayType$.MODULE$}))}));
    }

    @Override
    public DataType dataType() {
        return this.child().dataType();
    }

    @Override
    public Object nullSafeEval(Object input) {
        return this.doReverse().apply(input);
    }

    private Function1<Object, Object> doReverse$lzycompute() {
        Reverse reverse = this;
        synchronized (reverse) {
            if (!this.bitmap$trans$0) {
                Function1 & Serializable & scala.Serializable intersect;
                DataType dataType = this.dataType();
                if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    DataType elementType = arrayType.elementType();
                    intersect = (Function1 & Serializable & scala.Serializable)input -> {
                        ArrayData arrayData = (ArrayData)input;
                        return new GenericArrayData(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(arrayData.toObjectArray(elementType))).reverse());
                    };
                } else if (StringType$.MODULE$.equals(dataType)) {
                    intersect = (Function1 & Serializable & scala.Serializable)x$27 -> ((UTF8String)x$27).reverse();
                } else {
                    throw new MatchError((Object)dataType);
                }
                this.doReverse = intersect;
                this.bitmap$trans$0 = true;
            }
        }
        return this.doReverse;
    }

    private Function1<Object, Object> doReverse() {
        return !this.bitmap$trans$0 ? this.doReverse$lzycompute() : this.doReverse;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> {
            String string;
            DataType dataType = this.dataType();
            if (dataType instanceof StringType) {
                string = this.stringCodeGen(ev, (String)c);
            } else if (dataType instanceof ArrayType) {
                string = this.arrayCodeGen(ctx, ev, (String)c);
            } else {
                throw new MatchError((Object)dataType);
            }
            return string;
        });
    }

    private String stringCodeGen(ExprCode ev, String childName) {
        return new StringBuilder(16).append(ev.value()).append(" = (").append(childName).append(").reverse();").toString();
    }

    private String arrayCodeGen(CodegenContext ctx, ExprCode ev, String childName) {
        String numElements = ctx.freshName("numElements");
        String arrayData = ctx.freshName("arrayData");
        String i = ctx.freshName("i");
        String j = ctx.freshName("j");
        DataType elementType = ((ArrayType)this.dataType()).elementType();
        String initialization = CodeGenerator$.MODULE$.createArrayData(arrayData, elementType, numElements, new StringBuilder(9).append(" ").append(this.prettyName()).append(" failed.").toString());
        String assignment = CodeGenerator$.MODULE$.createArrayAssignment(arrayData, elementType, childName, i, j, ((ArrayType)this.dataType()).containsNull());
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(146).append("\n       |final int ").append(numElements).append(" = ").append(childName).append(".numElements();\n       |").append(initialization).append("\n       |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append(numElements).append("; ").append(i).append("++) {\n       |  int ").append(j).append(" = ").append(numElements).append(" - ").append(i).append(" - 1;\n       |  ").append(assignment).append("\n       |}\n       |").append(ev.value()).append(" = ").append(arrayData).append(";\n     ").toString())).stripMargin();
    }

    @Override
    public String prettyName() {
        return "reverse";
    }

    public Reverse copy(Expression child) {
        return new Reverse(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Reverse";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Reverse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Reverse)) return false;
        boolean bl = true;
        if (!bl) return false;
        Reverse reverse = (Reverse)x$1;
        Expression expression = this.child();
        Expression expression2 = reverse.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!reverse.canEqual(this)) return false;
        return true;
    }

    public Reverse(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

