/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.master.ui;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.spark.SSLOptions;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.DeployMessages;
import org.apache.spark.deploy.DeployMessages$RequestMasterState$;
import org.apache.spark.deploy.master.ApplicationInfo;
import org.apache.spark.deploy.master.Master;
import org.apache.spark.deploy.master.WorkerInfo;
import org.apache.spark.deploy.master.ui.ApplicationPage;
import org.apache.spark.deploy.master.ui.MasterPage;
import org.apache.spark.deploy.master.ui.MasterWebUI$;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.ui.JettyUtils$;
import org.apache.spark.ui.WebUI;
import org.apache.spark.ui.WebUI$;
import org.sparkproject.jetty.servlet.ServletContextHandler;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\u0005-b!B\u000b\u0017\u0001a\u0011\u0003\u0002C\r\u0001\u0005\u000b\u0007I\u0011A\u0018\t\u0011Q\u0002!\u0011!Q\u0001\nAB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\u0006y\u0001!\t!\u0010\u0005\b\u0005\u0002\u0011\r\u0011\"\u0001D\u0011\u0019Q\u0005\u0001)A\u0005\t\"91\n\u0001b\u0001\n\u0003a\u0005B\u0002)\u0001A\u0003%Q\nC\u0004R\u0001\t\u0007I\u0011\u0001*\t\ry\u0003\u0001\u0015!\u0003T\u0011\u0015y\u0006\u0001\"\u0001a\u0011\u0015!\u0007\u0001\"\u0001a\u0011\u0015)\u0007\u0001\"\u0001g\u0011\u0015a\u0007\u0001\"\u0003n\u0011\u0015A\b\u0001\"\u0003z\u000f!\tiA\u0006E\u00011\u0005=aaB\u000b\u0017\u0011\u0003A\u0012\u0011\u0003\u0005\u0007yE!\t!!\u0007\t\u0013\u0005m\u0011C1A\u0005\n\u0005u\u0001\u0002CA\u0015#\u0001\u0006I!a\b\u0003\u00175\u000b7\u000f^3s/\u0016\u0014W+\u0013\u0006\u0003/a\t!!^5\u000b\u0005eQ\u0012AB7bgR,'O\u0003\u0002\u001c9\u00051A-\u001a9m_fT!!\b\u0010\u0002\u000bM\u0004\u0018M]6\u000b\u0005}\u0001\u0013AB1qC\u000eDWMC\u0001\"\u0003\ry'oZ\n\u0004\u0001\rB\u0003C\u0001\u0013'\u001b\u0005)#BA\f\u001d\u0013\t9SEA\u0003XK\n,\u0016\n\u0005\u0002*Y5\t!F\u0003\u0002,9\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002.U\t9Aj\\4hS:<7\u0001A\u000b\u0002aA\u0011\u0011GM\u0007\u00021%\u00111\u0007\u0007\u0002\u0007\u001b\u0006\u001cH/\u001a:\u0002\u000f5\f7\u000f^3sA\u0005i!/Z9vKN$X\r\u001a)peR\u0004\"a\u000e\u001e\u000e\u0003aR\u0011!O\u0001\u0006g\u000e\fG.Y\u0005\u0003wa\u00121!\u00138u\u0003\u0019a\u0014N\\5u}Q\u0019a\bQ!\u0011\u0005}\u0002Q\"\u0001\f\t\u000be!\u0001\u0019\u0001\u0019\t\u000bU\"\u0001\u0019\u0001\u001c\u0002#5\f7\u000f^3s\u000b:$\u0007o\\5oiJ+g-F\u0001E!\t)\u0005*D\u0001G\u0015\t9E$A\u0002sa\u000eL!!\u0013$\u0003\u001dI\u00038-\u00128ea>Lg\u000e\u001e*fM\u0006\u0011R.Y:uKJ,e\u000e\u001a9pS:$(+\u001a4!\u0003-Y\u0017\u000e\u001c7F]\u0006\u0014G.\u001a3\u0016\u00035\u0003\"a\u000e(\n\u0005=C$a\u0002\"p_2,\u0017M\\\u0001\rW&dG.\u00128bE2,G\rI\u0001\u0016I\u0016\u001cw.\\7jgNLwN\\!mY><Xj\u001c3f+\u0005\u0019\u0006C\u0001+\\\u001d\t)\u0016\f\u0005\u0002Wq5\tqK\u0003\u0002Y]\u00051AH]8pizJ!A\u0017\u001d\u0002\rA\u0013X\rZ3g\u0013\taVL\u0001\u0004TiJLgn\u001a\u0006\u00035b\na\u0003Z3d_6l\u0017n]:j_:\fE\u000e\\8x\u001b>$W\rI\u0001\u000bS:LG/[1mSj,G#A1\u0011\u0005]\u0012\u0017BA29\u0005\u0011)f.\u001b;\u0002\u0011\u0005$G\r\u0015:pqf\fQ\"\u001b3U_VK\u0017\t\u001a3sKN\u001cHCA4k!\r9\u0004nU\u0005\u0003Sb\u0012aa\u00149uS>t\u0007\"B6\u000e\u0001\u0004\u0019\u0016AA5e\u0003\u001dI7\u000fT8dC2$\"!\u00148\t\u000b=t\u0001\u0019\u00019\u0002\u000f\u0005$GM]3tgB\u0011\u0011O^\u0007\u0002e*\u00111\u000f^\u0001\u0004]\u0016$(\"A;\u0002\t)\fg/Y\u0005\u0003oJ\u00141\"\u00138fi\u0006#GM]3tg\u0006y\u0012n\u001d#fG>lW.[:tS>t\u0017N\\4SKF,Xm\u001d;BY2|w/\u001a3\u0015\u00055S\b\"B>\u0010\u0001\u0004a\u0018a\u0001:fcB\u0019Q0!\u0003\u000e\u0003yT1a`A\u0001\u0003\u0011AG\u000f\u001e9\u000b\t\u0005\r\u0011QA\u0001\bg\u0016\u0014h\u000f\\3u\u0015\t\t9!A\u0003kCZ\f\u00070C\u0002\u0002\fy\u0014!\u0003\u0013;uaN+'O\u001e7fiJ+\u0017/^3ti\u0006YQ*Y:uKJ<VMY+J!\ty\u0014cE\u0002\u0012\u0003'\u00012aNA\u000b\u0013\r\t9\u0002\u000f\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005=\u0011aE*U\u0003RK5i\u0018*F'>+&kQ#`\t&\u0013VCAA\u0010!\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013i\u0006!A.\u00198h\u0013\ra\u00161E\u0001\u0015'R\u000bE+S\"`%\u0016\u001bv*\u0016*D\u000b~#\u0015J\u0015\u0011")
public class MasterWebUI
extends WebUI {
    private final Master master;
    private final RpcEndpointRef masterEndpointRef;
    private final boolean killEnabled;
    private final String decommissionAllowMode;

    public Master master() {
        return this.master;
    }

    public RpcEndpointRef masterEndpointRef() {
        return this.masterEndpointRef;
    }

    public boolean killEnabled() {
        return this.killEnabled;
    }

    public String decommissionAllowMode() {
        return this.decommissionAllowMode;
    }

    @Override
    public void initialize() {
        MasterPage masterPage = new MasterPage(this);
        this.attachPage(new ApplicationPage(this));
        this.attachPage(masterPage);
        this.addStaticHandler(MasterWebUI$.MODULE$.org$apache$spark$deploy$master$ui$MasterWebUI$$STATIC_RESOURCE_DIR(), this.addStaticHandler$default$2());
        String x$1 = "/app/kill";
        String x$2 = "/";
        Function1 & Serializable & scala.Serializable x$3 = (Function1 & Serializable & scala.Serializable)request -> {
            masterPage.handleAppKillRequest(request);
            return BoxedUnit.UNIT;
        };
        Set x$4 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"POST"}));
        String x$5 = JettyUtils$.MODULE$.createRedirectHandler$default$4();
        this.attachHandler(JettyUtils$.MODULE$.createRedirectHandler(x$1, x$2, (Function1<HttpServletRequest, BoxedUnit>)x$3, x$5, (Set<String>)x$4));
        String x$6 = "/driver/kill";
        String x$7 = "/";
        Function1 & Serializable & scala.Serializable x$8 = (Function1 & Serializable & scala.Serializable)request -> {
            masterPage.handleDriverKillRequest(request);
            return BoxedUnit.UNIT;
        };
        Set x$9 = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"POST"}));
        String x$10 = JettyUtils$.MODULE$.createRedirectHandler$default$4();
        this.attachHandler(JettyUtils$.MODULE$.createRedirectHandler(x$6, x$7, (Function1<HttpServletRequest, BoxedUnit>)x$8, x$10, (Set<String>)x$9));
        this.attachHandler(JettyUtils$.MODULE$.createServletHandler("/workers/kill", new HttpServlet(this){
            private final /* synthetic */ MasterWebUI $outer;

            public void doPost(HttpServletRequest req, HttpServletResponse resp) {
                Seq hostnames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)req.getParameterValues("host")).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))))).toSeq();
                if (!this.$outer.org$apache$spark$deploy$master$ui$MasterWebUI$$isDecommissioningRequestAllowed(req)) {
                    resp.sendError(405);
                } else {
                    Integer removedWorkers = (Integer)this.$outer.masterEndpointRef().askSync(new DeployMessages.DecommissionWorkersOnHosts((Seq<String>)hostnames), ClassTag$.MODULE$.apply(Integer.class));
                    this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Decommissioning of hosts ").append(hostnames).append(" decommissioned ").append(removedWorkers).append(" workers").toString());
                    if (Predef$.MODULE$.Integer2int(removedWorkers) > 0) {
                        resp.setStatus(200);
                    } else if (BoxesRunTime.equalsNumObject((Number)removedWorkers, (Object)BoxesRunTime.boxToInteger((int)0))) {
                        resp.sendError(404);
                    } else {
                        resp.setStatus(500);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$doPost$1(), $anonfun$doPost$2(scala.collection.Seq java.lang.Integer )}, serializedLambda);
            }
        }, ""));
    }

    public void addProxy() {
        ServletContextHandler handler = JettyUtils$.MODULE$.createProxyHandler((Function1<String, Option<String>>)(Function1 & Serializable & scala.Serializable)id -> this.idToUiAddress((String)id));
        this.attachHandler(handler);
    }

    public Option<String> idToUiAddress(String id) {
        DeployMessages.MasterStateResponse state = (DeployMessages.MasterStateResponse)this.masterEndpointRef().askSync(DeployMessages$RequestMasterState$.MODULE$, ClassTag$.MODULE$.apply(DeployMessages.MasterStateResponse.class));
        Option maybeWorkerUiAddress = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])state.workers())).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MasterWebUI.$anonfun$idToUiAddress$1(id, x$1))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.webUiAddress());
        Option maybeAppUiAddress = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])state.activeApps())).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MasterWebUI.$anonfun$idToUiAddress$3(id, x$3))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.desc().appUiUrl());
        return maybeWorkerUiAddress.orElse((Function0 & Serializable & scala.Serializable)() -> maybeAppUiAddress);
    }

    private boolean isLocal(InetAddress address) {
        boolean bl;
        block4: {
            if (address.isAnyLocalAddress() || address.isLoopbackAddress()) {
                return true;
            }
            try {
                if (NetworkInterface.getByInetAddress(address) != null) {
                    bl = true;
                    break block4;
                }
                bl = false;
            }
            catch (SocketException socketException) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean org$apache$spark$deploy$master$ui$MasterWebUI$$isDecommissioningRequestAllowed(HttpServletRequest req) {
        String string = this.decommissionAllowMode();
        boolean bl = "ALLOW".equals(string) ? true : ("LOCAL".equals(string) ? this.isLocal(InetAddress.getByName(req.getRemoteAddr())) : false);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$idToUiAddress$1(String id$1, WorkerInfo x$1) {
        String string = x$1.id();
        String string2 = id$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$idToUiAddress$3(String id$1, ApplicationInfo x$3) {
        String string = x$3.id();
        String string2 = id$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public MasterWebUI(Master master, int requestedPort) {
        this.master = master;
        SecurityManager x$1 = master.securityMgr();
        SSLOptions x$2 = master.securityMgr().getSSLOptions("standalone");
        int x$3 = requestedPort;
        SparkConf x$4 = master.conf();
        String x$5 = "MasterUI";
        String x$6 = WebUI$.MODULE$.$lessinit$greater$default$5();
        super(x$1, x$2, x$3, x$4, x$6, x$5);
        this.masterEndpointRef = master.self();
        this.killEnabled = BoxesRunTime.unboxToBoolean((Object)master.conf().get(UI$.MODULE$.UI_KILL_ENABLED()));
        this.decommissionAllowMode = master.conf().get(UI$.MODULE$.MASTER_UI_DECOMMISSION_ALLOW_MODE());
        this.initialize();
    }
}

