/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.history;

import com.codahale.metrics.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.EnumSet;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import javax.servlet.DispatcherType;
import org.apache.spark.deploy.history.ApplicationCacheCheckFilter;
import org.apache.spark.deploy.history.ApplicationCacheOperations;
import org.apache.spark.deploy.history.CacheEntry;
import org.apache.spark.deploy.history.CacheKey;
import org.apache.spark.deploy.history.CacheMetrics;
import org.apache.spark.deploy.history.LoadedAppUI;
import org.apache.spark.internal.Logging;
import org.apache.spark.status.api.v1.ApplicationAttemptInfo;
import org.apache.spark.status.api.v1.ApplicationInfo;
import org.apache.spark.ui.SparkUI;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import org.sparkproject.guava.cache.CacheBuilder;
import org.sparkproject.guava.cache.CacheLoader;
import org.sparkproject.guava.cache.LoadingCache;
import org.sparkproject.guava.cache.RemovalListener;
import org.sparkproject.guava.cache.RemovalNotification;
import org.sparkproject.guava.util.concurrent.UncheckedExecutionException;
import org.sparkproject.jetty.servlet.FilterHolder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\tUa!B\r\u001b\u0001i!\u0003\u0002C\u0019\u0001\u0005\u000b\u0007I\u0011A\u001a\t\u0011a\u0002!\u0011!Q\u0001\nQB\u0001\"\u000f\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t}\u0001\u0011\t\u0011)A\u0005w!Aq\b\u0001BC\u0002\u0013\u0005\u0001\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003B\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u001dq\u0005A1A\u0005\n=CaA\u0019\u0001!\u0002\u0013\u0001\u0006bB2\u0001\u0005\u0004%I\u0001\u001a\u0005\u0007Q\u0002\u0001\u000b\u0011B3\t\u000fQ\u0004!\u0019!C\u0005k\"1\u0011\u0010\u0001Q\u0001\nYDqA\u001f\u0001C\u0002\u0013\u00051\u0010\u0003\u0004\u0000\u0001\u0001\u0006I\u0001 \u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0011%\tI\u0003AI\u0001\n\u0003\tY\u0003C\u0004\u0002B\u0001!\t!a\u0011\t\u000f\u0005e\u0004\u0001\"\u0001\u0002|!9\u00111\u0011\u0001\u0005\n\u0005\u0015\u0005bBAV\u0001\u0011%\u0011Q\u0016\u0005\b\u0003g\u0004A\u0011IA{\u0011\u001d\t9\u0010\u0001C\u0005\u0003sDqAa\u0004\u0001\t\u0003\u0011\tB\u0001\tBaBd\u0017nY1uS>t7)Y2iK*\u00111\u0004H\u0001\bQ&\u001cHo\u001c:z\u0015\tib$\u0001\u0004eKBdw.\u001f\u0006\u0003?\u0001\nQa\u001d9be.T!!\t\u0012\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0013aA8sON\u0019\u0001!J\u0016\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g!\tas&D\u0001.\u0015\tqc$\u0001\u0005j]R,'O\\1m\u0013\t\u0001TFA\u0004M_\u001e<\u0017N\\4\u0002\u0015=\u0004XM]1uS>t7o\u0001\u0001\u0016\u0003Q\u0002\"!\u000e\u001c\u000e\u0003iI!a\u000e\u000e\u00035\u0005\u0003\b\u000f\\5dCRLwN\\\"bG\",w\n]3sCRLwN\\:\u0002\u0017=\u0004XM]1uS>t7\u000fI\u0001\u0015e\u0016$\u0018-\u001b8fI\u0006\u0003\b\u000f\\5dCRLwN\\:\u0016\u0003m\u0002\"A\n\u001f\n\u0005u:#aA%oi\u0006)\"/\u001a;bS:,G-\u00119qY&\u001c\u0017\r^5p]N\u0004\u0013!B2m_\u000e\\W#A!\u0011\u0005\t+U\"A\"\u000b\u0005\u0011s\u0012\u0001B;uS2L!AR\"\u0003\u000b\rcwnY6\u0002\r\rdwnY6!\u0003\u0019a\u0014N\\5u}Q!!j\u0013'N!\t)\u0004\u0001C\u00032\u000f\u0001\u0007A\u0007C\u0003:\u000f\u0001\u00071\bC\u0003@\u000f\u0001\u0007\u0011)A\u0005baBdu.\u00193feV\t\u0001\u000b\u0005\u0003R5r{V\"\u0001*\u000b\u0005M#\u0016!B2bG\",'BA+W\u0003\u0019\u0019w.\\7p]*\u0011q\u000bW\u0001\u0007O>|w\r\\3\u000b\u0003e\u000b1aY8n\u0013\tY&KA\u0006DC\u000eDW\rT8bI\u0016\u0014\bCA\u001b^\u0013\tq&D\u0001\u0005DC\u000eDWmS3z!\t)\u0004-\u0003\u0002b5\tQ1)Y2iK\u0016sGO]=\u0002\u0015\u0005\u0004\b\u000fT8bI\u0016\u0014\b%A\bsK6|g/\u00197MSN$XM\\3s+\u0005)'c\u00014jc\u001a!qm\u0003\u0001f\u00051a$/\u001a4j]\u0016lWM\u001c;?\u0003A\u0011X-\\8wC2d\u0015n\u001d;f]\u0016\u0014\b\u0005\u0005\u0002k_6\t1N\u0003\u0002m[\u0006!A.\u00198h\u0015\u0005q\u0017\u0001\u00026bm\u0006L!\u0001]6\u0003\r=\u0013'.Z2u!\u0011\t&\u000fX0\n\u0005M\u0014&a\u0004*f[>4\u0018\r\u001c'jgR,g.\u001a:\u0002\u0011\u0005\u0004\boQ1dQ\u0016,\u0012A\u001e\t\u0005#^dv,\u0003\u0002y%\naAj\\1eS:<7)Y2iK\u0006I\u0011\r\u001d9DC\u000eDW\rI\u0001\b[\u0016$(/[2t+\u0005a\bCA\u001b~\u0013\tq(D\u0001\u0007DC\u000eDW-T3ue&\u001c7/\u0001\u0005nKR\u0014\u0018nY:!\u0003\r9W\r\u001e\u000b\u0006?\u0006\u0015\u0011q\u0004\u0005\b\u0003\u000f\u0001\u0002\u0019AA\u0005\u0003\u0015\t\u0007\u000f]%e!\u0011\tY!!\u0007\u000f\t\u00055\u0011Q\u0003\t\u0004\u0003\u001f9SBAA\t\u0015\r\t\u0019BM\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005]q%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u00037\tiB\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003/9\u0003\"CA\u0011!A\u0005\t\u0019AA\u0012\u0003%\tG\u000f^3naRLE\rE\u0003'\u0003K\tI!C\u0002\u0002(\u001d\u0012aa\u00149uS>t\u0017!D4fi\u0012\"WMZ1vYR$#'\u0006\u0002\u0002.)\"\u00111EA\u0018W\t\t\t\u0004\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001eO\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0012Q\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aC<ji\"\u001c\u0006/\u0019:l+&+B!!\u0012\u0002NQ1\u0011qIA;\u0003o\"B!!\u0013\u0002`A!\u00111JA'\u0019\u0001!q!a\u0014\u0013\u0005\u0004\t\tFA\u0001U#\u0011\t\u0019&!\u0017\u0011\u0007\u0019\n)&C\u0002\u0002X\u001d\u0012qAT8uQ&tw\rE\u0002'\u00037J1!!\u0018(\u0005\r\te.\u001f\u0005\b\u0003C\u0012\u0002\u0019AA2\u0003\t1g\u000eE\u0004'\u0003K\nI'!\u0013\n\u0007\u0005\u001dtEA\u0005Gk:\u001cG/[8ocA!\u00111NA9\u001b\t\tiGC\u0002\u0002py\t!!^5\n\t\u0005M\u0014Q\u000e\u0002\b'B\f'o[+J\u0011\u001d\t9A\u0005a\u0001\u0003\u0013Aq!!\t\u0013\u0001\u0004\t\u0019#\u0001\u0003tSj,GCAA?!\r1\u0013qP\u0005\u0004\u0003\u0003;#\u0001\u0002'p]\u001e\fA\u0001^5nKV!\u0011qQAG)\u0011\tI)!'\u0015\t\u0005-\u0015q\u0012\t\u0005\u0003\u0017\ni\tB\u0004\u0002PQ\u0011\r!!\u0015\t\u0011\u0005EE\u0003\"a\u0001\u0003'\u000b\u0011A\u001a\t\u0006M\u0005U\u00151R\u0005\u0004\u0003/;#\u0001\u0003\u001fcs:\fW.\u001a \t\u000f\u0005mE\u00031\u0001\u0002\u001e\u0006\tA\u000f\u0005\u0003\u0002 \u0006\u001dVBAAQ\u0015\rQ\u00181\u0015\u0006\u0004\u0003KC\u0016\u0001C2pI\u0006D\u0017\r\\3\n\t\u0005%\u0016\u0011\u0015\u0002\u0006)&lWM]\u0001\u0015Y>\fG-\u00119qY&\u001c\u0017\r^5p]\u0016sGO]=\u0015\u000b}\u000by+!-\t\u000f\u0005\u001dQ\u00031\u0001\u0002\n!9\u0011\u0011E\u000bA\u0002\u0005\r\u0002&B\u000b\u00026\u0006\u0015\u0007#\u0002\u0014\u00028\u0006m\u0016bAA]O\t1A\u000f\u001b:poN\u0004B!!0\u0002B6\u0011\u0011q\u0018\u0006\u0003\t6LA!a1\u0002@\n1bj\\*vG\",E.Z7f]R,\u0005pY3qi&|g.M\u0004\u001f\u0003\u0013\t9-!=2\u0013\r\nI-a4\u0002h\u0006EW\u0003BAf\u0003\u001b,\"!!\u0003\u0005\u000f\u0005=#G1\u0001\u0002X&!\u0011\u0011[Aj\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u0011Q[\u0014\u0002\rQD'o\\<t#\u0011\t\u0019&!7\u0011\t\u0005m\u0017\u0011\u001d\b\u0004M\u0005u\u0017bAApO\u00059\u0001/Y2lC\u001e,\u0017\u0002BAr\u0003K\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005}w%M\u0005$\u0003S\fY/!<\u0002V:\u0019a%a;\n\u0007\u0005Uw%M\u0003#M\u001d\nyOA\u0003tG\u0006d\u0017-M\u0002'\u0003w\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u0013\taB]3hSN$XM\u001d$jYR,'\u000f\u0006\u0004\u0002|\n\u0005!Q\u0001\t\u0004M\u0005u\u0018bAA\u0000O\t!QK\\5u\u0011\u0019\u0011\u0019a\u0006a\u00019\u0006\u00191.Z=\t\u000f\t\u001dq\u00031\u0001\u0003\n\u0005AAn\\1eK\u0012,\u0016\nE\u00026\u0005\u0017I1A!\u0004\u001b\u0005-au.\u00193fI\u0006\u0003\b/V%\u0002\u0015%tg/\u00197jI\u0006$X\r\u0006\u0003\u0002|\nM\u0001B\u0002B\u00021\u0001\u0007A\f")
public class ApplicationCache
implements Logging {
    private final ApplicationCacheOperations operations;
    private final int retainedApplications;
    private final Clock clock;
    private final CacheLoader<CacheKey, CacheEntry> appLoader;
    private final RemovalListener<CacheKey, CacheEntry> removalListener;
    private final LoadingCache<CacheKey, CacheEntry> appCache;
    private final CacheMetrics metrics;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ApplicationCacheOperations operations() {
        return this.operations;
    }

    public int retainedApplications() {
        return this.retainedApplications;
    }

    public Clock clock() {
        return this.clock;
    }

    private CacheLoader<CacheKey, CacheEntry> appLoader() {
        return this.appLoader;
    }

    private RemovalListener<CacheKey, CacheEntry> removalListener() {
        return this.removalListener;
    }

    private LoadingCache<CacheKey, CacheEntry> appCache() {
        return this.appCache;
    }

    public CacheMetrics metrics() {
        return this.metrics;
    }

    public CacheEntry get(String appId, Option<String> attemptId) {
        CacheEntry cacheEntry;
        try {
            cacheEntry = (CacheEntry)this.appCache().get((Object)new CacheKey(appId, attemptId));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof ExecutionException ? true : throwable2 instanceof UncheckedExecutionException;
            if (bl) {
                throw (Throwable)Option$.MODULE$.apply((Object)throwable2.getCause()).getOrElse((Function0 & Serializable & scala.Serializable)() -> throwable2);
            }
            throw throwable;
        }
        return cacheEntry;
    }

    public Option<String> get$default$2() {
        return None$.MODULE$;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T withSparkUI(String appId, Option<String> attemptId, Function1<SparkUI, T> fn) {
        CacheEntry entry = this.get(appId, attemptId);
        entry.loadedUI().lock().readLock().lock();
        try {
            while (!entry.loadedUI().valid()) {
                entry.loadedUI().lock().readLock().unlock();
                entry = null;
                try {
                    this.invalidate(new CacheKey(appId, attemptId));
                    entry = this.get(appId, attemptId);
                    this.metrics().loadCount().inc();
                }
                finally {
                    if (entry == null) continue;
                    entry.loadedUI().lock().readLock().lock();
                }
            }
            return (T)fn.apply((Object)entry.loadedUI().ui());
        }
        finally {
            if (entry != null) {
                entry.loadedUI().lock().readLock().unlock();
            }
        }
    }

    public long size() {
        return this.appCache().size();
    }

    private <T> T time(Timer t, Function0<T> f) {
        Object object;
        try (Timer.Context timeCtx = t.time();){
            object = f.apply();
        }
        return (T)object;
    }

    public CacheEntry org$apache$spark$deploy$history$ApplicationCache$$loadApplicationEntry(String appId, Option<String> attemptId) throws NoSuchElementException {
        CacheEntry cacheEntry;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(27).append("Loading application Entry ").append(appId).append("/").append(attemptId).toString());
        this.metrics().loadCount().inc();
        LoadedAppUI loadedUI = (LoadedAppUI)this.time(this.metrics().loadTimer(), (Function0 & Serializable & scala.Serializable)() -> {
            this.metrics().lookupCount().inc();
            Option<LoadedAppUI> option = this.operations().getAppUI(appId, attemptId);
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    this.metrics().lookupFailureCount().inc();
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(36).append("Failed to load application attempt ").append(appId).append("/").append(attemptId).toString());
                    throw new NoSuchElementException(new java.lang.StringBuilder(37).append("no application with application Id '").append(appId).append("'").append(attemptId.map((Function1 & Serializable & scala.Serializable)id -> new java.lang.StringBuilder(13).append(" attemptId '").append((String)id).append("'").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> " and no attempt Id")).toString());
                }
                throw new MatchError(option);
            }
            Some some = (Some)option;
            LoadedAppUI loadedUI = (LoadedAppUI)some.value();
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(20).append("Loaded application ").append(appId).append("/").append(attemptId).toString());
            LoadedAppUI loadedAppUI = loadedUI;
            return loadedAppUI;
        });
        try {
            boolean completed = loadedUI.ui().getApplicationInfoList().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ApplicationCache.$anonfun$loadApplicationEntry$7(x$1)));
            if (!completed) {
                this.registerFilter(new CacheKey(appId, attemptId), loadedUI);
            }
            this.operations().attachSparkUI(appId, attemptId, loadedUI.ui(), completed);
            cacheEntry = new CacheEntry(loadedUI, completed);
        }
        catch (Exception e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(41).append("Failed to initialize application UI for ").append(appId).append("/").append(attemptId).toString(), e);
            this.operations().detachSparkUI(appId, attemptId, loadedUI.ui());
            throw e;
        }
        return cacheEntry;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(new java.lang.StringBuilder(41).append("ApplicationCache(").append(" retainedApplications= ").append(this.retainedApplications()).append(")").toString());
        sb.append(new java.lang.StringBuilder(8).append("; time= ").append(this.clock().getTimeMillis()).toString());
        sb.append(new java.lang.StringBuilder(16).append("; entry count= ").append(this.appCache().size()).append("\n").toString());
        sb.append("----\n");
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.appCache().asMap()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            CacheKey key = (CacheKey)tuple2._1();
            CacheEntry entry = (CacheEntry)tuple2._2();
            StringBuilder stringBuilder = sb.append(new java.lang.StringBuilder(7).append("  ").append(key).append(" -> ").append(entry).append("\n").toString());
            return stringBuilder;
        });
        sb.append("----\n");
        sb.append((Object)this.metrics());
        sb.append("----\n");
        return sb.toString();
    }

    private void registerFilter(CacheKey key, LoadedAppUI loadedUI) {
        Predef$.MODULE$.require(loadedUI != null);
        EnumSet<DispatcherType> enumDispatcher = EnumSet.of(DispatcherType.ASYNC, DispatcherType.REQUEST);
        ApplicationCacheCheckFilter filter = new ApplicationCacheCheckFilter(key, loadedUI, this);
        FilterHolder holder = new FilterHolder(filter);
        Predef$.MODULE$.require(loadedUI.ui().getHandlers() != null, (Function0 & Serializable & scala.Serializable)() -> "null handlers");
        loadedUI.ui().getHandlers().foreach((Function1 & Serializable & scala.Serializable)handler -> {
            handler.addFilter(holder, "/*", (EnumSet<DispatcherType>)enumDispatcher);
            return BoxedUnit.UNIT;
        });
    }

    public void invalidate(CacheKey key) {
        this.appCache().invalidate((Object)key);
    }

    public static final /* synthetic */ boolean $anonfun$loadApplicationEntry$7(ApplicationInfo x$1) {
        return ((ApplicationAttemptInfo)x$1.attempts().last()).completed();
    }

    public ApplicationCache(ApplicationCacheOperations operations, int retainedApplications, Clock clock) {
        this.operations = operations;
        this.retainedApplications = retainedApplications;
        this.clock = clock;
        Logging.$init$(this);
        this.appLoader = new CacheLoader<CacheKey, CacheEntry>(this){
            private final /* synthetic */ ApplicationCache $outer;

            public CacheEntry load(CacheKey key) {
                return this.$outer.org$apache$spark$deploy$history$ApplicationCache$$loadApplicationEntry(key.appId(), key.attemptId());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.removalListener = new RemovalListener<CacheKey, CacheEntry>(this){
            private final /* synthetic */ ApplicationCache $outer;

            public void onRemoval(RemovalNotification<CacheKey, CacheEntry> rm) {
                this.$outer.metrics().evictionCount().inc();
                CacheKey key = (CacheKey)rm.getKey();
                this.$outer.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(15).append("Evicting entry ").append(key).toString());
                this.$outer.operations().detachSparkUI(key.appId(), key.attemptId(), ((CacheEntry)rm.getValue()).loadedUI().ui());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onRemoval$1(org.apache.spark.deploy.history.CacheKey )}, serializedLambda);
            }
        };
        this.appCache = CacheBuilder.newBuilder().maximumSize((long)retainedApplications).removalListener(this.removalListener()).build(this.appLoader());
        this.metrics = new CacheMetrics("history.cache");
    }
}

