/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.CreateMap$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GenArrayData$;
import org.apache.spark.sql.catalyst.expressions.NoThrow;
import org.apache.spark.sql.catalyst.expressions.codegen.Block;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapBuilder;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ExpressionDescription(usage="_FUNC_(key0, value0, key1, value1, ...) - Creates a map with the given key/value pairs.", examples="\n    Examples:\n      > SELECT _FUNC_(1.0, '2', 3.0, '4');\n       {1.0:\"2\",3.0:\"4\"}\n  ", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0001\tea\u0001\u0002\u0013&\u0001JB\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t#\u0002\u0011\t\u0012)A\u0005\u000b\"A!\u000b\u0001BK\u0002\u0013\u00051\u000b\u0003\u0005X\u0001\tE\t\u0015!\u0003U\u0011\u0015A\u0006\u0001\"\u0001Z\u0011\u0015A\u0006\u0001\"\u0001^\u0011!y\u0006\u0001#b\u0001\n\u0003\u0001\u0007\u0002C5\u0001\u0011\u000b\u0007I\u0011\u00011\t\u000f)\u0004!\u0019!C\u0005W\"1!\u000f\u0001Q\u0001\n1DQa\u001d\u0001\u0005BMCQ\u0001\u001e\u0001\u0005BUDQ\u0001 \u0001\u0005BuD!\"!\u0003\u0001\u0011\u000b\u0007I\u0011IA\u0006\u0011\u0019\t\u0019\u0002\u0001C!'\"Q\u0011Q\u0003\u0001\t\u0006\u0004%I!a\u0006\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(!9\u0011Q\u0007\u0001\u0005B\u0005]\u0002bBA*\u0001\u0011\u0005\u0013Q\u000b\u0005\n\u0003O\u0002\u0011\u0011!C\u0001\u0003SB\u0011\"a\u001c\u0001#\u0003%\t!!\u001d\t\u0013\u0005\u001d\u0005!%A\u0005\u0002\u0005%\u0005\"CAG\u0001\u0005\u0005I\u0011IAH\u0011%\ty\nAA\u0001\n\u0003\t\t\u000bC\u0005\u0002*\u0002\t\t\u0011\"\u0001\u0002,\"I\u0011\u0011\u0017\u0001\u0002\u0002\u0013\u0005\u00131\u0017\u0005\n\u0003w\u0003\u0011\u0011!C\u0001\u0003{C\u0011\"!1\u0001\u0003\u0003%\t%a1\b\u000f\u0005\u0005X\u0005#\u0001\u0002d\u001a1A%\nE\u0001\u0003KDa\u0001\u0017\u0010\u0005\u0002\u00055\bbBAx=\u0011\u0005\u0011\u0011\u001f\u0005\n\u0003_t\u0012\u0011!CA\u0003kD\u0011\"a?\u001f\u0003\u0003%\t)!@\t\u0013\t=a$!A\u0005\n\tE!!C\"sK\u0006$X-T1q\u0015\t1s%A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0015*\u0003!\u0019\u0017\r^1msN$(B\u0001\u0016,\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003Y5\nQa\u001d9be.T!AL\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0001\u0014aA8sO\u000e\u00011#\u0002\u00014oi\u0002\u0005C\u0001\u001b6\u001b\u0005)\u0013B\u0001\u001c&\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003iaJ!!O\u0013\u0003\u000f9{G\u000b\u001b:poB\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t9\u0001K]8ek\u000e$\bCA\u001eB\u0013\t\u0011EH\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0005dQ&dGM]3o+\u0005)\u0005c\u0001$Og9\u0011q\t\u0014\b\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015F\na\u0001\u0010:p_Rt\u0014\"A\u001f\n\u00055c\u0014a\u00029bG.\fw-Z\u0005\u0003\u001fB\u00131aU3r\u0015\tiE(A\u0005dQ&dGM]3oA\u00051Ro]3TiJLgn\u001a+za\u0016<\u0006.\u001a8F[B$\u00180F\u0001U!\tYT+\u0003\u0002Wy\t9!i\\8mK\u0006t\u0017aF;tKN#(/\u001b8h)f\u0004Xm\u00165f]\u0016k\u0007\u000f^=!\u0003\u0019a\u0014N\\5u}Q\u0019!l\u0017/\u0011\u0005Q\u0002\u0001\"B\"\u0006\u0001\u0004)\u0005\"\u0002*\u0006\u0001\u0004!FC\u0001._\u0011\u0015\u0019e\u00011\u0001F\u0003\u0011YW-_:\u0016\u0003\u0005\u00042AY44\u001b\u0005\u0019'B\u00013f\u0003%IW.\\;uC\ndWM\u0003\u0002gy\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005!\u001c'AC%oI\u0016DX\rZ*fc\u00061a/\u00197vKN\f!\u0003Z3gCVdG/\u00127f[\u0016tG\u000fV=qKV\tA\u000e\u0005\u0002na6\taN\u0003\u0002pS\u0005)A/\u001f9fg&\u0011\u0011O\u001c\u0002\t\t\u0006$\u0018\rV=qK\u0006\u0019B-\u001a4bk2$X\t\\3nK:$H+\u001f9fA\u0005Aam\u001c7eC\ndW-\u0001\u0006tiJLgnZ!sON,\u0012A\u001e\t\u0004\r^L\u0018B\u0001=Q\u0005!IE/\u001a:bi>\u0014\bCA\u001e{\u0013\tYHHA\u0002B]f\f1c\u00195fG.Le\u000e];u\t\u0006$\u0018\rV=qKN$\u0012A \t\u0004\u007f\u0006\u0015QBAA\u0001\u0015\r\t\u0019aJ\u0001\tC:\fG._:jg&!\u0011qAA\u0001\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u00055\u0001cA7\u0002\u0010%\u0019\u0011\u0011\u00038\u0003\u000f5\u000b\u0007\u000fV=qK\u0006Aa.\u001e7mC\ndW-\u0001\u0006nCB\u0014U/\u001b7eKJ,\"!!\u0007\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\b(\u0003\u0011)H/\u001b7\n\t\u0005\r\u0012Q\u0004\u0002\u0015\u0003J\u0014\u0018-\u001f\"bg\u0016$W*\u00199Ck&dG-\u001a:\u0002\t\u00154\u0018\r\u001c\u000b\u0004s\u0006%\u0002\"CA\u0016#A\u0005\t\u0019AA\u0017\u0003\u0015Ig\u000e];u!\u0011\ty#!\r\u000e\u0003\u001dJ1!a\r(\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0013\u0011|w)\u001a8D_\u0012,GCBA\u001d\u0003\u000b\ny\u0005\u0005\u0003\u0002<\u0005\u0005SBAA\u001f\u0015\r\ty$J\u0001\bG>$WmZ3o\u0013\u0011\t\u0019%!\u0010\u0003\u0011\u0015C\bO]\"pI\u0016Dq!a\u0012\u0013\u0001\u0004\tI%A\u0002dib\u0004B!a\u000f\u0002L%!\u0011QJA\u001f\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDq!!\u0015\u0013\u0001\u0004\tI$\u0001\u0002fm\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u0005]\u0003\u0003BA-\u0003CrA!a\u0017\u0002^A\u0011\u0001\nP\u0005\u0004\u0003?b\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002d\u0005\u0015$AB*ue&twMC\u0002\u0002`q\nAaY8qsR)!,a\u001b\u0002n!91\t\u0006I\u0001\u0002\u0004)\u0005b\u0002*\u0015!\u0003\u0005\r\u0001V\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019HK\u0002F\u0003kZ#!a\u001e\u0011\t\u0005e\u00141Q\u0007\u0003\u0003wRA!! \u0002\u0000\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0003c\u0014AC1o]>$\u0018\r^5p]&!\u0011QQA>\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tYIK\u0002U\u0003k\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAI!\u0011\t\u0019*!(\u000e\u0005\u0005U%\u0002BAL\u00033\u000bA\u0001\\1oO*\u0011\u00111T\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002d\u0005U\u0015\u0001\u00049s_\u0012,8\r^!sSRLXCAAR!\rY\u0014QU\u0005\u0004\u0003Oc$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA=\u0002.\"I\u0011qV\r\u0002\u0002\u0003\u0007\u00111U\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005U\u0006#BA\\\u0003sKX\"A3\n\u0005a,\u0017\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007Q\u000by\f\u0003\u0005\u00020n\t\t\u00111\u0001z\u0003\u0019)\u0017/^1mgR\u0019A+!2\t\u0011\u0005=F$!AA\u0002eDs\u0002AAe\u0003\u001f\f\t.!6\u0002X\u0006m\u0017Q\u001c\t\u0004i\u0005-\u0017bAAgK\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAj\u0003]{f)\u0016(D?\"ZW-\u001f\u0019-AY\fG.^31Y\u0001ZW-_\u0019-AY\fG.^32Y\u0001rcFL\u0015![\u0001\u001a%/Z1uKN\u0004\u0013\rI7ba\u0002:\u0018\u000e\u001e5!i\",\u0007eZ5wK:\u00043.Z=0m\u0006dW/\u001a\u0011qC&\u00148OL\u0001\tKb\fW\u000e\u001d7fg\u0006\u0012\u0011\u0011\\\u0001V\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\nd\u0006\r\u0017!OI:C\u0006I\u001a/a1\u0002s\u0005N\u0014*w)\u0001\u0003\u0005\t\u0011!A\u0001Z\u0018G\f\u0019;EI\u0012Cf\r\u00181u\t\"$% \u0006!A\u0005)1/\u001b8dK\u0006\u0012\u0011q\\\u0001\u0006e9\u0002d\u0006M\u0001\n\u0007J,\u0017\r^3NCB\u0004\"\u0001\u000e\u0010\u0014\ty\t9\u000f\u0011\t\u0004w\u0005%\u0018bAAvy\t1\u0011I\\=SK\u001a$\"!a9\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007i\u000b\u0019\u0010C\u0003DA\u0001\u0007Q\tF\u0003[\u0003o\fI\u0010C\u0003DC\u0001\u0007Q\tC\u0003SC\u0001\u0007A+A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\u0005}(1\u0002\t\u0006w\t\u0005!QA\u0005\u0004\u0005\u0007a$AB(qi&|g\u000eE\u0003<\u0005\u000f)E+C\u0002\u0003\nq\u0012a\u0001V;qY\u0016\u0014\u0004\u0002\u0003B\u0007E\u0005\u0005\t\u0019\u0001.\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GC\u0001B\n!\u0011\t\u0019J!\u0006\n\t\t]\u0011Q\u0013\u0002\u0007\u001f\nTWm\u0019;")
public class CreateMap
extends Expression
implements NoThrow,
scala.Serializable {
    private IndexedSeq<Expression> keys;
    private IndexedSeq<Expression> values;
    private MapType dataType;
    private ArrayBasedMapBuilder mapBuilder;
    private final Seq<Expression> children;
    private final boolean useStringTypeWhenEmpty;
    private final DataType defaultElementType;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Seq<Expression>, Object>> unapply(CreateMap createMap) {
        return CreateMap$.MODULE$.unapply(createMap);
    }

    @Override
    public Seq<Expression> children() {
        return this.children;
    }

    public boolean useStringTypeWhenEmpty() {
        return this.useStringTypeWhenEmpty;
    }

    private IndexedSeq<Expression> keys$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.keys = (IndexedSeq)((TraversableLike)this.children().indices().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$8 -> x$8 % 2 == 0)).map(this.children(), IndexedSeq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.keys;
    }

    public IndexedSeq<Expression> keys() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.keys$lzycompute() : this.keys;
    }

    private IndexedSeq<Expression> values$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.values = (IndexedSeq)((TraversableLike)this.children().indices().filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$9 -> x$9 % 2 != 0)).map(this.children(), IndexedSeq$.MODULE$.canBuildFrom());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.values;
    }

    public IndexedSeq<Expression> values() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.values$lzycompute() : this.values;
    }

    private DataType defaultElementType() {
        return this.defaultElementType;
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.foldable()));
    }

    @Override
    public Iterator<Object> stringArgs() {
        return super.stringArgs().take(1);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return this.children().size() % 2 != 0 ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(45).append(this.prettyName()).append(" expects a positive even number of arguments.").toString()) : (!TypeCoercion$.MODULE$.haveSameType((Seq<DataType>)((Seq)this.keys().map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(73).append("The given keys of function map should all be the same type, but they are ").append(((TraversableOnce)this.keys().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.dataType().catalogString(), IndexedSeq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).toString()) : (!TypeCoercion$.MODULE$.haveSameType((Seq<DataType>)((Seq)this.values().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder(75).append("The given values of function map should all be the same type, but they are ").append(((TraversableOnce)this.values().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.dataType().catalogString(), IndexedSeq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).toString()) : TypeUtils$.MODULE$.checkForMapKeyType(this.dataType().keyType())));
    }

    private MapType dataType$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.dataType = new MapType((DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags((Seq<DataType>)((Seq)this.keys().map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.defaultElementType()), (DataType)TypeCoercion$.MODULE$.findCommonTypeDifferentOnlyInNullFlags((Seq<DataType>)((Seq)this.values().map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.dataType(), IndexedSeq$.MODULE$.canBuildFrom()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.defaultElementType()), this.values().exists((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.nullable())));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.dataType;
    }

    @Override
    public MapType dataType() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.dataType$lzycompute() : this.dataType;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    private ArrayBasedMapBuilder mapBuilder$lzycompute() {
        CreateMap createMap = this;
        synchronized (createMap) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.mapBuilder = new ArrayBasedMapBuilder(this.dataType().keyType(), this.dataType().valueType());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.mapBuilder;
    }

    private ArrayBasedMapBuilder mapBuilder() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.mapBuilder$lzycompute() : this.mapBuilder;
    }

    @Override
    public Object eval(InternalRow input) {
        for (int i = 0; i < this.keys().length(); ++i) {
            this.mapBuilder().put(((Expression)this.keys().apply(i)).eval(input), ((Expression)this.values().apply(i)).eval(input));
        }
        return this.mapBuilder().build();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        MapType mapType = this.dataType();
        if (mapType == null) {
            throw new MatchError((Object)mapType);
        }
        DataType keyDt = mapType.keyType();
        DataType valueDt = mapType.valueType();
        Tuple2 tuple2 = new Tuple2((Object)keyDt, (Object)valueDt);
        Tuple2 tuple22 = tuple2;
        DataType keyDt2 = (DataType)tuple22._1();
        DataType valueDt2 = (DataType)tuple22._2();
        Tuple3<String, String, String> tuple3 = GenArrayData$.MODULE$.genCodeToCreateArrayData(ctx, keyDt2, (Seq<Expression>)this.keys(), "createMap");
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        String allocationKeyData = (String)tuple3._1();
        String assignKeys = (String)tuple3._2();
        String keyArrayData = (String)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)allocationKeyData, (Object)assignKeys, (Object)keyArrayData);
        Tuple3 tuple33 = tuple32;
        String allocationKeyData2 = (String)tuple33._1();
        String assignKeys2 = (String)tuple33._2();
        String keyArrayData2 = (String)tuple33._3();
        Tuple3<String, String, String> tuple34 = GenArrayData$.MODULE$.genCodeToCreateArrayData(ctx, valueDt2, (Seq<Expression>)this.values(), "createMap");
        if (tuple34 == null) {
            throw new MatchError(tuple34);
        }
        String allocationValueData = (String)tuple34._1();
        String assignValues = (String)tuple34._2();
        String valueArrayData = (String)tuple34._3();
        Tuple3 tuple35 = new Tuple3((Object)allocationValueData, (Object)assignValues, (Object)valueArrayData);
        Tuple3 tuple36 = tuple35;
        String allocationValueData2 = (String)tuple36._1();
        String assignValues2 = (String)tuple36._2();
        String valueArrayData2 = (String)tuple36._3();
        String builderTerm = ctx.addReferenceObj("mapBuilder", this.mapBuilder(), ctx.addReferenceObj$default$3());
        Block code = Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       ", "\n       ", "\n       ", "\n       ", "\n       final MapData ", " = ", ".from(", ", ", ");\n      "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{allocationKeyData2, assignKeys2, allocationValueData2, assignValues2, ev.value(), builderTerm, keyArrayData2, valueArrayData2}));
        return ev.copy(code, FalseLiteral$.MODULE$, ev.copy$default$3());
    }

    @Override
    public String prettyName() {
        return "map";
    }

    public CreateMap copy(Seq<Expression> children2, boolean useStringTypeWhenEmpty) {
        return new CreateMap(children2, useStringTypeWhenEmpty);
    }

    public Seq<Expression> copy$default$1() {
        return this.children();
    }

    public boolean copy$default$2() {
        return this.useStringTypeWhenEmpty();
    }

    @Override
    public String productPrefix() {
        return "CreateMap";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.children();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToBoolean((boolean)this.useStringTypeWhenEmpty());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CreateMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CreateMap)) return false;
        boolean bl = true;
        if (!bl) return false;
        CreateMap createMap = (CreateMap)x$1;
        Seq<Expression> seq = this.children();
        Seq<Expression> seq2 = createMap.children();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (this.useStringTypeWhenEmpty() != createMap.useStringTypeWhenEmpty()) return false;
        if (!createMap.canEqual(this)) return false;
        return true;
    }

    public CreateMap(Seq<Expression> children2, boolean useStringTypeWhenEmpty) {
        this.children = children2;
        this.useStringTypeWhenEmpty = useStringTypeWhenEmpty;
        this.defaultElementType = useStringTypeWhenEmpty ? StringType$.MODULE$ : NullType$.MODULE$;
    }

    public CreateMap(Seq<Expression> children2) {
        this(children2, BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.LEGACY_CREATE_EMPTY_COLLECTION_USING_STRING_TYPE())));
    }
}

