/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.io.InterruptedIOException;
import java.io.Serializable;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.yarn.Client;
import org.apache.spark.deploy.yarn.ClientArguments;
import org.apache.spark.deploy.yarn.YarnAppReport;
import org.apache.spark.deploy.yarn.config.package$;
import org.apache.spark.launcher.SparkAppHandle;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.SchedulerBackendUtils$;
import org.apache.spark.scheduler.cluster.YarnSchedulerBackend;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001u4QAF\f\u00017\u0005B\u0001B\u0007\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!)a\u0007\u0001C\u0001o!91\b\u0001a\u0001\n\u0013a\u0004bB#\u0001\u0001\u0004%IA\u0012\u0005\u0007\u001f\u0002\u0001\u000b\u0015B\u001f\t\u000fA\u0003\u0001\u0019!C\u0005#\"91\u000e\u0001a\u0001\n\u0013a\u0007B\u00028\u0001A\u0003&!\u000bC\u0003p\u0001\u0011\u0005\u0013\u000eC\u0003q\u0001\u0011%\u0011N\u0002\u0003U\u0001\u0011)\u0006\"\u0002\u001c\r\t\u0003q\u0006bB0\r\u0001\u0004%I\u0001\u0019\u0005\bI2\u0001\r\u0011\"\u0003f\u0011\u00199G\u0002)Q\u0005C\")\u0001\u000e\u0004C!S\")!\u000e\u0004C\u0001S\")\u0011\u000f\u0001C\u0005=\")!\u000f\u0001C!S\")1\u000f\u0001C)i\nQ\u0012,\u0019:o\u00072LWM\u001c;TG\",G-\u001e7fe\n\u000b7m[3oI*\u0011\u0001$G\u0001\bG2,8\u000f^3s\u0015\tQ2$A\u0005tG\",G-\u001e7fe*\u0011A$H\u0001\u0006gB\f'o\u001b\u0006\u0003=}\ta!\u00199bG\",'\"\u0001\u0011\u0002\u0007=\u0014xmE\u0002\u0001E\u0019\u0002\"a\t\u0013\u000e\u0003]I!!J\f\u0003)e\u000b'O\\*dQ\u0016$W\u000f\\3s\u0005\u0006\u001c7.\u001a8e!\t9#&D\u0001)\u0015\tI3$\u0001\u0005j]R,'O\\1m\u0013\tY\u0003FA\u0004M_\u001e<\u0017N\\4\u0004\u0001A\u0011afL\u0007\u00023%\u0011\u0001'\u0007\u0002\u0012)\u0006\u001c8nU2iK\u0012,H.\u001a:J[Bd\u0017AA:d!\t\u0019D'D\u0001\u001c\u0013\t)4D\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0004qeR\u0004CA\u0012\u0001\u0011\u0015Q2\u00011\u0001.\u0011\u0015\t4\u00011\u00013\u0003\u0019\u0019G.[3oiV\tQ\b\u0005\u0002?\u00076\tqH\u0003\u0002A\u0003\u0006!\u00110\u0019:o\u0015\t\u00115$\u0001\u0004eKBdw._\u0005\u0003\t~\u0012aa\u00117jK:$\u0018AC2mS\u0016tGo\u0018\u0013fcR\u0011q)\u0014\t\u0003\u0011.k\u0011!\u0013\u0006\u0002\u0015\u0006)1oY1mC&\u0011A*\u0013\u0002\u0005+:LG\u000fC\u0004O\u000b\u0005\u0005\t\u0019A\u001f\u0002\u0007a$\u0013'A\u0004dY&,g\u000e\u001e\u0011\u0002\u001b5|g.\u001b;peRC'/Z1e+\u0005\u0011\u0006CA*\r\u001b\u0005\u0001!!D'p]&$xN\u001d+ie\u0016\fGm\u0005\u0002\r-B\u0011q\u000bX\u0007\u00021*\u0011\u0011LW\u0001\u0005Y\u0006twMC\u0001\\\u0003\u0011Q\u0017M^1\n\u0005uC&A\u0002+ie\u0016\fG\rF\u0001S\u00039\tG\u000e\\8x\u0013:$XM\u001d:vaR,\u0012!\u0019\t\u0003\u0011\nL!aY%\u0003\u000f\t{w\u000e\\3b]\u0006\u0011\u0012\r\u001c7po&sG/\u001a:skB$x\fJ3r)\t9e\rC\u0004O\u001f\u0005\u0005\t\u0019A1\u0002\u001f\u0005dGn\\<J]R,'O];qi\u0002\n1A];o)\u00059\u0015aC:u_BluN\\5u_J\f\u0011#\\8oSR|'\u000f\u00165sK\u0006$w\fJ3r)\t9U\u000eC\u0004O\u0011\u0005\u0005\t\u0019\u0001*\u0002\u001d5|g.\u001b;peRC'/Z1eA\u0005)1\u000f^1si\u0006\u0011r/Y5u\r>\u0014\u0018\t\u001d9mS\u000e\fG/[8o\u0003]\t7/\u001f8d\u001b>t\u0017\u000e^8s\u0003B\u0004H.[2bi&|g.\u0001\u0003ti>\u0004\u0018AF;qI\u0006$X\rR3mK\u001e\fG/[8o)>\\WM\\:\u0015\u0005\u001d+\b\"\u0002<\u0016\u0001\u00049\u0018A\u0002;pW\u0016t7\u000fE\u0002IqjL!!_%\u0003\u000b\u0005\u0013(/Y=\u0011\u0005![\u0018B\u0001?J\u0005\u0011\u0011\u0015\u0010^3")
public class YarnClientSchedulerBackend
extends YarnSchedulerBackend {
    public final SparkContext org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$sc;
    private Client org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client;
    private MonitorThread monitorThread;

    public Client org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client() {
        return this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client;
    }

    private void org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client_$eq(Client x$1) {
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client = x$1;
    }

    private MonitorThread monitorThread() {
        return this.monitorThread;
    }

    private void monitorThread_$eq(MonitorThread x$1) {
        this.monitorThread = x$1;
    }

    public void start() {
        super.start();
        String driverHost = (String)this.conf().get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_HOST_ADDRESS());
        int driverPort = BoxesRunTime.unboxToInt((Object)this.conf().get(org.apache.spark.internal.config.package$.MODULE$.DRIVER_PORT()));
        String hostport = new StringBuilder(1).append(driverHost).append(":").append(driverPort).toString();
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$sc.ui().foreach((Function1 & Serializable & scala.Serializable)ui -> this.conf().set(package$.MODULE$.DRIVER_APP_UI_ADDRESS(), (Object)ui.webUrl()));
        ArrayBuffer argsArrayBuf = new ArrayBuffer();
        argsArrayBuf.$plus$eq((Object)"--arg", (Object)hostport, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("ClientArguments called with: ").append(argsArrayBuf.mkString(" ")).toString());
        ClientArguments args = new ClientArguments((String[])argsArrayBuf.toArray(ClassTag$.MODULE$.apply(String.class)));
        this.totalExpectedExecutors_$eq(SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber(this.conf(), SchedulerBackendUtils$.MODULE$.getInitialTargetExecutorNumber$default$2()));
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client_$eq(new Client(args, this.conf(), this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$sc.env().rpcEnv()));
        this.bindToYarn(this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client().submitApplication(), (Option<ApplicationAttemptId>)None$.MODULE$);
        this.waitForApplication();
        this.monitorThread_$eq(this.asyncMonitorApplication());
        this.monitorThread().start();
        this.startBindings();
    }

    private void waitForApplication() {
        block10: {
            YarnApplicationState state;
            block9: {
                String string;
                Option diags;
                block8: {
                    long monitorInterval = BoxesRunTime.unboxToLong((Object)this.conf().get(package$.MODULE$.CLIENT_LAUNCH_MONITOR_INTERVAL()));
                    Predef$.MODULE$.assert(this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client() != null && this.appId().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Application has not been submitted yet!");
                    Client qual$1 = this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client();
                    ApplicationId x$1 = (ApplicationId)this.appId().get();
                    boolean x$2 = true;
                    long x$3 = monitorInterval;
                    boolean x$4 = qual$1.monitorApplication$default$3();
                    YarnAppReport yarnAppReport = qual$1.monitorApplication(x$1, x$2, x$4, x$3);
                    if (yarnAppReport == null) {
                        throw new MatchError((Object)yarnAppReport);
                    }
                    YarnApplicationState state2 = yarnAppReport.appState();
                    Option<String> diags2 = yarnAppReport.diagnostics();
                    Tuple2 tuple2 = new Tuple2((Object)state2, diags2);
                    Tuple2 tuple22 = tuple2;
                    state = (YarnApplicationState)tuple22._1();
                    diags = (Option)tuple22._2();
                    YarnApplicationState yarnApplicationState = state;
                    YarnApplicationState yarnApplicationState2 = YarnApplicationState.FINISHED;
                    if (!(yarnApplicationState == null ? yarnApplicationState2 != null : !yarnApplicationState.equals(yarnApplicationState2))) break block8;
                    YarnApplicationState yarnApplicationState3 = state;
                    YarnApplicationState yarnApplicationState4 = YarnApplicationState.FAILED;
                    if (!(yarnApplicationState3 == null ? yarnApplicationState4 != null : !yarnApplicationState3.equals(yarnApplicationState4))) break block8;
                    YarnApplicationState yarnApplicationState5 = state;
                    YarnApplicationState yarnApplicationState6 = YarnApplicationState.KILLED;
                    if (yarnApplicationState5 != null ? !yarnApplicationState5.equals(yarnApplicationState6) : yarnApplicationState6 != null) break block9;
                }
                String genericMessage = "The YARN application has already ended! It might have been killed or the Application Master may have failed to start. Check the YARN application logs for more details.";
                Option option = diags;
                if (option instanceof Some) {
                    Some some = (Some)option;
                    String msg = (String)some.value();
                    this.logError((Function0 & Serializable & scala.Serializable)() -> genericMessage);
                    string = msg;
                } else if (None$.MODULE$.equals(option)) {
                    string = genericMessage;
                } else {
                    throw new MatchError((Object)option);
                }
                String exceptionMsg = string;
                throw new SparkException(exceptionMsg);
            }
            YarnApplicationState yarnApplicationState = state;
            YarnApplicationState yarnApplicationState7 = YarnApplicationState.RUNNING;
            if (yarnApplicationState != null ? !yarnApplicationState.equals(yarnApplicationState7) : yarnApplicationState7 != null) break block10;
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Application ").append(this.appId().get()).append(" has started running.").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private MonitorThread asyncMonitorApplication() {
        void var1_1;
        Predef$.MODULE$.assert(this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client() != null && this.appId().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Application has not been submitted yet!");
        MonitorThread t = new MonitorThread();
        t.setName("YARN application state monitor");
        t.setDaemon(true);
        return var1_1;
    }

    @Override
    public void stop() {
        Predef$.MODULE$.assert(this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client() != null, (Function0 & Serializable & scala.Serializable)() -> "Attempted to stop this scheduler before starting it!");
        if (this.monitorThread() != null) {
            this.monitorThread().stopMonitor();
        }
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client().reportLauncherState(SparkAppHandle.State.FINISHED);
        super.stop();
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client().stop();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> "YARN client scheduler backend Stopped");
    }

    public void updateDelegationTokens(byte[] tokens) {
        super.updateDelegationTokens(tokens);
        this.amEndpoint().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.send((Object)new CoarseGrainedClusterMessages.UpdateDelegationTokens(tokens));
            return BoxedUnit.UNIT;
        });
    }

    public YarnClientSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc) {
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$sc = sc;
        super(scheduler, sc);
        this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client = null;
        this.monitorThread = null;
    }

    public class MonitorThread
    extends Thread {
        private boolean allowInterrupt;

        private boolean allowInterrupt() {
            return this.allowInterrupt;
        }

        private void allowInterrupt_$eq(boolean x$1) {
            this.allowInterrupt = x$1;
        }

        @Override
        public void run() {
            try {
                Client qual$1 = this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer().org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$client();
                ApplicationId x$1 = (ApplicationId)this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer().appId().get();
                boolean x$2 = false;
                boolean x$3 = qual$1.monitorApplication$default$2();
                long x$4 = qual$1.monitorApplication$default$4();
                YarnAppReport yarnAppReport = qual$1.monitorApplication(x$1, x$3, x$2, x$4);
                if (yarnAppReport == null) {
                    throw new MatchError((Object)yarnAppReport);
                }
                FinalApplicationStatus state = yarnAppReport.finalState();
                Option<String> diags = yarnAppReport.diagnostics();
                Tuple2 tuple2 = new Tuple2((Object)state, diags);
                Tuple2 tuple22 = tuple2;
                FinalApplicationStatus state2 = (FinalApplicationStatus)tuple22._1();
                Option diags2 = (Option)tuple22._2();
                this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer().logError((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(103).append("YARN application has exited unexpectedly with state ").append(state2).append("! ").append("Check the YARN application logs for more details.").toString());
                diags2.foreach((Function1 & Serializable & scala.Serializable)err -> {
                    MonitorThread.$anonfun$run$2(this, err);
                    return BoxedUnit.UNIT;
                });
                this.allowInterrupt_$eq(false);
                this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer().org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$$sc.stop();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof InterruptedException ? true : throwable2 instanceof InterruptedIOException;
                if (bl) {
                    this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer().logInfo((Function0 & Serializable & scala.Serializable)() -> "Interrupting monitor thread");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }

        public void stopMonitor() {
            block0: {
                if (!this.allowInterrupt()) break block0;
                this.interrupt();
            }
        }

        public /* synthetic */ YarnClientSchedulerBackend org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer() {
            return YarnClientSchedulerBackend.this;
        }

        public static final /* synthetic */ void $anonfun$run$2(MonitorThread $this, String err) {
            $this.org$apache$spark$scheduler$cluster$YarnClientSchedulerBackend$MonitorThread$$$outer().logError((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Diagnostics message: ").append(err).toString());
        }

        public MonitorThread() {
            if (YarnClientSchedulerBackend.this == null) {
                throw null;
            }
            this.allowInterrupt = true;
        }
    }
}

