/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NextDay$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(start_date, day_of_week) - Returns the first date which is later than `start_date` and named as indicated.", examples="\n    Examples:\n      > SELECT _FUNC_('2015-01-14', 'TU');\n       2015-01-20\n  ", group="datetime_funcs", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001\u0002\u0010 \u00012B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\"A!\n\u0001BK\u0002\u0013\u0005Q\t\u0003\u0005L\u0001\tE\t\u0015!\u0003G\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u0015\t\u0006\u0001\"\u0011F\u0011\u0015\u0011\u0006\u0001\"\u0011F\u0011\u0015\u0019\u0006\u0001\"\u0011U\u0011\u00151\u0007\u0001\"\u0011h\u0011\u0015Y\u0007\u0001\"\u0011m\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0015I\b\u0001\"\u0015{\u0011\u001d\t\t\u0002\u0001C!\u0003'A\u0011\"!\n\u0001\u0003\u0003%\t!a\n\t\u0013\u00055\u0002!%A\u0005\u0002\u0005=\u0002\"CA#\u0001E\u0005I\u0011AA\u0018\u0011%\t9\u0005AA\u0001\n\u0003\nI\u0005C\u0005\u0002Z\u0001\t\t\u0011\"\u0001\u0002\\!I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0011Q\r\u0005\n\u0003W\u0002\u0011\u0011!C!\u0003[B\u0011\"a\u001f\u0001\u0003\u0003%\t!! \t\u0013\u0005\u0005\u0005!!A\u0005B\u0005\ru!CAT?\u0005\u0005\t\u0012AAU\r!qr$!A\t\u0002\u0005-\u0006B\u0002'\u0019\t\u0003\tI\fC\u0005\u0002<b\t\t\u0011\"\u0012\u0002>\"I\u0011q\u0018\r\u0002\u0002\u0013\u0005\u0015\u0011\u0019\u0005\n\u0003\u000fD\u0012\u0011!CA\u0003\u0013D\u0011\"a7\u0019\u0003\u0003%I!!8\u0003\u000f9+\u0007\u0010\u001e#bs*\u0011\u0001%I\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002#G\u0005A1-\u0019;bYf\u001cHO\u0003\u0002%K\u0005\u00191/\u001d7\u000b\u0005\u0019:\u0013!B:qCJ\\'B\u0001\u0015*\u0003\u0019\t\u0007/Y2iK*\t!&A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001[E\"4(\u0011\t\u0003]=j\u0011aH\u0005\u0003a}\u0011\u0001CQ5oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00059\u0012\u0014BA\u001a \u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u001b9\u001d\tqc'\u0003\u00028?\u00059\u0001/Y2lC\u001e,\u0017BA\u001d;\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!aN\u0010\u0011\u0005qzT\"A\u001f\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0003\u000fA\u0013x\u000eZ;diB\u0011AHQ\u0005\u0003\u0007v\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f\u0011b\u001d;beR$\u0015\r^3\u0016\u0003\u0019\u0003\"AL$\n\u0005!{\"AC#yaJ,7o]5p]\u0006Q1\u000f^1si\u0012\u000bG/\u001a\u0011\u0002\u0013\u0011\f\u0017p\u00144XK\u0016\\\u0017A\u00033bs>3w+Z3lA\u00051A(\u001b8jiz\"2AT(Q!\tq\u0003\u0001C\u0003E\u000b\u0001\u0007a\tC\u0003K\u000b\u0001\u0007a)\u0001\u0003mK\u001a$\u0018!\u0002:jO\"$\u0018AC5oaV$H+\u001f9fgV\tQ\u000bE\u0002W;\u0002t!a\u0016/\u000f\u0005a[V\"A-\u000b\u0005i[\u0013A\u0002\u001fs_>$h(C\u0001?\u0013\t9T(\u0003\u0002_?\n\u00191+Z9\u000b\u0005]j\u0004CA1e\u001b\u0005\u0011'BA2$\u0003\u0015!\u0018\u0010]3t\u0013\t)'M\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001i!\t\t\u0017.\u0003\u0002kE\nAA)\u0019;b)f\u0004X-\u0001\u0005ok2d\u0017M\u00197f+\u0005i\u0007C\u0001\u001fo\u0013\tyWHA\u0004C_>dW-\u00198\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\u0007I,x\u000f\u0005\u0002=g&\u0011A/\u0010\u0002\u0004\u0003:L\b\"\u0002<\f\u0001\u0004\u0011\u0018!B:uCJ$\b\"\u0002=\f\u0001\u0004\u0011\u0018A\u00023bs>3w+A\u0005e_\u001e+gnQ8eKR)10a\u0001\u0002\u000eA\u0011Ap`\u0007\u0002{*\u0011apH\u0001\bG>$WmZ3o\u0013\r\t\t! \u0002\t\u000bb\u0004(oQ8eK\"9\u0011Q\u0001\u0007A\u0002\u0005\u001d\u0011aA2uqB\u0019A0!\u0003\n\u0007\u0005-QP\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\r\u0005=A\u00021\u0001|\u0003\t)g/\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u0006\u0011\t\u0005]\u0011q\u0004\b\u0005\u00033\tY\u0002\u0005\u0002Y{%\u0019\u0011QD\u001f\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t#a\t\u0003\rM#(/\u001b8h\u0015\r\ti\"P\u0001\u0005G>\u0004\u0018\u0010F\u0003O\u0003S\tY\u0003C\u0004E\u001dA\u0005\t\u0019\u0001$\t\u000f)s\u0001\u0013!a\u0001\r\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0019U\r1\u00151G\u0016\u0003\u0003k\u0001B!a\u000e\u0002B5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$A\u0005v]\u000eDWmY6fI*\u0019\u0011qH\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002D\u0005e\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002LA!\u0011QJA,\u001b\t\tyE\u0003\u0003\u0002R\u0005M\u0013\u0001\u00027b]\u001eT!!!\u0016\u0002\t)\fg/Y\u0005\u0005\u0003C\ty%\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002^A\u0019A(a\u0018\n\u0007\u0005\u0005THA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002s\u0003OB\u0011\"!\u001b\u0014\u0003\u0003\u0005\r!!\u0018\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\ty\u0007E\u0003\u0002r\u0005]$/\u0004\u0002\u0002t)\u0019\u0011QO\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002z\u0005M$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2!\\A@\u0011!\tI'FA\u0001\u0002\u0004\u0011\u0018AB3rk\u0006d7\u000fF\u0002n\u0003\u000bC\u0001\"!\u001b\u0017\u0003\u0003\u0005\rA\u001d\u0015\u0014\u0001\u0005%\u0015qRAI\u0003+\u000b9*a'\u0002\u001e\u0006\u0005\u00161\u0015\t\u0004]\u0005-\u0015bAAG?\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAJ\u0003E|f)\u0016(D?\"\u001aH/\u0019:u?\u0012\fG/\u001a\u0017!I\u0006Lxl\u001c4`o\u0016,7.\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011gSJ\u001cH\u000f\t3bi\u0016\u0004s\u000f[5dQ\u0002J7\u000f\t7bi\u0016\u0014\b\u0005\u001e5b]\u0002\u00027\u000f^1si~#\u0017\r^3aA\u0005tG\r\t8b[\u0016$\u0007%Y:!S:$\u0017nY1uK\u0012t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005e\u0015A\u0014\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OI\u0002\u0014'N\u00171c5\nDg\n\u0017!OQ+v%K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!eA\nT'\f\u00192[I\u0002$\u0002\t\u0011\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005}\u0015A\u00043bi\u0016$\u0018.\\3`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003K\u000bQ!\r\u00186]A\nqAT3yi\u0012\u000b\u0017\u0010\u0005\u0002/1M!\u0001$!,B!\u001d\ty+!.G\r:k!!!-\u000b\u0007\u0005MV(A\u0004sk:$\u0018.\\3\n\t\u0005]\u0016\u0011\u0017\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAAU\u0003!!xn\u0015;sS:<GCAA&\u0003\u0015\t\u0007\u000f\u001d7z)\u0015q\u00151YAc\u0011\u0015!5\u00041\u0001G\u0011\u0015Q5\u00041\u0001G\u0003\u001d)h.\u00199qYf$B!a3\u0002XB)A(!4\u0002R&\u0019\u0011qZ\u001f\u0003\r=\u0003H/[8o!\u0015a\u00141\u001b$G\u0013\r\t).\u0010\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005eG$!AA\u00029\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005}\u0007\u0003BA'\u0003CLA!a9\u0002P\t1qJ\u00196fGR\u0004")
public class NextDay
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression startDate;
    private final Expression dayOfWeek;

    public static Option<Tuple2<Expression, Expression>> unapply(NextDay nextDay) {
        return NextDay$.MODULE$.unapply(nextDay);
    }

    public static Function1<Tuple2<Expression, Expression>, NextDay> tupled() {
        return NextDay$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, NextDay>> curried() {
        return NextDay$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression startDate() {
        return this.startDate;
    }

    public Expression dayOfWeek() {
        return this.dayOfWeek;
    }

    @Override
    public Expression left() {
        return this.startDate();
    }

    @Override
    public Expression right() {
        return this.dayOfWeek();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AtomicType[]{DateType$.MODULE$, StringType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return DateType$.MODULE$;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object nullSafeEval(Object start, Object dayOfW) {
        Integer n;
        int dow = DateTimeUtils$.MODULE$.getDayOfWeekFromString((UTF8String)dayOfW);
        if (dow == -1) {
            n = null;
        } else {
            int sd = BoxesRunTime.unboxToInt((Object)start);
            n = BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.getNextDateForDayOfWeek(sd, dow));
        }
        return n;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(sd, dowS) -> {
            String string;
            String dateTimeUtilClass = new StringOps(Predef$.MODULE$.augmentString(DateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
            String dayOfWeekTerm = ctx.freshName("dayOfWeek");
            if (this.dayOfWeek().foldable()) {
                UTF8String input = (UTF8String)this.dayOfWeek().eval(this.dayOfWeek().eval$default$1());
                if (input == null || DateTimeUtils$.MODULE$.getDayOfWeekFromString(input) == -1) {
                    string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(35).append("\n             |").append(ev.isNull()).append(" = true;\n           ").toString())).stripMargin();
                } else {
                    int dayOfWeekValue = DateTimeUtils$.MODULE$.getDayOfWeekFromString(input);
                    string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(59).append("\n             |").append(ev.value()).append(" = ").append(dateTimeUtilClass).append(".getNextDateForDayOfWeek(").append((String)sd).append(", ").append(dayOfWeekValue).append(");\n           ").toString())).stripMargin();
                }
            } else {
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(187).append("\n           |int ").append(dayOfWeekTerm).append(" = ").append(dateTimeUtilClass).append(".getDayOfWeekFromString(").append((String)dowS).append(");\n           |if (").append(dayOfWeekTerm).append(" == -1) {\n           |  ").append(ev.isNull()).append(" = true;\n           |} else {\n           |  ").append(ev.value()).append(" = ").append(dateTimeUtilClass).append(".getNextDateForDayOfWeek(").append((String)sd).append(", ").append(dayOfWeekTerm).append(");\n           |}\n         ").toString())).stripMargin();
            }
            return string;
        });
    }

    @Override
    public String prettyName() {
        return "next_day";
    }

    public NextDay copy(Expression startDate, Expression dayOfWeek) {
        return new NextDay(startDate, dayOfWeek);
    }

    public Expression copy$default$1() {
        return this.startDate();
    }

    public Expression copy$default$2() {
        return this.dayOfWeek();
    }

    @Override
    public String productPrefix() {
        return "NextDay";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.startDate();
                break;
            }
            case 1: {
                expression = this.dayOfWeek();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NextDay;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NextDay)) return false;
        boolean bl = true;
        if (!bl) return false;
        NextDay nextDay = (NextDay)x$1;
        Expression expression = this.startDate();
        Expression expression2 = nextDay.startDate();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.dayOfWeek();
        Expression expression4 = nextDay.dayOfWeek();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!nextDay.canEqual(this)) return false;
        return true;
    }

    public NextDay(Expression startDate, Expression dayOfWeek) {
        this.startDate = startDate;
        this.dayOfWeek = dayOfWeek;
        ExpectsInputTypes.$init$(this);
    }
}

