/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NaNvl$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr1, expr2) - Returns `expr1` if it's not NaN, or `expr2` otherwise.", examples="\n    Examples:\n      > SELECT _FUNC_(cast('NaN' as double), 123);\n       123.0\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001\u0002\u000e\u001c\u0001\"B\u0001\"\u000f\u0001\u0003\u0016\u0004%\tA\u000f\u0005\t}\u0001\u0011\t\u0012)A\u0005w!Aq\b\u0001BK\u0002\u0013\u0005!\b\u0003\u0005A\u0001\tE\t\u0015!\u0003<\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u00151\u0005\u0001\"\u0011H\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u0015Q\u0007\u0001\"\u0011l\u0011\u001dI\b!!A\u0005\u0002iDq! \u0001\u0012\u0002\u0013\u0005a\u0010\u0003\u0005\u0002\u0014\u0001\t\n\u0011\"\u0001\u007f\u0011%\t)\u0002AA\u0001\n\u0003\n9\u0002C\u0005\u0002*\u0001\t\t\u0011\"\u0001\u0002,!I\u00111\u0007\u0001\u0002\u0002\u0013\u0005\u0011Q\u0007\u0005\n\u0003w\u0001\u0011\u0011!C!\u0003{A\u0011\"a\u0013\u0001\u0003\u0003%\t!!\u0014\t\u0013\u0005]\u0003!!A\u0005B\u0005es!CA<7\u0005\u0005\t\u0012AA=\r!Q2$!A\t\u0002\u0005m\u0004BB!\u0015\t\u0003\tI\tC\u0005\u0002\fR\t\t\u0011\"\u0012\u0002\u000e\"I\u0011q\u0012\u000b\u0002\u0002\u0013\u0005\u0015\u0011\u0013\u0005\n\u0003/#\u0012\u0011!CA\u00033C\u0011\"a+\u0015\u0003\u0003%I!!,\u0003\u000b9\u000bgJ\u001e7\u000b\u0005qi\u0012aC3yaJ,7o]5p]NT!AH\u0010\u0002\u0011\r\fG/\u00197zgRT!\u0001I\u0011\u0002\u0007M\fHN\u0003\u0002#G\u0005)1\u000f]1sW*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u0015.aY\u0002\"AK\u0016\u000e\u0003mI!\u0001L\u000e\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u0016/\u0013\ty3D\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t\tD'D\u00013\u0015\u0005\u0019\u0014!B:dC2\f\u0017BA\u001b3\u0005\u001d\u0001&o\u001c3vGR\u0004\"!M\u001c\n\u0005a\u0012$\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00027fMR,\u0012a\u000f\t\u0003UqJ!!P\u000e\u0003\u0015\u0015C\bO]3tg&|g.A\u0003mK\u001a$\b%A\u0003sS\u001eDG/\u0001\u0004sS\u001eDG\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\r#U\t\u0005\u0002+\u0001!)\u0011(\u0002a\u0001w!)q(\u0002a\u0001w\u0005AA-\u0019;b)f\u0004X-F\u0001I!\tIE*D\u0001K\u0015\tYu$A\u0003usB,7/\u0003\u0002N\u0015\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012\u0001\u0015\t\u0004#fcfB\u0001*X\u001d\t\u0019f+D\u0001U\u0015\t)v%\u0001\u0004=e>|GOP\u0005\u0002g%\u0011\u0001LM\u0001\ba\u0006\u001c7.Y4f\u0013\tQ6LA\u0002TKFT!\u0001\u0017\u001a\u0011\u0005%k\u0016B\u00010K\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0003fm\u0006dGCA1e!\t\t$-\u0003\u0002de\t\u0019\u0011I\\=\t\u000f\u0015D\u0001\u0013!a\u0001M\u0006)\u0011N\u001c9viB\u0011q\r[\u0007\u0002;%\u0011\u0011.\b\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0005e_\u001e+gnQ8eKR\u0019AN]<\u0011\u00055\u0004X\"\u00018\u000b\u0005=\\\u0012aB2pI\u0016<WM\\\u0005\u0003c:\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006g&\u0001\r\u0001^\u0001\u0004GRD\bCA7v\u0013\t1hN\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000baL\u0001\u0019\u00017\u0002\u0005\u00154\u0018\u0001B2paf$2aQ>}\u0011\u001dI$\u0002%AA\u0002mBqa\u0010\u0006\u0011\u0002\u0003\u00071(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0003}T3aOA\u0001W\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005=QBAA\u0004\u0015\u0011\tI!a\u0003\u0002\u0013Ut7\r[3dW\u0016$'bAA\u0007e\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0011q\u0001\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005e\u0001\u0003BA\u000e\u0003Ki!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0005Y\u0006twM\u0003\u0002\u0002$\u0005!!.\u0019<b\u0013\u0011\t9#!\b\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ti\u0003E\u00022\u0003_I1!!\r3\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r\t\u0017q\u0007\u0005\n\u0003sy\u0011\u0011!a\u0001\u0003[\t1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA !\u0015\t\t%a\u0012b\u001b\t\t\u0019EC\u0002\u0002FI\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI%a\u0011\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u001f\n)\u0006E\u00022\u0003#J1!a\u00153\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u000f\u0012\u0003\u0003\u0005\r!Y\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005=\u00131\f\u0005\t\u0003s\u0011\u0012\u0011!a\u0001C\"z\u0001!a\u0018\u0002f\u0005\u001d\u00141NA7\u0003c\n\u0019\bE\u0002+\u0003CJ1!a\u0019\u001c\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!\u001b\u0002\u001b~3UKT\"`Q\u0015D\bO]\u0019-A\u0015D\bO\u001d\u001a*A5\u0002#+\u001a;ve:\u001c\b\u0005Y3yaJ\f\u0004\rI5gA%$xe\u001d\u0011o_R\u0004c*\u0019(-A=\u0014\b\u0005Y3yaJ\u0014\u0004\rI8uQ\u0016\u0014x/[:f]\u0005AQ\r_1na2,7/\t\u0002\u0002p\u0005\t&\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK2bgRDsET1OO\u0001\n7\u000f\t3pk\ndW-\u000b\u0017!cI\u001a\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00112eMr\u0003G\u0003\u0011!\u0003\u0015\u0019\u0018N\\2fC\t\t)(A\u00032]Ur\u0003'A\u0003OC:3H\u000e\u0005\u0002+)M!A#! 7!\u001d\ty(!\"<w\rk!!!!\u000b\u0007\u0005\r%'A\u0004sk:$\u0018.\\3\n\t\u0005\u001d\u0015\u0011\u0011\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DCAA=\u0003!!xn\u0015;sS:<GCAA\r\u0003\u0015\t\u0007\u000f\u001d7z)\u0015\u0019\u00151SAK\u0011\u0015It\u00031\u0001<\u0011\u0015yt\u00031\u0001<\u0003\u001d)h.\u00199qYf$B!a'\u0002(B)\u0011'!(\u0002\"&\u0019\u0011q\u0014\u001a\u0003\r=\u0003H/[8o!\u0015\t\u00141U\u001e<\u0013\r\t)K\r\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005%\u0006$!AA\u0002\r\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005=\u0006\u0003BA\u000e\u0003cKA!a-\u0002\u001e\t1qJ\u00196fGR\u0004")
public class NaNvl
extends BinaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(NaNvl naNvl) {
        return NaNvl$.MODULE$.unapply(naNvl);
    }

    public static Function1<Tuple2<Expression, Expression>, NaNvl> tupled() {
        return NaNvl$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, NaNvl>> curried() {
        return NaNvl$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public DataType dataType() {
        return this.left().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, FloatType$.MODULE$})), TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, FloatType$.MODULE$}))}));
    }

    @Override
    public Object eval(InternalRow input) {
        Object object;
        Object value = this.left().eval(input);
        if (value == null) {
            object = null;
        } else {
            Object object2;
            DataType dataType = this.left().dataType();
            if (DoubleType$.MODULE$.equals(dataType)) {
                object2 = !Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)value)).isNaN() ? value : this.right().eval(input);
            } else if (FloatType$.MODULE$.equals(dataType)) {
                object2 = !Predef$.MODULE$.float2Float(BoxesRunTime.unboxToFloat((Object)value)).isNaN() ? value : this.right().eval(input);
            } else {
                throw new MatchError((Object)dataType);
            }
            object = object2;
        }
        return object;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        ExprCode leftGen = this.left().genCode(ctx);
        ExprCode rightGen = this.right().genCode(ctx);
        DataType dataType = this.left().dataType();
        boolean bl = DoubleType$.MODULE$.equals(dataType) ? true : FloatType$.MODULE$.equals(dataType);
        if (!bl) {
            throw new MatchError((Object)dataType);
        }
        ExprCode exprCode = ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n          ", "\n          boolean ", " = false;\n          ", " ", " = ", ";\n          if (", ") {\n            ", " = true;\n          } else {\n            if (!Double.isNaN(", ")) {\n              ", " = ", ";\n            } else {\n              ", "\n              if (", ") {\n                ", " = true;\n              } else {\n                ", " = ", ";\n              }\n            }\n          }"}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{leftGen.code(), ev.isNull(), CodeGenerator$.MODULE$.javaType(this.dataType()), ev.value(), CodeGenerator$.MODULE$.defaultValue(this.dataType(), CodeGenerator$.MODULE$.defaultValue$default$2()), leftGen.isNull(), ev.isNull(), leftGen.value(), ev.value(), leftGen.value(), rightGen.code(), rightGen.isNull(), ev.isNull(), ev.value(), rightGen.value()})), ev.copy$default$2(), ev.copy$default$3());
        return exprCode;
    }

    public NaNvl copy(Expression left, Expression right) {
        return new NaNvl(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "NaNvl";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof NaNvl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof NaNvl)) return false;
        boolean bl = true;
        if (!bl) return false;
        NaNvl naNvl = (NaNvl)x$1;
        Expression expression = this.left();
        Expression expression2 = naNvl.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = naNvl.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!naNvl.canEqual(this)) return false;
        return true;
    }

    public NaNvl(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

