/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCoercion$;
import org.apache.spark.sql.catalyst.expressions.ArrayPosition$;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.TypeUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array, element) - Returns the (1-based) index of the first element of the array as long.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(array(3, 2, 1), 1);\n       3\n  ", group="array_funcs", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\u0005uh\u0001B\u000f\u001f\u0001.B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u0011\u0002\u0011\t\u0012)A\u0005\u000b\"A\u0011\n\u0001BK\u0002\u0013\u0005A\t\u0003\u0005K\u0001\tE\t\u0015!\u0003F\u0011\u0015Y\u0005\u0001\"\u0001M\u0011!\u0001\u0006\u0001#b\u0001\n\u0013\t\u0006\"\u00023\u0001\t\u0003*\u0007\"\u00027\u0001\t\u0003j\u0007\"\u0002;\u0001\t\u0003*\b\"\u0002?\u0001\t\u0003j\bbBA\u0003\u0001\u0011\u0005\u0013q\u0001\u0005\b\u00033\u0001A\u0011IA\u000e\u0011%\t9\u0004AA\u0001\n\u0003\tI\u0004C\u0005\u0002@\u0001\t\n\u0011\"\u0001\u0002B!I\u0011q\u000b\u0001\u0012\u0002\u0013\u0005\u0011\u0011\t\u0005\n\u00033\u0002\u0011\u0011!C!\u00037B\u0011\"a\u001b\u0001\u0003\u0003%\t!!\u001c\t\u0013\u0005U\u0004!!A\u0005\u0002\u0005]\u0004\"CA?\u0001\u0005\u0005I\u0011IA@\u0011%\ti\tAA\u0001\n\u0003\ty\tC\u0005\u0002\u001a\u0002\t\t\u0011\"\u0011\u0002\u001c\u001eI\u0011q\u0018\u0010\u0002\u0002#\u0005\u0011\u0011\u0019\u0004\t;y\t\t\u0011#\u0001\u0002D\"11j\u0006C\u0001\u0003#D\u0011\"a5\u0018\u0003\u0003%)%!6\t\u0013\u0005]w#!A\u0005\u0002\u0006e\u0007\"CAp/\u0005\u0005I\u0011QAq\u0011%\t\u0019pFA\u0001\n\u0013\t)PA\u0007BeJ\f\u0017\u0010U8tSRLwN\u001c\u0006\u0003?\u0001\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0011EI\u0001\tG\u0006$\u0018\r\\=ti*\u00111\u0005J\u0001\u0004gFd'BA\u0013'\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0003&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002S\u0005\u0019qN]4\u0004\u0001M1\u0001\u0001\f\u00194u\u0001\u0003\"!\f\u0018\u000e\u0003yI!a\f\u0010\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u00172\u0013\t\u0011dD\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t!tG\u0004\u0002.k%\u0011aGH\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0014H\u0001\bOk2d\u0017J\u001c;pY\u0016\u0014\u0018M\u001c;\u000b\u0005Yr\u0002CA\u001e?\u001b\u0005a$\"A\u001f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}b$a\u0002)s_\u0012,8\r\u001e\t\u0003w\u0005K!A\u0011\u001f\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\t1,g\r^\u000b\u0002\u000bB\u0011QFR\u0005\u0003\u000fz\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u0015aWM\u001a;!\u0003\u0015\u0011\u0018n\u001a5u\u0003\u0019\u0011\u0018n\u001a5uA\u00051A(\u001b8jiz\"2!\u0014(P!\ti\u0003\u0001C\u0003D\u000b\u0001\u0007Q\tC\u0003J\u000b\u0001\u0007Q)\u0001\u0005pe\u0012,'/\u001b8h+\u0005\u0011\u0006cA*[;:\u0011A+\u0017\b\u0003+bk\u0011A\u0016\u0006\u0003/*\na\u0001\u0010:p_Rt\u0014\"A\u001f\n\u0005Yb\u0014BA.]\u0005!y%\u000fZ3sS:<'B\u0001\u001c=!\tYd,\u0003\u0002`y\t\u0019\u0011I\\=)\u0005\u0019\t\u0007CA\u001ec\u0013\t\u0019GHA\u0005ue\u0006t7/[3oi\u0006AA-\u0019;b)f\u0004X-F\u0001g!\t9'.D\u0001i\u0015\tI'%A\u0003usB,7/\u0003\u0002lQ\nAA)\u0019;b)f\u0004X-\u0001\u0006j]B,H\u000fV=qKN,\u0012A\u001c\t\u0004'>\f\u0018B\u00019]\u0005\r\u0019V-\u001d\t\u0003OJL!a\u001d5\u0003!\u0005\u00137\u000f\u001e:bGR$\u0015\r^1UsB,\u0017aE2iK\u000e\\\u0017J\u001c9vi\u0012\u000bG/\u0019+za\u0016\u001cH#\u0001<\u0011\u0005]TX\"\u0001=\u000b\u0005e\u0004\u0013\u0001C1oC2L8/[:\n\u0005mD(a\u0004+za\u0016\u001c\u0005.Z2l%\u0016\u001cX\u000f\u001c;\u0002\u00199,H\u000e\\*bM\u0016,e/\u00197\u0015\tus\u0018\u0011\u0001\u0005\u0006\u007f*\u0001\r!X\u0001\u0004CJ\u0014\bBBA\u0002\u0015\u0001\u0007Q,A\u0003wC2,X-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!!\u0003\u0011\t\u0005-\u00111\u0003\b\u0005\u0003\u001b\ty\u0001\u0005\u0002Vy%\u0019\u0011\u0011\u0003\u001f\u0002\rA\u0013X\rZ3g\u0013\u0011\t)\"a\u0006\u0003\rM#(/\u001b8h\u0015\r\t\t\u0002P\u0001\nI><UM\\\"pI\u0016$b!!\b\u0002*\u0005M\u0002\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\rb$A\u0004d_\u0012,w-\u001a8\n\t\u0005\u001d\u0012\u0011\u0005\u0002\t\u000bb\u0004(oQ8eK\"9\u00111\u0006\u0007A\u0002\u00055\u0012aA2uqB!\u0011qDA\u0018\u0013\u0011\t\t$!\t\u0003\u001d\r{G-Z4f]\u000e{g\u000e^3yi\"9\u0011Q\u0007\u0007A\u0002\u0005u\u0011AA3w\u0003\u0011\u0019w\u000e]=\u0015\u000b5\u000bY$!\u0010\t\u000f\rk\u0001\u0013!a\u0001\u000b\"9\u0011*\u0004I\u0001\u0002\u0004)\u0015AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0007R3!RA#W\t\t9\u0005\u0005\u0003\u0002J\u0005MSBAA&\u0015\u0011\ti%a\u0014\u0002\u0013Ut7\r[3dW\u0016$'bAA)y\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00131\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005u\u0003\u0003BA0\u0003Sj!!!\u0019\u000b\t\u0005\r\u0014QM\u0001\u0005Y\u0006twM\u0003\u0002\u0002h\u0005!!.\u0019<b\u0013\u0011\t)\"!\u0019\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005=\u0004cA\u001e\u0002r%\u0019\u00111\u000f\u001f\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007u\u000bI\bC\u0005\u0002|I\t\t\u00111\u0001\u0002p\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!!\u0011\u000b\u0005\r\u0015\u0011R/\u000e\u0005\u0005\u0015%bAADy\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005-\u0015Q\u0011\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0012\u0006]\u0005cA\u001e\u0002\u0014&\u0019\u0011Q\u0013\u001f\u0003\u000f\t{w\u000e\\3b]\"A\u00111\u0010\u000b\u0002\u0002\u0003\u0007Q,\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003#\u000bi\n\u0003\u0005\u0002|U\t\t\u00111\u0001^QM\u0001\u0011\u0011UAT\u0003S\u000bi+a,\u00024\u0006U\u0016\u0011XA^!\ri\u00131U\u0005\u0004\u0003Ks\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003W\u000bqM\u0003\u0011!A\u0001zf)\u0016(D?\"\n'O]1zY\u0001*G.Z7f]RL\u0003%\f\u0011SKR,(O\\:!i\",\u0007\u0005K\u0019.E\u0006\u001cX\rZ\u0015!S:$W\r\u001f\u0011pM\u0002\"\b.\u001a\u0011gSJ\u001cH\u000fI3mK6,g\u000e\u001e\u0011pM\u0002\"\b.\u001a\u0011beJ\f\u0017\u0010I1tA1|gn\u001a\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003c\u000bAI\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015beJ\f\u0017\u0010K\u001a-AIb\u0003%M\u0015-AEJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u001a\u000bA\u0001\nQa\u001a:pkB\f#!a.\u0002\u0017\u0005\u0014(/Y=`MVt7m]\u0001\u0006g&t7-Z\u0011\u0003\u0003{\u000bQA\r\u00185]A\nQ\"\u0011:sCf\u0004vn]5uS>t\u0007CA\u0017\u0018'\u00119\u0012Q\u0019!\u0011\u000f\u0005\u001d\u0017QZ#F\u001b6\u0011\u0011\u0011\u001a\u0006\u0004\u0003\u0017d\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003\u001f\fIMA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!!1\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0018\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000b5\u000bY.!8\t\u000b\rS\u0002\u0019A#\t\u000b%S\u0002\u0019A#\u0002\u000fUt\u0017\r\u001d9msR!\u00111]Ax!\u0015Y\u0014Q]Au\u0013\r\t9\u000f\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u000bm\nY/R#\n\u0007\u00055HH\u0001\u0004UkBdWM\r\u0005\t\u0003c\\\u0012\u0011!a\u0001\u001b\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003o\u0004B!a\u0018\u0002z&!\u00111`A1\u0005\u0019y%M[3di\u0002")
public class ArrayPosition
extends BinaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private transient Ordering<Object> ordering;
    private final Expression left;
    private final Expression right;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArrayPosition arrayPosition) {
        return ArrayPosition$.MODULE$.unapply(arrayPosition);
    }

    public static Function1<Tuple2<Expression, Expression>, ArrayPosition> tupled() {
        return ArrayPosition$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, ArrayPosition>> curried() {
        return ArrayPosition$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    private Ordering<Object> ordering$lzycompute() {
        ArrayPosition arrayPosition = this;
        synchronized (arrayPosition) {
            if (!this.bitmap$trans$0) {
                this.ordering = TypeUtils$.MODULE$.getInterpretedOrdering(this.right().dataType());
                this.bitmap$trans$0 = true;
            }
        }
        return this.ordering;
    }

    private Ordering<Object> ordering() {
        return !this.bitmap$trans$0 ? this.ordering$lzycompute() : this.ordering;
    }

    @Override
    public DataType dataType() {
        return LongType$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Seq<AbstractDataType> inputTypes() {
        Seq seq;
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 == null) return (Seq)Seq$.MODULE$.empty();
        DataType dataType = (DataType)tuple2._1();
        DataType e2 = (DataType)tuple2._2();
        if (!(dataType instanceof ArrayType)) return (Seq)Seq$.MODULE$.empty();
        ArrayType arrayType = (ArrayType)dataType;
        DataType e1 = arrayType.elementType();
        boolean hasNull = arrayType.containsNull();
        Option option = (Option)TypeCoercion$.MODULE$.findTightestCommonType().apply((Object)e1, (Object)e2);
        if (option instanceof Some) {
            Some some = (Some)option;
            DataType dt = (DataType)some.value();
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{new ArrayType(dt, hasNull), dt}));
            return seq;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TypeCheckResult checkInputDataTypes() {
        Tuple2 tuple2 = new Tuple2((Object)this.left().dataType(), (Object)this.right().dataType());
        if (tuple2 == null) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(95).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
        DataType dataType = (DataType)tuple2._1();
        DataType e2 = (DataType)tuple2._2();
        if (!(dataType instanceof ArrayType)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(95).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
        ArrayType arrayType = (ArrayType)dataType;
        DataType e1 = arrayType.elementType();
        if (!e1.sameType(e2)) return new TypeCheckResult.TypeCheckFailure(new StringBuilder(95).append("Input to function ").append(this.prettyName()).append(" should have ").append("been ").append(ArrayType$.MODULE$.simpleString()).append(" followed by a value with same element type, but it's ").append("[").append(this.left().dataType().catalogString()).append(", ").append(this.right().dataType().catalogString()).append("].").toString());
        return TypeUtils$.MODULE$.checkForOrderingExpr(e2, new StringBuilder(9).append("function ").append(this.prettyName()).toString());
    }

    @Override
    public Object nullSafeEval(Object arr, Object value) {
        Object object;
        Object object2 = new Object();
        try {
            ((ArrayData)arr).foreach(this.right().dataType(), (Function2<Object, Object, BoxedUnit>)(Function2 & Serializable & scala.Serializable)(i, v) -> {
                ArrayPosition.$anonfun$nullSafeEval$4(this, value, object2, BoxesRunTime.unboxToInt((Object)i), v);
                return BoxedUnit.UNIT;
            });
            object = BoxesRunTime.boxToLong((long)0L);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object2) {
                object = ex.value();
            }
            throw ex;
        }
        return object;
    }

    @Override
    public String prettyName() {
        return "array_position";
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable & scala.Serializable)(arr, value) -> {
            String pos = ctx.freshName("arrayPosition");
            String i = ctx.freshName("i");
            String getValue = CodeGenerator$.MODULE$.getValue((String)arr, this.right().dataType(), i);
            return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(207).append("\n         |int ").append(pos).append(" = 0;\n         |for (int ").append(i).append(" = 0; ").append(i).append(" < ").append((String)arr).append(".numElements(); ").append(i).append(" ++) {\n         |  if (!").append((String)arr).append(".isNullAt(").append(i).append(") && ").append(ctx.genEqual(this.right().dataType(), (String)value, getValue)).append(") {\n         |    ").append(pos).append(" = ").append(i).append(" + 1;\n         |    break;\n         |  }\n         |}\n         |").append(ev.value()).append(" = (long) ").append(pos).append(";\n       ").toString())).stripMargin();
        });
    }

    public ArrayPosition copy(Expression left, Expression right) {
        return new ArrayPosition(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "ArrayPosition";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.left();
                break;
            }
            case 1: {
                expression = this.right();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayPosition;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayPosition)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayPosition arrayPosition = (ArrayPosition)x$1;
        Expression expression = this.left();
        Expression expression2 = arrayPosition.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = arrayPosition.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arrayPosition.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ void $anonfun$nullSafeEval$4(ArrayPosition $this, Object value$2, Object nonLocalReturnKey4$1, int i, Object v) {
        if (v != null && $this.ordering().equiv(v, value$2)) {
            throw new NonLocalReturnControl.mcJ.sp(nonLocalReturnKey4$1, (long)(i + 1));
        }
    }

    public ArrayPosition(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        ExpectsInputTypes.$init$(this);
    }
}

