/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.feature.InstanceBlock$;
import org.apache.spark.ml.feature.StandardScalerModel$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.BlockAFTAggregator;
import org.apache.spark.ml.optim.loss.DifferentiableRegularization;
import org.apache.spark.ml.optim.loss.RDDLossFunction;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.regression.AFTSurvivalRegression$;
import org.apache.spark.ml.regression.AFTSurvivalRegressionModel;
import org.apache.spark.ml.regression.AFTSurvivalRegressionParams;
import org.apache.spark.ml.regression.Regressor;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t=a\u0001\u0002\f\u0018\u0001\tB\u0001\u0002\u0011\u0001\u0003\u0006\u0004%\t%\u0011\u0005\t1\u0002\u0011\t\u0011)A\u0005\u0005\")!\f\u0001C\u00017\")!\f\u0001C\u0001?\")\u0011\r\u0001C\u0001E\")q\r\u0001C\u0001Q\")!\u000f\u0001C\u0001g\")a\u000f\u0001C\u0001o\")Q\u0010\u0001C\u0001}\"9\u0011\u0011\u0002\u0001\u0005\u0002\u0005-\u0001bBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003;\u0001A\u0011AA\u0010\u0011\u001d\tI\u0003\u0001C)\u0003WAq!!\u0016\u0001\t\u0013\t9\u0006C\u0004\u0002&\u0002!\t%a*\t\u000f\u0005m\u0006\u0001\"\u0011\u0002>\u001e9\u00111[\f\t\u0002\u0005UgA\u0002\f\u0018\u0011\u0003\t9\u000e\u0003\u0004[%\u0011\u0005\u00111\u001e\u0005\b\u0003[\u0014B\u0011IAx\u0011%\t9PEA\u0001\n\u0013\tIPA\u000bB\rR\u001bVO\u001d<jm\u0006d'+Z4sKN\u001c\u0018n\u001c8\u000b\u0005aI\u0012A\u0003:fOJ,7o]5p]*\u0011!dG\u0001\u0003[2T!\u0001H\u000f\u0002\u000bM\u0004\u0018M]6\u000b\u0005yy\u0012AB1qC\u000eDWMC\u0001!\u0003\ry'oZ\u0002\u0001'\u0015\u00011%\r\u001b;!\u0015!SeJ\u0017/\u001b\u00059\u0012B\u0001\u0014\u0018\u0005%\u0011Vm\u001a:fgN|'\u000f\u0005\u0002)W5\t\u0011F\u0003\u0002+3\u00051A.\u001b8bY\u001eL!\u0001L\u0015\u0003\rY+7\r^8s!\t!\u0003\u0001\u0005\u0002%_%\u0011\u0001g\u0006\u0002\u001b\u0003\u001a#6+\u001e:wSZ\fGNU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\t\u0003IIJ!aM\f\u00037\u00053EkU;sm&4\u0018\r\u001c*fOJ,7o]5p]B\u000b'/Y7t!\t)\u0004(D\u00017\u0015\t9\u0014$\u0001\u0003vi&d\u0017BA\u001d7\u0005U!UMZ1vYR\u0004\u0016M]1ng^\u0013\u0018\u000e^1cY\u0016\u0004\"a\u000f \u000e\u0003qR!!P\u000e\u0002\u0011%tG/\u001a:oC2L!a\u0010\u001f\u0003\u000f1{wmZ5oO\u0006\u0019Q/\u001b3\u0016\u0003\t\u0003\"a\u0011'\u000f\u0005\u0011S\u0005CA#I\u001b\u00051%BA$\"\u0003\u0019a$o\\8u})\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0011\u00061\u0001K]3eK\u001aL!!\u0014(\u0003\rM#(/\u001b8h\u0015\tY\u0005\nK\u0002\u0002!Z\u0003\"!\u0015+\u000e\u0003IS!aU\u000e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002V%\n)1+\u001b8dK\u0006\nq+A\u00032]Yr\u0003'\u0001\u0003vS\u0012\u0004\u0003f\u0001\u0002Q-\u00061A(\u001b8jiz\"\"!\f/\t\u000b\u0001\u001b\u0001\u0019\u0001\")\u0007q\u0003f\u000bK\u0002\u0004!Z#\u0012!\f\u0015\u0004\tA3\u0016\u0001D:fi\u000e+gn]8s\u0007>dGCA2e\u001b\u0005\u0001\u0001\"B3\u0006\u0001\u0004\u0011\u0015!\u0002<bYV,\u0007fA\u0003Q-\u0006A2/\u001a;Rk\u0006tG/\u001b7f!J|'-\u00192jY&$\u0018.Z:\u0015\u0005\rL\u0007\"B3\u0007\u0001\u0004Q\u0007cA6m]6\t\u0001*\u0003\u0002n\u0011\n)\u0011I\u001d:bsB\u00111n\\\u0005\u0003a\"\u0013a\u0001R8vE2,\u0007f\u0001\u0004Q-\u0006y1/\u001a;Rk\u0006tG/\u001b7fg\u000e{G\u000e\u0006\u0002di\")Qm\u0002a\u0001\u0005\"\u001aq\u0001\u0015,\u0002\u001fM,GOR5u\u0013:$XM]2faR$\"a\u0019=\t\u000b\u0015D\u0001\u0019A=\u0011\u0005-T\u0018BA>I\u0005\u001d\u0011un\u001c7fC:D3\u0001\u0003)W\u0003)\u0019X\r^'bq&#XM\u001d\u000b\u0003G~Da!Z\u0005A\u0002\u0005\u0005\u0001cA6\u0002\u0004%\u0019\u0011Q\u0001%\u0003\u0007%sG\u000fK\u0002\n!Z\u000baa]3u)>dGcA2\u0002\u000e!)QM\u0003a\u0001]\"\u001a!\u0002\u0015,\u0002'M,G/Q4he\u0016<\u0017\r^5p]\u0012+\u0007\u000f\u001e5\u0015\u0007\r\f)\u0002\u0003\u0004f\u0017\u0001\u0007\u0011\u0011\u0001\u0015\u0005\u0017A\u000bI\"\t\u0002\u0002\u001c\u0005)!GL\u0019/a\u0005\u00192/\u001a;NCb\u0014En\\2l'&TX-\u00138N\u0005R\u00191-!\t\t\u000b\u0015d\u0001\u0019\u00018)\t1\u0001\u0016QE\u0011\u0003\u0003O\tQa\r\u00182]A\nQ\u0001\u001e:bS:$2ALA\u0017\u0011\u001d\ty#\u0004a\u0001\u0003c\tq\u0001Z1uCN,G\u000f\r\u0003\u00024\u0005\r\u0003CBA\u001b\u0003w\ty$\u0004\u0002\u00028)\u0019\u0011\u0011H\u000e\u0002\u0007M\fH.\u0003\u0003\u0002>\u0005]\"a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003\u0003\n\u0019\u0005\u0004\u0001\u0005\u0019\u0005\u0015\u0013QFA\u0001\u0002\u0003\u0015\t!a\u0012\u0003\u0007}#\u0013'\u0005\u0003\u0002J\u0005=\u0003cA6\u0002L%\u0019\u0011Q\n%\u0003\u000f9{G\u000f[5oOB\u00191.!\u0015\n\u0007\u0005M\u0003JA\u0002B]f\f\u0011\u0002\u001e:bS:LU\u000e\u001d7\u0015\u0019\u0005e\u0013qLA>\u0003\u007f\n\u0019)!)\u0011\u000b-\fYF\u001b6\n\u0007\u0005u\u0003J\u0001\u0004UkBdWM\r\u0005\b\u0003Cr\u0001\u0019AA2\u0003%Ign\u001d;b]\u000e,7\u000f\u0005\u0004\u0002f\u0005-\u0014qN\u0007\u0003\u0003OR1!!\u001b\u001c\u0003\r\u0011H\rZ\u0005\u0005\u0003[\n9GA\u0002S\t\u0012\u0003B!!\u001d\u0002x5\u0011\u00111\u000f\u0006\u0004\u0003kJ\u0012a\u00024fCR,(/Z\u0005\u0005\u0003s\n\u0019H\u0001\u0005J]N$\u0018M\\2f\u0011\u0019\tiH\u0004a\u0001]\u0006\u0019\u0012m\u0019;vC2\u0014En\\2l'&TX-\u00138N\u0005\"1\u0011\u0011\u0011\bA\u0002)\f1BZ3biV\u0014Xm]*uI\"9\u0011Q\u0011\bA\u0002\u0005\u001d\u0015!C8qi&l\u0017N_3s!\u0019\tI)a%\u0002\u00186\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000by)\u0001\u0005paRLW.\u001b>f\u0015\t\t\t*\u0001\u0004ce\u0016,'0Z\u0005\u0005\u0003+\u000bYIA\u0003M\u0005\u001a;5\u000bE\u0003\u0002\u001a\u0006ue.\u0004\u0002\u0002\u001c*\u0019!&a$\n\t\u0005}\u00151\u0014\u0002\f\t\u0016t7/\u001a,fGR|'\u000f\u0003\u0004\u0002$:\u0001\raJ\u0001\u0012S:LG/[1m!\u0006\u0014\u0018-\\3uKJ\u001c\u0018a\u0004;sC:\u001chm\u001c:n'\u000eDW-\\1\u0015\t\u0005%\u0016Q\u0017\t\u0005\u0003W\u000b\t,\u0004\u0002\u0002.*!\u0011qVA\u001c\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t\u0019,!,\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u00028>\u0001\r!!+\u0002\rM\u001c\u0007.Z7bQ\ry\u0001KV\u0001\u0005G>\u0004\u0018\u0010F\u0002.\u0003\u007fCq!!1\u0011\u0001\u0004\t\u0019-A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002F\u0006-WBAAd\u0015\r\tI-G\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0003\u001b\f9M\u0001\u0005QCJ\fW.T1qQ\r\u0001\u0002K\u0016\u0015\u0004\u0001A3\u0016!F!G)N+(O^5wC2\u0014Vm\u001a:fgNLwN\u001c\t\u0003II\u0019rAEAm\u0003?\f)\u000fE\u0002l\u00037L1!!8I\u0005\u0019\te.\u001f*fMB!Q'!9.\u0013\r\t\u0019O\u000e\u0002\u0016\t\u00164\u0017-\u001e7u!\u0006\u0014\u0018-\\:SK\u0006$\u0017M\u00197f!\rY\u0017q]\u0005\u0004\u0003SD%\u0001D*fe&\fG.\u001b>bE2,GCAAk\u0003\u0011aw.\u00193\u0015\u00075\n\t\u0010\u0003\u0004\u0002tR\u0001\rAQ\u0001\u0005a\u0006$\b\u000eK\u0002\u0015!Z\u000b1B]3bIJ+7o\u001c7wKR\u0011\u00111 \t\u0005\u0003{\u00149!\u0004\u0002\u0002\u0000*!!\u0011\u0001B\u0002\u0003\u0011a\u0017M\\4\u000b\u0005\t\u0015\u0011\u0001\u00026bm\u0006LAA!\u0003\u0002\u0000\n1qJ\u00196fGRD3A\u0005)WQ\r\t\u0002K\u0016")
public class AFTSurvivalRegression
extends Regressor<Vector, AFTSurvivalRegression, AFTSurvivalRegressionModel>
implements AFTSurvivalRegressionParams,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> censorCol;
    private final DoubleArrayParam quantileProbabilities;
    private final Param<String> quantilesCol;
    private final DoubleParam maxBlockSizeInMB;
    private final IntParam aggregationDepth;
    private final BooleanParam fitIntercept;
    private final DoubleParam tol;
    private final IntParam maxIter;

    public static AFTSurvivalRegression load(String string) {
        return AFTSurvivalRegression$.MODULE$.load(string);
    }

    public static MLReader<AFTSurvivalRegression> read() {
        return AFTSurvivalRegression$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public String getCensorCol() {
        return AFTSurvivalRegressionParams.getCensorCol$(this);
    }

    @Override
    public double[] getQuantileProbabilities() {
        return AFTSurvivalRegressionParams.getQuantileProbabilities$(this);
    }

    @Override
    public String getQuantilesCol() {
        return AFTSurvivalRegressionParams.getQuantilesCol$(this);
    }

    @Override
    public boolean hasQuantilesCol() {
        return AFTSurvivalRegressionParams.hasQuantilesCol$(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting) {
        return AFTSurvivalRegressionParams.validateAndTransformSchema$(this, schema, fitting);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final Param<String> censorCol() {
        return this.censorCol;
    }

    @Override
    public final DoubleArrayParam quantileProbabilities() {
        return this.quantileProbabilities;
    }

    @Override
    public final Param<String> quantilesCol() {
        return this.quantilesCol;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$censorCol_$eq(Param<String> x$1) {
        this.censorCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantileProbabilities_$eq(DoubleArrayParam x$1) {
        this.quantileProbabilities = x$1;
    }

    @Override
    public final void org$apache$spark$ml$regression$AFTSurvivalRegressionParams$_setter_$quantilesCol_$eq(Param<String> x$1) {
        this.quantilesCol = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public AFTSurvivalRegression setCensorCol(String value) {
        return (AFTSurvivalRegression)this.set(this.censorCol(), value);
    }

    public AFTSurvivalRegression setQuantileProbabilities(double[] value) {
        return (AFTSurvivalRegression)this.set(this.quantileProbabilities(), value);
    }

    public AFTSurvivalRegression setQuantilesCol(String value) {
        return (AFTSurvivalRegression)this.set(this.quantilesCol(), value);
    }

    public AFTSurvivalRegression setFitIntercept(boolean value) {
        return (AFTSurvivalRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public AFTSurvivalRegression setMaxIter(int value) {
        return (AFTSurvivalRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public AFTSurvivalRegression setTol(double value) {
        return (AFTSurvivalRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public AFTSurvivalRegression setAggregationDepth(int value) {
        return (AFTSurvivalRegression)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    public AFTSurvivalRegression setMaxBlockSizeInMB(double value) {
        return (AFTSurvivalRegression)this.set(this.maxBlockSizeInMB(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public AFTSurvivalRegressionModel train(Dataset<?> dataset) {
        return (AFTSurvivalRegressionModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable & scala.Serializable)instr -> {
            Vector initialParameters;
            LBFGS optimizer;
            Tuple2<double[], double[]> tuple2;
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.featuresCol(), this.censorCol(), this.predictionCol(), this.quantilesCol(), this.fitIntercept(), this.maxIter(), this.tol(), this.aggregationDepth(), this.maxBlockSizeInMB()}));
            instr.logNamedValue("quantileProbabilities.size", this.$(this.quantileProbabilities()).length);
            StorageLevel storageLevel = dataset.storageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            if (storageLevel == null ? storageLevel2 != null : !storageLevel.equals(storageLevel2)) {
                instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(122).append("Input instances will be standardized, blockified to blocks, and ").append("then cached during training. Be careful of double caching!").toString());
            }
            RDD instances = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol())), functions$.MODULE$.col(this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$), functions$.MODULE$.col(this.$(this.censorCol())).cast((DataType)DoubleType$.MODULE$)})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                double d;
                Vector vector;
                Object censor;
                block3: {
                    Row row;
                    block2: {
                        row = x0$1;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block2;
                        Object features = ((SeqLike)some.get()).apply(0);
                        Object label = ((SeqLike)some.get()).apply(1);
                        censor = ((SeqLike)some.get()).apply(2);
                        if (!(features instanceof Vector)) break block2;
                        vector = (Vector)features;
                        if (!(label instanceof Double)) break block2;
                        d = BoxesRunTime.unboxToDouble((Object)label);
                        if (censor instanceof Double) break block3;
                    }
                    throw new MatchError((Object)row);
                }
                double d2 = BoxesRunTime.unboxToDouble((Object)censor);
                Predef$.MODULE$.require(d2 == 1.0 || d2 == 0.0, (Function0 & Serializable & scala.Serializable)() -> "censor must be 1.0 or 0.0");
                Instance instance = new Instance(d, d2, vector);
                return instance;
            }, ClassTag$.MODULE$.apply(Instance.class)).setName("training instances");
            SummarizerBuffer summarizer = (SummarizerBuffer)instances.treeAggregate((Object)Summarizer$.MODULE$.createSummarizerBuffer((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mean", "std", "count"})), (Function2 & Serializable & scala.Serializable)(c, i) -> c.add(i.features()), (Function2 & Serializable & scala.Serializable)(c1, c2) -> c1.merge((SummarizerBuffer)c2), BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(SummarizerBuffer.class));
            double[] featuresStd = summarizer.std().toArray();
            int numFeatures = featuresStd.length;
            instr.logNumFeatures(numFeatures);
            instr.logNumExamples(summarizer.count());
            double actualBlockSizeInMB = BoxesRunTime.unboxToDouble((Object)this.$(this.maxBlockSizeInMB()));
            if (actualBlockSizeInMB == 0.0) {
                actualBlockSizeInMB = InstanceBlock$.MODULE$.DefaultBlockSizeInMB();
                Predef$.MODULE$.require(actualBlockSizeInMB > 0.0, (Function0 & Serializable & scala.Serializable)() -> "inferred actual BlockSizeInMB must > 0");
                instr.logNamedValue("actualBlockSizeInMB", ((Object)BoxesRunTime.boxToDouble((double)actualBlockSizeInMB)).toString());
            }
            if (!BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numFeatures).exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> featuresStd[i] == 0.0 && summarizer.mean().apply(i) != 0.0)) {
                instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Fitting AFTSurvivalRegressionModel without intercept on dataset with constant nonzero column, Spark MLlib outputs zero coefficients for constant nonzero columns. This behavior is different from R survival::survreg.");
            }
            if ((tuple2 = this.trainImpl((RDD<Instance>)instances, actualBlockSizeInMB, featuresStd, (LBFGS<DenseVector<Object>>)(optimizer = new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space_Double())), initialParameters = Vectors$.MODULE$.zeros(numFeatures + 2))) == null) {
                throw new MatchError(tuple2);
            }
            double[] rawCoefficients = (double[])tuple2._1();
            double[] objectiveHistory = (double[])tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)rawCoefficients, (Object)objectiveHistory);
            Tuple2 tuple23 = tuple22;
            double[] rawCoefficients2 = (double[])tuple23._1();
            double[] objectiveHistory2 = (double[])tuple23._2();
            if (rawCoefficients2 == null) {
                String msg = new StringBuilder(8).append(optimizer.getClass().getName()).append(" failed.").toString();
                instr.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> msg);
                throw new SparkException(msg);
            }
            double[] coefficientArray = (double[])Array$.MODULE$.tabulate(numFeatures, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> featuresStd[i] != 0.0 ? rawCoefficients2[i] / featuresStd[i] : 0.0, ClassTag$.MODULE$.Double());
            Vector coefficients = Vectors$.MODULE$.dense(coefficientArray);
            double intercept = rawCoefficients2[numFeatures];
            double scale = package$.MODULE$.exp(rawCoefficients2[numFeatures + 1]);
            return new AFTSurvivalRegressionModel(this.uid(), coefficients, intercept, scale);
        });
    }

    private Tuple2<double[], double[]> trainImpl(RDD<Instance> instances, double actualBlockSizeInMB, double[] featuresStd, LBFGS<DenseVector<Object>> optimizer, Vector initialParameters) {
        Broadcast bcFeaturesStd = instances.context().broadcast((Object)featuresStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD standardized = instances.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            double[] inverseStd = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])bcFeaturesStd.value())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)std -> std != 0.0 ? 1.0 / std : 0.0, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            Function1<Vector, Vector> func = StandardScalerModel$.MODULE$.getTransformFunc((double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double()), inverseStd, false, true);
            return iter.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Instance instance = x0$1;
                if (instance == null) {
                    throw new MatchError((Object)instance);
                }
                double label = instance.label();
                double weight = instance.weight();
                Vector vec = instance.features();
                Instance instance2 = new Instance(label, weight, (Vector)func.apply((Object)vec));
                return instance2;
            });
        }, instances.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Instance.class));
        long maxMemUsage = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(actualBlockSizeInMB * (double)1024L * (double)1024L));
        RDD blocks = InstanceBlock$.MODULE$.blokifyWithMaxMemUsage((RDD<Instance>)standardized, maxMemUsage).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()).setName(new StringBuilder(32).append("training blocks (blockSizeInMB=").append(actualBlockSizeInMB).append(")").toString());
        Function1 & Serializable & scala.Serializable getAggregatorFunc = (Function1 & Serializable & scala.Serializable)x$2 -> new BlockAFTAggregator(BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), (Broadcast<Vector>)x$2);
        RDDLossFunction costFun = new RDDLossFunction(blocks, getAggregatorFunc, (Option<DifferentiableRegularization<Vector>>)None$.MODULE$, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(InstanceBlock.class), ClassTag$.MODULE$.apply(BlockAFTAggregator.class));
        Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction(costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)initialParameters.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
        ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
        FirstOrderMinimizer.State state = null;
        while (states.hasNext()) {
            state = (FirstOrderMinimizer.State)states.next();
            arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
        }
        blocks.unpersist(blocks.unpersist$default$1());
        bcFeaturesStd.destroy();
        return new Tuple2(state != null ? ((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double()) : null, arrayBuilder.result());
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema, true);
    }

    @Override
    public AFTSurvivalRegression copy(ParamMap extra) {
        return (AFTSurvivalRegression)this.defaultCopy(extra);
    }

    public AFTSurvivalRegression(String uid) {
        this.uid = uid;
        HasMaxIter.$init$(this);
        HasTol.$init$(this);
        HasFitIntercept.$init$(this);
        HasAggregationDepth.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        AFTSurvivalRegressionParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
    }

    public AFTSurvivalRegression() {
        this(Identifiable$.MODULE$.randomUID("aftSurvReg"));
    }
}

