/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.sort.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Optional;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.config.package$;
import org.apache.spark.shuffle.IndexShuffleBlockResolver;
import org.apache.spark.shuffle.api.ShuffleMapOutputWriter;
import org.apache.spark.shuffle.api.ShufflePartitionWriter;
import org.apache.spark.shuffle.api.WritableByteChannelWrapper;
import org.apache.spark.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalDiskShuffleMapOutputWriter
implements ShuffleMapOutputWriter {
    private static final Logger log = LoggerFactory.getLogger(LocalDiskShuffleMapOutputWriter.class);
    private final int shuffleId;
    private final long mapId;
    private final IndexShuffleBlockResolver blockResolver;
    private final long[] partitionLengths;
    private final int bufferSize;
    private int lastPartitionId = -1;
    private long currChannelPosition;
    private long bytesWrittenToMergedFile = 0L;
    private final File outputFile;
    private File outputTempFile;
    private FileOutputStream outputFileStream;
    private FileChannel outputFileChannel;
    private BufferedOutputStream outputBufferedFileStream;

    public LocalDiskShuffleMapOutputWriter(int shuffleId, long mapId, int numPartitions, IndexShuffleBlockResolver blockResolver, SparkConf sparkConf) {
        this.shuffleId = shuffleId;
        this.mapId = mapId;
        this.blockResolver = blockResolver;
        this.bufferSize = (int)((Long)sparkConf.get(package$.MODULE$.SHUFFLE_UNSAFE_FILE_OUTPUT_BUFFER_SIZE())).longValue() * 1024;
        this.partitionLengths = new long[numPartitions];
        this.outputFile = blockResolver.getDataFile(shuffleId, mapId);
        this.outputTempFile = null;
    }

    @Override
    public ShufflePartitionWriter getPartitionWriter(int reducePartitionId) throws IOException {
        if (reducePartitionId <= this.lastPartitionId) {
            throw new IllegalArgumentException("Partitions should be requested in increasing order.");
        }
        this.lastPartitionId = reducePartitionId;
        if (this.outputTempFile == null) {
            this.outputTempFile = Utils.tempFileWith(this.outputFile);
        }
        this.currChannelPosition = this.outputFileChannel != null ? this.outputFileChannel.position() : 0L;
        return new LocalDiskShufflePartitionWriter(reducePartitionId);
    }

    @Override
    public long[] commitAllPartitions() throws IOException {
        if (this.outputFileChannel != null && this.outputFileChannel.position() != this.bytesWrittenToMergedFile) {
            throw new IOException("Current position " + this.outputFileChannel.position() + " does not equal expected position " + this.bytesWrittenToMergedFile + " after transferTo. Please check your  kernel version to see if it is 2.6.32, as there is a kernel bug which will lead to unexpected behavior when using transferTo. You can set spark.file.transferTo=false to disable this NIO feature.");
        }
        this.cleanUp();
        File resolvedTmp = this.outputTempFile != null && this.outputTempFile.isFile() ? this.outputTempFile : null;
        log.debug("Writing shuffle index file for mapId {} with length {}", (Object)this.mapId, (Object)this.partitionLengths.length);
        this.blockResolver.writeIndexFileAndCommit(this.shuffleId, this.mapId, this.partitionLengths, resolvedTmp);
        return this.partitionLengths;
    }

    @Override
    public void abort(Throwable error) throws IOException {
        this.cleanUp();
        if (this.outputTempFile != null && this.outputTempFile.exists() && !this.outputTempFile.delete()) {
            log.warn("Failed to delete temporary shuffle file at {}", (Object)this.outputTempFile.getAbsolutePath());
        }
    }

    private void cleanUp() throws IOException {
        if (this.outputBufferedFileStream != null) {
            this.outputBufferedFileStream.close();
        }
        if (this.outputFileChannel != null) {
            this.outputFileChannel.close();
        }
        if (this.outputFileStream != null) {
            this.outputFileStream.close();
        }
    }

    private void initStream() throws IOException {
        if (this.outputFileStream == null) {
            this.outputFileStream = new FileOutputStream(this.outputTempFile, true);
        }
        if (this.outputBufferedFileStream == null) {
            this.outputBufferedFileStream = new BufferedOutputStream(this.outputFileStream, this.bufferSize);
        }
    }

    private void initChannel() throws IOException {
        if (this.outputFileChannel == null) {
            this.outputFileChannel = new FileOutputStream(this.outputTempFile, true).getChannel();
        }
    }

    private class PartitionWriterChannel
    implements WritableByteChannelWrapper {
        private final int partitionId;

        PartitionWriterChannel(int partitionId) {
            this.partitionId = partitionId;
        }

        public long getCount() throws IOException {
            long writtenPosition = LocalDiskShuffleMapOutputWriter.this.outputFileChannel.position();
            return writtenPosition - LocalDiskShuffleMapOutputWriter.this.currChannelPosition;
        }

        @Override
        public WritableByteChannel channel() {
            return LocalDiskShuffleMapOutputWriter.this.outputFileChannel;
        }

        @Override
        public void close() throws IOException {
            ((LocalDiskShuffleMapOutputWriter)LocalDiskShuffleMapOutputWriter.this).partitionLengths[this.partitionId] = this.getCount();
            LocalDiskShuffleMapOutputWriter.this.bytesWrittenToMergedFile = LocalDiskShuffleMapOutputWriter.this.bytesWrittenToMergedFile + LocalDiskShuffleMapOutputWriter.this.partitionLengths[this.partitionId];
        }
    }

    private class PartitionWriterStream
    extends OutputStream {
        private final int partitionId;
        private long count = 0L;
        private boolean isClosed = false;

        PartitionWriterStream(int partitionId) {
            this.partitionId = partitionId;
        }

        public long getCount() {
            return this.count;
        }

        @Override
        public void write(int b) throws IOException {
            this.verifyNotClosed();
            LocalDiskShuffleMapOutputWriter.this.outputBufferedFileStream.write(b);
            ++this.count;
        }

        @Override
        public void write(byte[] buf, int pos, int length) throws IOException {
            this.verifyNotClosed();
            LocalDiskShuffleMapOutputWriter.this.outputBufferedFileStream.write(buf, pos, length);
            this.count += (long)length;
        }

        @Override
        public void close() {
            this.isClosed = true;
            ((LocalDiskShuffleMapOutputWriter)LocalDiskShuffleMapOutputWriter.this).partitionLengths[this.partitionId] = this.count;
            LocalDiskShuffleMapOutputWriter.this.bytesWrittenToMergedFile = LocalDiskShuffleMapOutputWriter.this.bytesWrittenToMergedFile + this.count;
        }

        private void verifyNotClosed() {
            if (this.isClosed) {
                throw new IllegalStateException("Attempting to write to a closed block output stream.");
            }
        }
    }

    private class LocalDiskShufflePartitionWriter
    implements ShufflePartitionWriter {
        private final int partitionId;
        private PartitionWriterStream partStream = null;
        private PartitionWriterChannel partChannel = null;

        private LocalDiskShufflePartitionWriter(int partitionId) {
            this.partitionId = partitionId;
        }

        @Override
        public OutputStream openStream() throws IOException {
            if (this.partStream == null) {
                if (LocalDiskShuffleMapOutputWriter.this.outputFileChannel != null) {
                    throw new IllegalStateException("Requested an output channel for a previous write but now an output stream has been requested. Should not be using both channels and streams to write.");
                }
                LocalDiskShuffleMapOutputWriter.this.initStream();
                this.partStream = new PartitionWriterStream(this.partitionId);
            }
            return this.partStream;
        }

        @Override
        public Optional<WritableByteChannelWrapper> openChannelWrapper() throws IOException {
            if (this.partChannel == null) {
                if (this.partStream != null) {
                    throw new IllegalStateException("Requested an output stream for a previous write but now an output channel has been requested. Should not be using both channels and streams to write.");
                }
                LocalDiskShuffleMapOutputWriter.this.initChannel();
                this.partChannel = new PartitionWriterChannel(this.partitionId);
            }
            return Optional.of(this.partChannel);
        }

        @Override
        public long getNumBytesWritten() {
            if (this.partChannel != null) {
                try {
                    return this.partChannel.getCount();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.partStream != null) {
                return this.partStream.getCount();
            }
            return 0L;
        }
    }
}

