/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.io.NioBufferedFileInputStream;
import org.apache.spark.network.buffer.FileSegmentManagedBuffer;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.netty.SparkTransportConf$;
import org.apache.spark.network.shuffle.ExecutorDiskUtils;
import org.apache.spark.network.util.TransportConf;
import org.apache.spark.shuffle.IndexShuffleBlockResolver$;
import org.apache.spark.shuffle.ShuffleBlockResolver;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.ShuffleBlockBatchId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.storage.ShuffleDataBlockId;
import org.apache.spark.storage.ShuffleIndexBlockId;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ed!\u0002\f\u0018\u0001ey\u0002\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011Y\u0002!\u0011!Q\u0001\n]BQ!\u0010\u0001\u0005\u0002yB\u0001B\u0011\u0001\t\u0006\u0004%Ia\u0011\u0005\b\t\u0002\u0011\r\u0011\"\u0003F\u0011\u0019q\u0005\u0001)A\u0005\r\")q\n\u0001C\u0001!\")q\n\u0001C\u0001G\")\u0011\u0010\u0001C\u0005u\"9a\u0010AI\u0001\n\u0013y\bbBA\u000b\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003G\u0001A\u0011BA\u0013\u0011\u001d\t)\u0004\u0001C\u0001\u0003oAq!!\u0012\u0001\t\u0003\n9\u0005C\u0004\u0002b\u0001!\t%a\u0019\b\u0011\u0005\u0015t\u0003#\u0001\u001a\u0003O2qAF\f\t\u0002e\tI\u0007\u0003\u0004>#\u0011\u0005\u00111\u000e\u0005\n\u0003[\n\"\u0019!C\u0001\u0003_Bq!!\u001d\u0012A\u0003%1\fC\u0005\u0002tE\t\n\u0011\"\u0001\u0002v\tI\u0012J\u001c3fqNCWO\u001a4mK\ncwnY6SKN|GN^3s\u0015\tA\u0012$A\u0004tQV4g\r\\3\u000b\u0005iY\u0012!B:qCJ\\'B\u0001\u000f\u001e\u0003\u0019\t\u0007/Y2iK*\ta$A\u0002pe\u001e\u001cB\u0001\u0001\u0011'UA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\u0004\"a\n\u0015\u000e\u0003]I!!K\f\u0003)MCWO\u001a4mK\ncwnY6SKN|GN^3s!\tYc&D\u0001-\u0015\ti\u0013$\u0001\u0005j]R,'O\\1m\u0013\tyCFA\u0004M_\u001e<\u0017N\\4\u0002\t\r|gNZ\u0002\u0001!\t\u0019D'D\u0001\u001a\u0013\t)\u0014DA\u0005Ta\u0006\u00148nQ8oM\u0006iqL\u00197pG.l\u0015M\\1hKJ\u0004\"\u0001O\u001e\u000e\u0003eR!AO\r\u0002\u000fM$xN]1hK&\u0011A(\u000f\u0002\r\u00052|7m['b]\u0006<WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007}\u0002\u0015\t\u0005\u0002(\u0001!)\u0001g\u0001a\u0001e!9ag\u0001I\u0001\u0002\u00049\u0014\u0001\u00042m_\u000e\\W*\u00198bO\u0016\u0014X#A\u001c\u0002\u001bQ\u0014\u0018M\\:q_J$8i\u001c8g+\u00051\u0005CA$M\u001b\u0005A%BA%K\u0003\u0011)H/\u001b7\u000b\u0005-K\u0012a\u00028fi^|'o[\u0005\u0003\u001b\"\u0013Q\u0002\u0016:b]N\u0004xN\u001d;D_:4\u0017A\u0004;sC:\u001c\bo\u001c:u\u0007>tg\rI\u0001\fO\u0016$H)\u0019;b\r&dW\rF\u0002R3z\u0003\"AU,\u000e\u0003MS!\u0001V+\u0002\u0005%|'\"\u0001,\u0002\t)\fg/Y\u0005\u00031N\u0013AAR5mK\")!l\u0002a\u00017\u0006I1\u000f[;gM2,\u0017\n\u001a\t\u0003CqK!!\u0018\u0012\u0003\u0007%sG\u000fC\u0003`\u000f\u0001\u0007\u0001-A\u0003nCBLE\r\u0005\u0002\"C&\u0011!M\t\u0002\u0005\u0019>tw\r\u0006\u0003RI\u00164\u0007\"\u0002.\t\u0001\u0004Y\u0006\"B0\t\u0001\u0004\u0001\u0007\"B4\t\u0001\u0004A\u0017\u0001\u00023jeN\u00042!I5l\u0013\tQ'E\u0001\u0004PaRLwN\u001c\t\u0004C1t\u0017BA7#\u0005\u0015\t%O]1z!\tygO\u0004\u0002qiB\u0011\u0011OI\u0007\u0002e*\u00111/M\u0001\u0007yI|w\u000e\u001e \n\u0005U\u0014\u0013A\u0002)sK\u0012,g-\u0003\u0002xq\n11\u000b\u001e:j]\u001eT!!\u001e\u0012\u0002\u0019\u001d,G/\u00138eKb4\u0015\u000e\\3\u0015\tE[H0 \u0005\u00065&\u0001\ra\u0017\u0005\u0006?&\u0001\r\u0001\u0019\u0005\bO&\u0001\n\u00111\u0001i\u0003Y9W\r^%oI\u0016Dh)\u001b7fI\u0011,g-Y;mi\u0012\u001aTCAA\u0001U\rA\u00171A\u0016\u0003\u0003\u000b\u0001B!a\u0002\u0002\u00125\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!A\u0005v]\u000eDWmY6fI*\u0019\u0011q\u0002\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0014\u0005%!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006y!/Z7pm\u0016$\u0015\r^1Cs6\u000b\u0007\u000f\u0006\u0004\u0002\u001a\u0005}\u0011\u0011\u0005\t\u0004C\u0005m\u0011bAA\u000fE\t!QK\\5u\u0011\u0015Q6\u00021\u0001\\\u0011\u0015y6\u00021\u0001a\u0003U\u0019\u0007.Z2l\u0013:$W\r_!oI\u0012\u000bG/\u0019$jY\u0016$\u0002\"a\n\u0002*\u00055\u0012\u0011\u0007\t\u0004C1\u0004\u0007BBA\u0016\u0019\u0001\u0007\u0011+A\u0003j]\u0012,\u0007\u0010\u0003\u0004\u000201\u0001\r!U\u0001\u0005I\u0006$\u0018\r\u0003\u0004\u000241\u0001\raW\u0001\u0007E2|7m[:\u0002/]\u0014\u0018\u000e^3J]\u0012,\u0007PR5mK\u0006sGmQ8n[&$HCCA\r\u0003s\tY$!\u0010\u0002B!)!,\u0004a\u00017\")q,\u0004a\u0001A\"9\u0011qH\u0007A\u0002\u0005\u001d\u0012a\u00027f]\u001e$\bn\u001d\u0005\u0007\u0003\u0007j\u0001\u0019A)\u0002\u000f\u0011\fG/\u0019+na\u0006aq-\u001a;CY>\u001c7\u000eR1uCR1\u0011\u0011JA+\u0003?\u0002B!a\u0013\u0002R5\u0011\u0011Q\n\u0006\u0004\u0003\u001fR\u0015A\u00022vM\u001a,'/\u0003\u0003\u0002T\u00055#!D'b]\u0006<W\r\u001a\"vM\u001a,'\u000fC\u0004\u0002X9\u0001\r!!\u0017\u0002\u000f\tdwnY6JIB\u0019\u0001(a\u0017\n\u0007\u0005u\u0013HA\u0004CY>\u001c7.\u00133\t\u000f\u001dt\u0001\u0013!a\u0001Q\u0006!1\u000f^8q)\t\tI\"A\rJ]\u0012,\u0007p\u00155vM\u001adWM\u00117pG.\u0014Vm]8mm\u0016\u0014\bCA\u0014\u0012'\t\t\u0002\u0005\u0006\u0002\u0002h\u0005qajT(Q?J+E)V\"F?&#U#A.\u0002\u001f9{u\nU0S\u000b\u0012+6)R0J\t\u0002\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012TCAA<U\r9\u00141\u0001")
public class IndexShuffleBlockResolver
implements ShuffleBlockResolver,
Logging {
    private BlockManager blockManager;
    private final BlockManager _blockManager;
    private final TransportConf transportConf;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static BlockManager $lessinit$greater$default$2() {
        return IndexShuffleBlockResolver$.MODULE$.$lessinit$greater$default$2();
    }

    public static int NOOP_REDUCE_ID() {
        return IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Option<String[]> getBlockData$default$2() {
        return ShuffleBlockResolver.getBlockData$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private BlockManager blockManager$lzycompute() {
        IndexShuffleBlockResolver indexShuffleBlockResolver = this;
        synchronized (indexShuffleBlockResolver) {
            if (!this.bitmap$0) {
                this.blockManager = (BlockManager)Option$.MODULE$.apply((Object)this._blockManager).getOrElse((Function0 & Serializable & scala.Serializable)() -> SparkEnv$.MODULE$.get().blockManager());
                this.bitmap$0 = true;
            }
        }
        this._blockManager = null;
        return this.blockManager;
    }

    private BlockManager blockManager() {
        return !this.bitmap$0 ? this.blockManager$lzycompute() : this.blockManager;
    }

    private TransportConf transportConf() {
        return this.transportConf;
    }

    public File getDataFile(int shuffleId, long mapId) {
        return this.getDataFile(shuffleId, mapId, (Option<String[]>)None$.MODULE$);
    }

    public File getDataFile(int shuffleId, long mapId, Option<String[]> dirs) {
        ShuffleDataBlockId blockId = new ShuffleDataBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
        return (File)dirs.map((Function1 & Serializable & scala.Serializable)x$1 -> ExecutorDiskUtils.getFile((String[])x$1, (int)this.blockManager().subDirsPerLocalDir(), (String)blockId.name())).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.blockManager().diskBlockManager().getFile(blockId));
    }

    private File getIndexFile(int shuffleId, long mapId, Option<String[]> dirs) {
        ShuffleIndexBlockId blockId = new ShuffleIndexBlockId(shuffleId, mapId, IndexShuffleBlockResolver$.MODULE$.NOOP_REDUCE_ID());
        return (File)dirs.map((Function1 & Serializable & scala.Serializable)x$2 -> ExecutorDiskUtils.getFile((String[])x$2, (int)this.blockManager().subDirsPerLocalDir(), (String)blockId.name())).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.blockManager().diskBlockManager().getFile(blockId));
    }

    private Option<String[]> getIndexFile$default$3() {
        return None$.MODULE$;
    }

    public void removeDataByMap(int shuffleId, long mapId) {
        block1: {
            ObjectRef file = ObjectRef.create((Object)this.getDataFile(shuffleId, mapId));
            if (((File)file.elem).exists() && !((File)file.elem).delete()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Error deleting data ").append(((File)file$1.elem).getPath()).toString());
            }
            file.elem = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
            if (!((File)file.elem).exists() || ((File)file.elem).delete()) break block1;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Error deleting index ").append(((File)file$1.elem).getPath()).toString());
        }
    }

    private long[] checkIndexAndDataFile(File index, File data, int blocks) {
        long[] lengths;
        block11: {
            long[] lArray;
            block10: {
                DataInputStream dataInputStream;
                if (index.length() != (long)(blocks + 1) * 8L) {
                    return null;
                }
                lengths = new long[blocks];
                try {
                    dataInputStream = new DataInputStream(new NioBufferedFileInputStream(index));
                }
                catch (IOException e) {
                    return null;
                }
                try (DataInputStream in = dataInputStream;){
                    try {
                        long offset = in.readLong();
                        if (offset != 0L) {
                            lArray = null;
                            break block10;
                        }
                        for (int i = 0; i < blocks; ++i) {
                            long off = in.readLong();
                            lengths[i] = off - offset;
                            offset = off;
                        }
                        break block11;
                    }
                    catch (IOException e) {
                        lArray = null;
                    }
                }
            }
            return lArray;
        }
        return (long[])(data.length() == BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(lengths)).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) ? lengths : null);
    }

    public void writeIndexFileAndCommit(int shuffleId, long mapId, long[] lengths, File dataTmp) {
        File indexFile = this.getIndexFile(shuffleId, mapId, this.getIndexFile$default$3());
        File indexTmp = Utils$.MODULE$.tempFileWith(indexFile);
        try {
            File dataFile = this.getDataFile(shuffleId, mapId);
            IndexShuffleBlockResolver indexShuffleBlockResolver = this;
            synchronized (indexShuffleBlockResolver) {
                Object object;
                long[] existingLengths = this.checkIndexAndDataFile(indexFile, dataFile, lengths.length);
                if (existingLengths != null) {
                    System.arraycopy(existingLengths, 0, lengths, 0, lengths.length);
                    object = dataTmp != null && dataTmp.exists() ? BoxesRunTime.boxToBoolean((boolean)dataTmp.delete()) : BoxedUnit.UNIT;
                } else {
                    DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(indexTmp)));
                    Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        LongRef offset = LongRef.create((long)0L);
                        out.writeLong(offset.elem);
                        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(lengths)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)length -> {
                            offset$1.elem += length;
                            out.writeLong(offset$1.elem);
                        });
                    }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> out.close());
                    Object object2 = indexFile.exists() ? BoxesRunTime.boxToBoolean((boolean)indexFile.delete()) : BoxedUnit.UNIT;
                    Object object3 = dataFile.exists() ? BoxesRunTime.boxToBoolean((boolean)dataFile.delete()) : BoxedUnit.UNIT;
                    if (!indexTmp.renameTo(indexFile)) {
                        throw new IOException(new StringBuilder(24).append("fail to rename file ").append(indexTmp).append(" to ").append(indexFile).toString());
                    }
                    if (dataTmp != null && dataTmp.exists() && !dataTmp.renameTo(dataFile)) {
                        throw new IOException(new StringBuilder(24).append("fail to rename file ").append(dataTmp).append(" to ").append(dataFile).toString());
                    }
                    object = BoxedUnit.UNIT;
                }
            }
        }
        finally {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Shuffle index for mapId ").append(mapId).append(": ").append(new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(lengths)).mkString("[", ",", "]")).toString());
            if (indexTmp.exists() && !indexTmp.delete()) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Failed to delete temporary index file at ").append(indexTmp.getAbsolutePath()).toString());
            }
        }
    }

    @Override
    public ManagedBuffer getBlockData(BlockId blockId, Option<String[]> dirs) {
        FileSegmentManagedBuffer fileSegmentManagedBuffer;
        Tuple4 tuple4;
        BlockId blockId2 = blockId;
        if (blockId2 instanceof ShuffleBlockId) {
            ShuffleBlockId shuffleBlockId = (ShuffleBlockId)blockId2;
            tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleBlockId.shuffleId()), (Object)BoxesRunTime.boxToLong((long)shuffleBlockId.mapId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockId.reduceId()), (Object)BoxesRunTime.boxToInteger((int)(shuffleBlockId.reduceId() + 1)));
        } else if (blockId2 instanceof ShuffleBlockBatchId) {
            ShuffleBlockBatchId shuffleBlockBatchId = (ShuffleBlockBatchId)blockId2;
            tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.shuffleId()), (Object)BoxesRunTime.boxToLong((long)shuffleBlockBatchId.mapId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.startReduceId()), (Object)BoxesRunTime.boxToInteger((int)shuffleBlockBatchId.endReduceId()));
        } else {
            throw new IllegalArgumentException(new StringBuilder(36).append("unexpected shuffle block id format: ").append(blockId).toString());
        }
        Tuple4 tuple42 = tuple4;
        if (tuple42 == null) {
            throw new MatchError((Object)tuple42);
        }
        int shuffleId = BoxesRunTime.unboxToInt((Object)tuple42._1());
        long mapId = BoxesRunTime.unboxToLong((Object)tuple42._2());
        int startReduceId = BoxesRunTime.unboxToInt((Object)tuple42._3());
        int endReduceId = BoxesRunTime.unboxToInt((Object)tuple42._4());
        Tuple4 tuple43 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)BoxesRunTime.boxToLong((long)mapId), (Object)BoxesRunTime.boxToInteger((int)startReduceId), (Object)BoxesRunTime.boxToInteger((int)endReduceId));
        Tuple4 tuple44 = tuple43;
        int shuffleId2 = BoxesRunTime.unboxToInt((Object)tuple44._1());
        long mapId2 = BoxesRunTime.unboxToLong((Object)tuple44._2());
        int startReduceId2 = BoxesRunTime.unboxToInt((Object)tuple44._3());
        int endReduceId2 = BoxesRunTime.unboxToInt((Object)tuple44._4());
        File indexFile = this.getIndexFile(shuffleId2, mapId2, dirs);
        SeekableByteChannel channel = Files.newByteChannel(indexFile.toPath(), new OpenOption[0]);
        channel.position((long)startReduceId2 * 8L);
        try (DataInputStream in = new DataInputStream(Channels.newInputStream(channel));){
            long startOffset = in.readLong();
            channel.position((long)endReduceId2 * 8L);
            long endOffset = in.readLong();
            long actualPosition = channel.position();
            long expectedPosition = (long)endReduceId2 * 8L + 8L;
            if (actualPosition != expectedPosition) {
                throw new Exception(new StringBuilder(99).append("SPARK-22982: Incorrect channel position after index file reads: ").append("expected ").append(expectedPosition).append(" but actual position was ").append(actualPosition).append(".").toString());
            }
            fileSegmentManagedBuffer = new FileSegmentManagedBuffer(this.transportConf(), this.getDataFile(shuffleId2, mapId2, dirs), startOffset, endOffset - startOffset);
        }
        return fileSegmentManagedBuffer;
    }

    @Override
    public void stop() {
    }

    public IndexShuffleBlockResolver(SparkConf conf, BlockManager _blockManager) {
        this._blockManager = _blockManager;
        Logging.$init$(this);
        this.transportConf = SparkTransportConf$.MODULE$.fromSparkConf(conf, "shuffle", SparkTransportConf$.MODULE$.fromSparkConf$default$3(), SparkTransportConf$.MODULE$.fromSparkConf$default$4());
    }
}

