/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001Q3a\u0001B\u0003\u0002\u0002\u0015y\u0001\"\u0002\f\u0001\t\u0003A\u0002\"B\u000e\u0001\t\u0003a\u0002\"B\u001d\u0001\t\u0003Q$AC*jY\"|W/\u001a;uK*\u0011aaB\u0001\u000bKZ\fG.^1uS>t'B\u0001\u0005\n\u0003\tiGN\u0003\u0002\u000b\u0017\u0005)1\u000f]1sW*\u0011A\"D\u0001\u0007CB\f7\r[3\u000b\u00039\t1a\u001c:h'\t\u0001\u0001\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t\u0011\u0004\u0005\u0002\u001b\u00015\tQ!\u0001\u000eq_&tGoU5mQ>,X\r\u001e;f\u0007>,gMZ5dS\u0016tG\u000fF\u0003\u001eA5zC\u0007\u0005\u0002\u0012=%\u0011qD\u0005\u0002\u0007\t>,(\r\\3\t\u000b\u0005\u0012\u0001\u0019\u0001\u0012\u0002\u0015\rdWo\u001d;fe&#7\u000fE\u0002$Uuq!\u0001\n\u0015\u0011\u0005\u0015\u0012R\"\u0001\u0014\u000b\u0005\u001d:\u0012A\u0002\u001fs_>$h(\u0003\u0002*%\u00051\u0001K]3eK\u001aL!a\u000b\u0017\u0003\u0007M+GO\u0003\u0002*%!)aF\u0001a\u0001;\u0005q\u0001o\\5oi\u000ecWo\u001d;fe&#\u0007\"\u0002\u0019\u0003\u0001\u0004\t\u0014a\u00069pS:$8\t\\;ti\u0016\u0014h*^7PMB{\u0017N\u001c;t!\t\t\"'\u0003\u00024%\t!Aj\u001c8h\u0011\u0015)$\u00011\u00017\u0003a\tg/\u001a:bO\u0016$\u0015n\u001d;b]\u000e,Gk\\\"mkN$XM\u001d\t\u0005#]jR$\u0003\u00029%\tIa)\u001e8di&|g.M\u0001\r_Z,'/\u00197m'\u000e|'/\u001a\u000b\u0004;mr\u0005\"\u0002\u001f\u0004\u0001\u0004i\u0014A\u00013g!\tq4J\u0004\u0002@\u0011:\u0011\u0001I\u0012\b\u0003\u0003\u0016s!A\u0011#\u000f\u0005\u0015\u001a\u0015\"\u0001\b\n\u00051i\u0011B\u0001\u0006\f\u0013\t9\u0015\"A\u0002tc2L!!\u0013&\u0002\u000fA\f7m[1hK*\u0011q)C\u0005\u0003\u00196\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005%S\u0005\"B(\u0004\u0001\u0004\u0001\u0016aC:d_J,7i\u001c7v[:\u0004\"!\u0015*\u000e\u0003)K!a\u0015&\u0003\r\r{G.^7o\u0001")
public abstract class Silhouette {
    public double pointSilhouetteCoefficient(Set<Object> clusterIds, double pointClusterId, long pointClusterNumOfPoints, Function1<Object, Object> averageDistanceToCluster) {
        double d;
        if (pointClusterNumOfPoints == 1L) {
            d = 0.0;
        } else {
            Set otherClusterIds = (Set)clusterIds.filter((Function1)(JFunction1.mcZD.sp & java.io.Serializable & Serializable)x$1 -> x$1 != pointClusterId);
            double neighboringClusterDissimilarity = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)otherClusterIds.map(averageDistanceToCluster, Set$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Double$.MODULE$));
            double currentClusterDissimilarity = averageDistanceToCluster.apply$mcDD$sp(pointClusterId) * (double)pointClusterNumOfPoints / (double)(pointClusterNumOfPoints - 1L);
            d = currentClusterDissimilarity < neighboringClusterDissimilarity ? 1.0 - currentClusterDissimilarity / neighboringClusterDissimilarity : (currentClusterDissimilarity > neighboringClusterDissimilarity ? neighboringClusterDissimilarity / currentClusterDissimilarity - 1.0 : 0.0);
        }
        return d;
    }

    public double overallScore(Dataset<Row> df, Column scoreColumn) {
        return ((Row[])df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.avg(scoreColumn)})).collect())[0].getDouble(0);
    }
}

