/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.DatePart$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Extract$;
import org.apache.spark.sql.catalyst.expressions.RuntimeReplaceable;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(field FROM source) - Extracts a part of the date/timestamp or interval source.", arguments="\n    Arguments:\n      * field - selects which part of the source should be extracted\n          - Supported string values of `field` for dates and timestamps are(case insensitive):\n              - \"YEAR\", (\"Y\", \"YEARS\", \"YR\", \"YRS\") - the year field\n              - \"YEAROFWEEK\" - the ISO 8601 week-numbering year that the datetime falls in. For example, 2005-01-02 is part of the 53rd week of year 2004, so the result is 2004\n              - \"QUARTER\", (\"QTR\") - the quarter (1 - 4) of the year that the datetime falls in\n              - \"MONTH\", (\"MON\", \"MONS\", \"MONTHS\") - the month field (1 - 12)\n              - \"WEEK\", (\"W\", \"WEEKS\") - the number of the ISO 8601 week-of-week-based-year. A week is considered to start on a Monday and week 1 is the first week with >3 days. In the ISO week-numbering system, it is possible for early-January dates to be part of the 52nd or 53rd week of the previous year, and for late-December dates to be part of the first week of the next year. For example, 2005-01-02 is part of the 53rd week of year 2004, while 2012-12-31 is part of the first week of 2013\n              - \"DAY\", (\"D\", \"DAYS\") - the day of the month field (1 - 31)\n              - \"DAYOFWEEK\",(\"DOW\") - the day of the week for datetime as Sunday(1) to Saturday(7)\n              - \"DAYOFWEEK_ISO\",(\"DOW_ISO\") - ISO 8601 based day of the week for datetime as Monday(1) to Sunday(7)\n              - \"DOY\" - the day of the year (1 - 365/366)\n              - \"HOUR\", (\"H\", \"HOURS\", \"HR\", \"HRS\") - The hour field (0 - 23)\n              - \"MINUTE\", (\"M\", \"MIN\", \"MINS\", \"MINUTES\") - the minutes field (0 - 59)\n              - \"SECOND\", (\"S\", \"SEC\", \"SECONDS\", \"SECS\") - the seconds field, including fractional parts\n          - Supported string values of `field` for interval(which consists of `months`, `days`, `microseconds`) are(case insensitive):\n              - \"YEAR\", (\"Y\", \"YEARS\", \"YR\", \"YRS\") - the total `months` / 12\n              - \"MONTH\", (\"MON\", \"MONS\", \"MONTHS\") - the total `months` % 12\n              - \"DAY\", (\"D\", \"DAYS\") - the `days` part of interval\n              - \"HOUR\", (\"H\", \"HOURS\", \"HR\", \"HRS\") - how many hours the `microseconds` contains\n              - \"MINUTE\", (\"M\", \"MIN\", \"MINS\", \"MINUTES\") - how many minutes left after taking hours from `microseconds`\n              - \"SECOND\", (\"S\", \"SEC\", \"SECONDS\", \"SECS\") - how many second with fractions left after taking hours and minutes from `microseconds`\n      * source - a date/timestamp or interval column from where `field` should be extracted\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(YEAR FROM TIMESTAMP '2019-08-12 01:00:00.123456');\n       2019\n      > SELECT _FUNC_(week FROM timestamp'2019-08-12 01:00:00.123456');\n       33\n      > SELECT _FUNC_(doy FROM DATE'2019-08-12');\n       224\n      > SELECT _FUNC_(SECONDS FROM timestamp'2019-10-01 00:00:01.000001');\n       1.000001\n      > SELECT _FUNC_(days FROM interval 1 year 10 months 5 days);\n       5\n      > SELECT _FUNC_(seconds FROM interval 5 hours 30 seconds 1 milliseconds 1 microseconds);\n       30.001001\n  ", note="\n    The _FUNC_ function is equivalent to `date_part(field, source)`.\n  ", since="3.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015f\u0001B\u000f\u001f\u0001.B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005}!A!\t\u0001BK\u0002\u0013\u0005Q\b\u0003\u0005D\u0001\tE\t\u0015!\u0003?\u0011!!\u0005A!f\u0001\n\u0003i\u0004\u0002C#\u0001\u0005#\u0005\u000b\u0011\u0002 \t\u000b\u0019\u0003A\u0011A$\t\u000b\u0019\u0003A\u0011\u0001'\t\u000b=\u0003A\u0011\t)\t\u000b\r\u0002A\u0011\t1\t\u000b%\u0004A\u0011\t1\t\u000f)\u0004\u0011\u0011!C\u0001W\"9q\u000eAI\u0001\n\u0003\u0001\bbB>\u0001#\u0003%\t\u0001\u001d\u0005\by\u0002\t\n\u0011\"\u0001q\u0011\u001di\b!!A\u0005ByD\u0011\"!\u0004\u0001\u0003\u0003%\t!a\u0004\t\u0013\u0005]\u0001!!A\u0005\u0002\u0005e\u0001\"CA\u0010\u0001\u0005\u0005I\u0011IA\u0011\u0011%\ti\u0003AA\u0001\n\u0003\ty\u0003C\u0005\u0002:\u0001\t\t\u0011\"\u0011\u0002<\u001dI\u0011Q\r\u0010\u0002\u0002#\u0005\u0011q\r\u0004\t;y\t\t\u0011#\u0001\u0002j!1ai\u0006C\u0001\u0003oB\u0011\"!\u001f\u0018\u0003\u0003%)%a\u001f\t\u0013\u0005ut#!A\u0005\u0002\u0006}\u0004\"CAD/\u0005\u0005I\u0011QAE\u0011%\tYjFA\u0001\n\u0013\tiJA\u0004FqR\u0014\u0018m\u0019;\u000b\u0005}\u0001\u0013aC3yaJ,7o]5p]NT!!\t\u0012\u0002\u0011\r\fG/\u00197zgRT!a\t\u0013\u0002\u0007M\fHN\u0003\u0002&M\u0005)1\u000f]1sW*\u0011q\u0005K\u0001\u0007CB\f7\r[3\u000b\u0003%\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u00171ge\u0002\"!\f\u0018\u000e\u0003yI!a\f\u0010\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"!L\u0019\n\u0005Ir\"A\u0005*v]RLW.\u001a*fa2\f7-Z1cY\u0016\u0004\"\u0001N\u001c\u000e\u0003UR\u0011AN\u0001\u0006g\u000e\fG.Y\u0005\u0003qU\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u00025u%\u00111(\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006M&,G\u000eZ\u000b\u0002}A\u0011QfP\u0005\u0003\u0001z\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0003\u00191\u0017.\u001a7eA\u000511o\\;sG\u0016\fqa]8ve\u000e,\u0007%A\u0003dQ&dG-\u0001\u0004dQ&dG\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t!K%j\u0013\t\u0003[\u0001AQ\u0001P\u0004A\u0002yBQAQ\u0004A\u0002yBQ\u0001R\u0004A\u0002y\"2\u0001S'O\u0011\u0015a\u0004\u00021\u0001?\u0011\u0015\u0011\u0005\u00021\u0001?\u000351G.\u0019;Be\u001e,X.\u001a8ugV\t\u0011\u000bE\u0002S5vs!a\u0015-\u000f\u0005Q;V\"A+\u000b\u0005YS\u0013A\u0002\u001fs_>$h(C\u00017\u0013\tIV'A\u0004qC\u000e\\\u0017mZ3\n\u0005mc&\u0001C%uKJ\fGo\u001c:\u000b\u0005e+\u0004C\u0001\u001b_\u0013\tyVGA\u0002B]f,\u0012!\u0019\t\u0003E\u001at!a\u00193\u0011\u0005Q+\u0014BA36\u0003\u0019\u0001&/\u001a3fM&\u0011q\r\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015,\u0014A\u00039sKR$\u0018PT1nK\u0006!1m\u001c9z)\u0011AE.\u001c8\t\u000fqb\u0001\u0013!a\u0001}!9!\t\u0004I\u0001\u0002\u0004q\u0004b\u0002#\r!\u0003\u0005\rAP\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\u0005\t(F\u0001 sW\u0005\u0019\bC\u0001;z\u001b\u0005)(B\u0001<x\u0003%)hn\u00195fG.,GM\u0003\u0002yk\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005i,(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003}\u0004B!!\u0001\u0002\f5\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0003mC:<'BAA\u0005\u0003\u0011Q\u0017M^1\n\u0007\u001d\f\u0019!\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\u0012A\u0019A'a\u0005\n\u0007\u0005UQGA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002^\u00037A\u0011\"!\b\u0013\u0003\u0003\u0005\r!!\u0005\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\u0019\u0003E\u0003\u0002&\u0005-R,\u0004\u0002\u0002()\u0019\u0011\u0011F\u001b\u0002\u0015\r|G\u000e\\3di&|g.C\u0002\\\u0003O\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003c\t9\u0004E\u00025\u0003gI1!!\u000e6\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\b\u0015\u0003\u0003\u0005\r!X\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005E\u0012Q\b\u0005\t\u0003;)\u0012\u0011!a\u0001;\":\u0002!!\u0011\u0002H\u0005%\u0013QJA(\u0003'\n)&!\u0017\u0002\\\u0005}\u0013\u0011\r\t\u0004[\u0005\r\u0013bAA#=\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA&\u0003U{f)\u0016(D?\"2\u0017.\u001a7eA\u0019\u0013v*\u0014\u0011t_V\u00148-Z\u0015![\u0001*\u0005\u0010\u001e:bGR\u001c\b%\u0019\u0011qCJ$\be\u001c4!i\",\u0007\u0005Z1uK>\"\u0018.\\3ti\u0006l\u0007\u000fI8sA%tG/\u001a:wC2\u00043o\\;sG\u0016t\u0013!C1sOVlWM\u001c;tC\t\t\t&AJf\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u0002c-[3mI\u0002j\u0003e]3mK\u000e$8\u000fI<iS\u000eD\u0007\u0005]1si\u0002zg\r\t;iK\u0002\u001ax.\u001e:dK\u0002\u001a\bn\\;mI\u0002\u0012W\rI3yiJ\f7\r^3e\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011TkB\u0004xN\u001d;fI\u0002\u001aHO]5oO\u00022\u0018\r\\;fg\u0002zg\r\t1gS\u0016dG\r\u0019\u0011g_J\u0004C-\u0019;fg\u0002\ng\u000e\u001a\u0011uS6,7\u000f^1naN\u0004\u0013M]3)G\u0006\u001cX\rI5og\u0016t7/\u001b;jm\u0016L#H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!Ee+\u0015I\u0015\u0012-A!\u0012\u0013L\t\u0017!Ee+\u0015IU*#Y\u0001\u0012\u0013L\u0015\u0012-A\tJ&k\u0015\u0012*A5\u0002C\u000f[3!s\u0016\f'\u000f\t4jK2$'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#3\u0016\u000b%k\u0014$X\u000b\u0016[%\u0005I\u0017!i\",\u0007%S*PAa2\u0004'\r\u0011xK\u0016\\WF\\;nE\u0016\u0014\u0018N\\4!s\u0016\f'\u000f\t;iCR\u0004C\u000f[3!I\u0006$X\r^5nK\u00022\u0017\r\u001c7tA%tg\u0006\t$pe\u0002*\u00070Y7qY\u0016d\u0003E\r\u00191k5\u0002\u0014'\f\u00193A%\u001c\b\u0005]1si\u0002zg\r\t;iK\u0002*4G\u001d3!o\u0016,7\u000eI8gAe,\u0017M\u001d\u00113aA\"D\u0006I:pAQDW\r\t:fgVdG\u000fI5tAI\u0002\u0004\u0007\u000e\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\t\nV+\u0011*U\u000bJ\u0013C\u0006\t\u0015##R\u0013&%\u000b\u0011.AQDW\rI9vCJ$XM\u001d\u0011)c\u0001j\u0003\u0005N\u0015!_\u001a\u0004C\u000f[3!s\u0016\f'\u000f\t;iCR\u0004C\u000f[3!I\u0006$X\r^5nK\u00022\u0017\r\u001c7tA%t'\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#\u001b>sE\u000b\u0013\u0012-A!\u0012Sj\u0014(#Y\u0001\u0012Sj\u0014(TE1\u0002#%T(O)\"\u001b&%\u000b\u0011.AQDW\rI7p]RD\u0007EZ5fY\u0012\u0004\u0003&\r\u0011.AE\u0012\u0014F\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E]+Ui\u0013\u0012-A!\u0012sK\t\u0017!E]+UiS*#S\u0001j\u0003\u0005\u001e5fA9,XNY3sA=4\u0007\u0005\u001e5fA%\u001bv\n\t\u001d7aE\u0002s/Z3l[=4Wf^3fW6\u0012\u0017m]3e[e,\u0017M\u001d\u0018!\u0003\u0002:X-Z6!SN\u00043m\u001c8tS\u0012,'/\u001a3!i>\u00043\u000f^1si\u0002zg\u000eI1!\u001b>tG-Y=!C:$\u0007e^3fW\u0002\n\u0004%[:!i\",\u0007EZ5sgR\u0004s/Z3lA]LG\u000f\u001b\u0011?g\u0001\"\u0017-_:/A%s\u0007\u0005\u001e5fA%\u001bv\nI<fK.lc.^7cKJLgn\u001a\u0011tsN$X-\u001c\u0017!SR\u0004\u0013n\u001d\u0011q_N\u001c\u0018N\u00197fA\u0019|'\u000fI3be2LXFS1ok\u0006\u0014\u0018\u0010\t3bi\u0016\u001c\b\u0005^8!E\u0016\u0004\u0003/\u0019:uA=4\u0007\u0005\u001e5fAU\u0012d\u000e\u001a\u0011pe\u0002*4G\u001d3!o\u0016,7\u000eI8gAQDW\r\t9sKZLw.^:!s\u0016\f'\u000f\f\u0011b]\u0012\u0004cm\u001c:!Y\u0006$X-\f#fG\u0016l'-\u001a:!I\u0006$Xm\u001d\u0011u_\u0002\u0012W\r\t9beR\u0004sN\u001a\u0011uQ\u0016\u0004c-\u001b:ti\u0002:X-Z6!_\u001a\u0004C\u000f[3!]\u0016DH\u000fI=fCJt\u0003ER8sA\u0015D\u0018-\u001c9mK2\u0002#\u0007\r\u00196[A\nT\u0006\r\u001a!SN\u0004\u0003/\u0019:uA=4\u0007\u0005\u001e5fAU\u001a$\u000f\u001a\u0011xK\u0016\\\u0007e\u001c4!s\u0016\f'\u000f\t\u001a1aQb\u0003e\u001e5jY\u0016\u0004#\u0007M\u00193[E\u0012TfM\u0019!SN\u0004\u0003/\u0019:uA=4\u0007\u0005\u001e5fA\u0019L'o\u001d;!o\u0016,7\u000eI8gAI\u0002\u0014g\r\u0006!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011.A\t\"\u0015)\u0017\u0012-A!\u0012CI\t\u0017!E\u0011\u000b\u0015l\u0015\u0012*A5\u0002C\u000f[3!I\u0006L\be\u001c4!i\",\u0007%\\8oi\"\u0004c-[3mI\u0002B\u0013\u0007I\u0017!gEJ#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#\t\u0006KvJR,F\u000b.\u0013C\u0006\u000b\u0012E\u001f^\u0013\u0013\u0006I\u0017!i\",\u0007\u0005Z1zA=4\u0007\u0005\u001e5fA],Wm\u001b\u0011g_J\u0004C-\u0019;fi&lW\rI1tAM+h\u000eZ1zQEJ\u0003\u0005^8!'\u0006$XO\u001d3bs\":\u0014F\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E\u0011\u000b\u0015l\u0014$X\u000b\u0016[u,S*PE1B#\u0005R(X?&\u001bvJI\u0015![\u0001J5k\u0014\u00119mA\n\u0004EY1tK\u0012\u0004C-Y=!_\u001a\u0004C\u000f[3!o\u0016,7\u000e\t4pe\u0002\"\u0017\r^3uS6,\u0007%Y:!\u001b>tG-Y=)c%\u0002Co\u001c\u0011Tk:$\u0017-\u001f\u00158S)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003E\t#P3\n\u0002S\u0006\t;iK\u0002\"\u0017-\u001f\u0011pM\u0002\"\b.\u001a\u0011zK\u0006\u0014\b\u0005K\u0019![\u0001\u001ad'N\u00184mYJ#\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#\u0011>+&K\t\u0017!Q\tB%\u0005\f\u0011#\u0011>+&k\u0015\u0012-A\tB%K\t\u0017!E!\u00136KI\u0015![\u0001\"\u0006.\u001a\u0011i_V\u0014\bEZ5fY\u0012\u0004\u0003\u0006\r\u0011.AI\u001a\u0014F\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E5Ke*\u0016+FE1\u0002\u0003FI'#Y\u0001\u0012S*\u0013(#Y\u0001\u0012S*\u0013(TE1\u0002#%T%O+R+5KI\u0015![\u0001\"\b.\u001a\u0011nS:,H/Z:!M&,G\u000e\u001a\u0011)a\u0001j\u0003%N\u001d*\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#eU#D\u001f:#%\u0005\f\u0011)EM\u0013C\u0006\t\u0012T\u000b\u000e\u0013C\u0006\t\u0012T\u000b\u000e{e\nR*#Y\u0001\u00123+R\"TE%\u0002S\u0006\t;iK\u0002\u001aXmY8oIN\u0004c-[3mI2\u0002\u0013N\\2mk\u0012Lgn\u001a\u0011ge\u0006\u001cG/[8oC2\u0004\u0003/\u0019:ug*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!'V\u0004\bo\u001c:uK\u0012\u00043\u000f\u001e:j]\u001e\u0004c/\u00197vKN\u0004sN\u001a\u0011aM&,G\u000e\u001a1!M>\u0014\b%\u001b8uKJ4\u0018\r\u001c\u0015xQ&\u001c\u0007\u000eI2p]NL7\u000f^:!_\u001a\u0004\u0003-\\8oi\"\u001c\b\r\f\u0011aI\u0006L8\u000f\u0019\u0017!A6L7M]8tK\u000e|g\u000eZ:aS\u0001\n'/\u001a\u0015dCN,\u0007%\u001b8tK:\u001c\u0018\u000e^5wK&R$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003%\f\u0011#3\u0016\u000b%K\t\u0017!Q\tJ&\u0005\f\u0011#3\u0016\u000b%k\u0015\u0012-A\tJ&K\t\u0017!Ee\u00136KI\u0015![\u0001\"\b.\u001a\u0011u_R\fG\u000e\t1n_:$\bn\u001d1!_\u0001\n$G\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E5{e\n\u0016%#Y\u0001B#%T(OE1\u0002#%T(O'\nb\u0003EI'P\u001dRC5KI\u0015![\u0001\"\b.\u001a\u0011u_R\fG\u000e\t1n_:$\bn\u001d1!K\u0001\n$G\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005I\u0017!E\u0011\u000b\u0015L\t\u0017!Q\t\"%\u0005\f\u0011#\t\u0006K6KI\u0015![\u0001\"\b.\u001a\u0011aI\u0006L8\u000f\u0019\u0011qCJ$\be\u001c4!S:$XM\u001d<bY*\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001j\u0003E\t%P+J\u0013C\u0006\t\u0015#\u0011\nb\u0003E\t%P+J\u001b&\u0005\f\u0011#\u0011J\u0013C\u0006\t\u0012I%N\u0013\u0013\u0006I\u0017!Q><\b%\\1os\u0002Bw.\u001e:tAQDW\r\t1nS\u000e\u0014xn]3d_:$7\u000f\u0019\u0011d_:$\u0018-\u001b8t\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A5\u0002#%T%O+R+%\u0005\f\u0011)E5\u0013C\u0006\t\u0012N\u0013:\u0013C\u0006\t\u0012N\u0013:\u001b&\u0005\f\u0011#\u001b&sU\u000bV#TE%\u0002S\u0006\t5po\u0002j\u0017M\\=![&tW\u000f^3tA1,g\r\u001e\u0011bMR,'\u000f\t;bW&tw\r\t5pkJ\u001c\bE\u001a:p[\u0002\u0002W.[2s_N,7m\u001c8eg\u0002T\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005\t\u0011!A\u0001\u0002S\u0006\t\u0012T\u000b\u000e{e\n\u0012\u0012-A!\u00123K\t\u0017!EM+5I\t\u0017!EM+5i\u0014(E'\nb\u0003EI*F\u0007N\u0013\u0013\u0006I\u0017!Q><\b%\\1os\u0002\u001aXmY8oI\u0002:\u0018\u000e\u001e5!MJ\f7\r^5p]N\u0004C.\u001a4uA\u00054G/\u001a:!i\u0006\\\u0017N\\4!Q>,(o\u001d\u0011b]\u0012\u0004S.\u001b8vi\u0016\u001c\bE\u001a:p[\u0002\u0002W.[2s_N,7m\u001c8eg\u0002T\u0001\u0005\t\u0011!A\u0001R\u0003e]8ve\u000e,\u0007%\f\u0011bA\u0011\fG/Z\u0018uS6,7\u000f^1na\u0002z'\u000fI5oi\u0016\u0014h/\u00197!G>dW/\u001c8!MJ|W\u000eI<iKJ,\u0007\u0005\u00194jK2$\u0007\rI:i_VdG\r\t2fA\u0015DHO]1di\u0016$'\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\u0016\u0002\t3Q\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&W#B%\u00022%kT'!)&kUi\u0015+B\u001bB\u0003sE\r\u00192s5\u0002\u0004(L\u00193AA\n$\b\r\u0019;aAr\u0013GM\u001a5kY:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113aEJ$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK<fK.\u0004cIU(NAQLW.Z:uC6\u0004xE\r\u00192s5\u0002\u0004(L\u00193AA\n$\b\r\u0019;aAr\u0013GM\u001a5kY:\u0013f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00114g)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~CCm\\=!\rJ{U\n\t#B)\u0016;#\u0007M\u0019:[ABT&\r\u001a(SmR\u0001\u0005\t\u0011!A\u0001\u0002#G\r\u001b\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QM+5i\u0014(E'\u00022%kT'!i&lWm\u001d;b[B<#\u0007M\u0019:[E\u0002T\u0006M\u0019!aAR\u0004\u0007\r\u001e1c9\u0002\u0004\u0007\r\u00191c\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I\u0019/aA\u0002\u0004\u0007M\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0011\f\u0017p\u001d\u0011G%>k\u0005%\u001b8uKJ4\u0018\r\u001c\u00112Ae,\u0017M\u001d\u00112a\u0001jwN\u001c;ig\u0002*\u0004\u0005Z1zg&Z$\u0002\t\u0011!A\u0001\u0002\u0003%\u000e\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)g\u0016\u001cwN\u001c3tA\u0019\u0013v*\u0014\u0011j]R,'O^1mAU\u0002\u0003n\\;sg\u0002\u001a\u0004\u0007I:fG>tGm\u001d\u00112A5LG\u000e\\5tK\u000e|g\u000eZ:!c\u0001j\u0017n\u0019:pg\u0016\u001cwN\u001c3tSmR\u0001\u0005\t\u0011!A\u0001\u00023\u0007\r\u00181aE\u0002\u0004'\r\u0006!A\u0005!an\u001c;fC\t\ti&\u0001%\u000bA\u0001\u0002\u0003\u0005\u00165fA}3UKT\"`A\u0019,hn\u0019;j_:\u0004\u0013n\u001d\u0011fcVLg/\u00197f]R\u0004Co\u001c\u0011aI\u0006$Xm\u00189beRDc-[3mI2\u00023o\\;sG\u0016L\u0003M\f\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u00111M\u0001\u0006g9\u0002d\u0006M\u0001\b\u000bb$(/Y2u!\tisc\u0005\u0003\u0018\u0003WJ\u0004\u0003CA7\u0003grdH\u0010%\u000e\u0005\u0005=$bAA9k\u00059!/\u001e8uS6,\u0017\u0002BA;\u0003_\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\t9'\u0001\u0005u_N#(/\u001b8h)\u0005y\u0018!B1qa2LHc\u0002%\u0002\u0002\u0006\r\u0015Q\u0011\u0005\u0006yi\u0001\rA\u0010\u0005\u0006\u0005j\u0001\rA\u0010\u0005\u0006\tj\u0001\rAP\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tY)a&\u0011\u000bQ\ni)!%\n\u0007\u0005=UG\u0001\u0004PaRLwN\u001c\t\u0007i\u0005MeH\u0010 \n\u0007\u0005UUG\u0001\u0004UkBdWm\r\u0005\t\u00033[\u0012\u0011!a\u0001\u0011\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003?\u0003B!!\u0001\u0002\"&!\u00111UA\u0002\u0005\u0019y%M[3di\u0002")
public class Extract
extends UnaryExpression
implements RuntimeReplaceable,
Serializable {
    private final Expression field;
    private final Expression source;
    private final Expression child;
    private Expression canonicalized;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Extract extract2) {
        return Extract$.MODULE$.unapply(extract2);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Extract> tupled() {
        return Extract$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Extract>>> curried() {
        return Extract$.MODULE$.curried();
    }

    @Override
    public boolean nullable() {
        return RuntimeReplaceable.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return RuntimeReplaceable.foldable$(this);
    }

    @Override
    public DataType dataType() {
        return RuntimeReplaceable.dataType$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    private Expression canonicalized$lzycompute() {
        Extract extract2 = this;
        synchronized (extract2) {
            if (!this.bitmap$0) {
                this.canonicalized = RuntimeReplaceable.canonicalized$(this);
                this.bitmap$0 = true;
            }
        }
        return this.canonicalized;
    }

    @Override
    public Expression canonicalized() {
        return !this.bitmap$0 ? this.canonicalized$lzycompute() : this.canonicalized;
    }

    public Expression field() {
        return this.field;
    }

    public Expression source() {
        return this.source;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Iterator<Object> flatArguments() {
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.field(), this.source()}));
    }

    @Override
    public String sql() {
        return new StringBuilder(8).append(this.prettyName()).append("(").append(this.field().sql()).append(" FROM ").append(this.source().sql()).append(")").toString();
    }

    @Override
    public String prettyName() {
        return "extract";
    }

    public Extract copy(Expression field, Expression source, Expression child) {
        return new Extract(field, source, child);
    }

    public Expression copy$default$1() {
        return this.field();
    }

    public Expression copy$default$2() {
        return this.source();
    }

    public Expression copy$default$3() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Extract";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.field();
                break;
            }
            case 1: {
                expression = this.source();
                break;
            }
            case 2: {
                expression = this.child();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Extract;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Extract)) return false;
        boolean bl = true;
        if (!bl) return false;
        Extract extract2 = (Extract)x$1;
        Expression expression = this.field();
        Expression expression2 = extract2.field();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.source();
        Expression expression4 = extract2.source();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.child();
        Expression expression6 = extract2.child();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!extract2.canEqual(this)) return false;
        return true;
    }

    public Extract(Expression field, Expression source, Expression child) {
        this.field = field;
        this.source = source;
        this.child = child;
        Unevaluable.$init$(this);
        RuntimeReplaceable.$init$(this);
    }

    public Extract(Expression field, Expression source) {
        this(field, source, DatePart$.MODULE$.toEquivalentExpr(field, source));
    }
}

