/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.ArrowBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.apache.arrow.memory.ArrowByteBufAllocator;
import org.apache.arrow.memory.BoundsChecking;
import org.apache.arrow.util.Preconditions;

public class NettyArrowBuf
extends AbstractByteBuf
implements AutoCloseable {
    private final ArrowBuf arrowBuf;
    private final ArrowByteBufAllocator arrowByteBufAllocator;
    private int length;
    private final long address;

    public NettyArrowBuf(ArrowBuf arrowBuf, ByteBufAllocator arrowByteBufAllocator, int length) {
        super(length);
        this.arrowBuf = arrowBuf;
        this.arrowByteBufAllocator = (ArrowByteBufAllocator)arrowByteBufAllocator;
        this.length = length;
        this.address = arrowBuf.memoryAddress();
    }

    public ByteBuf copy() {
        throw new UnsupportedOperationException();
    }

    public ByteBuf copy(int index, int length) {
        throw new UnsupportedOperationException();
    }

    public ByteBuf retain() {
        this.arrowBuf.getReferenceManager().retain();
        return this;
    }

    public ArrowBuf arrowBuf() {
        return this.arrowBuf;
    }

    public ByteBuf retain(int increment) {
        this.arrowBuf.getReferenceManager().retain(increment);
        return this;
    }

    public boolean isDirect() {
        return true;
    }

    public synchronized ByteBuf capacity(int newCapacity) {
        if (newCapacity == this.length) {
            return this;
        }
        Preconditions.checkArgument(newCapacity >= 0);
        if (newCapacity < this.length) {
            this.length = newCapacity;
            return this;
        }
        throw new UnsupportedOperationException("Buffers don't support resizing that increases the size.");
    }

    public ByteBuf unwrap() {
        throw new UnsupportedOperationException("Unwrap not supported.");
    }

    public int refCnt() {
        return this.arrowBuf.getReferenceManager().getRefCount();
    }

    public ArrowByteBufAllocator alloc() {
        return this.arrowByteBufAllocator;
    }

    public boolean hasArray() {
        return false;
    }

    public byte[] array() {
        throw new UnsupportedOperationException("Operation not supported on direct buffer");
    }

    public int arrayOffset() {
        throw new UnsupportedOperationException("Operation not supported on direct buffer");
    }

    public boolean hasMemoryAddress() {
        return true;
    }

    public long memoryAddress() {
        return this.address;
    }

    public ByteBuf touch() {
        return this;
    }

    public ByteBuf touch(Object hint) {
        return this;
    }

    public int capacity() {
        return this.arrowBuf.capacity();
    }

    public NettyArrowBuf slice() {
        return this.arrowBuf.slice(this.readerIndex, this.writerIndex - this.readerIndex).asNettyBuffer();
    }

    public NettyArrowBuf slice(int index, int length) {
        return this.arrowBuf.slice(index, length).asNettyBuffer();
    }

    @Override
    public void close() {
        this.arrowBuf.close();
    }

    public boolean release() {
        return this.arrowBuf.getReferenceManager().release();
    }

    public boolean release(int decrement) {
        return this.arrowBuf.getReferenceManager().release(decrement);
    }

    public NettyArrowBuf readerIndex(int readerIndex) {
        super.readerIndex(readerIndex);
        return this;
    }

    public NettyArrowBuf writerIndex(int writerIndex) {
        super.writerIndex(writerIndex);
        return this;
    }

    public int nioBufferCount() {
        return 1;
    }

    public ByteBuffer internalNioBuffer(int index, int length) {
        ByteBuffer nioBuf = this.getDirectBuffer(index);
        return (ByteBuffer)nioBuf.clear().limit(length);
    }

    public ByteBuffer[] nioBuffers() {
        return new ByteBuffer[]{this.nioBuffer()};
    }

    public ByteBuffer[] nioBuffers(int index, int length) {
        return new ByteBuffer[]{this.nioBuffer(index, length)};
    }

    public ByteBuffer nioBuffer() {
        return this.nioBuffer(this.readerIndex(), this.readableBytes());
    }

    public ByteBuffer nioBuffer(int index, int length) {
        this.chk(index, length);
        ByteBuffer buffer = this.getDirectBuffer(index);
        buffer.limit(length);
        return buffer;
    }

    private ByteBuffer getDirectBuffer(int index) {
        return PlatformDependent.directBuffer((long)this.addr(index), (int)(this.length - index));
    }

    public ByteBuf getBytes(int index, ByteBuffer dst) {
        this.arrowBuf.getBytes(index, dst);
        return this;
    }

    public ByteBuf setBytes(int index, ByteBuffer src) {
        this.arrowBuf.setBytes(index, src);
        return this;
    }

    public ByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.arrowBuf.getBytes(index, dst, dstIndex, length);
        return this;
    }

    public ByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        this.arrowBuf.setBytes(index, src, srcIndex, length);
        return this;
    }

    private static boolean isOutOfBounds(int index, int length, int capacity) {
        return (index | length | index + length | capacity - (index + length)) < 0;
    }

    public ByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.chk(index, length);
        Preconditions.checkArgument(dst != null, "Expecting valid dst ByteBuffer");
        if (NettyArrowBuf.isOutOfBounds(dstIndex, length, dst.capacity())) {
            throw new IndexOutOfBoundsException("dstIndex: " + dstIndex + " length: " + length);
        }
        long srcAddress = this.addr(index);
        if (dst.hasMemoryAddress()) {
            long dstAddress = dst.memoryAddress() + (long)dstIndex;
            PlatformDependent.copyMemory((long)srcAddress, (long)dstAddress, (long)length);
        } else if (dst.hasArray()) {
            PlatformDependent.copyMemory((long)srcAddress, (byte[])dst.array(), (int)(dstIndex += dst.arrayOffset()), (long)length);
        } else {
            dst.setBytes(dstIndex, (ByteBuf)this, index, length);
        }
        return this;
    }

    public ByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.chk(index, length);
        Preconditions.checkArgument(src != null, "Expecting valid src ByteBuffer");
        if (NettyArrowBuf.isOutOfBounds(srcIndex, length, src.capacity())) {
            throw new IndexOutOfBoundsException("srcIndex: " + srcIndex + " length: " + length);
        }
        if (length != 0) {
            long dstAddress = this.addr(index);
            if (src.hasMemoryAddress()) {
                long srcAddress = src.memoryAddress() + (long)srcIndex;
                PlatformDependent.copyMemory((long)srcAddress, (long)dstAddress, (long)length);
            } else if (src.hasArray()) {
                PlatformDependent.copyMemory((byte[])src.array(), (int)(srcIndex += src.arrayOffset()), (long)dstAddress, (long)length);
            } else {
                src.getBytes(srcIndex, (ByteBuf)this, index, length);
            }
        }
        return this;
    }

    public ByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        this.arrowBuf.getBytes(index, out, length);
        return this;
    }

    public int setBytes(int index, InputStream in, int length) throws IOException {
        return this.arrowBuf.setBytes(index, in, length);
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        Preconditions.checkArgument(out != null, "expecting valid gathering byte channel");
        this.chk(index, length);
        if (length == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = this.getDirectBuffer(index);
        tmpBuf.clear().limit(length);
        return out.write(tmpBuf);
    }

    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        this.chk(index, length);
        if (length == 0) {
            return 0;
        }
        ByteBuffer tmpBuf = this.getDirectBuffer(index);
        tmpBuf.clear().limit(length);
        return out.write(tmpBuf, position);
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        return (int)in.read(this.nioBuffers(index, length));
    }

    public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        return (int)in.read(this.nioBuffers(index, length));
    }

    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }

    public ByteBuf order(ByteOrder endianness) {
        return this;
    }

    protected int _getUnsignedMedium(int index) {
        return this.getUnsignedMedium(index);
    }

    protected int _getUnsignedMediumLE(int index) {
        this.chk(index, 3);
        long addr = this.addr(index);
        return PlatformDependent.getByte((long)addr) & 0xFF | (Short.reverseBytes(PlatformDependent.getShort((long)(addr + 1L))) & 0xFFFF) << 8;
    }

    protected byte _getByte(int index) {
        return this.getByte(index);
    }

    public byte getByte(int index) {
        return this.arrowBuf.getByte(index);
    }

    protected short _getShortLE(int index) {
        short s = this.getShort(index);
        return Short.reverseBytes(s);
    }

    protected short _getShort(int index) {
        return this.getShort(index);
    }

    public short getShort(int index) {
        return this.arrowBuf.getShort(index);
    }

    protected int _getIntLE(int index) {
        int value = this.getInt(index);
        return Integer.reverseBytes(value);
    }

    protected int _getInt(int index) {
        return this.getInt(index);
    }

    public int getInt(int index) {
        return this.arrowBuf.getInt(index);
    }

    protected long _getLongLE(int index) {
        long value = this.getLong(index);
        return Long.reverseBytes(value);
    }

    protected long _getLong(int index) {
        return this.getLong(index);
    }

    public long getLong(int index) {
        return this.arrowBuf.getLong(index);
    }

    protected void _setByte(int index, int value) {
        this.setByte(index, value);
    }

    public NettyArrowBuf setByte(int index, int value) {
        this.arrowBuf.setByte(index, value);
        return this;
    }

    protected void _setShortLE(int index, int value) {
        this.chk(index, 2);
        PlatformDependent.putShort((long)this.addr(index), (short)Short.reverseBytes((short)value));
    }

    protected void _setShort(int index, int value) {
        this.setShort(index, value);
    }

    public NettyArrowBuf setShort(int index, int value) {
        this.arrowBuf.setShort(index, value);
        return this;
    }

    private long addr(int index) {
        return this.address + (long)index;
    }

    private void chk(int index, int fieldLength) {
        if (BoundsChecking.BOUNDS_CHECKING_ENABLED) {
            this.ensureAccessible();
            if (fieldLength < 0) {
                throw new IllegalArgumentException("length: " + fieldLength + " (expected: >= 0)");
            }
            if (index < 0 || index > this.capacity() - fieldLength) {
                throw new IndexOutOfBoundsException(String.format("index: %d, length: %d (expected: range(0, %d))", index, fieldLength, this.capacity()));
            }
        }
    }

    protected void _setMedium(int index, int value) {
        this.setMedium(index, value);
    }

    protected void _setMediumLE(int index, int value) {
        this.chk(index, 3);
        long addr = this.addr(index);
        PlatformDependent.putByte((long)addr, (byte)((byte)value));
        PlatformDependent.putShort((long)(addr + 1L), (short)Short.reverseBytes((short)(value >>> 8)));
    }

    public NettyArrowBuf setMedium(int index, int value) {
        this.chk(index, 3);
        long addr = this.addr(index);
        PlatformDependent.putShort((long)addr, (short)((short)value));
        PlatformDependent.putByte((long)(addr + 2L), (byte)((byte)(value >>> 16)));
        return this;
    }

    protected void _setInt(int index, int value) {
        this.setInt(index, value);
    }

    protected void _setIntLE(int index, int value) {
        this.chk(index, 4);
        PlatformDependent.putInt((long)this.addr(index), (int)Integer.reverseBytes(value));
    }

    public NettyArrowBuf setInt(int index, int value) {
        this.arrowBuf.setInt(index, value);
        return this;
    }

    protected void _setLong(int index, long value) {
        this.setLong(index, value);
    }

    public void _setLongLE(int index, long value) {
        this.chk(index, 8);
        PlatformDependent.putLong((long)this.addr(index), (long)Long.reverseBytes(value));
    }

    public NettyArrowBuf setLong(int index, long value) {
        this.arrowBuf.setLong(index, value);
        return this;
    }
}

