/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.spark.metrics.source.HiveCatalogMetrics$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.execution.datasources.PartitioningAwareFileIndex;
import org.apache.spark.sql.execution.streaming.FileStreamSink$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.AbstractIterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.LinkedHashSet$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u00115b\u0001\u00028p\u0001qD!\"a\u0001\u0001\u0005\u0003\u0005\u000b\u0011BA\u0003\u0011)\ti\u0001\u0001B\u0001B\u0003%\u0011q\u0002\u0005\u000b\u0003w\u0001!\u0011!Q\u0001\n\u0005u\u0002BCA*\u0001\t\u0005\t\u0015!\u0003\u0002V!Q\u0011\u0011\u000e\u0001\u0003\u0002\u0003\u0006I!a\u001b\t\u0015\u0005E\u0004A!A!\u0002\u0013\t\u0019\b\u0003\u0006\u0002|\u0001\u0011)\u0019!C!\u0003{B!\"a\"\u0001\u0005\u0003\u0005\u000b\u0011BA@\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017C\u0011\"!(\u0001\u0005\u0004%\t%a(\t\u0011\u0005-\u0006\u0001)A\u0005\u0003CC1\"!,\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u00020\"Y\u00111\u0019\u0001A\u0002\u0003\u0007I\u0011BAc\u0011-\t\t\u000e\u0001a\u0001\u0002\u0003\u0006K!!-\t\u0017\u0005m\u0007\u00011AA\u0002\u0013%\u0011Q\u001c\u0005\f\u0003O\u0004\u0001\u0019!a\u0001\n\u0013\tI\u000fC\u0006\u0002n\u0002\u0001\r\u0011!Q!\n\u0005}\u0007bCAy\u0001\u0001\u0007\t\u0019!C\u0005\u0003gD1\"!>\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002x\"Y\u00111 \u0001A\u0002\u0003\u0005\u000b\u0015BA;\u0011\u001d\ty\u0010\u0001C!\u0005\u0003AqAa\u0001\u0001\t#\ny\u000bC\u0004\u0003\u0006\u0001!\t&!8\t\u000f\t\u001d\u0001\u0001\"\u0011\u0003\n!9!1\u0002\u0001\u0005\n\t%\u0001b\u0002B\u0007\u0001\u0011\u0005#q\u0002\u0005\b\u0005C\u0001A\u0011\tB\u0012\u0011\u001d\u0011Y\u0003\u0001C\u0001\u0005[9qA!\u000fp\u0011\u0003\u0011YD\u0002\u0004o_\"\u0005!Q\b\u0005\b\u0003\u0013sB\u0011\u0001B)\r\u0019\u0011\u0019F\b#\u0003V!Q!1\r\u0011\u0003\u0016\u0004%\tA!\u001a\t\u0015\t%\u0004E!E!\u0002\u0013\u00119\u0007\u0003\u0006\u0003l\u0001\u0012)\u001a!C\u0001\u0005KB!B!\u001c!\u0005#\u0005\u000b\u0011\u0002B4\u0011)\u0011y\u0007\tBK\u0002\u0013\u0005!\u0011\u000f\u0005\u000b\u0005g\u0002#\u0011#Q\u0001\n\u0005\u0005\u0005B\u0003B;A\tU\r\u0011\"\u0001\u0003r!Q!q\u000f\u0011\u0003\u0012\u0003\u0006I!!!\t\u000f\u0005%\u0005\u0005\"\u0001\u0003z!I!q\u0011\u0011\u0002\u0002\u0013\u0005!\u0011\u0012\u0005\n\u0005'\u0003\u0013\u0013!C\u0001\u0005+C\u0011Ba+!#\u0003%\tA!&\t\u0013\t5\u0006%%A\u0005\u0002\t=\u0006\"\u0003BZAE\u0005I\u0011\u0001BX\u0011%\u0011)\fIA\u0001\n\u0003\u00129\fC\u0005\u0003H\u0002\n\t\u0011\"\u0001\u0003J\"I!1\u001a\u0011\u0002\u0002\u0013\u0005!Q\u001a\u0005\n\u0005#\u0004\u0013\u0011!C!\u0005'D\u0011Ba7!\u0003\u0003%\tA!8\t\u0013\t\u0005\u0002%!A\u0005B\t\r\u0002\"\u0003BqA\u0005\u0005I\u0011\tBr\u0011%\u0011i\u0001IA\u0001\n\u0003\u0012)oB\u0005\u0003jz\t\t\u0011#\u0003\u0003l\u001aI!1\u000b\u0010\u0002\u0002#%!Q\u001e\u0005\b\u0003\u0013CD\u0011\u0001B~\u0011%\u0011\t\u000fOA\u0001\n\u000b\u0012\u0019\u000fC\u0005\u0003~b\n\t\u0011\"!\u0003\u0000\"I1\u0011\u0002\u001d\u0002\u0002\u0013\u000551\u0002\u0005\n\u00073A\u0014\u0011!C\u0005\u000771aaa\t\u001f\t\u000e\u0015\u0002BCB\u0014}\tU\r\u0011\"\u0001\u0004*!Q11\u0006 \u0003\u0012\u0003\u0006I!!\u0014\t\u0015\tUdH!f\u0001\n\u0003\u0011\t\b\u0003\u0006\u0003xy\u0012\t\u0012)A\u0005\u0003\u0003C!b!\f?\u0005+\u0007I\u0011AB\u0018\u0011)\u0019\tD\u0010B\tB\u0003%!\u0011\u0003\u0005\u000b\u0007gq$Q3A\u0005\u0002\rU\u0002BCB\u001f}\tE\t\u0015!\u0003\u00048!Q1q\b \u0003\u0016\u0004%\tA!\u001d\t\u0015\r\u0005cH!E!\u0002\u0013\t\t\t\u0003\u0006\u0004Dy\u0012)\u001a!C\u0001\u0005cB!b!\u0012?\u0005#\u0005\u000b\u0011BAA\u0011)\u00199E\u0010BK\u0002\u0013\u0005!\u0011\u000f\u0005\u000b\u0007\u0013r$\u0011#Q\u0001\n\u0005\u0005\u0005BCB&}\tU\r\u0011\"\u0001\u0004N!Q1\u0011\u000b \u0003\u0012\u0003\u0006Iaa\u0014\t\u000f\u0005%e\b\"\u0001\u0004T!I!q\u0011 \u0002\u0002\u0013\u00051q\r\u0005\n\u0005's\u0014\u0013!C\u0001\u0007sB\u0011Ba+?#\u0003%\tAa,\t\u0013\t5f(%A\u0005\u0002\ru\u0004\"\u0003BZ}E\u0005I\u0011ABA\u0011%\u0019)IPI\u0001\n\u0003\u0011y\u000bC\u0005\u0004\bz\n\n\u0011\"\u0001\u00030\"I1\u0011\u0012 \u0012\u0002\u0013\u0005!q\u0016\u0005\n\u0007\u0017s\u0014\u0013!C\u0001\u0007\u001bC\u0011B!.?\u0003\u0003%\tEa.\t\u0013\t\u001dg(!A\u0005\u0002\t%\u0007\"\u0003Bf}\u0005\u0005I\u0011ABI\u0011%\u0011\tNPA\u0001\n\u0003\u0012\u0019\u000eC\u0005\u0003\\z\n\t\u0011\"\u0001\u0004\u0016\"I!\u0011\u0005 \u0002\u0002\u0013\u0005#1\u0005\u0005\n\u0005Ct\u0014\u0011!C!\u0005GD\u0011B!\u0004?\u0003\u0003%\te!'\b\u0013\rue$!A\t\n\r}e!CB\u0012=\u0005\u0005\t\u0012BBQ\u0011\u001d\tII\u0019C\u0001\u0007SC\u0011B!9c\u0003\u0003%)Ea9\t\u0013\tu(-!A\u0005\u0002\u000e-\u0006\"CB\u0005E\u0006\u0005I\u0011QB_\u0011%\u0019IBYA\u0001\n\u0013\u0019Y\u0002\u0003\u0005\u0004Jz!\ta]Bf\u0011\u001d\u0011YC\bC\u0005\u0007sDq\u0001b\u0005\u001f\t\u0003!)\u0002C\u0005\u0005\u001cy\t\n\u0011\"\u0001\u0005\u001e!IA\u0011\u0005\u0010\u0012\u0002\u0013\u0005A1\u0005\u0005\n\tOq\u0012\u0013!C\u0001\tS\u0011\u0011#\u00138NK6|'/\u001f$jY\u0016Le\u000eZ3y\u0015\t\u0001\u0018/A\u0006eCR\f7o\\;sG\u0016\u001c(B\u0001:t\u0003%)\u00070Z2vi&|gN\u0003\u0002uk\u0006\u00191/\u001d7\u000b\u0005Y<\u0018!B:qCJ\\'B\u0001=z\u0003\u0019\t\u0007/Y2iK*\t!0A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001{B\u0011ap`\u0007\u0002_&\u0019\u0011\u0011A8\u00035A\u000b'\u000f^5uS>t\u0017N\\4Bo\u0006\u0014XMR5mK&sG-\u001a=\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\t\u0005\u001d\u0011\u0011B\u0007\u0002g&\u0019\u00111B:\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002%I|w\u000e\u001e)bi\"\u001c8\u000b]3dS\u001aLW\r\u001a\t\u0007\u0003#\t)#a\u000b\u000f\t\u0005M\u0011q\u0004\b\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011D>\u0002\rq\u0012xn\u001c;?\u0013\t\ti\"A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\"\u0005\r\u0012a\u00029bG.\fw-\u001a\u0006\u0003\u0003;IA!a\n\u0002*\t\u00191+Z9\u000b\t\u0005\u0005\u00121\u0005\t\u0005\u0003[\t9$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003\t17OC\u0002\u00026]\fa\u0001[1e_>\u0004\u0018\u0002BA\u001d\u0003_\u0011A\u0001U1uQ\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0011\u0011\u0005}\u0012qIA'\u0003\u001brA!!\u0011\u0002DA!\u0011QCA\u0012\u0013\u0011\t)%a\t\u0002\rA\u0013X\rZ3g\u0013\u0011\tI%a\u0013\u0003\u00075\u000b\u0007O\u0003\u0003\u0002F\u0005\r\u0002\u0003BA \u0003\u001fJA!!\u0015\u0002L\t11\u000b\u001e:j]\u001e\f1#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006\u0004b!a\u0016\u0002Z\u0005uSBAA\u0012\u0013\u0011\tY&a\t\u0003\r=\u0003H/[8o!\u0011\ty&!\u001a\u000e\u0005\u0005\u0005$bAA2g\u0006)A/\u001f9fg&!\u0011qMA1\u0005)\u0019FO];diRK\b/Z\u0001\u0010M&dWm\u0015;biV\u001c8)Y2iKB\u0019a0!\u001c\n\u0007\u0005=tNA\bGS2,7\u000b^1ukN\u001c\u0015m\u00195f\u0003i)8/\u001a:Ta\u0016\u001c\u0017NZ5fIB\u000b'\u000f^5uS>t7\u000b]3d!\u0019\t9&!\u0017\u0002vA\u0019a0a\u001e\n\u0007\u0005etNA\u0007QCJ$\u0018\u000e^5p]N\u0003XmY\u0001\u0012[\u0016$\u0018\rZ1uC>\u00038\u000fV5nK:\u001bXCAA@!\u0019\t9&!\u0017\u0002\u0002B!\u0011qKAB\u0013\u0011\t))a\t\u0003\t1{gnZ\u0001\u0013[\u0016$\u0018\rZ1uC>\u00038\u000fV5nK:\u001b\b%\u0001\u0004=S:LGO\u0010\u000b\u0011\u0003\u001b\u000by)!%\u0002\u0014\u0006U\u0015qSAM\u00037\u0003\"A \u0001\t\u000f\u0005\r\u0011\u00021\u0001\u0002\u0006!9\u0011QB\u0005A\u0002\u0005=\u0001bBA\u001e\u0013\u0001\u0007\u0011Q\b\u0005\b\u0003'J\u0001\u0019AA+\u0011%\tI'\u0003I\u0001\u0002\u0004\tY\u0007C\u0005\u0002r%\u0001\n\u00111\u0001\u0002t!I\u00111P\u0005\u0011\u0002\u0003\u0007\u0011qP\u0001\ne>|G\u000fU1uQN,\"!!)\u0011\r\u0005\r\u0016\u0011VA\u0016\u001b\t\t)K\u0003\u0003\u0002(\u0006\r\u0012AC2pY2,7\r^5p]&!\u0011qEAS\u0003)\u0011xn\u001c;QCRD7\u000fI\u0001\u0010G\u0006\u001c\u0007.\u001a3MK\u00064g)\u001b7fgV\u0011\u0011\u0011\u0017\t\t\u0003g\u000bI,a\u000b\u0002>6\u0011\u0011Q\u0017\u0006\u0005\u0003o\u000b)+A\u0004nkR\f'\r\\3\n\t\u0005m\u0016Q\u0017\u0002\u000e\u0019&t7.\u001a3ICNDW*\u00199\u0011\t\u00055\u0012qX\u0005\u0005\u0003\u0003\fyC\u0001\u0006GS2,7\u000b^1ukN\f1cY1dQ\u0016$G*Z1g\r&dWm]0%KF$B!a2\u0002NB!\u0011qKAe\u0013\u0011\tY-a\t\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u001fl\u0011\u0011!a\u0001\u0003c\u000b1\u0001\u001f\u00132\u0003A\u0019\u0017m\u00195fI2+\u0017M\u001a$jY\u0016\u001c\b\u0005K\u0002\u000f\u0003+\u0004B!a\u0016\u0002X&!\u0011\u0011\\A\u0012\u0005!1x\u000e\\1uS2,\u0017\u0001H2bG\",G\rT3bM\u0012K'\u000fV8DQ&dGM]3o\r&dWm]\u000b\u0003\u0003?\u0004\u0002\"a\u0010\u0002H\u0005-\u0012\u0011\u001d\t\u0007\u0003/\n\u0019/!0\n\t\u0005\u0015\u00181\u0005\u0002\u0006\u0003J\u0014\u0018-_\u0001!G\u0006\u001c\u0007.\u001a3MK\u00064G)\u001b:U_\u000eC\u0017\u000e\u001c3sK:4\u0015\u000e\\3t?\u0012*\u0017\u000f\u0006\u0003\u0002H\u0006-\b\"CAh!\u0005\u0005\t\u0019AAp\u0003u\u0019\u0017m\u00195fI2+\u0017M\u001a#jeR{7\t[5mIJ,gNR5mKN\u0004\u0003fA\t\u0002V\u0006\u00192-Y2iK\u0012\u0004\u0016M\u001d;ji&|gn\u00159fGV\u0011\u0011QO\u0001\u0018G\u0006\u001c\u0007.\u001a3QCJ$\u0018\u000e^5p]N\u0003XmY0%KF$B!a2\u0002z\"I\u0011qZ\n\u0002\u0002\u0003\u0007\u0011QO\u0001\u0015G\u0006\u001c\u0007.\u001a3QCJ$\u0018\u000e^5p]N\u0003Xm\u0019\u0011)\u0007Q\t).A\u0007qCJ$\u0018\u000e^5p]N\u0003Xm\u0019\u000b\u0003\u0003k\n\u0011\u0002\\3bM\u001aKG.Z:\u0002-1,\u0017M\u001a#jeR{7\t[5mIJ,gNR5mKN\fqA]3ge\u0016\u001c\b\u000e\u0006\u0002\u0002H\u0006A!/\u001a4sKND\u0007'\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0005#\u00119\u0002\u0005\u0003\u0002X\tM\u0011\u0002\u0002B\u000b\u0003G\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0003\u001ai\u0001\rAa\u0007\u0002\u000b=$\b.\u001a:\u0011\t\u0005]#QD\u0005\u0005\u0005?\t\u0019CA\u0002B]f\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0005K\u0001B!a\u0016\u0003(%!!\u0011FA\u0012\u0005\rIe\u000e^\u0001\u000eY&\u001cH\u000fT3bM\u001aKG.Z:\u0015\t\t=\"Q\u0007\t\u0007\u0003g\u0013\t$!0\n\t\tM\u0012Q\u0017\u0002\u000e\u0019&t7.\u001a3ICND7+\u001a;\t\u000f\t]B\u00041\u0001\u0002\u0010\u0005)\u0001/\u0019;ig\u0006\t\u0012J\\'f[>\u0014\u0018PR5mK&sG-\u001a=\u0011\u0005yt2#\u0002\u0010\u0003@\t\u0015\u0003\u0003BA,\u0005\u0003JAAa\u0011\u0002$\t1\u0011I\\=SK\u001a\u0004BAa\u0012\u0003N5\u0011!\u0011\n\u0006\u0004\u0005\u0017*\u0018\u0001C5oi\u0016\u0014h.\u00197\n\t\t=#\u0011\n\u0002\b\u0019><w-\u001b8h)\t\u0011YDA\rTKJL\u0017\r\\5{C\ndWM\u00117pG.dunY1uS>t7c\u0002\u0011\u0003@\t]#Q\f\t\u0005\u0003/\u0012I&\u0003\u0003\u0003\\\u0005\r\"a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003/\u0012y&\u0003\u0003\u0003b\u0005\r\"\u0001D*fe&\fG.\u001b>bE2,\u0017!\u00028b[\u0016\u001cXC\u0001B4!\u0019\t9&a9\u0002N\u00051a.Y7fg\u0002\nQ\u0001[8tiN\fa\u0001[8tiN\u0004\u0013AB8gMN,G/\u0006\u0002\u0002\u0002\u00069qN\u001a4tKR\u0004\u0013A\u00027f]\u001e$\b.A\u0004mK:<G\u000f\u001b\u0011\u0015\u0015\tm$q\u0010BA\u0005\u0007\u0013)\tE\u0002\u0003~\u0001j\u0011A\b\u0005\b\u0005GJ\u0003\u0019\u0001B4\u0011\u001d\u0011Y'\u000ba\u0001\u0005OBqAa\u001c*\u0001\u0004\t\t\tC\u0004\u0003v%\u0002\r!!!\u0002\t\r|\u0007/\u001f\u000b\u000b\u0005w\u0012YI!$\u0003\u0010\nE\u0005\"\u0003B2UA\u0005\t\u0019\u0001B4\u0011%\u0011YG\u000bI\u0001\u0002\u0004\u00119\u0007C\u0005\u0003p)\u0002\n\u00111\u0001\u0002\u0002\"I!Q\u000f\u0016\u0011\u0002\u0003\u0007\u0011\u0011Q\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u00119J\u000b\u0003\u0003h\te5F\u0001BN!\u0011\u0011iJa*\u000e\u0005\t}%\u0002\u0002BQ\u0005G\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\t\u0015\u00161E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BU\u0005?\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u00032*\"\u0011\u0011\u0011BM\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B]!\u0011\u0011YL!2\u000e\u0005\tu&\u0002\u0002B`\u0005\u0003\fA\u0001\\1oO*\u0011!1Y\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002R\tu\u0016\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\u0013\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\u0007\u0003P\"I\u0011qZ\u0019\u0002\u0002\u0003\u0007!QE\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\u001b\t\u0007\u0003G\u00139Na\u0007\n\t\te\u0017Q\u0015\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u0012\t}\u0007\"CAhg\u0005\u0005\t\u0019\u0001B\u000e\u0003!!xn\u0015;sS:<GC\u0001B])\u0011\u0011\tBa:\t\u0013\u0005=g'!AA\u0002\tm\u0011!G*fe&\fG.\u001b>bE2,'\t\\8dW2{7-\u0019;j_:\u00042A! 9'\u0015A$q\u001eB/!9\u0011\tPa>\u0003h\t\u001d\u0014\u0011QAA\u0005wj!Aa=\u000b\t\tU\u00181E\u0001\beVtG/[7f\u0013\u0011\u0011IPa=\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>tG\u0007\u0006\u0002\u0003l\u0006)\u0011\r\u001d9msRQ!1PB\u0001\u0007\u0007\u0019)aa\u0002\t\u000f\t\r4\b1\u0001\u0003h!9!1N\u001eA\u0002\t\u001d\u0004b\u0002B8w\u0001\u0007\u0011\u0011\u0011\u0005\b\u0005kZ\u0004\u0019AAA\u0003\u001d)h.\u00199qYf$Ba!\u0004\u0004\u0016A1\u0011qKA-\u0007\u001f\u0001B\"a\u0016\u0004\u0012\t\u001d$qMAA\u0003\u0003KAaa\u0005\u0002$\t1A+\u001e9mKRB\u0011ba\u0006=\u0003\u0003\u0005\rAa\u001f\u0002\u0007a$\u0003'A\u0006sK\u0006$'+Z:pYZ,GCAB\u000f!\u0011\u0011Yla\b\n\t\r\u0005\"Q\u0018\u0002\u0007\u001f\nTWm\u0019;\u0003-M+'/[1mSj\f'\r\\3GS2,7\u000b^1ukN\u001crA\u0010B \u0005/\u0012i&\u0001\u0003qCRDWCAA'\u0003\u0015\u0001\u0018\r\u001e5!\u0003\u0015I7\u000fR5s+\t\u0011\t\"\u0001\u0004jg\u0012K'\u000fI\u0001\u0011E2|7m\u001b*fa2L7-\u0019;j_:,\"aa\u000e\u0011\t\u0005]3\u0011H\u0005\u0005\u0007w\t\u0019CA\u0003TQ>\u0014H/A\tcY>\u001c7NU3qY&\u001c\u0017\r^5p]\u0002\n\u0011B\u00197pG.\u001c\u0016N_3\u0002\u0015\tdwnY6TSj,\u0007%\u0001\tn_\u0012Lg-[2bi&|g\u000eV5nK\u0006\tRn\u001c3jM&\u001c\u0017\r^5p]RKW.\u001a\u0011\u0002\u0015\u0005\u001c7-Z:t)&lW-A\u0006bG\u000e,7o\u001d+j[\u0016\u0004\u0013A\u00042m_\u000e\\Gj\\2bi&|gn]\u000b\u0003\u0007\u001f\u0002b!a\u0016\u0002d\nm\u0014a\u00042m_\u000e\\Gj\\2bi&|gn\u001d\u0011\u0015%\rU3qKB-\u00077\u001aifa\u0018\u0004b\r\r4Q\r\t\u0004\u0005{r\u0004bBB\u0014\u001f\u0002\u0007\u0011Q\n\u0005\b\u0005kz\u0005\u0019AAA\u0011\u001d\u0019ic\u0014a\u0001\u0005#Aqaa\rP\u0001\u0004\u00199\u0004C\u0004\u0004@=\u0003\r!!!\t\u000f\r\rs\n1\u0001\u0002\u0002\"91qI(A\u0002\u0005\u0005\u0005bBB&\u001f\u0002\u00071q\n\u000b\u0013\u0007+\u001aIga\u001b\u0004n\r=4\u0011OB:\u0007k\u001a9\bC\u0005\u0004(A\u0003\n\u00111\u0001\u0002N!I!Q\u000f)\u0011\u0002\u0003\u0007\u0011\u0011\u0011\u0005\n\u0007[\u0001\u0006\u0013!a\u0001\u0005#A\u0011ba\rQ!\u0003\u0005\raa\u000e\t\u0013\r}\u0002\u000b%AA\u0002\u0005\u0005\u0005\"CB\"!B\u0005\t\u0019AAA\u0011%\u00199\u0005\u0015I\u0001\u0002\u0004\t\t\tC\u0005\u0004LA\u0003\n\u00111\u0001\u0004PU\u001111\u0010\u0016\u0005\u0003\u001b\u0012I*\u0006\u0002\u0004\u0000)\"!\u0011\u0003BM+\t\u0019\u0019I\u000b\u0003\u00048\te\u0015AD2paf$C-\u001a4bk2$H%N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uI]\nabY8qs\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0004\u0010*\"1q\nBM)\u0011\u0011Yba%\t\u0013\u0005=7,!AA\u0002\t\u0015B\u0003\u0002B\t\u0007/C\u0011\"a4^\u0003\u0003\u0005\rAa\u0007\u0015\t\tE11\u0014\u0005\n\u0003\u001f\u0004\u0017\u0011!a\u0001\u00057\tacU3sS\u0006d\u0017N_1cY\u00164\u0015\u000e\\3Ti\u0006$Xo\u001d\t\u0004\u0005{\u00127#\u00022\u0004$\nu\u0003C\u0006By\u0007K\u000bi%!!\u0003\u0012\r]\u0012\u0011QAA\u0003\u0003\u001bye!\u0016\n\t\r\u001d&1\u001f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:DDCABP)I\u0019)f!,\u00040\u000eE61WB[\u0007o\u001bIla/\t\u000f\r\u001dR\r1\u0001\u0002N!9!QO3A\u0002\u0005\u0005\u0005bBB\u0017K\u0002\u0007!\u0011\u0003\u0005\b\u0007g)\u0007\u0019AB\u001c\u0011\u001d\u0019y$\u001aa\u0001\u0003\u0003Cqaa\u0011f\u0001\u0004\t\t\tC\u0004\u0004H\u0015\u0004\r!!!\t\u000f\r-S\r1\u0001\u0004PQ!1qXBd!\u0019\t9&!\u0017\u0004BB!\u0012qKBb\u0003\u001b\n\tI!\u0005\u00048\u0005\u0005\u0015\u0011QAA\u0007\u001fJAa!2\u0002$\t1A+\u001e9mKbB\u0011ba\u0006g\u0003\u0003\u0005\ra!\u0016\u0002#\t,Hn\u001b'jgRdU-\u00194GS2,7\u000f\u0006\u0007\u0004N\u000e]7\u0011\\Bu\u0007g\u001c)\u0010\u0005\u0004\u0002\u0012\u0005\u00152q\u001a\t\t\u0003/\u001a\t.a\u000b\u0004V&!11[A\u0012\u0005\u0019!V\u000f\u001d7feA1\u0011\u0011CA\u0013\u0003{CqAa\u000ei\u0001\u0004\ty\u0001C\u0004\u0004\\\"\u0004\ra!8\u0002\u0015!\fGm\\8q\u0007>tg\r\u0005\u0003\u0004`\u000e\u0015XBABq\u0015\u0011\u0019\u0019/a\r\u0002\t\r|gNZ\u0005\u0005\u0007O\u001c\tOA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\b\u0007WD\u0007\u0019ABw\u0003\u00191\u0017\u000e\u001c;feB!\u0011QFBx\u0013\u0011\u0019\t0a\f\u0003\u0015A\u000bG\u000f\u001b$jYR,'\u000fC\u0004\u0002\u0004!\u0004\r!!\u0002\t\u000f\r]\b\u000e1\u0001\u0003\u0012\u0005a\u0011M]3S_>$\b+\u0019;igR\u00012Q[B~\u0007{\u001cy\u0010\"\u0001\u0005\b\u0011-Aq\u0002\u0005\b\u0007OI\u0007\u0019AA\u0016\u0011\u001d\u0019Y.\u001ba\u0001\u0007;Dqaa;j\u0001\u0004\u0019i\u000fC\u0004\u0005\u0004%\u0004\r\u0001\"\u0002\u0002\u0015M,7o]5p]>\u0003H\u000f\u0005\u0004\u0002X\u0005e\u0013Q\u0001\u0005\b\t\u0013I\u0007\u0019\u0001B\t\u0003IIwM\\8sK6K7o]5oO\u001aKG.Z:\t\u000f\u00115\u0011\u000e1\u0001\u0003\u0012\u0005q\u0011n\u001a8pe\u0016dunY1mSRL\bb\u0002C\tS\u0002\u0007!\u0011C\u0001\u000bSN\u0014vn\u001c;QCRD\u0017aD:i_VdGMR5mi\u0016\u0014x*\u001e;\u0015\t\tEAq\u0003\u0005\b\t3Q\u0007\u0019AA'\u0003!\u0001\u0018\r\u001e5OC6,\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0005 )\"\u00111\u000eBM\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011AQ\u0005\u0016\u0005\u0003g\u0012I*A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeN\u000b\u0003\tWQC!a \u0003\u001a\u0002")
public class InMemoryFileIndex
extends PartitioningAwareFileIndex {
    private final SparkSession sparkSession;
    private final FileStatusCache fileStatusCache;
    private final Option<PartitionSpec> userSpecifiedPartitionSpec;
    private final Option<Object> metadataOpsTimeNs;
    private final Seq<Path> rootPaths;
    private volatile LinkedHashMap<Path, FileStatus> cachedLeafFiles;
    private volatile Map<Path, FileStatus[]> cachedLeafDirToChildrenFiles;
    private volatile PartitionSpec cachedPartitionSpec;

    public static Option<Object> $lessinit$greater$default$7() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<PartitionSpec> $lessinit$greater$default$6() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$6();
    }

    public static FileStatusCache $lessinit$greater$default$5() {
        return InMemoryFileIndex$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean shouldFilterOut(String string) {
        return InMemoryFileIndex$.MODULE$.shouldFilterOut(string);
    }

    @Override
    public Option<Object> metadataOpsTimeNs() {
        return this.metadataOpsTimeNs;
    }

    @Override
    public Seq<Path> rootPaths() {
        return this.rootPaths;
    }

    private LinkedHashMap<Path, FileStatus> cachedLeafFiles() {
        return this.cachedLeafFiles;
    }

    private void cachedLeafFiles_$eq(LinkedHashMap<Path, FileStatus> x$1) {
        this.cachedLeafFiles = x$1;
    }

    private Map<Path, FileStatus[]> cachedLeafDirToChildrenFiles() {
        return this.cachedLeafDirToChildrenFiles;
    }

    private void cachedLeafDirToChildrenFiles_$eq(Map<Path, FileStatus[]> x$1) {
        this.cachedLeafDirToChildrenFiles = x$1;
    }

    private PartitionSpec cachedPartitionSpec() {
        return this.cachedPartitionSpec;
    }

    private void cachedPartitionSpec_$eq(PartitionSpec x$1) {
        this.cachedPartitionSpec = x$1;
    }

    @Override
    public PartitionSpec partitionSpec() {
        if (this.cachedPartitionSpec() == null) {
            if (this.userSpecifiedPartitionSpec.isDefined()) {
                this.cachedPartitionSpec_$eq((PartitionSpec)this.userSpecifiedPartitionSpec.get());
            } else {
                this.cachedPartitionSpec_$eq(this.inferPartitioning());
            }
        }
        this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Partition spec: ").append(this.cachedPartitionSpec()).toString());
        return this.cachedPartitionSpec();
    }

    @Override
    public LinkedHashMap<Path, FileStatus> leafFiles() {
        return this.cachedLeafFiles();
    }

    @Override
    public Map<Path, FileStatus[]> leafDirToChildrenFiles() {
        return this.cachedLeafDirToChildrenFiles();
    }

    @Override
    public void refresh() {
        this.fileStatusCache.invalidateAll();
        this.refresh0();
    }

    private void refresh0() {
        LinkedHashSet<FileStatus> files = this.listLeafFiles(this.rootPaths());
        this.cachedLeafFiles_$eq((LinkedHashMap<Path, FileStatus>)((LinkedHashMap)new LinkedHashMap().$plus$plus$eq((TraversableOnce)files.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.getPath()), f), LinkedHashSet$.MODULE$.canBuildFrom()))));
        this.cachedLeafDirToChildrenFiles_$eq((Map<Path, FileStatus[]>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files.toArray(ClassTag$.MODULE$.apply(FileStatus.class)))).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getPath().getParent()));
        this.cachedPartitionSpec_$eq(null);
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof InMemoryFileIndex) {
            InMemoryFileIndex inMemoryFileIndex = (InMemoryFileIndex)object;
            Set set = this.rootPaths().toSet();
            Set set2 = inMemoryFileIndex.rootPaths().toSet();
            bl = !(set != null ? !set.equals(set2) : set2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.rootPaths().toSet().hashCode();
    }

    public LinkedHashSet<FileStatus> listLeafFiles(Seq<Path> paths) {
        long startTime = System.nanoTime();
        LinkedHashSet output = (LinkedHashSet)LinkedHashSet$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer pathsToFetch = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        paths.foreach((Function1 & Serializable & scala.Serializable)path -> {
            InMemoryFileIndex.$anonfun$listLeafFiles$1(this, output, pathsToFetch, path);
            return BoxedUnit.UNIT;
        });
        PathFilter filter = FileInputFormat.getInputPathFilter((JobConf)new JobConf(this.hadoopConf(), this.getClass()));
        Seq<Tuple2<Path, Seq<FileStatus>>> discovered = InMemoryFileIndex$.MODULE$.bulkListLeafFiles((Seq<Path>)pathsToFetch, this.hadoopConf(), filter, this.sparkSession, true);
        discovered.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Path path = (Path)tuple2._1();
            Seq leafFiles = (Seq)tuple2._2();
            HiveCatalogMetrics$.MODULE$.incrementFilesDiscovered(leafFiles.size());
            $this.fileStatusCache.putLeafFiles(path, (FileStatus[])leafFiles.toArray(ClassTag$.MODULE$.apply(FileStatus.class)));
            LinkedHashSet linkedHashSet = (LinkedHashSet)output.$plus$plus$eq((TraversableOnce)leafFiles);
            return linkedHashSet;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("It took ").append((System.nanoTime() - startTime) / 1000000L).append(" ms to list leaf files").append(" for ").append(paths.length()).append(" paths.").toString());
        return output;
    }

    public static final /* synthetic */ void $anonfun$listLeafFiles$1(InMemoryFileIndex $this, LinkedHashSet output$1, ArrayBuffer pathsToFetch$1, Path path) {
        ArrayBuffer arrayBuffer;
        Option<FileStatus[]> option = $this.fileStatusCache.getLeafFiles(path);
        if (option instanceof Some) {
            Some some = (Some)option;
            FileStatus[] files = (FileStatus[])some.value();
            HiveCatalogMetrics$.MODULE$.incrementFileCacheHits(files.length);
            arrayBuffer = (AbstractIterable)output$1.$plus$plus$eq((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)));
        } else if (None$.MODULE$.equals(option)) {
            arrayBuffer = pathsToFetch$1.$plus$eq((Object)path);
        } else {
            throw new MatchError(option);
        }
    }

    public InMemoryFileIndex(SparkSession sparkSession, Seq<Path> rootPathsSpecified, Map<String, String> parameters, Option<StructType> userSpecifiedSchema, FileStatusCache fileStatusCache, Option<PartitionSpec> userSpecifiedPartitionSpec, Option<Object> metadataOpsTimeNs) {
        this.sparkSession = sparkSession;
        this.fileStatusCache = fileStatusCache;
        this.userSpecifiedPartitionSpec = userSpecifiedPartitionSpec;
        this.metadataOpsTimeNs = metadataOpsTimeNs;
        super(sparkSession, parameters, userSpecifiedSchema, fileStatusCache);
        this.rootPaths = (Seq)rootPathsSpecified.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)FileStreamSink$.MODULE$.ancestorIsMetadataDirectory(x$1, this.hadoopConf())));
        this.refresh0();
    }

    public static class SerializableBlockLocation
    implements Product,
    scala.Serializable {
        private final String[] names;
        private final String[] hosts;
        private final long offset;
        private final long length;

        public String[] names() {
            return this.names;
        }

        public String[] hosts() {
            return this.hosts;
        }

        public long offset() {
            return this.offset;
        }

        public long length() {
            return this.length;
        }

        public SerializableBlockLocation copy(String[] names, String[] hosts, long offset, long length) {
            return new SerializableBlockLocation(names, hosts, offset, length);
        }

        public String[] copy$default$1() {
            return this.names();
        }

        public String[] copy$default$2() {
            return this.hosts();
        }

        public long copy$default$3() {
            return this.offset();
        }

        public long copy$default$4() {
            return this.length();
        }

        public String productPrefix() {
            return "SerializableBlockLocation";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.names();
                    break;
                }
                case 1: {
                    object = this.hosts();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.offset());
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToLong((long)this.length());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SerializableBlockLocation;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.names()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.hosts()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.offset()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.length()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SerializableBlockLocation)) return false;
            boolean bl = true;
            if (!bl) return false;
            SerializableBlockLocation serializableBlockLocation = (SerializableBlockLocation)x$1;
            if (this.names() != serializableBlockLocation.names()) return false;
            if (this.hosts() != serializableBlockLocation.hosts()) return false;
            if (this.offset() != serializableBlockLocation.offset()) return false;
            if (this.length() != serializableBlockLocation.length()) return false;
            if (!serializableBlockLocation.canEqual(this)) return false;
            return true;
        }

        public SerializableBlockLocation(String[] names, String[] hosts, long offset, long length) {
            this.names = names;
            this.hosts = hosts;
            this.offset = offset;
            this.length = length;
            Product.$init$((Product)this);
        }
    }

    public static class SerializableFileStatus
    implements Product,
    scala.Serializable {
        private final String path;
        private final long length;
        private final boolean isDir;
        private final short blockReplication;
        private final long blockSize;
        private final long modificationTime;
        private final long accessTime;
        private final SerializableBlockLocation[] blockLocations;

        public String path() {
            return this.path;
        }

        public long length() {
            return this.length;
        }

        public boolean isDir() {
            return this.isDir;
        }

        public short blockReplication() {
            return this.blockReplication;
        }

        public long blockSize() {
            return this.blockSize;
        }

        public long modificationTime() {
            return this.modificationTime;
        }

        public long accessTime() {
            return this.accessTime;
        }

        public SerializableBlockLocation[] blockLocations() {
            return this.blockLocations;
        }

        public SerializableFileStatus copy(String path, long length, boolean isDir, short blockReplication, long blockSize, long modificationTime, long accessTime, SerializableBlockLocation[] blockLocations) {
            return new SerializableFileStatus(path, length, isDir, blockReplication, blockSize, modificationTime, accessTime, blockLocations);
        }

        public String copy$default$1() {
            return this.path();
        }

        public long copy$default$2() {
            return this.length();
        }

        public boolean copy$default$3() {
            return this.isDir();
        }

        public short copy$default$4() {
            return this.blockReplication();
        }

        public long copy$default$5() {
            return this.blockSize();
        }

        public long copy$default$6() {
            return this.modificationTime();
        }

        public long copy$default$7() {
            return this.accessTime();
        }

        public SerializableBlockLocation[] copy$default$8() {
            return this.blockLocations();
        }

        public String productPrefix() {
            return "SerializableFileStatus";
        }

        public int productArity() {
            return 8;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.path();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.length());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToBoolean((boolean)this.isDir());
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToShort((short)this.blockReplication());
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToLong((long)this.blockSize());
                    break;
                }
                case 5: {
                    object = BoxesRunTime.boxToLong((long)this.modificationTime());
                    break;
                }
                case 6: {
                    object = BoxesRunTime.boxToLong((long)this.accessTime());
                    break;
                }
                case 7: {
                    object = this.blockLocations();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SerializableFileStatus;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.length()));
            n = Statics.mix((int)n, (int)(this.isDir() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)this.blockReplication());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.blockSize()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.modificationTime()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.accessTime()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.blockLocations()));
            return Statics.finalizeHash((int)n, (int)8);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SerializableFileStatus)) return false;
            boolean bl = true;
            if (!bl) return false;
            SerializableFileStatus serializableFileStatus = (SerializableFileStatus)x$1;
            String string = this.path();
            String string2 = serializableFileStatus.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.length() != serializableFileStatus.length()) return false;
            if (this.isDir() != serializableFileStatus.isDir()) return false;
            if (this.blockReplication() != serializableFileStatus.blockReplication()) return false;
            if (this.blockSize() != serializableFileStatus.blockSize()) return false;
            if (this.modificationTime() != serializableFileStatus.modificationTime()) return false;
            if (this.accessTime() != serializableFileStatus.accessTime()) return false;
            if (this.blockLocations() != serializableFileStatus.blockLocations()) return false;
            if (!serializableFileStatus.canEqual(this)) return false;
            return true;
        }

        public SerializableFileStatus(String path, long length, boolean isDir, short blockReplication, long blockSize, long modificationTime, long accessTime, SerializableBlockLocation[] blockLocations) {
            this.path = path;
            this.length = length;
            this.isDir = isDir;
            this.blockReplication = blockReplication;
            this.blockSize = blockSize;
            this.modificationTime = modificationTime;
            this.accessTime = accessTime;
            this.blockLocations = blockLocations;
            Product.$init$((Product)this);
        }
    }
}

