/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.SubqueryExpression;
import org.apache.spark.sql.catalyst.optimizer.EliminateResolvedHint$;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.HintInfo;
import org.apache.spark.sql.catalyst.plans.logical.IgnoreCachedData;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.ResolvedHint;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanHelper;
import org.apache.spark.sql.execution.columnar.InMemoryRelation;
import org.apache.spark.sql.execution.columnar.InMemoryRelation$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.FileTable;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

@ScalaSignature(bytes="\u0006\u0001\t\u0005b\u0001B\f\u0019\u0001\rBQA\u000e\u0001\u0005\u0002]BqA\u000f\u0001A\u0002\u0013%1\bC\u0004H\u0001\u0001\u0007I\u0011\u0002%\t\r9\u0003\u0001\u0015)\u0003=\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015q\u0006\u0001\"\u0001`\u0011%\t)\u0002AI\u0001\n\u0003\t9\u0002C\u0005\u0002.\u0001\t\n\u0011\"\u0001\u00020!9\u00111\u0007\u0001\u0005\u0002\u0005U\u0002bBA\u001a\u0001\u0011\u0005\u0011q\t\u0005\n\u0003_\u0002\u0011\u0013!C\u0001\u0003cB\u0001\"!\u001e\u0001\t\u0003Q\u0012q\u000f\u0005\b\u0003C\u0003A\u0011AAR\u0011\u001d\tI\u000b\u0001C\u0005\u0003WCq!!/\u0001\t\u0003\tY\fC\u0004\u0002:\u0002!\t!a3\t\u000f\u0005=\u0007\u0001\"\u0001\u0002R\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0007bBAk\u0001\u0011\u0005\u0011q\u001c\u0005\b\u0003{\u0004A\u0011BA\u0000\u0011\u001d\u0011I\u0001\u0001C\u0005\u0005\u0017\u0011AbQ1dQ\u0016l\u0015M\\1hKJT!!\u0007\u000e\u0002\u0013\u0015DXmY;uS>t'BA\u000e\u001d\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003;y\tQa\u001d9be.T!a\b\u0011\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0013aA8sO\u000e\u00011\u0003\u0002\u0001%UA\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0007CA\u0016/\u001b\u0005a#BA\u0017\u001d\u0003!Ig\u000e^3s]\u0006d\u0017BA\u0018-\u0005\u001daunZ4j]\u001e\u0004\"!\r\u001b\u000e\u0003IR!a\r\r\u0002\u0011\u0005$\u0017\r\u001d;jm\u0016L!!\u000e\u001a\u0003/\u0005#\u0017\r\u001d;jm\u0016\u001c\u0006/\u0019:l!2\fg\u000eS3ma\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u00019!\tI\u0004!D\u0001\u0019\u0003)\u0019\u0017m\u00195fI\u0012\u000bG/Y\u000b\u0002yA\u0019QH\u0011#\u000e\u0003yR!a\u0010!\u0002\u0013%lW.\u001e;bE2,'BA!'\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u0007z\u0012!\"\u00138eKb,GmU3r!\tIT)\u0003\u0002G1\tQ1)Y2iK\u0012$\u0015\r^1\u0002\u001d\r\f7\r[3e\t\u0006$\u0018m\u0018\u0013fcR\u0011\u0011\n\u0014\t\u0003K)K!a\u0013\u0014\u0003\tUs\u0017\u000e\u001e\u0005\b\u001b\u000e\t\t\u00111\u0001=\u0003\rAH%M\u0001\fG\u0006\u001c\u0007.\u001a3ECR\f\u0007\u0005\u000b\u0002\u0005!B\u0011Q%U\u0005\u0003%\u001a\u0012\u0001B^8mCRLG.\u001a\u0015\u0003\tQ\u0003\"!J+\n\u0005Y3#!\u0003;sC:\u001c\u0018.\u001a8u\u0003)\u0019G.Z1s\u0007\u0006\u001c\u0007.\u001a\u000b\u0002\u0013\u00069\u0011n]#naRLX#A.\u0011\u0005\u0015b\u0016BA/'\u0005\u001d\u0011un\u001c7fC:\f!bY1dQ\u0016\fV/\u001a:z)\u0015I\u0005M]A\u0003\u0011\u0015\tw\u00011\u0001c\u0003\u0015\tX/\u001a:za\t\u0019\u0017\u000eE\u0002eK\u001el\u0011AG\u0005\u0003Mj\u0011q\u0001R1uCN,G\u000f\u0005\u0002iS2\u0001A!\u00036a\u0003\u0003\u0005\tQ!\u0001l\u0005\ryF%M\t\u0003Y>\u0004\"!J7\n\u000594#a\u0002(pi\"Lgn\u001a\t\u0003KAL!!\u001d\u0014\u0003\u0007\u0005s\u0017\u0010C\u0004t\u000fA\u0005\t\u0019\u0001;\u0002\u0013Q\f'\r\\3OC6,\u0007cA\u0013vo&\u0011aO\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005a|hBA=~!\tQh%D\u0001|\u0015\ta(%\u0001\u0004=e>|GOP\u0005\u0003}\u001a\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0001\u0003\u0007\u0011aa\u0015;sS:<'B\u0001@'\u0011%\t9a\u0002I\u0001\u0002\u0004\tI!\u0001\u0007ti>\u0014\u0018mZ3MKZ,G\u000e\u0005\u0003\u0002\f\u0005EQBAA\u0007\u0015\r\ty\u0001H\u0001\bgR|'/Y4f\u0013\u0011\t\u0019\"!\u0004\u0003\u0019M#xN]1hK2+g/\u001a7\u0002)\r\f7\r[3Rk\u0016\u0014\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tIBK\u0002u\u00037Y#!!\b\u0011\t\u0005}\u0011\u0011F\u0007\u0003\u0003CQA!a\t\u0002&\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003O1\u0013AC1o]>$\u0018\r^5p]&!\u00111FA\u0011\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0015G\u0006\u001c\u0007.Z)vKJLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005E\"\u0006BA\u0005\u00037\tA\"\u001e8dC\u000eDW-U;fef$R!SA\u001c\u0003\u0007Ba!\u0019\u0006A\u0002\u0005e\u0002\u0007BA\u001e\u0003\u007f\u0001B\u0001Z3\u0002>A\u0019\u0001.a\u0010\u0005\u0017\u0005\u0005\u0013qGA\u0001\u0002\u0003\u0015\ta\u001b\u0002\u0004?\u0012\u0012\u0004BBA#\u0015\u0001\u00071,A\u0004dCN\u001c\u0017\rZ3\u0015\u0013%\u000bI%!\u0015\u0002j\u0005-\u0004BB\u000f\f\u0001\u0004\tY\u0005E\u0002e\u0003\u001bJ1!a\u0014\u001b\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u001d\t\u0019f\u0003a\u0001\u0003+\nA\u0001\u001d7b]B!\u0011qKA3\u001b\t\tIF\u0003\u0003\u0002\\\u0005u\u0013a\u00027pO&\u001c\u0017\r\u001c\u0006\u0005\u0003?\n\t'A\u0003qY\u0006t7OC\u0002\u0002di\t\u0001bY1uC2L8\u000f^\u0005\u0005\u0003O\nIFA\u0006M_\u001eL7-\u00197QY\u0006t\u0007BBA#\u0017\u0001\u00071\f\u0003\u0005\u0002n-\u0001\n\u00111\u0001\\\u0003!\u0011Gn\\2lS:<\u0017AF;oG\u0006\u001c\u0007.Z)vKJLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005M$fA.\u0002\u001c\u00059\u0012M\\1msj,7i\u001c7v[:\u001c\u0015m\u00195f#V,'/\u001f\u000b\b\u0013\u0006e\u0014QPA@\u0011\u001d\tY(\u0004a\u0001\u0003\u0017\nAb\u001d9be.\u001cVm]:j_:DQAO\u0007A\u0002\u0011Cq!!!\u000e\u0001\u0004\t\u0019)\u0001\u0004d_2,XN\u001c\t\u0007\u0003\u000b\u000by)!&\u000f\t\u0005\u001d\u00151\u0012\b\u0004u\u0006%\u0015\"A\u0014\n\u0007\u00055e%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E\u00151\u0013\u0002\u0004'\u0016\f(bAAGMA!\u0011qSAO\u001b\t\tIJ\u0003\u0003\u0002\u001c\u0006\u0005\u0014aC3yaJ,7o]5p]NLA!a(\u0002\u001a\nI\u0011\t\u001e;sS\n,H/Z\u0001\u000ee\u0016\u001c\u0017m\u00195f\u0005f\u0004F.\u00198\u0015\u000b%\u000b)+a*\t\ruq\u0001\u0019AA&\u0011\u001d\t\u0019F\u0004a\u0001\u0003+\n!C]3dC\u000eDWMQ=D_:$\u0017\u000e^5p]R)\u0011*!,\u00020\"1Qd\u0004a\u0001\u0003\u0017Bq!!-\u0010\u0001\u0004\t\u0019,A\u0005d_:$\u0017\u000e^5p]B)Q%!.E7&\u0019\u0011q\u0017\u0014\u0003\u0013\u0019+hn\u0019;j_:\f\u0014\u0001\u00057p_.,\boQ1dQ\u0016$G)\u0019;b)\u0011\ti,a0\u0011\u0007\u0015*H\t\u0003\u0004b!\u0001\u0007\u0011\u0011\u0019\u0019\u0005\u0003\u0007\f9\r\u0005\u0003eK\u0006\u0015\u0007c\u00015\u0002H\u0012Y\u0011\u0011ZA`\u0003\u0003\u0005\tQ!\u0001l\u0005\ryFe\r\u000b\u0005\u0003{\u000bi\rC\u0004\u0002TE\u0001\r!!\u0016\u0002\u001bU\u001cXmQ1dQ\u0016$G)\u0019;b)\u0011\t)&a5\t\u000f\u0005M#\u00031\u0001\u0002V\u0005i!/Z2bG\",')\u001f)bi\"$R!SAm\u00037Da!H\nA\u0002\u0005-\u0003BBAo'\u0001\u0007q/\u0001\u0007sKN|WO]2f!\u0006$\b\u000eF\u0004J\u0003C\f\u0019/!>\t\ru!\u0002\u0019AA&\u0011\u001d\ti\u000e\u0006a\u0001\u0003K\u0004B!a:\u0002r6\u0011\u0011\u0011\u001e\u0006\u0005\u0003W\fi/\u0001\u0002gg*\u0019\u0011q\u001e\u0010\u0002\r!\fGm\\8q\u0013\u0011\t\u00190!;\u0003\tA\u000bG\u000f\u001b\u0005\b\u0003W$\u0002\u0019AA|!\u0011\t9/!?\n\t\u0005m\u0018\u0011\u001e\u0002\u000b\r&dWmU=ti\u0016l\u0017\u0001\u00057p_.,\b/\u00118e%\u00164'/Z:i)\u001dY&\u0011\u0001B\u0002\u0005\u000bAq!a\u0015\u0016\u0001\u0004\t)\u0006C\u0004\u0002lV\u0001\r!a>\t\u000f\t\u001dQ\u00031\u0001\u0002f\u0006i\u0011/^1mS\u001aLW\r\u001a)bi\"\f1D]3ge\u0016\u001c\bNR5mK&sG-\u001a=JM:+7-Z:tCJLHcB.\u0003\u000e\tu!q\u0004\u0005\b\u0005\u001f1\u0002\u0019\u0001B\t\u0003%1\u0017\u000e\\3J]\u0012,\u0007\u0010\u0005\u0003\u0003\u0014\teQB\u0001B\u000b\u0015\r\u00119\u0002G\u0001\fI\u0006$\u0018m]8ve\u000e,7/\u0003\u0003\u0003\u001c\tU!!\u0003$jY\u0016Le\u000eZ3y\u0011\u001d\tYO\u0006a\u0001\u0003oDqAa\u0002\u0017\u0001\u0004\t)\u000f")
public class CacheManager
implements Logging,
AdaptiveSparkPlanHelper {
    private volatile transient IndexedSeq<CachedData> cachedData;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public Option<SparkPlan> find(SparkPlan p, Function1<SparkPlan, Object> f) {
        return AdaptiveSparkPlanHelper.find$(this, p, f);
    }

    @Override
    public void foreach(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreach$(this, p, f);
    }

    @Override
    public void foreachUp(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreachUp$(this, p, f);
    }

    @Override
    public <A> Seq<A> mapPlans(SparkPlan p, Function1<SparkPlan, A> f) {
        return AdaptiveSparkPlanHelper.mapPlans$(this, p, f);
    }

    @Override
    public <A> Seq<A> flatMap(SparkPlan p, Function1<SparkPlan, TraversableOnce<A>> f) {
        return AdaptiveSparkPlanHelper.flatMap$(this, p, f);
    }

    @Override
    public <B> Seq<B> collect(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collect$(this, p, pf);
    }

    @Override
    public Seq<SparkPlan> collectLeaves(SparkPlan p) {
        return AdaptiveSparkPlanHelper.collectLeaves$(this, p);
    }

    @Override
    public <B> Option<B> collectFirst(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collectFirst$(this, p, pf);
    }

    @Override
    public <B> Seq<B> collectWithSubqueries(SparkPlan p, PartialFunction<SparkPlan, B> f) {
        return AdaptiveSparkPlanHelper.collectWithSubqueries$(this, p, f);
    }

    @Override
    public Seq<SparkPlan> subqueriesAll(SparkPlan p) {
        return AdaptiveSparkPlanHelper.subqueriesAll$(this, p);
    }

    @Override
    public SparkPlan stripAQEPlan(SparkPlan p) {
        return AdaptiveSparkPlanHelper.stripAQEPlan$(this, p);
    }

    @Override
    public <T> SparkSession getOrCloneSessionWithAqeOff(SparkSession session) {
        return AdaptiveSparkPlanHelper.getOrCloneSessionWithAqeOff$(this, session);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private IndexedSeq<CachedData> cachedData() {
        return this.cachedData;
    }

    private void cachedData_$eq(IndexedSeq<CachedData> x$1) {
        this.cachedData = x$1;
    }

    public synchronized void clearCache() {
        this.cachedData().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            CacheManager.$anonfun$clearCache$1(x$1);
            return BoxedUnit.UNIT;
        });
        this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)IndexedSeq$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    public boolean isEmpty() {
        return this.cachedData().isEmpty();
    }

    public void cacheQuery(Dataset<?> query, Option<String> tableName, StorageLevel storageLevel) {
        LogicalPlan planToCache = query.logicalPlan();
        if (this.lookupCachedData(planToCache).nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Asked to cache already cached data.");
        } else {
            SparkSession sessionWithAqeOff = this.getOrCloneSessionWithAqeOff(query.sparkSession());
            InMemoryRelation inMemoryRelation = (InMemoryRelation)((Object)sessionWithAqeOff.withActive((Function0 & Serializable & scala.Serializable)() -> {
                QueryExecution qe = sessionWithAqeOff.sessionState().executePlan(planToCache);
                return InMemoryRelation$.MODULE$.apply(sessionWithAqeOff.sessionState().conf().useCompression(), sessionWithAqeOff.sessionState().conf().columnBatchSize(), storageLevel, qe.executedPlan(), tableName, qe.optimizedPlan());
            }));
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                if (this.lookupCachedData(planToCache).nonEmpty()) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Data has already been cached.");
                } else {
                    CachedData cachedData = new CachedData(planToCache, inMemoryRelation);
                    this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().$plus$colon((Object)cachedData, IndexedSeq$.MODULE$.canBuildFrom())));
                }
            }
        }
    }

    public Option<String> cacheQuery$default$2() {
        return None$.MODULE$;
    }

    public StorageLevel cacheQuery$default$3() {
        return StorageLevel$.MODULE$.MEMORY_AND_DISK();
    }

    public void uncacheQuery(Dataset<?> query, boolean cascade) {
        this.uncacheQuery(query.sparkSession(), query.logicalPlan(), cascade, this.uncacheQuery$default$4());
    }

    public void uncacheQuery(SparkSession spark, LogicalPlan plan, boolean cascade, boolean blocking) {
        block3: {
            Function1 & Serializable & scala.Serializable shouldRemove = cascade ? (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$1(plan, x$3)) : (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.sameResult((QueryPlan)plan));
            IndexedSeq plansToUncache = (IndexedSeq)this.cachedData().filter((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$4(shouldRemove, cd)));
            CacheManager cacheManager = this;
            synchronized (cacheManager) {
                this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plansToUncache.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$6(cd, x$6)))))));
            }
            plansToUncache.foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                CacheManager.$anonfun$uncacheQuery$7(blocking, x$7);
                return BoxedUnit.UNIT;
            });
            if (cascade) break block3;
            this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$uncacheQuery$8(plan, cd)));
        }
    }

    public boolean uncacheQuery$default$4() {
        return false;
    }

    public void analyzeColumnCacheQuery(SparkSession sparkSession, CachedData cachedData, Seq<Attribute> column) {
        InMemoryRelation relation = cachedData.cachedRepresentation();
        Tuple2<Object, Map<Attribute, ColumnStat>> tuple2 = CommandUtils$.MODULE$.computeColumnStats(sparkSession, (LogicalPlan)relation, column);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long rowCount = tuple2._1$mcJ$sp();
        Map newColStats = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)newColStats);
        Tuple2 tuple23 = tuple22;
        long rowCount2 = tuple23._1$mcJ$sp();
        Map newColStats2 = (Map)tuple23._2();
        relation.updateStats(rowCount2, (Map<Attribute, ColumnStat>)newColStats2);
    }

    public void recacheByPlan(SparkSession spark, LogicalPlan plan) {
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPlan$1(plan, x$10)));
    }

    private void recacheByCondition(SparkSession spark, Function1<CachedData, Object> condition) {
        IndexedSeq needToRecache = (IndexedSeq)this.cachedData().filter(condition);
        CacheManager cacheManager = this;
        synchronized (cacheManager) {
            this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)this.cachedData().filterNot((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)needToRecache.exists((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByCondition$2(cd, x$12)))))));
        }
        needToRecache.foreach((Function1 & Serializable & scala.Serializable)cd -> {
            CacheManager.$anonfun$recacheByCondition$3(this, spark, cd);
            return BoxedUnit.UNIT;
        });
    }

    public Option<CachedData> lookupCachedData(Dataset<?> query) {
        return this.lookupCachedData(query.logicalPlan());
    }

    public Option<CachedData> lookupCachedData(LogicalPlan plan) {
        return this.cachedData().find((Function1 & Serializable & scala.Serializable)cd -> BoxesRunTime.boxToBoolean((boolean)plan.sameResult((QueryPlan)cd.plan())));
    }

    public LogicalPlan useCachedData(LogicalPlan plan) {
        LogicalPlan newPlan = plan.transformDown((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                IgnoreCachedData ignoreCachedData;
                A1 A1 = x1;
                Object object = A1 instanceof IgnoreCachedData ? (ignoreCachedData = (IgnoreCachedData)A1) : this.$outer.lookupCachedData(A1).map((Function1 & Serializable & scala.Serializable)cached -> {
                    Seq hints = (Seq)EliminateResolvedHint$.MODULE$.extractHintsFromPlan(A1)._2();
                    InMemoryRelation cachedPlan = cached.cachedRepresentation().withOutput((Seq<Attribute>)A1.output());
                    return (LogicalPlan)hints.foldRight((Object)((Object)cachedPlan), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                        Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        HintInfo hint = (HintInfo)tuple2._1();
                        LogicalPlan p = (LogicalPlan)tuple2._2();
                        ResolvedHint resolvedHint = new ResolvedHint(p, hint);
                        return resolvedHint;
                    });
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> A1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan2 = x1;
                boolean bl = logicalPlan2 instanceof IgnoreCachedData ? true : true;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.execution.CachedData ), $anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.plans.logical.HintInfo org.apache.spark.sql.catalyst.plans.logical.LogicalPlan )}, serializedLambda);
            }
        });
        return newPlan.transformAllExpressions((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CacheManager $outer;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof SubqueryExpression) {
                    SubqueryExpression subqueryExpression = (SubqueryExpression)A1;
                    object = subqueryExpression.withNewPlan(this.$outer.useCachedData((LogicalPlan)subqueryExpression.plan()));
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x2) {
                Expression expression = x2;
                boolean bl = expression instanceof SubqueryExpression;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void recacheByPath(SparkSession spark, String resourcePath) {
        Path path = new Path(resourcePath);
        FileSystem fs = path.getFileSystem(spark.sessionState().newHadoopConf());
        this.recacheByPath(spark, path, fs);
    }

    public void recacheByPath(SparkSession spark, Path resourcePath, FileSystem fs) {
        Path qualifiedPath = fs.makeQualified(resourcePath);
        this.recacheByCondition(spark, (Function1<CachedData, Object>)(Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)CacheManager.$anonfun$recacheByPath$1(this, fs, qualifiedPath, x$14)));
    }

    private boolean lookupAndRefresh(LogicalPlan plan, FileSystem fs, Path qualifiedPath) {
        DataSourceV2Relation dataSourceV2Relation;
        Table fileTable;
        boolean bl;
        LogicalPlan logicalPlan2 = plan;
        if (logicalPlan2 instanceof LogicalRelation) {
            boolean bl2;
            LogicalRelation logicalRelation = (LogicalRelation)logicalPlan2;
            BaseRelation baseRelation = logicalRelation.relation();
            if (baseRelation instanceof HadoopFsRelation) {
                HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
                bl2 = this.refreshFileIndexIfNecessary(hadoopFsRelation.location(), fs, qualifiedPath);
            } else {
                bl2 = false;
            }
            bl = bl2;
        } else if (logicalPlan2 instanceof DataSourceV2Relation && (fileTable = (dataSourceV2Relation = (DataSourceV2Relation)logicalPlan2).table()) instanceof FileTable) {
            FileTable fileTable2 = (FileTable)fileTable;
            bl = this.refreshFileIndexIfNecessary(fileTable2.fileIndex(), fs, qualifiedPath);
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean refreshFileIndexIfNecessary(FileIndex fileIndex, FileSystem fs, Path qualifiedPath) {
        boolean needToRefresh;
        block0: {
            String prefixToInvalidate = qualifiedPath.toString();
            needToRefresh = ((IterableLike)fileIndex.rootPaths().map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.makeQualified(fs.getUri(), fs.getWorkingDirectory()).toString(), Seq$.MODULE$.canBuildFrom())).exists((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.startsWith(prefixToInvalidate)));
            if (!needToRefresh) break block0;
            fileIndex.refresh();
        }
        return needToRefresh;
    }

    public static final /* synthetic */ void $anonfun$clearCache$1(CachedData x$1) {
        x$1.cachedRepresentation().cacheBuilder().clearCache(x$1.cachedRepresentation().cacheBuilder().clearCache$default$1());
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$1(LogicalPlan plan$1, LogicalPlan x$3) {
        return x$3.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.sameResult((QueryPlan)plan$1))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$4(Function1 shouldRemove$1, CachedData cd) {
        return BoxesRunTime.unboxToBoolean((Object)shouldRemove$1.apply((Object)cd.plan()));
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$6(CachedData cd$1, CachedData x$6) {
        return x$6 == cd$1;
    }

    public static final /* synthetic */ void $anonfun$uncacheQuery$7(boolean blocking$1, CachedData x$7) {
        x$7.cachedRepresentation().cacheBuilder().clearCache(blocking$1);
    }

    public static final /* synthetic */ boolean $anonfun$uncacheQuery$8(LogicalPlan plan$1, CachedData cd) {
        boolean cacheAlreadyLoaded = cd.cachedRepresentation().cacheBuilder().isCachedColumnBuffersLoaded();
        return cd.plan().find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.sameResult((QueryPlan)plan$1))).isDefined() && !cacheAlreadyLoaded;
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPlan$1(LogicalPlan plan$2, CachedData x$10) {
        return x$10.plan().find((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.sameResult((QueryPlan)plan$2))).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$recacheByCondition$2(CachedData cd$2, CachedData x$12) {
        return x$12 == cd$2;
    }

    public static final /* synthetic */ void $anonfun$recacheByCondition$3(CacheManager $this, SparkSession spark$1, CachedData cd) {
        InMemoryRelation newCache;
        cd.cachedRepresentation().cacheBuilder().clearCache(cd.cachedRepresentation().cacheBuilder().clearCache$default$1());
        SparkSession sessionWithAqeOff = $this.getOrCloneSessionWithAqeOff(spark$1);
        InMemoryRelation x$6 = newCache = (InMemoryRelation)((Object)sessionWithAqeOff.withActive((Function0 & Serializable & scala.Serializable)() -> {
            QueryExecution qe = sessionWithAqeOff.sessionState().executePlan(cd.plan());
            SparkPlan x$1 = qe.executedPlan();
            boolean x$2 = cd.cachedRepresentation().cacheBuilder().copy$default$1();
            int x$3 = cd.cachedRepresentation().cacheBuilder().copy$default$2();
            StorageLevel x$4 = cd.cachedRepresentation().cacheBuilder().copy$default$3();
            Option<String> x$5 = cd.cachedRepresentation().cacheBuilder().copy$default$5();
            return InMemoryRelation$.MODULE$.apply(cd.cachedRepresentation().cacheBuilder().copy(x$2, x$3, x$4, x$1, x$5), qe.optimizedPlan());
        }));
        LogicalPlan x$7 = cd.copy$default$1();
        CachedData recomputedPlan = cd.copy(x$7, x$6);
        CacheManager cacheManager = $this;
        synchronized (cacheManager) {
            if ($this.lookupCachedData(recomputedPlan.plan()).nonEmpty()) {
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "While recaching, data was already added to cache.");
            } else {
                CachedData cachedData = recomputedPlan;
                $this.cachedData_$eq((IndexedSeq<CachedData>)((IndexedSeq)$this.cachedData().$plus$colon((Object)cachedData, IndexedSeq$.MODULE$.canBuildFrom())));
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$recacheByPath$1(CacheManager $this, FileSystem fs$1, Path qualifiedPath$1, CachedData x$14) {
        return x$14.plan().find((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)$this.lookupAndRefresh(x$15, fs$1, qualifiedPath$1))).isDefined();
    }

    public CacheManager() {
        Logging.$init$((Logging)this);
        AdaptiveSparkPlanHelper.$init$(this);
        this.cachedData = (IndexedSeq)IndexedSeq$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

