/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.hive.ql.io.parquet.serde.DeepParquetHiveMapInspector;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveArrayInspector;
import org.apache.hadoop.hive.ql.io.parquet.serde.StandardParquetHiveMapInspector;
import org.apache.hadoop.hive.ql.io.parquet.serde.primitive.ParquetPrimitiveInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;

public class ArrayWritableObjectInspector
extends SettableStructObjectInspector {
    private final TypeInfo typeInfo;
    private final List<TypeInfo> fieldInfos;
    private final List<String> fieldNames;
    private final List<StructField> fields;
    private final HashMap<String, StructFieldImpl> fieldsByName;
    private final boolean isRoot;

    public ArrayWritableObjectInspector(StructTypeInfo rowTypeInfo) {
        this(true, rowTypeInfo, null);
    }

    public ArrayWritableObjectInspector(StructTypeInfo originalTypeInfo, StructTypeInfo prunedTypeInfo) {
        this(true, originalTypeInfo, prunedTypeInfo);
    }

    public ArrayWritableObjectInspector(boolean isRoot, StructTypeInfo originalTypeInfo, StructTypeInfo prunedTypeInfo) {
        this.isRoot = isRoot;
        this.typeInfo = originalTypeInfo;
        this.fieldNames = originalTypeInfo.getAllStructFieldNames();
        this.fieldInfos = originalTypeInfo.getAllStructFieldTypeInfos();
        this.fields = new ArrayList<StructField>(this.fieldNames.size());
        this.fieldsByName = new HashMap();
        for (int i = 0; i < this.fieldNames.size(); ++i) {
            String name = this.fieldNames.get(i);
            TypeInfo fieldInfo = this.fieldInfos.get(i);
            StructFieldImpl field = null;
            if (prunedTypeInfo != null) {
                for (int idx = 0; idx < prunedTypeInfo.getAllStructFieldNames().size(); ++idx) {
                    if (!((String)prunedTypeInfo.getAllStructFieldNames().get(idx)).equalsIgnoreCase(name)) continue;
                    TypeInfo prunedFieldInfo = (TypeInfo)prunedTypeInfo.getAllStructFieldTypeInfos().get(idx);
                    field = new StructFieldImpl(name, this.getObjectInspector(fieldInfo, prunedFieldInfo), i, idx);
                    break;
                }
            }
            if (field == null) {
                field = new StructFieldImpl(name, this.getObjectInspector(fieldInfo, null), i, i);
            }
            this.fields.add(field);
            this.fieldsByName.put(name.toLowerCase(), field);
        }
    }

    private ObjectInspector getObjectInspector(TypeInfo typeInfo, TypeInfo prunedTypeInfo) {
        if (typeInfo.equals((Object)TypeInfoFactory.doubleTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }
        if (typeInfo.equals((Object)TypeInfoFactory.booleanTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
        }
        if (typeInfo.equals((Object)TypeInfoFactory.floatTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
        }
        if (typeInfo.equals((Object)TypeInfoFactory.intTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        }
        if (typeInfo.equals((Object)TypeInfoFactory.longTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        }
        if (typeInfo.equals((Object)TypeInfoFactory.stringTypeInfo)) {
            return ParquetPrimitiveInspectorFactory.parquetStringInspector;
        }
        if (typeInfo instanceof DecimalTypeInfo) {
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)((DecimalTypeInfo)typeInfo));
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.STRUCT)) {
            return new ArrayWritableObjectInspector(false, (StructTypeInfo)typeInfo, (StructTypeInfo)prunedTypeInfo);
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            TypeInfo subTypeInfo = ((ListTypeInfo)typeInfo).getListElementTypeInfo();
            return new ParquetHiveArrayInspector(this.getObjectInspector(subTypeInfo, null));
        }
        if (typeInfo.getCategory().equals((Object)ObjectInspector.Category.MAP)) {
            TypeInfo keyTypeInfo = ((MapTypeInfo)typeInfo).getMapKeyTypeInfo();
            TypeInfo valueTypeInfo = ((MapTypeInfo)typeInfo).getMapValueTypeInfo();
            if (keyTypeInfo.equals((Object)TypeInfoFactory.stringTypeInfo) || keyTypeInfo.equals((Object)TypeInfoFactory.byteTypeInfo) || keyTypeInfo.equals((Object)TypeInfoFactory.shortTypeInfo)) {
                return new DeepParquetHiveMapInspector(this.getObjectInspector(keyTypeInfo, null), this.getObjectInspector(valueTypeInfo, null));
            }
            return new StandardParquetHiveMapInspector(this.getObjectInspector(keyTypeInfo, null), this.getObjectInspector(valueTypeInfo, null));
        }
        if (typeInfo.equals((Object)TypeInfoFactory.byteTypeInfo)) {
            return ParquetPrimitiveInspectorFactory.parquetByteInspector;
        }
        if (typeInfo.equals((Object)TypeInfoFactory.shortTypeInfo)) {
            return ParquetPrimitiveInspectorFactory.parquetShortInspector;
        }
        if (typeInfo.equals((Object)TypeInfoFactory.timestampTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        }
        if (typeInfo.equals((Object)TypeInfoFactory.binaryTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
        }
        if (typeInfo.equals((Object)TypeInfoFactory.dateTypeInfo)) {
            return PrimitiveObjectInspectorFactory.writableDateObjectInspector;
        }
        if (typeInfo.getTypeName().toLowerCase().startsWith("char")) {
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)((CharTypeInfo)typeInfo));
        }
        if (typeInfo.getTypeName().toLowerCase().startsWith("varchar")) {
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)((VarcharTypeInfo)typeInfo));
        }
        throw new UnsupportedOperationException("Unknown field type: " + typeInfo);
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    public String getTypeName() {
        return this.typeInfo.getTypeName();
    }

    public List<? extends StructField> getAllStructFieldRefs() {
        return this.fields;
    }

    public Object getStructFieldData(Object data, StructField fieldRef) {
        if (data == null) {
            return null;
        }
        if (data instanceof ArrayWritable) {
            int index;
            ArrayWritable arr = (ArrayWritable)data;
            StructFieldImpl structField = (StructFieldImpl)fieldRef;
            int n = index = this.isRoot ? structField.getIndex() : structField.adjustedIndex;
            if (index < arr.get().length) {
                return arr.get()[index];
            }
            return null;
        }
        if (data instanceof List) {
            return ((List)data).get(((StructFieldImpl)fieldRef).getIndex());
        }
        throw new UnsupportedOperationException("Cannot inspect " + data.getClass().getCanonicalName());
    }

    public StructField getStructFieldRef(String name) {
        return this.fieldsByName.get(name.toLowerCase());
    }

    public List<Object> getStructFieldsDataAsList(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof ArrayWritable) {
            ArrayWritable arr = (ArrayWritable)data;
            Writable[] arrWritable = arr.get();
            return new ArrayList<Writable>(Arrays.asList(arrWritable));
        }
        if (data instanceof List) {
            return (List)data;
        }
        throw new UnsupportedOperationException("Cannot inspect " + data.getClass().getCanonicalName());
    }

    public Object create() {
        ArrayList<Object> list = new ArrayList<Object>(this.fields.size());
        for (int i = 0; i < this.fields.size(); ++i) {
            list.add(null);
        }
        return list;
    }

    public Object setStructFieldData(Object struct, StructField field, Object fieldValue) {
        ArrayList list = (ArrayList)struct;
        list.set(((StructFieldImpl)field).getIndex(), fieldValue);
        return list;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ArrayWritableObjectInspector that = (ArrayWritableObjectInspector)((Object)o);
        if (this.isRoot != that.isRoot || (this.typeInfo == null ? that.typeInfo != null : !this.typeInfo.equals((Object)that.typeInfo)) || (this.fieldInfos == null ? that.fieldInfos != null : !this.fieldInfos.equals(that.fieldInfos)) || (this.fieldNames == null ? that.fieldNames != null : !this.fieldNames.equals(that.fieldNames)) || (this.fields != null ? !this.fields.equals(that.fields) : that.fields != null)) {
            return false;
        }
        return this.fieldsByName != null ? this.fieldsByName.equals(that.fieldsByName) : that.fieldsByName == null;
    }

    public int hashCode() {
        int result = this.typeInfo != null ? this.typeInfo.hashCode() : 0;
        result = 31 * result + (this.fieldInfos != null ? this.fieldInfos.hashCode() : 0);
        result = 31 * result + (this.fieldNames != null ? this.fieldNames.hashCode() : 0);
        result = 31 * result + (this.fields != null ? this.fields.hashCode() : 0);
        result = 31 * result + (this.fieldsByName != null ? this.fieldsByName.hashCode() : 0);
        result = 31 * result + (this.isRoot ? 1 : 0);
        return result;
    }

    private class StructFieldImpl
    implements StructField {
        private final String name;
        private final ObjectInspector inspector;
        private final int index;
        final int adjustedIndex;

        public StructFieldImpl(String name, ObjectInspector inspector, int index, int adjustedIndex) {
            this.name = name;
            this.inspector = inspector;
            this.index = index;
            this.adjustedIndex = adjustedIndex;
        }

        public String getFieldComment() {
            return "";
        }

        public String getFieldName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public ObjectInspector getFieldObjectInspector() {
            return this.inspector;
        }

        public int getFieldID() {
            return this.index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StructFieldImpl that = (StructFieldImpl)o;
            if (this.index != that.index) {
                return false;
            }
            if (this.adjustedIndex != that.adjustedIndex) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return this.inspector != null ? this.inspector.equals(that.inspector) : that.inspector == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.inspector != null ? this.inspector.hashCode() : 0);
            result = 31 * result + this.index;
            result = 31 * result + this.adjustedIndex;
            return result;
        }
    }
}

