/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.adaptive;

import org.apache.commons.io.FileUtils;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t3A!\u0003\u0006\u0005/!)a\u0004\u0001C\u0001?!1!\u0005\u0001Q!\n\rBaA\n\u0001!B\u00139\u0003B\u0002\u0016\u0001A\u0003&q\u0005\u0003\u0004,\u0001\u0001\u0006Ka\n\u0005\u0006Y\u0001!\t!\f\u0005\u0006]\u0001!\ta\f\u0005\u0006k\u0001!\tE\u000e\u0002\t'.,w\u000fR3tG*\u00111\u0002D\u0001\tC\u0012\f\u0007\u000f^5wK*\u0011QBD\u0001\nKb,7-\u001e;j_:T!a\u0004\t\u0002\u0007M\fHN\u0003\u0002\u0012%\u0005)1\u000f]1sW*\u00111\u0003F\u0001\u0007CB\f7\r[3\u000b\u0003U\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\"\u00015\t!\"A\nok6\u001c6.Z<fIB\u000b'\u000f^5uS>t7\u000f\u0005\u0002\u001aI%\u0011QE\u0007\u0002\u0004\u0013:$\u0018!\u0003;pi\u0006d7+\u001b>f!\tI\u0002&\u0003\u0002*5\t!Aj\u001c8h\u0003\u001di\u0017\r_*ju\u0016\fq!\\5o'&TX-A\u0007ok6\u0004\u0016M\u001d;ji&|gn]\u000b\u0002G\u0005\u0001\u0012\r\u001a3QCJ$\u0018\u000e^5p]NK'0\u001a\u000b\u0003aM\u0002\"!G\u0019\n\u0005IR\"\u0001B+oSRDQ\u0001N\u0004A\u0002\u001d\nAa]5{K\u0006AAo\\*ue&tw\rF\u00018!\tAtH\u0004\u0002:{A\u0011!HG\u0007\u0002w)\u0011AHF\u0001\u0007yI|w\u000e\u001e \n\u0005yR\u0012A\u0002)sK\u0012,g-\u0003\u0002A\u0003\n11\u000b\u001e:j]\u001eT!A\u0010\u000e")
public class SkewDesc {
    private int numSkewedPartitions = 0;
    private long totalSize = 0L;
    private long maxSize = 0L;
    private long minSize = 0L;

    public int numPartitions() {
        return this.numSkewedPartitions;
    }

    public void addPartitionSize(long size) {
        block2: {
            if (this.numSkewedPartitions == 0) {
                this.maxSize = size;
                this.minSize = size;
            }
            ++this.numSkewedPartitions;
            this.totalSize += size;
            if (size > this.maxSize) {
                this.maxSize = size;
            }
            if (size >= this.minSize) break block2;
            this.minSize = size;
        }
    }

    public String toString() {
        String string;
        if (this.numSkewedPartitions == 0) {
            string = "no skewed partition";
        } else {
            String maxSizeStr = FileUtils.byteCountToDisplaySize((long)this.maxSize);
            String minSizeStr = FileUtils.byteCountToDisplaySize((long)this.minSize);
            String avgSizeStr = FileUtils.byteCountToDisplaySize((long)(this.totalSize / (long)this.numSkewedPartitions));
            string = new StringBuilder(46).append(this.numSkewedPartitions).append(" skewed partitions with ").append("size(max=").append(maxSizeStr).append(", min=").append(minSizeStr).append(", avg=").append(avgSizeStr).append(")").toString();
        }
        return string;
    }
}

