/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.metrics.sink;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.metrics.sink.Sink;
import org.apache.spark.ui.JettyUtils;
import org.apache.spark.ui.JettyUtils$;
import org.apache.spark.ui.JettyUtils$ServletParams$;
import org.sparkproject.jetty.servlet.ServletContextHandler;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015b!B\t\u0013\u0001Ya\u0002\u0002C\u0014\u0001\u0005\u000b\u0007I\u0011A\u0015\t\u0011I\u0002!\u0011!Q\u0001\n)B\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\t}\u0001\u0011\t\u0011)A\u0005k!Aq\b\u0001B\u0001B\u0003%\u0001\tC\u0003E\u0001\u0011\u0005Q\tC\u0004K\u0001\t\u0007I\u0011A&\t\rI\u0003\u0001\u0015!\u0003M\u0011\u001d\u0019\u0006A1A\u0005\u0002-Ca\u0001\u0016\u0001!\u0002\u0013a\u0005\"B+\u0001\t\u00031\u0006\"B5\u0001\t\u0003Q\u0007bBA\u0001\u0001\u0011%\u00111\u0001\u0005\b\u0003\u0013\u0001A\u0011IA\u0006\u0011\u001d\t\u0019\u0002\u0001C!\u0003\u0017Aq!!\u0006\u0001\t\u0003\nYAA\tQe>lW\r\u001e5fkN\u001cVM\u001d<mKRT!a\u0005\u000b\u0002\tMLgn\u001b\u0006\u0003+Y\tq!\\3ue&\u001c7O\u0003\u0002\u00181\u0005)1\u000f]1sW*\u0011\u0011DG\u0001\u0007CB\f7\r[3\u000b\u0003m\t1a\u001c:h'\r\u0001Qd\t\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011*S\"\u0001\n\n\u0005\u0019\u0012\"\u0001B*j].\f\u0001\u0002\u001d:pa\u0016\u0014H/_\u0002\u0001+\u0005Q\u0003CA\u00161\u001b\u0005a#BA\u0017/\u0003\u0011)H/\u001b7\u000b\u0003=\nAA[1wC&\u0011\u0011\u0007\f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!\u00039s_B,'\u000f^=!\u0003!\u0011XmZ5tiJLX#A\u001b\u0011\u0005YbT\"A\u001c\u000b\u0005UA$BA\u001d;\u0003!\u0019w\u000eZ1iC2,'\"A\u001e\u0002\u0007\r|W.\u0003\u0002>o\tqQ*\u001a;sS\u000e\u0014VmZ5tiJL\u0018!\u0003:fO&\u001cHO]=!\u0003-\u0019XmY;sSRLXj\u001a:\u0011\u0005\u0005\u0013U\"\u0001\f\n\u0005\r3\"aD*fGV\u0014\u0018\u000e^=NC:\fw-\u001a:\u0002\rqJg.\u001b;?)\u00111u\tS%\u0011\u0005\u0011\u0002\u0001\"B\u0014\u0007\u0001\u0004Q\u0003\"B\u001a\u0007\u0001\u0004)\u0004\"B \u0007\u0001\u0004\u0001\u0015\u0001E*F%ZcU\tV0L\u000bf{\u0006+\u0011+I+\u0005a\u0005CA'Q\u001b\u0005q%BA(/\u0003\u0011a\u0017M\\4\n\u0005Es%AB*ue&tw-A\tT\u000bJ3F*\u0012+`\u0017\u0016Kv\fU!U\u0011\u0002\n1b]3sm2,G\u000fU1uQ\u0006a1/\u001a:wY\u0016$\b+\u0019;iA\u0005Yq-\u001a;IC:$G.\u001a:t)\t9F\rE\u0002\u001f1jK!!W\u0010\u0003\u000b\u0005\u0013(/Y=\u0011\u0005m\u0013W\"\u0001/\u000b\u0005us\u0016aB:feZdW\r\u001e\u0006\u0003?\u0002\fQA[3uifT!!\u0019\u000e\u0002\u000f\u0015\u001cG.\u001b9tK&\u00111\r\u0018\u0002\u0016'\u0016\u0014h\u000f\\3u\u0007>tG/\u001a=u\u0011\u0006tG\r\\3s\u0011\u0015)7\u00021\u0001g\u0003\u0011\u0019wN\u001c4\u0011\u0005\u0005;\u0017B\u00015\u0017\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\nhKRlU\r\u001e:jGN\u001cf.\u00199tQ>$HCA6v!\ta7O\u0004\u0002ncB\u0011anH\u0007\u0002_*\u0011\u0001\u000fK\u0001\u0007yI|w\u000e\u001e \n\u0005I|\u0012A\u0002)sK\u0012,g-\u0003\u0002Ri*\u0011!o\b\u0005\u0006m2\u0001\ra^\u0001\be\u0016\fX/Z:u!\tAh0D\u0001z\u0015\tQ80\u0001\u0003iiR\u0004(BA/}\u0015\u0005i\u0018!\u00026bm\u0006D\u0018BA@z\u0005IAE\u000f\u001e9TKJ4H.\u001a;SKF,Xm\u001d;\u0002\u00199|'/\\1mSj,7*Z=\u0015\u0007-\f)\u0001\u0003\u0004\u0002\b5\u0001\ra[\u0001\u0004W\u0016L\u0018!B:uCJ$HCAA\u0007!\rq\u0012qB\u0005\u0004\u0003#y\"\u0001B+oSR\fAa\u001d;pa\u00061!/\u001a9peRD3\u0001AA\r!\u0011\tY\"!\t\u000e\u0005\u0005u!bAA\u0010-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0012Q\u0004\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c")
public class PrometheusServlet
implements Sink {
    private final Properties property;
    private final MetricRegistry registry;
    private final String SERVLET_KEY_PATH;
    private final String servletPath;

    public Properties property() {
        return this.property;
    }

    public MetricRegistry registry() {
        return this.registry;
    }

    public String SERVLET_KEY_PATH() {
        return this.SERVLET_KEY_PATH;
    }

    public String servletPath() {
        return this.servletPath;
    }

    public ServletContextHandler[] getHandlers(SparkConf conf) {
        return (ServletContextHandler[])((Object[])new ServletContextHandler[]{JettyUtils$.MODULE$.createServletHandler(this.servletPath(), new JettyUtils.ServletParams<Object>((Function1 & Serializable & scala.Serializable)request -> this.getMetricsSnapshot((HttpServletRequest)request), "text/plain", JettyUtils$ServletParams$.MODULE$.$lessinit$greater$default$3()), conf, JettyUtils$.MODULE$.createServletHandler$default$4())});
    }

    public String getMetricsSnapshot(HttpServletRequest request) {
        String countersLabel;
        String guagesLabel = "{type=\"gauges\"}";
        String metersLabel = countersLabel = "{type=\"counters\"}";
        String histogramslabels = "{type=\"histograms\"}";
        String timersLabels = "{type=\"timers\"}";
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.registry().getGauges()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                Gauge v = (Gauge)tuple2._2();
                if (!(v.getValue() instanceof String)) {
                    sb.append(new StringBuilder(8).append(this.normalizeKey(k)).append("Number").append(guagesLabel).append(" ").append(v.getValue()).append("\n").toString());
                    boxedUnit = sb.append(new StringBuilder(7).append(this.normalizeKey(k)).append("Value").append(guagesLabel).append(" ").append(v.getValue()).append("\n").toString());
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return boxedUnit2;
        });
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.registry().getCounters()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Counter v = (Counter)tuple2._2();
            scala.collection.mutable.StringBuilder stringBuilder = sb.append(new StringBuilder(7).append(this.normalizeKey(k)).append("Count").append(countersLabel).append(" ").append(v.getCount()).append("\n").toString());
            return stringBuilder;
        });
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)this.registry().getHistograms()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            Histogram h = (Histogram)tuple2._2();
            Snapshot snapshot = h.getSnapshot();
            String prefix = this.normalizeKey(k);
            sb.append(new StringBuilder(7).append(prefix).append("Count").append(histogramslabels).append(" ").append(h.getCount()).append("\n").toString());
            sb.append(new StringBuilder(5).append(prefix).append("Max").append(histogramslabels).append(" ").append(snapshot.getMax()).append("\n").toString());
            sb.append(new StringBuilder(6).append(prefix).append("Mean").append(histogramslabels).append(" ").append(snapshot.getMean()).append("\n").toString());
            sb.append(new StringBuilder(5).append(prefix).append("Min").append(histogramslabels).append(" ").append(snapshot.getMin()).append("\n").toString());
            sb.append(new StringBuilder(16).append(prefix).append("50thPercentile").append(histogramslabels).append(" ").append(snapshot.getMedian()).append("\n").toString());
            sb.append(new StringBuilder(16).append(prefix).append("75thPercentile").append(histogramslabels).append(" ").append(snapshot.get75thPercentile()).append("\n").toString());
            sb.append(new StringBuilder(16).append(prefix).append("95thPercentile").append(histogramslabels).append(" ").append(snapshot.get95thPercentile()).append("\n").toString());
            sb.append(new StringBuilder(16).append(prefix).append("98thPercentile").append(histogramslabels).append(" ").append(snapshot.get98thPercentile()).append("\n").toString());
            sb.append(new StringBuilder(16).append(prefix).append("99thPercentile").append(histogramslabels).append(" ").append(snapshot.get99thPercentile()).append("\n").toString());
            sb.append(new StringBuilder(17).append(prefix).append("999thPercentile").append(histogramslabels).append(" ").append(snapshot.get999thPercentile()).append("\n").toString());
            scala.collection.mutable.StringBuilder stringBuilder = sb.append(new StringBuilder(8).append(prefix).append("StdDev").append(histogramslabels).append(" ").append(snapshot.getStdDev()).append("\n").toString());
            return stringBuilder;
        });
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.registry().getMeters().entrySet().iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)kv -> {
            String prefix = this.normalizeKey((String)kv.getKey());
            Meter meter = (Meter)kv.getValue();
            sb.append(new StringBuilder(7).append(prefix).append("Count").append(metersLabel).append(" ").append(meter.getCount()).append("\n").toString());
            sb.append(new StringBuilder(10).append(prefix).append("MeanRate").append(metersLabel).append(" ").append(meter.getMeanRate()).append("\n").toString());
            sb.append(new StringBuilder(15).append(prefix).append("OneMinuteRate").append(metersLabel).append(" ").append(meter.getOneMinuteRate()).append("\n").toString());
            sb.append(new StringBuilder(16).append(prefix).append("FiveMinuteRate").append(metersLabel).append(" ").append(meter.getFiveMinuteRate()).append("\n").toString());
            return sb.append(new StringBuilder(19).append(prefix).append("FifteenMinuteRate").append(metersLabel).append(" ").append(meter.getFifteenMinuteRate()).append("\n").toString());
        });
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.registry().getTimers().entrySet().iterator()).asScala()).foreach((Function1 & Serializable & scala.Serializable)kv -> {
            String prefix = this.normalizeKey((String)kv.getKey());
            Timer timer = (Timer)kv.getValue();
            Snapshot snapshot = timer.getSnapshot();
            sb.append(new StringBuilder(7).append(prefix).append("Count").append(timersLabels).append(" ").append(timer.getCount()).append("\n").toString());
            sb.append(new StringBuilder(5).append(prefix).append("Max").append(timersLabels).append(" ").append(snapshot.getMax()).append("\n").toString());
            sb.append(new StringBuilder(6).append(prefix).append("Mean").append(timersLabels).append(" ").append(snapshot.getMean()).append("\n").toString());
            sb.append(new StringBuilder(5).append(prefix).append("Min").append(timersLabels).append(" ").append(snapshot.getMin()).append("\n").toString());
            sb.append(new StringBuilder(16).append(prefix).append("50thPercentile").append(timersLabels).append(" ").append(snapshot.getMedian()).append("\n").toString());
            sb.append(new StringBuilder(16).append(prefix).append("75thPercentile").append(timersLabels).append(" ").append(snapshot.get75thPercentile()).append("\n").toString());
            sb.append(new StringBuilder(16).append(prefix).append("95thPercentile").append(timersLabels).append(" ").append(snapshot.get95thPercentile()).append("\n").toString());
            sb.append(new StringBuilder(16).append(prefix).append("98thPercentile").append(timersLabels).append(" ").append(snapshot.get98thPercentile()).append("\n").toString());
            sb.append(new StringBuilder(16).append(prefix).append("99thPercentile").append(timersLabels).append(" ").append(snapshot.get99thPercentile()).append("\n").toString());
            sb.append(new StringBuilder(17).append(prefix).append("999thPercentile").append(timersLabels).append(" ").append(snapshot.get999thPercentile()).append("\n").toString());
            sb.append(new StringBuilder(8).append(prefix).append("StdDev").append(timersLabels).append(" ").append(snapshot.getStdDev()).append("\n").toString());
            sb.append(new StringBuilder(19).append(prefix).append("FifteenMinuteRate").append(timersLabels).append(" ").append(timer.getFifteenMinuteRate()).append("\n").toString());
            sb.append(new StringBuilder(16).append(prefix).append("FiveMinuteRate").append(timersLabels).append(" ").append(timer.getFiveMinuteRate()).append("\n").toString());
            sb.append(new StringBuilder(15).append(prefix).append("OneMinuteRate").append(timersLabels).append(" ").append(timer.getOneMinuteRate()).append("\n").toString());
            return sb.append(new StringBuilder(10).append(prefix).append("MeanRate").append(timersLabels).append(" ").append(timer.getMeanRate()).append("\n").toString());
        });
        return sb.toString();
    }

    private String normalizeKey(String key) {
        return new StringBuilder(9).append("metrics_").append(key.replaceAll("[^a-zA-Z0-9]", "_")).append("_").toString();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void report() {
    }

    public PrometheusServlet(Properties property, MetricRegistry registry, SecurityManager securityMgr) {
        this.property = property;
        this.registry = registry;
        this.SERVLET_KEY_PATH = "path";
        this.servletPath = property.getProperty(this.SERVLET_KEY_PATH());
    }
}

