/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.aggregate.Collect;
import org.apache.spark.sql.catalyst.expressions.aggregate.CollectSet$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ImperativeAggregate;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Collects and returns a set of unique elements.", examples="\n    Examples:\n      > SELECT _FUNC_(col) FROM VALUES (1), (2), (1) AS tab(col);\n       [1,2]\n  ", note="\n    The function is non-deterministic because the order of collected results depends\n    on the order of the rows which may be non-deterministic after a shuffle.\n  ", group="agg_funcs", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0001\t\ra\u0001\u0002\u0014(\u0001ZB\u0001b\u0014\u0001\u0003\u0016\u0004%\t\u0001\u0015\u0005\t+\u0002\u0011\t\u0012)A\u0005#\"Aa\u000b\u0001BK\u0002\u0013\u0005q\u000b\u0003\u0005\\\u0001\tE\t\u0015!\u0003Y\u0011!a\u0006A!f\u0001\n\u00039\u0006\u0002C/\u0001\u0005#\u0005\u000b\u0011\u0002-\t\u000by\u0003A\u0011A0\t\u000by\u0003A\u0011\u00013\t\u0011\u0019\u0004\u0001R1A\u0005B\u001dDQA\u001c\u0001\u0005B=DQA\u001d\u0001\u0005BMDQA\u001e\u0001\u0005B]DQA \u0001\u0005B}Dq!a\u0003\u0001\t\u0003\ni\u0001C\u0004\u0002\u0014\u0001!\t%!\u0006\t\u000f\u00055\u0002\u0001\"\u0011\u00020!I\u0011\u0011\u0007\u0001\u0002\u0002\u0013\u0005\u00111\u0007\u0005\n\u0003w\u0001\u0011\u0013!C\u0001\u0003{A\u0011\"a\u0015\u0001#\u0003%\t!!\u0016\t\u0013\u0005e\u0003!%A\u0005\u0002\u0005U\u0003\"CA.\u0001\u0005\u0005I\u0011IA/\u0011!\ti\u0007AA\u0001\n\u00039\u0006\"CA8\u0001\u0005\u0005I\u0011AA9\u0011%\t9\bAA\u0001\n\u0003\nI\bC\u0005\u0002\u0004\u0002\t\t\u0011\"\u0001\u0002\u0006\"I\u0011q\u0012\u0001\u0002\u0002\u0013\u0005\u0013\u0011S\u0004\n\u0003w;\u0013\u0011!E\u0001\u0003{3\u0001BJ\u0014\u0002\u0002#\u0005\u0011q\u0018\u0005\u0007=r!\t!!4\t\u0013\u0005=G$!A\u0005F\u0005E\u0007\"CAj9\u0005\u0005I\u0011QAk\u0011%\ti\u000eHI\u0001\n\u0003\t)\u0006C\u0005\u0002`r\t\n\u0011\"\u0001\u0002V!I\u0011\u0011\u001d\u000f\u0002\u0002\u0013\u0005\u00151\u001d\u0005\n\u0003kd\u0012\u0013!C\u0001\u0003+B\u0011\"a>\u001d#\u0003%\t!!\u0016\t\u0013\u0005eH$!A\u0005\n\u0005m(AC\"pY2,7\r^*fi*\u0011\u0001&K\u0001\nC\u001e<'/Z4bi\u0016T!AK\u0016\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003Y5\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003]=\n1a]9m\u0015\t\u0001\u0014'A\u0003ta\u0006\u00148N\u0003\u00023g\u00051\u0011\r]1dQ\u0016T\u0011\u0001N\u0001\u0004_J<7\u0001A\n\u0005\u0001]JE\nE\u00029smj\u0011aJ\u0005\u0003u\u001d\u0012qaQ8mY\u0016\u001cG\u000fE\u0002=\u0007\u0016k\u0011!\u0010\u0006\u0003}}\nq!\\;uC\ndWM\u0003\u0002A\u0003\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003\t\u000bQa]2bY\u0006L!\u0001R\u001f\u0003\u000f!\u000b7\u000f[*fiB\u0011aiR\u0007\u0002\u0003&\u0011\u0001*\u0011\u0002\u0004\u0003:L\bC\u0001$K\u0013\tY\u0015IA\u0004Qe>$Wo\u0019;\u0011\u0005\u0019k\u0015B\u0001(B\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u0015\u0019\u0007.\u001b7e+\u0005\t\u0006C\u0001*T\u001b\u0005I\u0013B\u0001+*\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0007G\"LG\u000e\u001a\u0011\u0002-5,H/\u00192mK\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR,\u0012\u0001\u0017\t\u0003\rfK!AW!\u0003\u0007%sG/A\fnkR\f'\r\\3BO\u001e\u0014UO\u001a4fe>3gm]3uA\u0005!\u0012N\u001c9vi\u0006;wMQ;gM\u0016\u0014xJ\u001a4tKR\fQ#\u001b8qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\b%\u0001\u0004=S:LGO\u0010\u000b\u0005A\u0006\u00147\r\u0005\u00029\u0001!)qj\u0002a\u0001#\"9ak\u0002I\u0001\u0002\u0004A\u0006b\u0002/\b!\u0003\u0005\r\u0001\u0017\u000b\u0003A\u0016DQa\u0014\u0005A\u0002E\u000b\u0011CY;gM\u0016\u0014X\t\\3nK:$H+\u001f9f+\u0005A\u0007CA5m\u001b\u0005Q'BA6.\u0003\u0015!\u0018\u0010]3t\u0013\ti'N\u0001\u0005ECR\fG+\u001f9f\u0003Y\u0019wN\u001c<feR$vNQ;gM\u0016\u0014X\t\\3nK:$HCA#q\u0011\u0015\t(\u00021\u0001F\u0003\u00151\u0018\r\\;f\u0003\u0011)g/\u00197\u0015\u0005\u0015#\b\"B;\f\u0001\u0004Y\u0014A\u00022vM\u001a,'/A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000fF\u0001y!\tIH0D\u0001{\u0015\tY8&\u0001\u0005b]\u0006d\u0017p]5t\u0013\ti(PA\bUsB,7\t[3dWJ+7/\u001e7u\u0003u9\u0018\u000e\u001e5OK^lU\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$H\u0003BA\u0001\u0003\u000f\u00012\u0001OA\u0002\u0013\r\t)a\n\u0002\u0014\u00136\u0004XM]1uSZ,\u0017iZ4sK\u001e\fG/\u001a\u0005\u0007\u0003\u0013i\u0001\u0019\u0001-\u000239,w/T;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r^\u0001\u001co&$\bNT3x\u0013:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\u0015\t\u0005\u0005\u0011q\u0002\u0005\u0007\u0003#q\u0001\u0019\u0001-\u0002/9,w/\u00138qkR\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\u0018A\u00039sKR$\u0018PT1nKV\u0011\u0011q\u0003\t\u0005\u00033\t9C\u0004\u0003\u0002\u001c\u0005\r\u0002cAA\u000f\u00036\u0011\u0011q\u0004\u0006\u0004\u0003C)\u0014A\u0002\u001fs_>$h(C\u0002\u0002&\u0005\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0015\u0003W\u0011aa\u0015;sS:<'bAA\u0013\u0003\u000692M]3bi\u0016\fum\u001a:fO\u0006$\u0018n\u001c8Ck\u001a4WM\u001d\u000b\u0002w\u0005!1m\u001c9z)\u001d\u0001\u0017QGA\u001c\u0003sAqaT\t\u0011\u0002\u0003\u0007\u0011\u000bC\u0004W#A\u0005\t\u0019\u0001-\t\u000fq\u000b\u0002\u0013!a\u00011\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA U\r\t\u0016\u0011I\u0016\u0003\u0003\u0007\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%A\u0005v]\u000eDWmY6fI*\u0019\u0011QJ!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002R\u0005\u001d#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA,U\rA\u0016\u0011I\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\f\t\u0005\u0003C\nY'\u0004\u0002\u0002d)!\u0011QMA4\u0003\u0011a\u0017M\\4\u000b\u0005\u0005%\u0014\u0001\u00026bm\u0006LA!!\u000b\u0002d\u0005a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$HcA#\u0002t!A\u0011QO\f\u0002\u0002\u0003\u0007\u0001,A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003w\u0002R!! \u0002\u0000\u0015k\u0011aP\u0005\u0004\u0003\u0003{$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!a\"\u0002\u000eB\u0019a)!#\n\u0007\u0005-\u0015IA\u0004C_>dW-\u00198\t\u0011\u0005U\u0014$!AA\u0002\u0015\u000ba!Z9vC2\u001cH\u0003BAD\u0003'C\u0001\"!\u001e\u001b\u0003\u0003\u0005\r!\u0012\u0015\u0018\u0001\u0005]\u0015QTAP\u0003G\u000b)+!+\u0002,\u0006=\u0016\u0011WA[\u0003o\u00032AUAM\u0013\r\tY*\u000b\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\t+A\u001f`\rVs5i\u0018\u0015fqB\u0014\u0018\u0006I\u0017!\u0007>dG.Z2ug\u0002\ng\u000e\u001a\u0011sKR,(O\\:!C\u0002\u001aX\r\u001e\u0011pM\u0002*h.[9vK\u0002*G.Z7f]R\u001ch&\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\t9+\u00011\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\r|G.\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0019*Y\u0001B#'\u000b\u0017!QEJ\u0003%Q*!i\u0006\u0014\u0007fY8mSmR\u0001\u0005\t\u0011!A\u0001\u00023,\r\u00173;*\u0001\u0003%\u0001\u0003o_R,\u0017EAAW\u0003\u0005-#\u0002\t\u0011!AQCW\r\t4v]\u000e$\u0018n\u001c8!SN\u0004cn\u001c8.I\u0016$XM]7j]&\u001cH/[2!E\u0016\u001c\u0017-^:fAQDW\rI8sI\u0016\u0014\be\u001c4!G>dG.Z2uK\u0012\u0004#/Z:vYR\u001c\b\u0005Z3qK:$7O\u0003\u0011!A\u0001zg\u000e\t;iK\u0002z'\u000fZ3sA=4\u0007\u0005\u001e5fAI|wo\u001d\u0011xQ&\u001c\u0007\u000eI7bs\u0002\u0012W\r\t8p]6\"W\r^3s[&t\u0017n\u001d;jG\u0002\ng\r^3sA\u0005\u00043\u000f[;gM2,gF\u0003\u0011!\u0003\u00159'o\\;qC\t\t\u0019,A\u0005bO\u001e|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u0011\u0011X\u0001\u0006e9\u0002d\u0006M\u0001\u000b\u0007>dG.Z2u'\u0016$\bC\u0001\u001d\u001d'\u0011a\u0012\u0011\u0019'\u0011\u0011\u0005\r\u0017\u0011Z)Y1\u0002l!!!2\u000b\u0007\u0005\u001d\u0017)A\u0004sk:$\u0018.\\3\n\t\u0005-\u0017Q\u0019\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDCAA_\u0003!!xn\u0015;sS:<GCAA0\u0003\u0015\t\u0007\u000f\u001d7z)\u001d\u0001\u0017q[Am\u00037DQaT\u0010A\u0002ECqAV\u0010\u0011\u0002\u0003\u0007\u0001\fC\u0004]?A\u0005\t\u0019\u0001-\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uII\nq\"\u00199qYf$C-\u001a4bk2$HeM\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t)/!=\u0011\u000b\u0019\u000b9/a;\n\u0007\u0005%\u0018I\u0001\u0004PaRLwN\u001c\t\u0007\r\u00065\u0018\u000b\u0017-\n\u0007\u0005=\u0018I\u0001\u0004UkBdWm\r\u0005\t\u0003g\u0014\u0013\u0011!a\u0001A\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\u0010\u0005\u0003\u0002b\u0005}\u0018\u0002\u0002B\u0001\u0003G\u0012aa\u00142kK\u000e$\b")
public class CollectSet
extends Collect<HashSet<Object>>
implements scala.Serializable {
    private DataType bufferElementType;
    private final Expression child;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private volatile boolean bitmap$0;

    public static int $lessinit$greater$default$3() {
        return CollectSet$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$2() {
        return CollectSet$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple3<Expression, Object, Object>> unapply(CollectSet collectSet) {
        return CollectSet$.MODULE$.unapply(collectSet);
    }

    public static int apply$default$3() {
        return CollectSet$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return CollectSet$.MODULE$.apply$default$2();
    }

    public static Function1<Tuple3<Expression, Object, Object>, CollectSet> tupled() {
        return CollectSet$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Object, Function1<Object, CollectSet>>> curried() {
        return CollectSet$.MODULE$.curried();
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private DataType bufferElementType$lzycompute() {
        CollectSet collectSet = this;
        synchronized (collectSet) {
            if (!this.bitmap$0) {
                DataType dataType = this.child().dataType();
                DataType dataType2 = BinaryType$.MODULE$.equals(dataType) ? ArrayType$.MODULE$.apply(ByteType$.MODULE$) : dataType;
                this.bufferElementType = dataType2;
                this.bitmap$0 = true;
            }
        }
        return this.bufferElementType;
    }

    @Override
    public DataType bufferElementType() {
        return !this.bitmap$0 ? this.bufferElementType$lzycompute() : this.bufferElementType;
    }

    @Override
    public Object convertToBufferElement(Object value) {
        DataType dataType = this.child().dataType();
        Object object = BinaryType$.MODULE$.equals(dataType) ? UnsafeArrayData.fromPrimitiveArray((byte[])value) : InternalRow$.MODULE$.copyValue(value);
        return object;
    }

    @Override
    public Object eval(HashSet<Object> buffer) {
        DataType dataType = this.child().dataType();
        Object object = BinaryType$.MODULE$.equals(dataType) ? buffer.iterator().map((Function1 & Serializable & scala.Serializable)x$3 -> ((ArrayData)x$3).toByteArray()).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE))) : buffer.toArray(ClassTag$.MODULE$.Any());
        Object array = object;
        return new GenericArrayData(array);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return !this.child().dataType().existsRecursively((Function1<DataType, Object>)(Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CollectSet.$anonfun$checkInputDataTypes$1(x$4))) ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure("collect_set() cannot have map type data");
    }

    @Override
    public ImperativeAggregate withNewMutableAggBufferOffset(int newMutableAggBufferOffset) {
        int x$1 = newMutableAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ImperativeAggregate withNewInputAggBufferOffset(int newInputAggBufferOffset) {
        int x$1 = newInputAggBufferOffset;
        Expression x$2 = this.copy$default$1();
        int x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, x$1);
    }

    @Override
    public String prettyName() {
        return "collect_set";
    }

    @Override
    public HashSet<Object> createAggregationBuffer() {
        return HashSet$.MODULE$.empty();
    }

    public CollectSet copy(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new CollectSet(child, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public int copy$default$2() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$3() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "CollectSet";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.child();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CollectSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CollectSet)) return false;
        boolean bl = true;
        if (!bl) return false;
        CollectSet collectSet = (CollectSet)x$1;
        Expression expression = this.child();
        Expression expression2 = collectSet.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (this.mutableAggBufferOffset() != collectSet.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != collectSet.inputAggBufferOffset()) return false;
        if (!collectSet.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$checkInputDataTypes$1(DataType x$4) {
        return x$4 instanceof MapType;
    }

    public CollectSet(Expression child, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
    }

    public CollectSet(Expression child) {
        this(child, 0, 0);
    }
}

