/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.DispatcherType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.deploy.security.HadoopDelegationTokenManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.rpc.RpcAddress;
import org.apache.spark.rpc.RpcCallContext;
import org.apache.spark.rpc.RpcEndpoint;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.rpc.RpcEnv;
import org.apache.spark.rpc.RpcTimeout;
import org.apache.spark.rpc.ThreadSafeRpcEndpoint;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.SlaveLost;
import org.apache.spark.scheduler.SlaveLost$;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.CoarseGrainedClusterMessages;
import org.apache.spark.scheduler.cluster.CoarseGrainedSchedulerBackend;
import org.apache.spark.scheduler.cluster.YarnSchedulerBackend$;
import org.apache.spark.scheduler.cluster.YarnSchedulerBackend$YarnSchedulerEndpoint$;
import org.apache.spark.ui.DelegatingServletContextHandler;
import org.apache.spark.ui.SparkUI;
import org.apache.spark.util.RpcUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t\rgA\u0002\u001d:\u0003\u0003i4\t\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003J\u0011!i\u0005A!A!\u0002\u0013q\u0005\"\u0002*\u0001\t\u0003\u0019\u0006bB,\u0001\u0005\u0004%I\u0001\u0017\u0005\u0007K\u0002\u0001\u000b\u0011B-\t\u000f\u0019\u0004!\u0019!C!O\"1a\u000e\u0001Q\u0001\n!Dqa\u001c\u0001A\u0002\u0013E\u0001\u000fC\u0004u\u0001\u0001\u0007I\u0011C;\t\rm\u0004\u0001\u0015)\u0003r\u0011\u001da\bA1A\u0005\nuDq!!!\u0001A\u0003%a\u0010C\u0005\u0002\u0004\u0002\u0001\r\u0011\"\u0005\u0002\u0006\"I\u00111\u0013\u0001A\u0002\u0013E\u0011Q\u0013\u0005\t\u00033\u0003\u0001\u0015)\u0003\u0002\b\"I\u00111\u0014\u0001C\u0002\u0013%\u0011Q\u0014\u0005\t\u0003?\u0003\u0001\u0015!\u0003\u0002\u000e\"I\u0011\u0011\u0015\u0001C\u0002\u0013-\u00111\u0015\u0005\t\u0003W\u0003\u0001\u0015!\u0003\u0002&\"I\u0011Q\u0016\u0001A\u0002\u0013E\u0011q\u0016\u0005\n\u0003\u0017\u0004\u0001\u0019!C\t\u0003\u001bD\u0001\"!5\u0001A\u0003&\u0011\u0011\u0017\u0005\n\u0003'\u0004\u0001\u0019!C\u0005\u0003+D\u0011\"a8\u0001\u0001\u0004%I!!9\t\u0011\u0005\u0015\b\u0001)Q\u0005\u0003/Dq!a:\u0001\t#\tI\u000fC\u0004\u0002p\u0002!\t\"!=\t\u000f\u0005M\b\u0001\"\u0011\u0002r\"9\u0011Q\u001f\u0001\u0005B\u0005]\bbBA~\u0001\u0011\u0005\u0013Q \u0005\t\u0003\u007f\u0004A\u0011A\u001d\u0003\u0002!9!\u0011\u0006\u0001\u0005B\t-\u0002b\u0002B \u0001\u0011\u0005#\u0011\t\u0005\b\u00053\u0002A\u0011\tB.\u0011!\u0011i\u0006\u0001C\u0001s\t}\u0003b\u0002B:\u0001\u0011\u0005#Q\u000f\u0005\t\u0005{\u0002A\u0011K\u001e\u0002r\"9!q\u0010\u0001\u0005R\t\u0005eA\u0002BK\u0001\u0011\u00119\n\u0003\u0004SO\u0011\u0005!\u0011\u0014\u0005\b\u0003#:C\u0011\tBO\r\u0019\t\t\u0001\u0001\u0003\u0002\u0004!Q\u00111\u0005\u0016\u0003\u0006\u0004%\t%!\n\t\u0015\u00055\"F!A!\u0002\u0013\t9\u0003\u0003\u0004SU\u0011\u0005\u0011q\u0006\u0005\b\u0003gQC\u0011IA\u001b\u0011\u001d\t\u0019E\u000bC!\u0003\u000bBq!!\u0015+\t\u0003\n\u0019\u0006\u0003\u0007\u0002`)\u0012\t\u0011!A\u0005\u0002\u0001\t\t\u0007\u0003\b\u0003$\u0002\u0001\n1!A\u0001\n\u0013\tiP!*\b\u0011\t-\u0016\b#\u0001>\u0005[3q\u0001O\u001d\t\u0002u\u0012y\u000b\u0003\u0004Si\u0011\u0005!\u0011\u0017\u0005\n\u0005g#$\u0019!C\u0001\u0005kC\u0001B!15A\u0003%!q\u0017\u0002\u00153\u0006\u0014hnU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u000b\u0005iZ\u0014aB2mkN$XM\u001d\u0006\u0003yu\n\u0011b]2iK\u0012,H.\u001a:\u000b\u0005yz\u0014!B:qCJ\\'B\u0001!B\u0003\u0019\t\u0007/Y2iK*\t!)A\u0002pe\u001e\u001c\"\u0001\u0001#\u0011\u0005\u00153U\"A\u001d\n\u0005\u001dK$!H\"pCJ\u001cXm\u0012:bS:,GmU2iK\u0012,H.\u001a:CC\u000e\\WM\u001c3\u0004\u0001A\u0011!jS\u0007\u0002w%\u0011Aj\u000f\u0002\u0012)\u0006\u001c8nU2iK\u0012,H.\u001a:J[Bd\u0017AA:d!\ty\u0005+D\u0001>\u0013\t\tVH\u0001\u0007Ta\u0006\u00148nQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0004)V3\u0006CA#\u0001\u0011\u0015a4\u00011\u0001J\u0011\u0015i5\u00011\u0001O\u0003\u001d\u0019Ho\u001c9qK\u0012,\u0012!\u0017\t\u00035\u000el\u0011a\u0017\u0006\u00039v\u000ba!\u0019;p[&\u001c'B\u00010`\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003A\u0006\fA!\u001e;jY*\t!-\u0001\u0003kCZ\f\u0017B\u00013\\\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006A1\u000f^8qa\u0016$\u0007%\u0001\nnS:\u0014VmZ5ti\u0016\u0014X\r\u001a*bi&|W#\u00015\u0011\u0005%dW\"\u00016\u000b\u0003-\fQa]2bY\u0006L!!\u001c6\u0003\r\u0011{WO\u00197f\u0003Mi\u0017N\u001c*fO&\u001cH/\u001a:fIJ\u000bG/[8!\u0003Y!x\u000e^1m\u000bb\u0004Xm\u0019;fI\u0016CXmY;u_J\u001cX#A9\u0011\u0005%\u0014\u0018BA:k\u0005\rIe\u000e^\u0001\u001bi>$\u0018\r\\#ya\u0016\u001cG/\u001a3Fq\u0016\u001cW\u000f^8sg~#S-\u001d\u000b\u0003mf\u0004\"![<\n\u0005aT'\u0001B+oSRDqA_\u0005\u0002\u0002\u0003\u0007\u0011/A\u0002yIE\nq\u0003^8uC2,\u0005\u0010]3di\u0016$W\t_3dkR|'o\u001d\u0011\u0002+e\f'O\\*dQ\u0016$W\u000f\\3s\u000b:$\u0007o\\5oiV\ta\u0010\u0005\u0002\u0000U5\t\u0001AA\u000bZCJt7k\u00195fIVdWM]#oIB|\u0017N\u001c;\u0014\u000f)\n)!a\u0003\u0002\u0018A\u0019\u0011.a\u0002\n\u0007\u0005%!N\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011C\u001f\u0002\u0007I\u00048-\u0003\u0003\u0002\u0016\u0005=!!\u0006+ie\u0016\fGmU1gKJ\u00038-\u00128ea>Lg\u000e\u001e\t\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011QD\u001f\u0002\u0011%tG/\u001a:oC2LA!!\t\u0002\u001c\t9Aj\\4hS:<\u0017A\u0002:qG\u0016sg/\u0006\u0002\u0002(A!\u0011QBA\u0015\u0013\u0011\tY#a\u0004\u0003\rI\u00038-\u00128w\u0003\u001d\u0011\boY#om\u0002\"2A`A\u0019\u0011\u001d\t\u0019#\fa\u0001\u0003O\tqA]3dK&4X-\u0006\u0002\u00028A1\u0011.!\u000f\u0002>YL1!a\u000fk\u0005=\u0001\u0016M\u001d;jC24UO\\2uS>t\u0007cA5\u0002@%\u0019\u0011\u0011\t6\u0003\u0007\u0005s\u00170A\bsK\u000e,\u0017N^3B]\u0012\u0014V\r\u001d7z)\u0011\t9$a\u0012\t\u000f\u0005%s\u00061\u0001\u0002L\u000591m\u001c8uKb$\b\u0003BA\u0007\u0003\u001bJA!a\u0014\u0002\u0010\tq!\u000b]2DC2d7i\u001c8uKb$\u0018AD8o\t&\u001c8m\u001c8oK\u000e$X\r\u001a\u000b\u0004m\u0006U\u0003bBA,a\u0001\u0007\u0011\u0011L\u0001\u000ee\u0016lw\u000e^3BI\u0012\u0014Xm]:\u0011\t\u00055\u00111L\u0005\u0005\u0003;\nyA\u0001\u0006Sa\u000e\fE\r\u001a:fgN\fQl\u001c:hI\u0005\u0004\u0018m\u00195fIM\u0004\u0018M]6%g\u000eDW\rZ;mKJ$3\r\\;ti\u0016\u0014H%W1s]N\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$G\u0005\n5b]\u0012dW-\u0012=fGV$xN\u001d#jg\u000e|gN\\3di\u0016$gI]8n\tJLg/\u001a:\u0015\u000bY\f\u0019'! \t\u000f\u0005\u0015\u0014\u00071\u0001\u0002h\u0005QQ\r_3dkR|'/\u00133\u0011\t\u0005%\u0014q\u000f\b\u0005\u0003W\n\u0019\bE\u0002\u0002n)l!!a\u001c\u000b\u0007\u0005E\u0004*\u0001\u0004=e>|GOP\u0005\u0004\u0003kR\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002z\u0005m$AB*ue&twMC\u0002\u0002v)Dq!a 2\u0001\u0004\tI&\u0001\nfq\u0016\u001cW\u000f^8s%B\u001c\u0017\t\u001a3sKN\u001c\u0018AF=be:\u001c6\r[3ek2,'/\u00128ea>Lg\u000e\u001e\u0011\u0002\u0015\u0005lWI\u001c3q_&tG/\u0006\u0002\u0002\bB)\u0011.!#\u0002\u000e&\u0019\u00111\u00126\u0003\r=\u0003H/[8o!\u0011\ti!a$\n\t\u0005E\u0015q\u0002\u0002\u000f%B\u001cWI\u001c3q_&tGOU3g\u00039\tW.\u00128ea>Lg\u000e^0%KF$2A^AL\u0011!Qh\"!AA\u0002\u0005\u001d\u0015aC1n\u000b:$\u0007o\\5oi\u0002\n\u0001$_1s]N\u001b\u0007.\u001a3vY\u0016\u0014XI\u001c3q_&tGOU3g+\t\ti)A\rzCJt7k\u00195fIVdWM]#oIB|\u0017N\u001c;SK\u001a\u0004\u0013AC1tWRKW.Z8viV\u0011\u0011Q\u0015\t\u0005\u0003\u001b\t9+\u0003\u0003\u0002*\u0006=!A\u0003*qGRKW.Z8vi\u0006Y\u0011m]6US6,w.\u001e;!\u0003\u0015\t\u0007\u000f]%e+\t\t\t\fE\u0003j\u0003\u0013\u000b\u0019\f\u0005\u0003\u00026\u0006\u001dWBAA\\\u0015\u0011\tI,a/\u0002\u000fI,7m\u001c:eg*!\u0011QXA`\u0003\r\t\u0007/\u001b\u0006\u0005\u0003\u0003\f\u0019-\u0001\u0003zCJt'bAAc\u007f\u00051\u0001.\u00193p_BLA!!3\u00028\ni\u0011\t\u001d9mS\u000e\fG/[8o\u0013\u0012\f\u0011\"\u00199q\u0013\u0012|F%Z9\u0015\u0007Y\fy\r\u0003\u0005{+\u0005\u0005\t\u0019AAY\u0003\u0019\t\u0007\u000f]%eA\u0005I\u0011\r\u001e;f[B$\u0018\nZ\u000b\u0003\u0003/\u0004R![AE\u00033\u0004B!!.\u0002\\&!\u0011Q\\A\\\u0005Q\t\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8BiR,W\u000e\u001d;JI\u0006i\u0011\r\u001e;f[B$\u0018\nZ0%KF$2A^Ar\u0011!Q\b$!AA\u0002\u0005]\u0017AC1ui\u0016l\u0007\u000f^%eA\u0005Q!-\u001b8e)>L\u0016M\u001d8\u0015\u000bY\fY/!<\t\u000f\u00055&\u00041\u0001\u00024\"9\u00111\u001b\u000eA\u0002\u0005]\u0017!D:uCJ$()\u001b8eS:<7\u000fF\u0001w\u0003\u0011\u0019Ho\u001c9\u0002)\u0005\u0004\b\u000f\\5dCRLwN\\!ui\u0016l\u0007\u000f^%e)\t\tI\u0010E\u0003j\u0003\u0013\u000b9'A\u0007baBd\u0017nY1uS>t\u0017\n\u001a\u000b\u0003\u0003O\nq\u0003\u001d:fa\u0006\u0014XMU3rk\u0016\u001cH/\u0012=fGV$xN]:\u0015\t\t\r!Q\u0005\t\u0005\u0005\u000b\u0011yB\u0004\u0003\u0003\b\tma\u0002\u0002B\u0005\u00053qAAa\u0003\u0003\u00189!!Q\u0002B\u000b\u001d\u0011\u0011yAa\u0005\u000f\t\u00055$\u0011C\u0005\u0002\u0005&\u0011\u0001)Q\u0005\u0003}}J!\u0001P\u001f\n\u0005iZ\u0014b\u0001B\u000fs\u0005a2i\\1sg\u0016<%/Y5oK\u0012\u001cE.^:uKJlUm]:bO\u0016\u001c\u0018\u0002\u0002B\u0011\u0005G\u0011\u0001CU3rk\u0016\u001cH/\u0012=fGV$xN]:\u000b\u0007\tu\u0011\b\u0003\u0004\u0003(}\u0001\r!]\u0001\u000fe\u0016\fX/Z:uK\u0012$v\u000e^1m\u0003]!wNU3rk\u0016\u001cH\u000fV8uC2,\u00050Z2vi>\u00148\u000f\u0006\u0003\u0003.\tu\u0002C\u0002B\u0018\u0005g\u00119$\u0004\u0002\u00032)\u0011aL[\u0005\u0005\u0005k\u0011\tD\u0001\u0004GkR,(/\u001a\t\u0004S\ne\u0012b\u0001B\u001eU\n9!i\\8mK\u0006t\u0007B\u0002B\u0014A\u0001\u0007\u0011/A\be_.KG\u000e\\#yK\u000e,Ho\u001c:t)\u0011\u0011iCa\u0011\t\u000f\t\u0015\u0013\u00051\u0001\u0003H\u0005YQ\r_3dkR|'/\u00133t!\u0019\u0011IEa\u0015\u0002h9!!1\nB(\u001d\u0011\tiG!\u0014\n\u0003-L1A!\u0015k\u0003\u001d\u0001\u0018mY6bO\u0016LAA!\u0016\u0003X\t\u00191+Z9\u000b\u0007\tE#.A\u000ftk\u001a4\u0017nY5f]R\u0014Vm]8ve\u000e,7OU3hSN$XM]3e)\t\u00119$\u0001\bbI\u0012<VMY+J\r&dG/\u001a:\u0015\u000fY\u0014\tG!\u001a\u0003p!9!1M\u0012A\u0002\u0005\u001d\u0014A\u00034jYR,'OT1nK\"9!qM\u0012A\u0002\t%\u0014\u0001\u00044jYR,'\u000fU1sC6\u001c\b\u0003CA5\u0005W\n9'a\u001a\n\t\t5\u00141\u0010\u0002\u0004\u001b\u0006\u0004\bb\u0002B9G\u0001\u0007\u0011qM\u0001\naJ|\u00070\u001f\"bg\u0016\fAc\u0019:fCR,GI]5wKJ,e\u000e\u001a9pS:$HC\u0001B<!\ry(\u0011P\u0005\u0004\u0005w2%A\u0004#sSZ,'/\u00128ea>Lg\u000e^\u0001\u0006e\u0016\u001cX\r^\u0001\u0013GJ,\u0017\r^3U_.,g.T1oC\u001e,'\u000f\u0006\u0002\u0003\u0004B)\u0011.!#\u0003\u0006B!!q\u0011BI\u001b\t\u0011II\u0003\u0003\u0003\f\n5\u0015\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0007\t=U(\u0001\u0004eKBdw._\u0005\u0005\u0005'\u0013II\u0001\u000fIC\u0012|w\u000e\u001d#fY\u0016<\u0017\r^5p]R{7.\u001a8NC:\fw-\u001a:\u0003%e\u000b'O\u001c#sSZ,'/\u00128ea>Lg\u000e^\n\u0004O\t]DC\u0001BN!\tyx\u0005F\u0002w\u0005?CqA!)*\u0001\u0004\tI&\u0001\u0006sa\u000e\fE\r\u001a:fgN\f1c];qKJ$\u0013\r\u001d9mS\u000e\fG/[8o\u0013\u0012LA!a?\u0003(&\u0019!\u0011V\u001e\u0003!M\u001b\u0007.\u001a3vY\u0016\u0014()Y2lK:$\u0017\u0001F-be:\u001c6\r[3ek2,'OQ1dW\u0016tG\r\u0005\u0002FiM\u0019A'!\u0002\u0015\u0005\t5\u0016!D#O\tB{\u0015J\u0014+`\u001d\u0006kU)\u0006\u0002\u00038B!!\u0011\u0018B`\u001b\t\u0011YLC\u0002\u0003>\u0006\fA\u0001\\1oO&!\u0011\u0011\u0010B^\u00039)e\n\u0012)P\u0013:#vLT!N\u000b\u0002\u0002")
public abstract class YarnSchedulerBackend
extends CoarseGrainedSchedulerBackend {
    private final TaskSchedulerImpl scheduler;
    private final SparkContext sc;
    private final AtomicBoolean org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped;
    private final double minRegisteredRatio;
    private int totalExpectedExecutors;
    private final YarnSchedulerEndpoint org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint;
    private Option<RpcEndpointRef> amEndpoint;
    private final RpcEndpointRef yarnSchedulerEndpointRef;
    private final RpcTimeout org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout;
    private Option<ApplicationId> appId;
    private Option<ApplicationAttemptId> attemptId;

    public static String ENDPOINT_NAME() {
        return YarnSchedulerBackend$.MODULE$.ENDPOINT_NAME();
    }

    private /* synthetic */ String super$applicationId() {
        return SchedulerBackend.applicationId$((SchedulerBackend)this);
    }

    public AtomicBoolean org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped() {
        return this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped;
    }

    public double minRegisteredRatio() {
        return this.minRegisteredRatio;
    }

    public int totalExpectedExecutors() {
        return this.totalExpectedExecutors;
    }

    public void totalExpectedExecutors_$eq(int x$1) {
        this.totalExpectedExecutors = x$1;
    }

    public YarnSchedulerEndpoint org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint() {
        return this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint;
    }

    public Option<RpcEndpointRef> amEndpoint() {
        return this.amEndpoint;
    }

    public void amEndpoint_$eq(Option<RpcEndpointRef> x$1) {
        this.amEndpoint = x$1;
    }

    private RpcEndpointRef yarnSchedulerEndpointRef() {
        return this.yarnSchedulerEndpointRef;
    }

    public RpcTimeout org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout() {
        return this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout;
    }

    public Option<ApplicationId> appId() {
        return this.appId;
    }

    public void appId_$eq(Option<ApplicationId> x$1) {
        this.appId = x$1;
    }

    private Option<ApplicationAttemptId> attemptId() {
        return this.attemptId;
    }

    private void attemptId_$eq(Option<ApplicationAttemptId> x$1) {
        this.attemptId = x$1;
    }

    public void bindToYarn(ApplicationId appId, Option<ApplicationAttemptId> attemptId) {
        this.appId_$eq((Option<ApplicationId>)new Some((Object)appId));
        this.attemptId_$eq(attemptId);
    }

    public void startBindings() {
        Predef$.MODULE$.require(this.appId().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "application ID unset");
    }

    public void stop() {
        try {
            this.requestTotalExecutors(0, 0, Predef$.MODULE$.Map().empty());
            super.stop();
        }
        finally {
            this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped().set(true);
        }
    }

    public Option<String> applicationAttemptId() {
        return this.attemptId().map((Function1 & Serializable & scala.Serializable)x$1 -> ((Object)BoxesRunTime.boxToInteger((int)x$1.getAttemptId())).toString());
    }

    public String applicationId() {
        return (String)this.appId().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.logWarning((Function0 & Serializable & scala.Serializable)() -> "Application ID is not initialized yet.");
            return this.super$applicationId();
        });
    }

    public CoarseGrainedClusterMessages.RequestExecutors prepareRequestExecutors(int requestedTotal) {
        Set nodeBlacklist = this.scheduler.nodeBlacklist();
        Map filteredHostToLocalTaskCount = (Map)this.hostToLocalTaskCount().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)YarnSchedulerBackend.$anonfun$prepareRequestExecutors$1(nodeBlacklist, x0$1)));
        return new CoarseGrainedClusterMessages.RequestExecutors(requestedTotal, this.localityAwareTasks(), filteredHostToLocalTaskCount, nodeBlacklist);
    }

    public Future<Object> doRequestTotalExecutors(int requestedTotal) {
        return this.yarnSchedulerEndpointRef().ask((Object)this.prepareRequestExecutors(requestedTotal), ClassTag$.MODULE$.Boolean());
    }

    public Future<Object> doKillExecutors(Seq<String> executorIds) {
        return this.yarnSchedulerEndpointRef().ask((Object)new CoarseGrainedClusterMessages.KillExecutors(executorIds), ClassTag$.MODULE$.Boolean());
    }

    public boolean sufficientResourcesRegistered() {
        return (double)this.totalRegisteredExecutors().get() >= (double)this.totalExpectedExecutors() * this.minRegisteredRatio();
    }

    public void addWebUIFilter(String filterName, Map<String, String> filterParams, String proxyBase) {
        block0: {
            boolean hasFilter;
            Object object = proxyBase != null && new StringOps(Predef$.MODULE$.augmentString(proxyBase)).nonEmpty() ? System.setProperty("spark.ui.proxyBase", proxyBase) : BoxedUnit.UNIT;
            boolean bl = hasFilter = filterName != null && new StringOps(Predef$.MODULE$.augmentString(filterName)).nonEmpty() && filterParams != null && filterParams.nonEmpty();
            if (!hasFilter) break block0;
            Seq allFilters = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{filterName}))).$plus$plus((GenTraversableOnce)this.conf().get(UI$.MODULE$.UI_FILTERS()), Seq$.MODULE$.canBuildFrom());
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Add WebUI Filter. ").append(filterName).append(", ").append(filterParams).append(", ").append(proxyBase).toString());
            this.scheduler.sc().ui().foreach((Function1 & Serializable & scala.Serializable)ui -> {
                YarnSchedulerBackend.$anonfun$addWebUIFilter$2(this, filterParams, filterName, allFilters, ui);
                return BoxedUnit.UNIT;
            });
        }
    }

    public CoarseGrainedSchedulerBackend.DriverEndpoint createDriverEndpoint() {
        return new YarnDriverEndpoint(this);
    }

    public void reset() {
        super.reset();
        this.sc.executorAllocationManager().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.reset();
            return BoxedUnit.UNIT;
        });
    }

    public Option<HadoopDelegationTokenManager> createTokenManager() {
        return new Some((Object)new HadoopDelegationTokenManager(this.sc.conf(), this.sc.hadoopConfiguration(), this.driverEndpoint()));
    }

    public static final /* synthetic */ boolean $anonfun$prepareRequestExecutors$1(Set nodeBlacklist$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        boolean bl = !nodeBlacklist$1.contains((Object)k);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$addWebUIFilter$4(String filterName$1, Map filterParams$1, DelegatingServletContextHandler h) {
        h.addFilter(filterName$1, filterName$1, filterParams$1);
        h.prependFilterMapping(filterName$1, "/*", EnumSet.allOf(DispatcherType.class));
    }

    public static final /* synthetic */ void $anonfun$addWebUIFilter$2(YarnSchedulerBackend $this, Map filterParams$1, String filterName$1, Seq allFilters$1, SparkUI ui) {
        SparkUI sparkUI = ui;
        synchronized (sparkUI) {
            filterParams$1.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                SparkConf sparkConf = $this.conf().set(new StringBuilder(13).append("spark.").append(filterName$1).append(".param.").append(k).toString(), v);
                return sparkConf;
            });
            $this.conf().set(UI$.MODULE$.UI_FILTERS(), (Object)allFilters$1);
            ui.getDelegatingHandlers().foreach((Function1 & Serializable & scala.Serializable)h -> {
                YarnSchedulerBackend.$anonfun$addWebUIFilter$4(filterName$1, filterParams$1, h);
                return BoxedUnit.UNIT;
            });
        }
    }

    public YarnSchedulerBackend(TaskSchedulerImpl scheduler, SparkContext sc) {
        this.scheduler = scheduler;
        this.sc = sc;
        super(scheduler, sc.env().rpcEnv());
        this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped = new AtomicBoolean(false);
        this.minRegisteredRatio = ((Option)this.conf().get((ConfigEntry)package$.MODULE$.SCHEDULER_MIN_REGISTERED_RESOURCES_RATIO())).isEmpty() ? 0.8 : super.minRegisteredRatio();
        this.totalExpectedExecutors = 0;
        this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint = new YarnSchedulerEndpoint(this, this.rpcEnv());
        this.amEndpoint = None$.MODULE$;
        this.yarnSchedulerEndpointRef = this.rpcEnv().setupEndpoint(YarnSchedulerBackend$.MODULE$.ENDPOINT_NAME(), (RpcEndpoint)this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint());
        this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout = RpcUtils$.MODULE$.askRpcTimeout(sc.conf());
        this.appId = None$.MODULE$;
        this.attemptId = None$.MODULE$;
    }

    public class YarnDriverEndpoint
    extends CoarseGrainedSchedulerBackend.DriverEndpoint {
        public void onDisconnected(RpcAddress rpcAddress) {
            this.addressToExecutorId().get((Object)rpcAddress).foreach((Function1 & Serializable & scala.Serializable)executorId -> {
                YarnDriverEndpoint.$anonfun$onDisconnected$1(this, rpcAddress, executorId);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ YarnSchedulerBackend org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnDriverEndpoint$$$outer() {
            return (YarnSchedulerBackend)this.$outer;
        }

        public static final /* synthetic */ void $anonfun$onDisconnected$1(YarnDriverEndpoint $this, RpcAddress rpcAddress$1, String executorId) {
            block0: {
                if ($this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped().get() || !$this.disableExecutor(executorId)) break block0;
                $this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnDriverEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$yarnSchedulerEndpoint().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$handleExecutorDisconnectedFromDriver(executorId, rpcAddress$1);
            }
        }

        public YarnDriverEndpoint(YarnSchedulerBackend $outer) {
            super((CoarseGrainedSchedulerBackend)$outer);
        }
    }

    public class YarnSchedulerEndpoint
    implements ThreadSafeRpcEndpoint,
    Logging {
        private final RpcEnv rpcEnv;
        private transient Logger org$apache$spark$internal$Logging$$log_;
        public final /* synthetic */ YarnSchedulerBackend $outer;

        public String logName() {
            return Logging.logName$((Logging)this);
        }

        public Logger log() {
            return Logging.log$((Logging)this);
        }

        public void logInfo(Function0<String> msg) {
            Logging.logInfo$((Logging)this, msg);
        }

        public void logDebug(Function0<String> msg) {
            Logging.logDebug$((Logging)this, msg);
        }

        public void logTrace(Function0<String> msg) {
            Logging.logTrace$((Logging)this, msg);
        }

        public void logWarning(Function0<String> msg) {
            Logging.logWarning$((Logging)this, msg);
        }

        public void logError(Function0<String> msg) {
            Logging.logError$((Logging)this, msg);
        }

        public void logInfo(Function0<String> msg, Throwable throwable) {
            Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
        }

        public void logDebug(Function0<String> msg, Throwable throwable) {
            Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
        }

        public void logTrace(Function0<String> msg, Throwable throwable) {
            Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
        }

        public void logWarning(Function0<String> msg, Throwable throwable) {
            Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
        }

        public void logError(Function0<String> msg, Throwable throwable) {
            Logging.logError$((Logging)this, msg, (Throwable)throwable);
        }

        public boolean isTraceEnabled() {
            return Logging.isTraceEnabled$((Logging)this);
        }

        public void initializeLogIfNecessary(boolean isInterpreter) {
            Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
        }

        public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
            return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
        }

        public boolean initializeLogIfNecessary$default$2() {
            return Logging.initializeLogIfNecessary$default$2$((Logging)this);
        }

        public void initializeForcefully(boolean isInterpreter, boolean silent) {
            Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
        }

        public final RpcEndpointRef self() {
            return RpcEndpoint.self$((RpcEndpoint)this);
        }

        public void onError(Throwable cause) {
            RpcEndpoint.onError$((RpcEndpoint)this, (Throwable)cause);
        }

        public void onConnected(RpcAddress remoteAddress) {
            RpcEndpoint.onConnected$((RpcEndpoint)this, (RpcAddress)remoteAddress);
        }

        public void onNetworkError(Throwable cause, RpcAddress remoteAddress) {
            RpcEndpoint.onNetworkError$((RpcEndpoint)this, (Throwable)cause, (RpcAddress)remoteAddress);
        }

        public void onStart() {
            RpcEndpoint.onStart$((RpcEndpoint)this);
        }

        public void onStop() {
            RpcEndpoint.onStop$((RpcEndpoint)this);
        }

        public final void stop() {
            RpcEndpoint.stop$((RpcEndpoint)this);
        }

        public Logger org$apache$spark$internal$Logging$$log_() {
            return this.org$apache$spark$internal$Logging$$log_;
        }

        public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
            this.org$apache$spark$internal$Logging$$log_ = x$1;
        }

        public RpcEnv rpcEnv() {
            return this.rpcEnv;
        }

        public void org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$handleExecutorDisconnectedFromDriver(String executorId, RpcAddress executorRpcAddress) {
            Future future;
            Option<RpcEndpointRef> option = this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().amEndpoint();
            if (option instanceof Some) {
                Some some = (Some)option;
                RpcEndpointRef am = (RpcEndpointRef)some.value();
                CoarseGrainedClusterMessages.GetExecutorLossReason lossReasonRequest = new CoarseGrainedClusterMessages.GetExecutorLossReason(executorId);
                future = am.ask((Object)lossReasonRequest, this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$askTimeout(), ClassTag$.MODULE$.apply(ExecutorLossReason.class)).map((Function1 & Serializable & scala.Serializable)reason -> new CoarseGrainedClusterMessages.RemoveExecutor(executorId, reason), (ExecutionContext)ThreadUtils$.MODULE$.sameThread()).recover((PartialFunction)new scala.Serializable(this, executorId, executorRpcAddress){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ YarnSchedulerEndpoint $outer;
                    private final String executorId$1;
                    private final RpcAddress executorRpcAddress$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x1;
                        Option option = NonFatal$.MODULE$.unapply(A1);
                        if (!option.isEmpty()) {
                            Throwable e = (Throwable)option.get();
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(115).append("Attempted to get executor loss reason").append(" for executor id ").append($this.executorId$1).append(" at RPC address ").append($this.executorRpcAddress$1).append(",").append(" but got no response. Marking as slave lost.").toString(), e);
                            object = new CoarseGrainedClusterMessages.RemoveExecutor(this.executorId$1, (ExecutorLossReason)new SlaveLost(SlaveLost$.MODULE$.apply$default$1(), SlaveLost$.MODULE$.apply$default$2()));
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        Option option = NonFatal$.MODULE$.unapply(throwable);
                        boolean bl = !option.isEmpty();
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.executorId$1 = executorId$1;
                        this.executorRpcAddress$1 = executorRpcAddress$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.scheduler.cluster.YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$1 )}, serializedLambda);
                    }
                }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
            } else if (None$.MODULE$.equals(option)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to check for an executor loss reason before the AM has registered!");
                future = Future$.MODULE$.successful((Object)new CoarseGrainedClusterMessages.RemoveExecutor(executorId, (ExecutorLossReason)new SlaveLost("AM is not yet registered.", SlaveLost$.MODULE$.apply$default$2())));
            } else {
                throw new MatchError(option);
            }
            Future removeExecutorMessage = future;
            removeExecutorMessage.foreach((Function1 & Serializable & scala.Serializable)message -> {
                YarnSchedulerEndpoint.$anonfun$org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$handleExecutorDisconnectedFromDriver$3(this, message);
                return BoxedUnit.UNIT;
            }, ExecutionContext.Implicits$.MODULE$.global());
        }

        public PartialFunction<Object, BoxedUnit> receive() {
            return new scala.Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnSchedulerEndpoint $outer;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof CoarseGrainedClusterMessages.RegisterClusterManager) {
                        CoarseGrainedClusterMessages.RegisterClusterManager registerClusterManager = (CoarseGrainedClusterMessages.RegisterClusterManager)A1;
                        RpcEndpointRef am = registerClusterManager.am();
                        this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("ApplicationMaster registered as ").append(am).toString());
                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().amEndpoint_$eq((Option<RpcEndpointRef>)Option$.MODULE$.apply((Object)am));
                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().reset();
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.AddWebUIFilter) {
                        CoarseGrainedClusterMessages.AddWebUIFilter addWebUIFilter = (CoarseGrainedClusterMessages.AddWebUIFilter)A1;
                        String filterName = addWebUIFilter.filterName();
                        Map filterParams = addWebUIFilter.filterParams();
                        String proxyBase = addWebUIFilter.proxyBase();
                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().addWebUIFilter(filterName, (Map<String, String>)filterParams, proxyBase);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.RemoveExecutor) {
                        BoxedUnit boxedUnit;
                        CoarseGrainedClusterMessages.RemoveExecutor removeExecutor = (CoarseGrainedClusterMessages.RemoveExecutor)A1;
                        String executorId = removeExecutor.executorId();
                        ExecutorLossReason reason = removeExecutor.reason();
                        if (!this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$stopped().get()) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Requesting driver to remove executor ").append(executorId).append(" for reason ").append(reason).toString());
                            this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().driverEndpoint().send((Object)removeExecutor);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        object = boxedUnit;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof CoarseGrainedClusterMessages.RegisterClusterManager ? true : (object instanceof CoarseGrainedClusterMessages.AddWebUIFilter ? true : object instanceof CoarseGrainedClusterMessages.RemoveExecutor);
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$2(org.apache.spark.rpc.RpcEndpointRef ), $anonfun$applyOrElse$3(java.lang.String org.apache.spark.scheduler.ExecutorLossReason )}, serializedLambda);
                }
            };
        }

        public PartialFunction<Object, BoxedUnit> receiveAndReply(RpcCallContext context) {
            return new scala.Serializable(this, context){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ YarnSchedulerEndpoint $outer;
                public final RpcCallContext context$1;

                public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof CoarseGrainedClusterMessages.RequestExecutors) {
                        CoarseGrainedClusterMessages.RequestExecutors requestExecutors = (CoarseGrainedClusterMessages.RequestExecutors)A1;
                        Option<RpcEndpointRef> option = this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().amEndpoint();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            RpcEndpointRef am = (RpcEndpointRef)some.value();
                            am.ask((Object)requestExecutors, ClassTag$.MODULE$.Boolean()).andThen((PartialFunction)new scala.Serializable(this, requestExecutors){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ YarnSchedulerEndpoint$$anonfun$receiveAndReply$1 $outer;
                                private final CoarseGrainedClusterMessages.RequestExecutors x2$1;

                                public final <A1 extends Try<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                    Failure failure;
                                    Throwable throwable;
                                    Option option;
                                    Object object;
                                    A1 A1 = x1;
                                    if (A1 instanceof Success) {
                                        Success success = (Success)A1;
                                        boolean b = BoxesRunTime.unboxToBoolean((Object)success.value());
                                        this.$outer.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)b));
                                        object = BoxedUnit.UNIT;
                                    } else if (A1 instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)A1).exception())).isEmpty()) {
                                        Throwable e = (Throwable)option.get();
                                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Sending ").append($this.x2$1).append(" to AM was unsuccessful").toString(), e);
                                        this.$outer.context$1.sendFailure(e);
                                        object = BoxedUnit.UNIT;
                                    } else {
                                        object = function1.apply(x1);
                                    }
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(Try<Object> x1) {
                                    Failure failure;
                                    Throwable throwable;
                                    Option option;
                                    Try<Object> try_ = x1;
                                    boolean bl = try_ instanceof Success ? true : try_ instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)try_).exception())).isEmpty();
                                    return bl;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.x2$1 = x2$1;
                                }

                                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$5(org.apache.spark.scheduler.cluster.YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$receiveAndReply$1$$anonfun$applyOrElse$4 )}, serializedLambda);
                                }
                            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (None$.MODULE$.equals(option)) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to request executors before the AM has registered!");
                            this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)false));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError(option);
                        }
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof CoarseGrainedClusterMessages.KillExecutors) {
                        CoarseGrainedClusterMessages.KillExecutors killExecutors = (CoarseGrainedClusterMessages.KillExecutors)A1;
                        Option<RpcEndpointRef> option = this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().amEndpoint();
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            RpcEndpointRef am = (RpcEndpointRef)some.value();
                            am.ask((Object)killExecutors, ClassTag$.MODULE$.Boolean()).andThen((PartialFunction)new scala.Serializable(this, killExecutors){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ YarnSchedulerEndpoint$$anonfun$receiveAndReply$1 $outer;
                                private final CoarseGrainedClusterMessages.KillExecutors x3$1;

                                public final <A1 extends Try<Object>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                    Failure failure;
                                    Throwable throwable;
                                    Option option;
                                    Object object;
                                    A1 A1 = x2;
                                    if (A1 instanceof Success) {
                                        Success success = (Success)A1;
                                        boolean b = BoxesRunTime.unboxToBoolean((Object)success.value());
                                        this.$outer.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)b));
                                        object = BoxedUnit.UNIT;
                                    } else if (A1 instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)A1).exception())).isEmpty()) {
                                        Throwable e = (Throwable)option.get();
                                        this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$$$outer().logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Sending ").append($this.x3$1).append(" to AM was unsuccessful").toString(), e);
                                        this.$outer.context$1.sendFailure(e);
                                        object = BoxedUnit.UNIT;
                                    } else {
                                        object = function1.apply(x2);
                                    }
                                    return (B1)object;
                                }

                                public final boolean isDefinedAt(Try<Object> x2) {
                                    Failure failure;
                                    Throwable throwable;
                                    Option option;
                                    Try<Object> try_ = x2;
                                    boolean bl = try_ instanceof Success ? true : try_ instanceof Failure && !(option = NonFatal$.MODULE$.unapply(throwable = (failure = (Failure)try_).exception())).isEmpty();
                                    return bl;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.x3$1 = x3$1;
                                }

                                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$8(org.apache.spark.scheduler.cluster.YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$receiveAndReply$1$$anonfun$applyOrElse$7 )}, serializedLambda);
                                }
                            }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (None$.MODULE$.equals(option)) {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Attempted to kill executors before the AM has registered!");
                            this.context$1.reply((Object)BoxesRunTime.boxToBoolean((boolean)false));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError(option);
                        }
                        object = BoxedUnit.UNIT;
                    } else if (CoarseGrainedClusterMessages.RetrieveLastAllocatedExecutorId$.MODULE$.equals(A1)) {
                        this.context$1.reply((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().currentExecutorIdCounter()));
                        object = BoxedUnit.UNIT;
                    } else if (CoarseGrainedClusterMessages.RetrieveDelegationTokens$.MODULE$.equals(A1)) {
                        this.context$1.reply((Object)this.$outer.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().currentDelegationTokens());
                        object = BoxedUnit.UNIT;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(Object x1) {
                    Object object = x1;
                    boolean bl = object instanceof CoarseGrainedClusterMessages.RequestExecutors ? true : (object instanceof CoarseGrainedClusterMessages.KillExecutors ? true : (CoarseGrainedClusterMessages.RetrieveLastAllocatedExecutorId$.MODULE$.equals(object) ? true : CoarseGrainedClusterMessages.RetrieveDelegationTokens$.MODULE$.equals(object)));
                    return bl;
                }

                public /* synthetic */ YarnSchedulerEndpoint org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.context$1 = context$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$6(), $anonfun$applyOrElse$9()}, serializedLambda);
                }
            };
        }

        public void onDisconnected(RpcAddress remoteAddress) {
            block0: {
                if (!this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().amEndpoint().exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)YarnSchedulerEndpoint.$anonfun$onDisconnected$2(remoteAddress, x$4)))) break block0;
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("ApplicationMaster has disassociated: ").append(remoteAddress).toString());
                this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().amEndpoint_$eq((Option<RpcEndpointRef>)None$.MODULE$);
            }
        }

        public /* synthetic */ YarnSchedulerBackend org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$org$apache$spark$scheduler$cluster$YarnSchedulerBackend$$handleExecutorDisconnectedFromDriver$3(YarnSchedulerEndpoint $this, CoarseGrainedClusterMessages.RemoveExecutor message) {
            $this.org$apache$spark$scheduler$cluster$YarnSchedulerBackend$YarnSchedulerEndpoint$$$outer().driverEndpoint().send((Object)message);
        }

        public static final /* synthetic */ boolean $anonfun$onDisconnected$2(RpcAddress remoteAddress$1, RpcEndpointRef x$4) {
            RpcAddress rpcAddress = x$4.address();
            RpcAddress rpcAddress2 = remoteAddress$1;
            return !(rpcAddress != null ? !rpcAddress.equals(rpcAddress2) : rpcAddress2 != null);
        }

        public YarnSchedulerEndpoint(YarnSchedulerBackend $outer, RpcEnv rpcEnv) {
            this.rpcEnv = rpcEnv;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            RpcEndpoint.$init$((RpcEndpoint)this);
            Logging.$init$((Logging)this);
        }
    }
}

