/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.resource;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Python$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ExecutorResourceRequest;
import org.apache.spark.resource.ExecutorResourceRequests;
import org.apache.spark.resource.ResourceProfile;
import org.apache.spark.resource.ResourceRequest;
import org.apache.spark.resource.ResourceUtils$;
import org.apache.spark.resource.TaskResourceRequest;
import org.apache.spark.resource.TaskResourceRequests;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;

public final class ResourceProfile$
implements Logging,
scala.Serializable {
    public static ResourceProfile$ MODULE$;
    private AtomicInteger nextProfileId;
    private final String CPUS;
    private final String CORES;
    private final String MEMORY;
    private final String OVERHEAD_MEM;
    private final String PYSPARK_MEM;
    private final Seq<String> allSupportedExecutorResources;
    private final int UNKNOWN_RESOURCE_PROFILE_ID;
    private final int DEFAULT_RESOURCE_PROFILE_ID;
    private final Object DEFAULT_PROFILE_LOCK;
    @GuardedBy(value="DEFAULT_PROFILE_LOCK")
    private Option<ResourceProfile> defaultProfile;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    static {
        new ResourceProfile$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String CPUS() {
        return this.CPUS;
    }

    public String CORES() {
        return this.CORES;
    }

    public String MEMORY() {
        return this.MEMORY;
    }

    public String OVERHEAD_MEM() {
        return this.OVERHEAD_MEM;
    }

    public String PYSPARK_MEM() {
        return this.PYSPARK_MEM;
    }

    public Seq<String> allSupportedExecutorResources() {
        return this.allSupportedExecutorResources;
    }

    public int UNKNOWN_RESOURCE_PROFILE_ID() {
        return this.UNKNOWN_RESOURCE_PROFILE_ID;
    }

    public int DEFAULT_RESOURCE_PROFILE_ID() {
        return this.DEFAULT_RESOURCE_PROFILE_ID;
    }

    private AtomicInteger nextProfileId$lzycompute() {
        ResourceProfile$ resourceProfile$ = this;
        synchronized (resourceProfile$) {
            if (!this.bitmap$0) {
                this.nextProfileId = new AtomicInteger(0);
                this.bitmap$0 = true;
            }
        }
        return this.nextProfileId;
    }

    private AtomicInteger nextProfileId() {
        return !this.bitmap$0 ? this.nextProfileId$lzycompute() : this.nextProfileId;
    }

    private Object DEFAULT_PROFILE_LOCK() {
        return this.DEFAULT_PROFILE_LOCK;
    }

    private Option<ResourceProfile> defaultProfile() {
        return this.defaultProfile;
    }

    private void defaultProfile_$eq(Option<ResourceProfile> x$1) {
        this.defaultProfile = x$1;
    }

    public int getNextProfileId() {
        return this.nextProfileId().getAndIncrement();
    }

    public ResourceProfile getOrCreateDefaultProfile(SparkConf conf) {
        ResourceProfile resourceProfile;
        Object object = this.DEFAULT_PROFILE_LOCK();
        synchronized (object) {
            ResourceProfile resourceProfile2;
            Option<ResourceProfile> option = this.defaultProfile();
            if (option instanceof Some) {
                ResourceProfile prof;
                Some some = (Some)option;
                resourceProfile2 = prof = (ResourceProfile)some.value();
            } else if (None$.MODULE$.equals(option)) {
                Map<String, TaskResourceRequest> taskResources = this.getDefaultTaskResources(conf);
                Map<String, ExecutorResourceRequest> executorResources = this.getDefaultExecutorResources(conf);
                ResourceProfile defProf = new ResourceProfile(executorResources, taskResources);
                defProf.setToDefaultProfile();
                this.defaultProfile_$eq((Option<ResourceProfile>)new Some((Object)defProf));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Default ResourceProfile created, executor resources: ").append(defProf.executorResources()).append(", task resources: ").append(defProf.taskResources()).toString());
                resourceProfile2 = defProf;
            } else {
                throw new MatchError(option);
            }
            resourceProfile = resourceProfile2;
        }
        return resourceProfile;
    }

    private Map<String, TaskResourceRequest> getDefaultTaskResources(SparkConf conf) {
        int cpusPerTask = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.CPUS_PER_TASK()));
        TaskResourceRequests treqs = new TaskResourceRequests().cpus(cpusPerTask);
        ResourceUtils$.MODULE$.addTaskResourceRequests(conf, treqs);
        return treqs.requests();
    }

    private Map<String, ExecutorResourceRequest> getDefaultExecutorResources(SparkConf conf) {
        ExecutorResourceRequests ereqs = new ExecutorResourceRequests();
        ereqs.cores(BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.EXECUTOR_CORES())));
        ereqs.memory(conf.get(package$.MODULE$.EXECUTOR_MEMORY()).toString());
        ((Option)conf.get(package$.MODULE$.EXECUTOR_MEMORY_OVERHEAD())).map((Function1 & Serializable & scala.Serializable)mem -> ereqs.memoryOverhead(((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)mem))).toString()));
        ((Option)conf.get(Python$.MODULE$.PYSPARK_EXECUTOR_MEMORY())).map((Function1 & Serializable & scala.Serializable)mem -> ereqs.pysparkMemory(((Object)BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong((Object)mem))).toString()));
        Seq<ResourceRequest> execReq = ResourceUtils$.MODULE$.parseAllResourceRequests(conf, package$.MODULE$.SPARK_EXECUTOR_PREFIX());
        execReq.foreach((Function1 & Serializable & scala.Serializable)req -> {
            String name = req.id().resourceName();
            return ereqs.resource(name, req.amount(), req.discoveryScript().orElse(""), req.vendor().orElse(""));
        });
        return ereqs.requests();
    }

    public void reInitDefaultProfile(SparkConf conf) {
        this.clearDefaultProfile();
        this.getOrCreateDefaultProfile(conf);
    }

    public void clearDefaultProfile() {
        Object object = this.DEFAULT_PROFILE_LOCK();
        synchronized (object) {
            this.defaultProfile_$eq((Option<ResourceProfile>)None$.MODULE$);
        }
    }

    public Map<String, TaskResourceRequest> getCustomTaskResources(ResourceProfile rp) {
        return rp.taskResources().filterKeys((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)ResourceProfile$.$anonfun$getCustomTaskResources$1(k)));
    }

    public Map<String, ExecutorResourceRequest> getCustomExecutorResources(ResourceProfile rp) {
        return rp.executorResources().filterKeys((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)ResourceProfile$.$anonfun$getCustomExecutorResources$1(k)));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$getCustomTaskResources$1(String k) {
        return !k.equals(MODULE$.CPUS());
    }

    public static final /* synthetic */ boolean $anonfun$getCustomExecutorResources$1(String k) {
        return !MODULE$.allSupportedExecutorResources().contains((Object)k);
    }

    private ResourceProfile$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.CPUS = "cpus";
        this.CORES = "cores";
        this.MEMORY = "memory";
        this.OVERHEAD_MEM = "memoryOverhead";
        this.PYSPARK_MEM = "pyspark.memory";
        this.allSupportedExecutorResources = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.CORES(), this.MEMORY(), this.OVERHEAD_MEM(), this.PYSPARK_MEM()}));
        this.UNKNOWN_RESOURCE_PROFILE_ID = -1;
        this.DEFAULT_RESOURCE_PROFILE_ID = 0;
        this.DEFAULT_PROFILE_LOCK = new Object();
        this.defaultProfile = None$.MODULE$;
    }
}

