/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.streaming;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.spark.SparkConf;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.examples.streaming.DroppedWordsCounter$;
import org.apache.spark.examples.streaming.WordBlacklist$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.Seconds$;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.StreamingContext$;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.DStream;
import org.apache.spark.streaming.dstream.DStream$;
import org.apache.spark.streaming.dstream.ReceiverInputDStream;
import org.apache.spark.util.IntParam$;
import org.apache.spark.util.LongAccumulator;
import org.sparkproject.guava.io.Files;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

public final class RecoverableNetworkWordCount$ {
    public static RecoverableNetworkWordCount$ MODULE$;

    static {
        new RecoverableNetworkWordCount$();
    }

    public StreamingContext createContext(String ip, int port, String outputPath, String checkpointDirectory) {
        Predef$.MODULE$.println((Object)"Creating new context");
        File outputFile = new File(outputPath);
        Object object = outputFile.exists() ? BoxesRunTime.boxToBoolean((boolean)outputFile.delete()) : BoxedUnit.UNIT;
        SparkConf sparkConf = new SparkConf().setAppName("RecoverableNetworkWordCount");
        StreamingContext ssc = new StreamingContext(sparkConf, Seconds$.MODULE$.apply(1L));
        ssc.checkpoint(checkpointDirectory);
        ReceiverInputDStream lines = ssc.socketTextStream(ip, port, ssc.socketTextStream$default$3());
        DStream words = lines.flatMap((Function1 & Serializable & scala.Serializable)x$1 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1.split(" "))), ClassTag$.MODULE$.apply(String.class));
        DStream wordCounts = DStream$.MODULE$.toPairDStreamFunctions(words.map((Function1 & Serializable & scala.Serializable)x$2 -> new Tuple2(x$2, (Object)BoxesRunTime.boxToInteger((int)1)), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Int(), (Ordering)Ordering.String$.MODULE$).reduceByKey((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$3, x$4) -> x$3 + x$4);
        wordCounts.foreachRDD((Function2 & Serializable & scala.Serializable)(rdd, time) -> {
            RecoverableNetworkWordCount$.$anonfun$createContext$4(outputFile, rdd, time);
            return BoxedUnit.UNIT;
        });
        return ssc;
    }

    public void main(String[] args) {
        Option option;
        String outputPath;
        String checkpointDirectory;
        String ip;
        block5: {
            String[] stringArray;
            block4: {
                Option option2;
                if (args.length != 4) {
                    System.err.println(new StringBuilder(20).append("Your arguments were ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).mkString("[", ", ", "]")).toString());
                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("\n          |Usage: RecoverableNetworkWordCount <hostname> <port> <checkpoint-directory>\n          |     <output-file>. <hostname> and <port> describe the TCP server that Spark\n          |     Streaming would connect to receive data. <checkpoint-directory> directory to\n          |     HDFS-compatible file system which checkpoint data <output-file> file to which the\n          |     word counts will be appended\n          |\n          |In local mode, <master> should be 'local[n]' with n > 1\n          |Both <checkpoint-directory> and <output-file> must be absolute paths\n        ")).stripMargin());
                    System.exit(1);
                }
                if ((option2 = Array$.MODULE$.unapplySeq((Object)(stringArray = args))).isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(4) != 0) break block4;
                ip = (String)((SeqLike)option2.get()).apply(0);
                String string = (String)((SeqLike)option2.get()).apply(1);
                checkpointDirectory = (String)((SeqLike)option2.get()).apply(2);
                outputPath = (String)((SeqLike)option2.get()).apply(3);
                option = IntParam$.MODULE$.unapply(string);
                if (!option.isEmpty()) break block5;
            }
            throw new MatchError((Object)stringArray);
        }
        int port = BoxesRunTime.unboxToInt((Object)option.get());
        Tuple4 tuple4 = new Tuple4((Object)ip, (Object)BoxesRunTime.boxToInteger((int)port), (Object)checkpointDirectory, (Object)outputPath);
        Tuple4 tuple42 = tuple4;
        String ip2 = (String)tuple42._1();
        int port2 = BoxesRunTime.unboxToInt((Object)tuple42._2());
        String checkpointDirectory2 = (String)tuple42._3();
        String outputPath2 = (String)tuple42._4();
        StreamingContext ssc = StreamingContext$.MODULE$.getOrCreate(checkpointDirectory2, (Function0 & Serializable & scala.Serializable)() -> MODULE$.createContext(ip2, port2, outputPath2, checkpointDirectory2), StreamingContext$.MODULE$.getOrCreate$default$3(), StreamingContext$.MODULE$.getOrCreate$default$4());
        ssc.start();
        ssc.awaitTermination();
    }

    public static final /* synthetic */ boolean $anonfun$createContext$5(Broadcast blacklist$1, LongAccumulator droppedWordsCounter$1, Tuple2 x0$1) {
        boolean bl;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String word = (String)tuple2._1();
            int count = tuple2._2$mcI$sp();
            if (((SeqLike)blacklist$1.value()).contains((Object)word)) {
                droppedWordsCounter$1.add((long)count);
                bl = false;
            } else {
                bl = true;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        boolean bl2 = bl;
        return bl2;
    }

    public static final /* synthetic */ void $anonfun$createContext$4(File outputFile$1, RDD rdd, Time time) {
        Broadcast<Seq<String>> blacklist = WordBlacklist$.MODULE$.getInstance(rdd.sparkContext());
        LongAccumulator droppedWordsCounter = DroppedWordsCounter$.MODULE$.getInstance(rdd.sparkContext());
        String counts = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rdd.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RecoverableNetworkWordCount$.$anonfun$createContext$5(blacklist, droppedWordsCounter, x0$1))).collect())).mkString("[", ", ", "]");
        String output = new StringBuilder(16).append("Counts at time ").append(time).append(" ").append(counts).toString();
        Predef$.MODULE$.println((Object)output);
        Predef$.MODULE$.println((Object)new StringBuilder(24).append("Dropped ").append(droppedWordsCounter.value()).append(" word(s) totally").toString());
        Predef$.MODULE$.println((Object)new StringBuilder(13).append("Appending to ").append(outputFile$1.getAbsolutePath()).toString());
        Files.append((CharSequence)new StringBuilder(1).append(output).append("\n").toString(), (File)outputFile$1, (Charset)Charset.defaultCharset());
    }

    private RecoverableNetworkWordCount$() {
        MODULE$ = this;
    }
}

