/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver.ui;

import java.io.Serializable;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.spark.sql.hive.thriftserver.ui.ExecutionInfo;
import org.apache.spark.sql.hive.thriftserver.ui.SqlStatsTableDataSource;
import org.apache.spark.sql.hive.thriftserver.ui.SqlStatsTableRow;
import org.apache.spark.sql.hive.thriftserver.ui.ThriftServerTab;
import org.apache.spark.sql.hive.thriftserver.ui.ToolTips$;
import org.apache.spark.ui.PagedTable;
import org.apache.spark.ui.UIUtils$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.xml.Comment;
import scala.xml.Elem;
import scala.xml.EntityRef;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.Unparsed;
import scala.xml.Unparsed$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0001\u00055c!\u0002\u000e\u001c\u0001mI\u0003\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u0011\u0015\u0003!\u0011!Q\u0001\n\u0019C\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\t3\u0002\u0011\t\u0011)A\u00055\"A!\r\u0001B\u0001B\u0003%!\f\u0003\u0005d\u0001\t\u0005\t\u0015!\u0003e\u0011!9\u0007A!A!\u0002\u0013Q\u0006\u0002\u00035\u0001\u0005\u0003\u0005\u000b\u0011B5\t\u00111\u0004!\u0011!Q\u0001\niC\u0001\"\u001c\u0001\u0003\u0002\u0003\u0006IA\u001c\u0005\u0006c\u0002!\tA\u001d\u0005\b}\u0002\u0011\r\u0011\"\u0011\u0000\u0011!\t9\u0001\u0001Q\u0001\n\u0005\u0005\u0001\"CA\u0005\u0001\t\u0007I\u0011BA\u0006\u0011\u001d\ti\u0001\u0001Q\u0001\niCq!a\u0004\u0001\t\u0003\nY\u0001C\u0004\u0002\u0012\u0001!\t%a\u0003\t\u000f\u0005M\u0001\u0001\"\u0011\u0002\u0016!9\u00111\u0004\u0001\u0005B\u0005-\u0001bBA\u000f\u0001\u0011\u0005\u00131\u0002\u0005\b\u0003?\u0001A\u0011IA\u0006\u0011\u001d\t\t\u0003\u0001C!\u0003GAq!a\r\u0001\t\u0003\n)\u0004C\u0004\u0002<\u0001!I!!\u0010\t\u000f\u0005\r\u0003\u0001\"\u0003\u0002F\t\u00112+\u001d7Ti\u0006$8\u000fU1hK\u0012$\u0016M\u00197f\u0015\taR$\u0001\u0002vS*\u0011adH\u0001\ri\"\u0014\u0018N\u001a;tKJ4XM\u001d\u0006\u0003A\u0005\nA\u0001[5wK*\u0011!eI\u0001\u0004gFd'B\u0001\u0013&\u0003\u0015\u0019\b/\u0019:l\u0015\t1s%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002Q\u0005\u0019qN]4\u0014\u0007\u0001Q\u0003\u0007\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0004B]f\u0014VM\u001a\t\u0004cM*T\"\u0001\u001a\u000b\u0005q\u0019\u0013B\u0001\u001b3\u0005)\u0001\u0016mZ3e)\u0006\u0014G.\u001a\t\u0003m]j\u0011aG\u0005\u0003qm\u0011\u0001cU9m'R\fGo\u001d+bE2,'k\\<\u0002\u000fI,\u0017/^3ti\u000e\u0001\u0001C\u0001\u001fD\u001b\u0005i$B\u0001 @\u0003\u0011AG\u000f\u001e9\u000b\u0005\u0001\u000b\u0015aB:feZdW\r\u001e\u0006\u0002\u0005\u0006)!.\u0019<bq&\u0011A)\u0010\u0002\u0013\u0011R$\boU3sm2,GOU3rk\u0016\u001cH/\u0001\u0004qCJ,g\u000e\u001e\t\u0003m\u001dK!\u0001S\u000e\u0003\u001fQC'/\u001b4u'\u0016\u0014h/\u001a:UC\n\fA\u0001Z1uCB\u00191j\u0015,\u000f\u00051\u000bfBA'Q\u001b\u0005q%BA(;\u0003\u0019a$o\\8u}%\tQ&\u0003\u0002SY\u00059\u0001/Y2lC\u001e,\u0017B\u0001+V\u0005\r\u0019V-\u001d\u0006\u0003%2\u0002\"AN,\n\u0005a[\"!D#yK\u000e,H/[8o\u0013:4w.A\u0004tk\n\u0004\u0016\r\u001e5\u0011\u0005m{fB\u0001/^!\tiE&\u0003\u0002_Y\u00051\u0001K]3eK\u001aL!\u0001Y1\u0003\rM#(/\u001b8h\u0015\tqF&\u0001\u0005cCN,\u0007+\u0019;i\u0003M\u0001\u0018M]1nKR,'o\u0014;iKJ$\u0016M\u00197f!\rYUMW\u0005\u0003MV\u0013\u0001\"\u0013;fe\u0006\u0014G.Z\u0001\u0011gFd7\u000b^1ugR\u000b'\r\\3UC\u001e\f\u0001\u0002]1hKNK'0\u001a\t\u0003W)L!a\u001b\u0017\u0003\u0007%sG/\u0001\u0006t_J$8i\u001c7v[:\fA\u0001Z3tGB\u00111f\\\u0005\u0003a2\u0012qAQ8pY\u0016\fg.\u0001\u0004=S:LGO\u0010\u000b\fgR,ho\u001e=zundX\u0010\u0005\u00027\u0001!)\u0011h\u0003a\u0001w!)Qi\u0003a\u0001\r\")\u0011j\u0003a\u0001\u0015\")\u0011l\u0003a\u00015\")!m\u0003a\u00015\")1m\u0003a\u0001I\")qm\u0003a\u00015\")\u0001n\u0003a\u0001S\")An\u0003a\u00015\")Qn\u0003a\u0001]\u0006QA-\u0019;b'>,(oY3\u0016\u0005\u0005\u0005\u0001c\u0001\u001c\u0002\u0004%\u0019\u0011QA\u000e\u0003/M\u000bHn\u0015;biN$\u0016M\u00197f\t\u0006$\u0018mU8ve\u000e,\u0017a\u00033bi\u0006\u001cv.\u001e:dK\u0002\nQ\u0002]1sC6,G/\u001a:QCRDW#\u0001.\u0002\u001dA\f'/Y7fi\u0016\u0014\b+\u0019;iA\u00059A/\u00192mK&#\u0017!\u0004;bE2,7i]:DY\u0006\u001c8/\u0001\u0005qC\u001e,G*\u001b8l)\rQ\u0016q\u0003\u0005\u0007\u00033\u0011\u0002\u0019A5\u0002\tA\fw-Z\u0001\u0012a\u0006<WmU5{K\u001a{'/\u001c$jK2$\u0017a\u00059bO\u0016tU/\u001c2fe\u001a{'/\u001c$jK2$\u0017\u0001E4p\u0005V$Ho\u001c8G_Jl\u0007+\u0019;i\u0003\u001dAW-\u00193feN,\"!!\n\u0011\t-\u001b\u0016q\u0005\t\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0019\u0011Q\u0006\u0017\u0002\u0007alG.\u0003\u0003\u00022\u0005-\"\u0001\u0002(pI\u0016\f1A]8x)\u0011\t)#a\u000e\t\r\u0005er\u00031\u00016\u0003A\u0019\u0018\u000f\\*uCR\u001cH+\u00192mKJ{w/\u0001\tfeJ|'/T3tg\u0006<WmQ3mYR!\u0011QEA \u0011\u0019\t\t\u0005\u0007a\u00015\u0006aQM\u001d:pe6+7o]1hK\u00061!n\u001c2V%2#RAWA$\u0003\u0013BQ!O\rA\u0002mBa!a\u0013\u001a\u0001\u0004Q\u0016!\u00026pE&#\u0007")
public class SqlStatsPagedTable
implements PagedTable<SqlStatsTableRow> {
    private final HttpServletRequest request;
    private final ThriftServerTab parent;
    private final String sqlStatsTableTag;
    private final int pageSize;
    private final String sortColumn;
    private final boolean desc;
    private final SqlStatsTableDataSource dataSource;
    private final String parameterPath;

    public Seq<Node> table(int page) {
        return PagedTable.table$((PagedTable)this, (int)page);
    }

    public Seq<Node> pageNavigation(int page, int pageSize, int totalPages, String navigationId) {
        return PagedTable.pageNavigation$((PagedTable)this, (int)page, (int)pageSize, (int)totalPages, (String)navigationId);
    }

    public String pageNavigation$default$4() {
        return PagedTable.pageNavigation$default$4$((PagedTable)this);
    }

    public SqlStatsTableDataSource dataSource() {
        return this.dataSource;
    }

    private String parameterPath() {
        return this.parameterPath;
    }

    public String tableId() {
        return this.sqlStatsTableTag;
    }

    public String tableCssClass() {
        return "table table-bordered table-condensed table-striped table-head-clickable table-cell-width-limited";
    }

    public String pageLink(int page) {
        String encodedSortColumn = URLEncoder.encode(this.sortColumn, StandardCharsets.UTF_8.name());
        return new StringBuilder(18).append(this.parameterPath()).append("&").append(this.pageNumberFormField()).append("=").append(page).append("&").append(this.sqlStatsTableTag).append(".sort=").append(encodedSortColumn).append("&").append(this.sqlStatsTableTag).append(".desc=").append(this.desc).append("&").append(this.pageSizeFormField()).append("=").append(this.pageSize).toString();
    }

    public String pageSizeFormField() {
        return new StringBuilder(9).append(this.sqlStatsTableTag).append(".pageSize").toString();
    }

    public String pageNumberFormField() {
        return new StringBuilder(5).append(this.sqlStatsTableTag).append(".page").toString();
    }

    public String goButtonFormPath() {
        String encodedSortColumn = URLEncoder.encode(this.sortColumn, StandardCharsets.UTF_8.name());
        return new StringBuilder(14).append(this.parameterPath()).append("&").append(this.sqlStatsTableTag).append(".sort=").append(encodedSortColumn).append("&").append(this.sqlStatsTableTag).append(".desc=").append(this.desc).toString();
    }

    public Seq<Node> headers() {
        Seq sqlTableHeaders = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"User", "JobID", "GroupID", "Start Time", "Finish Time", "Close Time", "Execution Time", "Duration", "Statement", "State", "Detail"}));
        Seq tooltips = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{None$.MODULE$, None$.MODULE$, None$.MODULE$, None$.MODULE$, new Some((Object)ToolTips$.MODULE$.THRIFT_SERVER_FINISH_TIME()), new Some((Object)ToolTips$.MODULE$.THRIFT_SERVER_CLOSE_TIME()), new Some((Object)ToolTips$.MODULE$.THRIFT_SERVER_EXECUTION()), new Some((Object)ToolTips$.MODULE$.THRIFT_SERVER_DURATION()), None$.MODULE$, None$.MODULE$, None$.MODULE$}));
        Predef$.MODULE$.assert(sqlTableHeaders.length() == tooltips.length());
        Seq headerRow = (Seq)((TraversableLike)sqlTableHeaders.zip((GenIterable)tooltips, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Elem elem;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String header = (String)tuple2._1();
                Option tooltip = (Option)tuple2._2();
                String string = header;
                String string2 = $this.sortColumn;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    String arrow;
                    Unparsed headerLink = Unparsed$.MODULE$.apply(new StringBuilder(26).append(this.parameterPath()).append("&").append($this.sqlStatsTableTag).append(".sort=").append(URLEncoder.encode(header, StandardCharsets.UTF_8.name())).append("&").append($this.sqlStatsTableTag).append(".desc=").append(!$this.desc).append("&").append($this.sqlStatsTableTag).append(".pageSize=").append($this.pageSize).append("#").append($this.sqlStatsTableTag).toString());
                    String string3 = arrow = $this.desc ? "&#x25BE;" : "&#x25B4;";
                    if (tooltip.nonEmpty()) {
                        NodeBuffer $buf = new NodeBuffer();
                        $buf.$amp$plus((Object)new Text("\n              "));
                        Null$ $md = Null$.MODULE$;
                        $md = new UnprefixedAttribute("href", (Seq)headerLink, (MetaData)$md);
                        NodeBuffer $buf2 = new NodeBuffer();
                        $buf2.$amp$plus((Object)new Text("\n                "));
                        Null$ $md2 = Null$.MODULE$;
                        $md2 = new UnprefixedAttribute("title", (String)tooltip.get(), (MetaData)$md2);
                        $md2 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md2);
                        NodeBuffer $buf3 = new NodeBuffer();
                        $buf3.$amp$plus((Object)new Text("\n                  "));
                        $buf3.$amp$plus((Object)header);
                        $buf3.$amp$plus((Object)new EntityRef("nbsp"));
                        $buf3.$amp$plus((Object)Unparsed$.MODULE$.apply(arrow));
                        $buf3.$amp$plus((Object)new Text("\n                "));
                        $buf2.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
                        $buf2.$amp$plus((Object)new Text("\n              "));
                        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
                        $buf.$amp$plus((Object)new Text("\n            "));
                        Elem elem2 = new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                        elem = elem2;
                    } else {
                        NodeBuffer $buf = new NodeBuffer();
                        $buf.$amp$plus((Object)new Text("\n              "));
                        Null$ $md = Null$.MODULE$;
                        $md = new UnprefixedAttribute("href", (Seq)headerLink, (MetaData)$md);
                        NodeBuffer $buf4 = new NodeBuffer();
                        $buf4.$amp$plus((Object)new Text("\n                "));
                        $buf4.$amp$plus((Object)header);
                        $buf4.$amp$plus((Object)new EntityRef("nbsp"));
                        $buf4.$amp$plus((Object)Unparsed$.MODULE$.apply(arrow));
                        $buf4.$amp$plus((Object)new Text("\n              "));
                        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
                        $buf.$amp$plus((Object)new Text("\n            "));
                        Elem elem3 = new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                        elem = elem3;
                    }
                } else {
                    Unparsed headerLink = Unparsed$.MODULE$.apply(new StringBuilder(19).append(this.parameterPath()).append("&").append($this.sqlStatsTableTag).append(".sort=").append(URLEncoder.encode(header, StandardCharsets.UTF_8.name())).append("&").append($this.sqlStatsTableTag).append(".pageSize=").append($this.pageSize).append("#").append($this.sqlStatsTableTag).toString());
                    if (tooltip.nonEmpty()) {
                        NodeBuffer $buf = new NodeBuffer();
                        $buf.$amp$plus((Object)new Text("\n              "));
                        Null$ $md = Null$.MODULE$;
                        $md = new UnprefixedAttribute("href", (Seq)headerLink, (MetaData)$md);
                        NodeBuffer $buf5 = new NodeBuffer();
                        $buf5.$amp$plus((Object)new Text("\n                "));
                        Null$ $md3 = Null$.MODULE$;
                        $md3 = new UnprefixedAttribute("title", (String)tooltip.get(), (MetaData)$md3);
                        $md3 = new UnprefixedAttribute("data-toggle", (Seq)new Text("tooltip"), (MetaData)$md3);
                        NodeBuffer $buf6 = new NodeBuffer();
                        $buf6.$amp$plus((Object)new Text("\n                  "));
                        $buf6.$amp$plus((Object)header);
                        $buf6.$amp$plus((Object)new Text("\n                "));
                        $buf5.$amp$plus((Object)new Elem(null, "span", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
                        $buf5.$amp$plus((Object)new Text("\n              "));
                        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
                        $buf.$amp$plus((Object)new Text("\n            "));
                        Elem elem4 = new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                        elem = elem4;
                    } else {
                        NodeBuffer $buf = new NodeBuffer();
                        $buf.$amp$plus((Object)new Text("\n              "));
                        Null$ $md = Null$.MODULE$;
                        $md = new UnprefixedAttribute("href", (Seq)headerLink, (MetaData)$md);
                        NodeBuffer $buf7 = new NodeBuffer();
                        $buf7.$amp$plus((Object)new Text("\n                "));
                        $buf7.$amp$plus((Object)header);
                        $buf7.$amp$plus((Object)new Text("\n              "));
                        $buf.$amp$plus((Object)new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
                        $buf.$amp$plus((Object)new Text("\n            "));
                        Elem elem5 = new Elem(null, "th", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
                        elem = elem5;
                    }
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Elem elem6 = elem;
            return elem6;
        }, Seq$.MODULE$.canBuildFrom());
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)headerRow);
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "thead", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    public Seq<Node> row(SqlStatsTableRow sqlStatsTableRow) {
        ExecutionInfo info = sqlStatsTableRow.executionInfo();
        long startTime = info.startTimestamp();
        long executionTime = sqlStatsTableRow.executionTime();
        long duration = sqlStatsTableRow.duration();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        $buf2.$amp$plus((Object)info.userName());
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("\n        "));
        $buf3.$amp$plus((Object)this.jobLinks$1(sqlStatsTableRow.jobId()));
        $buf3.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf4.$amp$plus((Object)info.groupId());
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf4));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("\n        "));
        $buf5.$amp$plus((Object)UIUtils$.MODULE$.formatDate(startTime));
        $buf5.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf5));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n        "));
        $buf6.$amp$plus((Object)(info.finishTimestamp() > 0L ? UIUtils$.MODULE$.formatDate(info.finishTimestamp()) : BoxedUnit.UNIT));
        $buf6.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf6));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf7 = new NodeBuffer();
        $buf7.$amp$plus((Object)new Text("\n        "));
        $buf7.$amp$plus((Object)(info.closeTimestamp() > 0L ? UIUtils$.MODULE$.formatDate(info.closeTimestamp()) : BoxedUnit.UNIT));
        $buf7.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf7));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Comment(" Returns a human-readable string representing a duration such as \"5 second 35 ms\""));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf8 = new NodeBuffer();
        $buf8.$amp$plus((Object)new Text("\n        "));
        $buf8.$amp$plus((Object)UIUtils$.MODULE$.formatDurationVerbose(executionTime));
        $buf8.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf8));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf9 = new NodeBuffer();
        $buf9.$amp$plus((Object)new Text("\n        "));
        $buf9.$amp$plus((Object)UIUtils$.MODULE$.formatDurationVerbose(duration));
        $buf9.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf9));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf10 = new NodeBuffer();
        $buf10.$amp$plus((Object)new Text("\n        "));
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("description-input"), (MetaData)$md);
        NodeBuffer $buf11 = new NodeBuffer();
        $buf11.$amp$plus((Object)new Text("\n          "));
        $buf11.$amp$plus((Object)info.statement());
        $buf11.$amp$plus((Object)new Text("\n        "));
        $buf10.$amp$plus((Object)new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf11));
        $buf10.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf10));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf12 = new NodeBuffer();
        $buf12.$amp$plus((Object)new Text("\n        "));
        $buf12.$amp$plus((Object)info.state());
        $buf12.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf12));
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus(this.errorMessageCell(sqlStatsTableRow.detail()));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "tr", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    private Seq<Node> errorMessageCell(String errorMessage) {
        boolean isMultiline = errorMessage.indexOf(10) >= 0;
        String errorSummary = StringEscapeUtils.escapeHtml4((String)(isMultiline ? errorMessage.substring(0, errorMessage.indexOf(10)) : errorMessage));
        Seq details = UIUtils$.MODULE$.detailsUINode(isMultiline, errorMessage);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)errorSummary);
        $buf.$amp$plus((Object)details);
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "td", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
    }

    private String jobURL(HttpServletRequest request, String jobId) {
        return new StringOps(Predef$.MODULE$.augmentString("%s/jobs/job/?id=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3()), jobId}));
    }

    private final Seq jobLinks$1(Seq jobData) {
        return (Seq)jobData.map((Function1 & Serializable & scala.Serializable)jobId -> {
            void var3_3;
            Null$ $md = Null$.MODULE$;
            $md = new UnprefixedAttribute("href", this.jobURL($this.request, (String)jobId), (MetaData)$md);
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus((Object)new Text("["));
            $buf.$amp$plus((Object)jobId.toString());
            $buf.$amp$plus((Object)new Text("]"));
            return new Elem(null, "a", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)var3_3);
        }, Seq$.MODULE$.canBuildFrom());
    }

    public SqlStatsPagedTable(HttpServletRequest request, ThriftServerTab parent, Seq<ExecutionInfo> data, String subPath, String basePath, Iterable<String> parameterOtherTable, String sqlStatsTableTag, int pageSize, String sortColumn, boolean desc) {
        this.request = request;
        this.parent = parent;
        this.sqlStatsTableTag = sqlStatsTableTag;
        this.pageSize = pageSize;
        this.sortColumn = sortColumn;
        this.desc = desc;
        PagedTable.$init$((PagedTable)this);
        this.dataSource = new SqlStatsTableDataSource(data, pageSize, sortColumn, desc);
        this.parameterPath = new StringBuilder(3).append(basePath).append("/").append(subPath).append("/?").append(parameterOtherTable.mkString("&")).toString();
    }
}

