/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg.distributed;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.LU;
import breeze.linalg.MatrixSingularException;
import breeze.linalg.NumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.Vector$;
import breeze.linalg.inv$;
import breeze.linalg.mapActiveValues$;
import breeze.linalg.qr;
import breeze.linalg.svd;
import breeze.linalg.svd$;
import breeze.numerics.package;
import breeze.storage.Zero;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseMatrix;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.EigenValueDecomposition$;
import org.apache.spark.mllib.linalg.Matrices$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.QRDecomposition;
import org.apache.spark.mllib.linalg.SingularValueDecomposition;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.linalg.distributed.CoordinateMatrix;
import org.apache.spark.mllib.linalg.distributed.DistributedMatrix;
import org.apache.spark.mllib.linalg.distributed.MatrixEntry;
import org.apache.spark.mllib.linalg.distributed.RowMatrix$;
import org.apache.spark.mllib.linalg.distributed.RowMatrix$SVDMode$1$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.mllib.stat.Statistics$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\tmd\u0001\u0002\u0015*\u0001YB\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t9\u0002\u0011\t\u0011)A\u0005\u0013\"Aa\f\u0001BA\u0002\u0013%q\f\u0003\u0005d\u0001\t\u0005\r\u0011\"\u0003e\u0011!Q\u0007A!A!B\u0013\u0001\u0007\u0002C6\u0001\u0005\u0003\u0007I\u0011\u00027\t\u0011A\u0004!\u00111A\u0005\nED\u0001b\u001d\u0001\u0003\u0002\u0003\u0006K!\u001c\u0005\u0006i\u0002!\t!\u001e\u0005\u0006i\u0002!\t\u0001 \u0005\u0007\u007f\u0002!\t%!\u0001\t\u000f\u0005\u0015\u0001\u0001\"\u0011\u0002\u0002!A\u0011\u0011\u0002\u0001\u0005\u00025\nY\u0001C\u0004\u0002&\u0001!\t!a\n\t\u000f\u0005E\u0002\u0001\"\u0003\u00024!9\u0011\u0011\t\u0001\u0005\n\u0005\r\u0003bBA&\u0001\u0011%\u0011Q\n\u0005\b\u0003'\u0002A\u0011AA+\u0011%\t\t\bAI\u0001\n\u0003\t\u0019\bC\u0005\u0002\b\u0002\t\n\u0011\"\u0001\u0002\n\"A\u00111\u000b\u0001\u0005\u00025\ni\tC\u0004\u00028\u0002!\t!a\n\t\u000f\u0005m\u0006\u0001\"\u0001\u0002>\"9\u0011Q\u001a\u0001\u0005\u0002\u0005=\u0007bBAk\u0001\u0011\u0005\u0011q\u001b\u0005\b\u0003O\u0004A\u0011AAu\u0011\u001d\t\t\u0010\u0001C\u0001\u0003gDq!!=\u0001\t\u0003\u0011\t\u0001C\u0004\u0003\n\u0001!\tAa\u0003\t\u0013\tu\u0001!%A\u0005\u0002\u0005M\u0004\u0002\u0003B\u0010\u0001\u0011\u0005QF!\t\t\u0011\tE\u0002\u0001\"\u0011.\u0005gAqAa\u000f\u0001\t\u0013\u0011i\u0004\u0003\u0005\u0003B\u0001!\ta\fB\"\u000f\u001d\u0011Y%\u000bE\u0001\u0005\u001b2a\u0001K\u0015\t\u0002\t=\u0003B\u0002;%\t\u0003\u00119\u0006C\u0004\u0003Z\u0011\"IAa\u0017\t\u0013\t\rD%!A\u0005\n\t\u0015$!\u0003*po6\u000bGO]5y\u0015\tQ3&A\u0006eSN$(/\u001b2vi\u0016$'B\u0001\u0017.\u0003\u0019a\u0017N\\1mO*\u0011afL\u0001\u0006[2d\u0017N\u0019\u0006\u0003aE\nQa\u001d9be.T!AM\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0014aA8sO\u000e\u00011\u0003\u0002\u00018{\u0005\u0003\"\u0001O\u001e\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012a!\u00118z%\u00164\u0007C\u0001 @\u001b\u0005I\u0013B\u0001!*\u0005E!\u0015n\u001d;sS\n,H/\u001a3NCR\u0014\u0018\u000e\u001f\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t>\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\r\u000e\u0013q\u0001T8hO&tw-\u0001\u0003s_^\u001cX#A%\u0011\u0007)ku*D\u0001L\u0015\tau&A\u0002sI\u0012L!AT&\u0003\u0007I#E\t\u0005\u0002Q#6\t1&\u0003\u0002SW\t1a+Z2u_JD3!\u0001+[!\t)\u0006,D\u0001W\u0015\t9v&\u0001\u0006b]:|G/\u0019;j_:L!!\u0017,\u0003\u000bMKgnY3\"\u0003m\u000bQ!\r\u00181]A\nQA]8xg\u0002B3A\u0001+[\u0003\u0015q'k\\<t+\u0005\u0001\u0007C\u0001\u001db\u0013\t\u0011\u0017H\u0001\u0003M_:<\u0017!\u00038S_^\u001cx\fJ3r)\t)\u0007\u000e\u0005\u00029M&\u0011q-\u000f\u0002\u0005+:LG\u000fC\u0004j\t\u0005\u0005\t\u0019\u00011\u0002\u0007a$\u0013'\u0001\u0004o%><8\u000fI\u0001\u0006]\u000e{Gn]\u000b\u0002[B\u0011\u0001H\\\u0005\u0003_f\u00121!\u00138u\u0003%q7i\u001c7t?\u0012*\u0017\u000f\u0006\u0002fe\"9\u0011nBA\u0001\u0002\u0004i\u0017A\u00028D_2\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0005m^L(\u0010\u0005\u0002?\u0001!)q)\u0003a\u0001\u0013\"\u001aq\u000f\u0016.\t\u000byK\u0001\u0019\u00011\t\u000b-L\u0001\u0019A7)\u0007%!&\f\u0006\u0002w{\")qI\u0003a\u0001\u0013\"\u001a!\u0002\u0016.\u0002\u000f9,XnQ8mgR\t\u0001\rK\u0002\f)j\u000bqA\\;n%><8\u000fK\u0002\r)j\u000bq#\\;mi&\u0004H._$sC6L\u0017M\\'biJL\u0007PQ=\u0015\t\u00055\u0011\u0011\u0005\t\u0007\u0003\u001f\t9\"a\u0007\u000e\u0005\u0005E!b\u0001\u0017\u0002\u0014)\u0011\u0011QC\u0001\u0007EJ,WM_3\n\t\u0005e\u0011\u0011\u0003\u0002\f\t\u0016t7/\u001a,fGR|'\u000fE\u00029\u0003;I1!a\b:\u0005\u0019!u.\u001e2mK\"9\u00111E\u0007A\u0002\u00055\u0011!\u0001<\u0002)\r|W\u000e];uK\u001e\u0013\u0018-\\5b]6\u000bGO]5y)\t\tI\u0003E\u0002Q\u0003WI1!!\f,\u0005\u0019i\u0015\r\u001e:jq\"\u001aa\u0002\u0016.\u00029\r|W\u000e];uK\u0012+gn]3WK\u000e$xN]\"pm\u0006\u0014\u0018.\u00198dKRA\u0011\u0011FA\u001b\u0003s\ti\u0004\u0003\u0004\u00028=\u0001\raT\u0001\u0005[\u0016\fg\u000e\u0003\u0004\u0002<=\u0001\r!\\\u0001\u0002]\"1\u0011qH\bA\u0002\u0001\f\u0011!\\\u0001\u001eG>l\u0007/\u001e;f'B\f'o]3WK\u000e$xN]\"pm\u0006\u0014\u0018.\u00198dKRA\u0011\u0011FA#\u0003\u000f\nI\u0005\u0003\u0004\u00028A\u0001\ra\u0014\u0005\u0007\u0003w\u0001\u0002\u0019A7\t\r\u0005}\u0002\u00031\u0001a\u0003=\u0019\u0007.Z2l\u001dVl7i\u001c7v[:\u001cHcA3\u0002P!1\u0011\u0011K\tA\u00025\fAaY8mg\u0006Q1m\\7qkR,7K\u0016#\u0015\u0011\u0005]\u0013QLA1\u0003W\u0002b\u0001UA-m\u0006%\u0012bAA.W\tQ2+\u001b8hk2\f'OV1mk\u0016$UmY8na>\u001c\u0018\u000e^5p]\"1\u0011q\f\nA\u00025\f\u0011a\u001b\u0005\n\u0003G\u0012\u0002\u0013!a\u0001\u0003K\n\u0001bY8naV$X-\u0016\t\u0004q\u0005\u001d\u0014bAA5s\t9!i\\8mK\u0006t\u0007\"CA7%A\u0005\t\u0019AA\u000e\u0003\u0015\u00118i\u001c8eQ\r\u0011BKW\u0001\u0015G>l\u0007/\u001e;f'Z#E\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005U$\u0006BA3\u0003oZ#!!\u001f\u0011\t\u0005m\u00141Q\u0007\u0003\u0003{RA!a \u0002\u0002\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003/fJA!!\"\u0002~\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002)\r|W\u000e];uKN3F\t\n3fM\u0006,H\u000e\u001e\u00134+\t\tYI\u000b\u0003\u0002\u001c\u0005]DCDA,\u0003\u001f\u000b\t*a%\u0002\u0016\u0006e\u0015Q\u0014\u0005\u0007\u0003?*\u0002\u0019A7\t\u000f\u0005\rT\u00031\u0001\u0002f!9\u0011QN\u000bA\u0002\u0005m\u0001BBAL+\u0001\u0007Q.A\u0004nCbLE/\u001a:\t\u000f\u0005mU\u00031\u0001\u0002\u001c\u0005\u0019Ao\u001c7\t\u000f\u0005}U\u00031\u0001\u0002\"\u0006!Qn\u001c3f!\u0011\t\u0019+!-\u000f\t\u0005\u0015\u0016Q\u0016\t\u0004\u0003OKTBAAU\u0015\r\tY+N\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=\u0016(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003g\u000b)L\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003_K\u0014!E2p[B,H/Z\"pm\u0006\u0014\u0018.\u00198dK\"\u001aa\u0003\u0016.\u0002]\r|W\u000e];uKB\u0013\u0018N\\2ja\u0006d7i\\7q_:,g\u000e^:B]\u0012,\u0005\u0010\u001d7bS:,GMV1sS\u0006t7-\u001a\u000b\u0005\u0003\u007f\u000b)\r\u0005\u00049\u0003\u0003\fIcT\u0005\u0004\u0003\u0007L$A\u0002+va2,'\u0007\u0003\u0004\u0002`]\u0001\r!\u001c\u0015\u0005/Q\u000bI-\t\u0002\u0002L\u0006)\u0011G\f\u001c/a\u0005Q2m\\7qkR,\u0007K]5oG&\u0004\u0018\r\\\"p[B|g.\u001a8ugR!\u0011\u0011FAi\u0011\u0019\ty\u0006\u0007a\u0001[\"\u001a\u0001\u0004\u0016.\u0002=\r|W\u000e];uK\u000e{G.^7o'VlW.\u0019:z'R\fG/[:uS\u000e\u001cHCAAm!\u0011\tY.!9\u000e\u0005\u0005u'bAAp[\u0005!1\u000f^1u\u0013\u0011\t\u0019/!8\u0003=5+H\u000e^5wCJL\u0017\r^3Ti\u0006$\u0018n\u001d;jG\u0006d7+^7nCJL\bfA\rU5\u0006AQ.\u001e7uSBd\u0017\u0010F\u0002w\u0003WDq!!<\u001b\u0001\u0004\tI#A\u0001CQ\rQBKW\u0001\u0013G>dW/\u001c8TS6LG.\u0019:ji&,7\u000f\u0006\u0002\u0002vB\u0019a(a>\n\u0007\u0005e\u0018F\u0001\tD_>\u0014H-\u001b8bi\u0016l\u0015\r\u001e:jq\"\"1\u0004VA\u007fC\t\ty0A\u00032]Ir\u0003\u0007\u0006\u0003\u0002v\n\r\u0001b\u0002B\u00039\u0001\u0007\u00111D\u0001\ni\"\u0014Xm\u001d5pY\u0012DC\u0001\b+\u0002~\u0006aA/\u00197m'.LgN\\=R%R!!Q\u0002B\n!\u0019\u0001&q\u0002<\u0002*%\u0019!\u0011C\u0016\u0003\u001fE\u0013F)Z2p[B|7/\u001b;j_:D\u0011B!\u0006\u001e!\u0003\u0005\r!!\u001a\u0002\u0011\r|W\u000e];uKFCC!\b+\u0003\u001a\u0005\u0012!1D\u0001\u0006c9*d\u0006M\u0001\u0017i\u0006dGnU6j]:L\u0018K\u0015\u0013eK\u001a\fW\u000f\u001c;%c\u0005A2m\u001c7v[:\u001c\u0016.\\5mCJLG/[3t\t&k5+V'\u0015\r\u0005U(1\u0005B\u0017\u0011\u001d\u0011)c\ba\u0001\u0005O\tqaY8m\u001b\u0006<7\u000fE\u00039\u0005S\tY\"C\u0002\u0003,e\u0012Q!\u0011:sCfDqAa\f \u0001\u0004\tY\"A\u0003hC6l\u0017-\u0001\u0005u_\n\u0013X-\u001a>f)\t\u0011)\u0004\u0005\u0004\u0002\u0010\t]\u00121D\u0005\u0005\u0005s\t\tBA\u0006EK:\u001cX-T1ue&D\u0018!D;qI\u0006$XMT;n%><8\u000fF\u0002f\u0005\u007fAa!a\u0010\"\u0001\u0004\u0001\u0017AG4fiR\u0013X-Z!hOJ,w-\u0019;f\u0013\u0012,\u0017\r\u001c#faRDGcA7\u0003F!1!q\t\u0012A\u0002\u0001\f1$Y4he\u0016<\u0017\r^3e\u001f\nTWm\u0019;TSj,\u0017J\u001c\"zi\u0016\u001c\bf\u0001\u0001U5\u0006I!k\\<NCR\u0014\u0018\u000e\u001f\t\u0003}\u0011\u001aB\u0001J\u001c\u0003RA\u0019\u0001Ha\u0015\n\u0007\tU\u0013H\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0006\u0002\u0003N\u0005QAO]5v)>4U\u000f\u001c7\u0015\r\u0005%\"Q\fB0\u0011\u0019\tYD\na\u0001[\"9!\u0011\r\u0014A\u0002\t\u001d\u0012!A+\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005O\u0002BA!\u001b\u0003t5\u0011!1\u000e\u0006\u0005\u0005[\u0012y'\u0001\u0003mC:<'B\u0001B9\u0003\u0011Q\u0017M^1\n\t\tU$1\u000e\u0002\u0007\u001f\nTWm\u0019;)\u0007\u0011\"&\fK\u0002$)j\u0003")
public class RowMatrix
implements DistributedMatrix,
Logging {
    private final RDD<Vector> rows;
    private long nRows;
    private int nCols;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RDD<Vector> rows() {
        return this.rows;
    }

    private long nRows() {
        return this.nRows;
    }

    private void nRows_$eq(long x$1) {
        this.nRows = x$1;
    }

    private int nCols() {
        return this.nCols;
    }

    private void nCols_$eq(int x$1) {
        this.nCols = x$1;
    }

    @Override
    public long numCols() {
        if (this.nCols() <= 0) {
            try {
                this.nCols_$eq(((Vector)this.rows().first()).size());
            }
            catch (UnsupportedOperationException err) {
                throw scala.sys.package$.MODULE$.error("Cannot determine the number of cols because it is not specified in the constructor and the rows RDD is empty.");
            }
        }
        return this.nCols();
    }

    @Override
    public long numRows() {
        if (this.nRows() <= 0L) {
            this.nRows_$eq(this.rows().count());
            if (this.nRows() == 0L) {
                throw scala.sys.package$.MODULE$.error("Cannot determine the number of rows because it is not specified in the constructor and the rows RDD is empty.");
            }
        }
        return this.nRows();
    }

    public breeze.linalg.DenseVector<Object> multiplyGramianMatrixBy(breeze.linalg.DenseVector<Object> v) {
        int n = (int)this.numCols();
        Broadcast vbr = this.rows().context().broadcast(v, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
        breeze.linalg.DenseVector x$1 = breeze.linalg.DenseVector$.MODULE$.zeros$mDc$sp(n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        Function2 & Serializable & scala.Serializable x$2 = (Function2 & Serializable & scala.Serializable)(U, r) -> {
            breeze.linalg.Vector<Object> rBrz = r.asBreeze();
            double a = BoxesRunTime.unboxToDouble((Object)rBrz.dot(vbr.value(), Vector$.MODULE$.castOps(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double())));
            breeze.linalg.Vector<Object> vector = rBrz;
            if (vector instanceof breeze.linalg.DenseVector) {
                breeze.linalg.package$.MODULE$.axpy((Object)BoxesRunTime.boxToDouble((double)a), (Object)((breeze.linalg.DenseVector)rBrz), U, (UFunc.InPlaceImpl3)DenseVector.canDaxpy$.MODULE$);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (vector instanceof breeze.linalg.SparseVector) {
                breeze.linalg.package$.MODULE$.axpy((Object)BoxesRunTime.boxToDouble((double)a), (Object)((breeze.linalg.SparseVector)rBrz), U, breeze.linalg.SparseVector$.MODULE$.implScaleAdd_DVT_T_SVT_InPlace_Double());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new UnsupportedOperationException(new StringBuilder(43).append("Do not support vector operation from type ").append(rBrz.getClass().getName()).append(".").toString());
            }
            return U;
        };
        Function2 & Serializable & scala.Serializable x$3 = (Function2 & Serializable & scala.Serializable)(U1, U2) -> (breeze.linalg.DenseVector)U1.$plus$eq(U2, breeze.linalg.DenseVector$.MODULE$.canAddIntoD());
        int x$4 = this.rows().treeAggregate$default$4((Object)x$1);
        return (breeze.linalg.DenseVector)this.rows().treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
    }

    public Matrix computeGramianMatrix() {
        int n = (int)this.numCols();
        this.checkNumColumns(n);
        int nt = n % 2 == 0 ? n / 2 * (n + 1) : n * ((n + 1) / 2);
        long gramianSizeInBytes = (long)nt * 8L;
        breeze.linalg.DenseVector GU = (breeze.linalg.DenseVector)this.rows().treeAggregate(null, (Function2 & Serializable & scala.Serializable)(maybeU, v) -> {
            void var3_3;
            breeze.linalg.DenseVector U = maybeU == null ? new DenseVector.mcD.sp(nt, ClassTag$.MODULE$.Double()) : maybeU;
            BLAS$.MODULE$.spr(1.0, (Vector)v, U.data$mcD$sp());
            return var3_3;
        }, (Function2 & Serializable & scala.Serializable)(U1, U2) -> U1 == null ? U2 : (U2 == null ? U1 : (breeze.linalg.DenseVector)U1.$plus$eq(U2, breeze.linalg.DenseVector$.MODULE$.canAddIntoD())), this.getTreeAggregateIdealDepth(gramianSizeInBytes), ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
        return RowMatrix$.MODULE$.org$apache$spark$mllib$linalg$distributed$RowMatrix$$triuToFull(n, GU.data$mcD$sp());
    }

    private Matrix computeDenseVectorCovariance(Vector mean, int n, long m) {
        Broadcast bc = this.rows().context().broadcast((Object)mean, ClassTag$.MODULE$.apply(Vector.class));
        int nt = n % 2 == 0 ? n / 2 * (n + 1) : n * ((n + 1) / 2);
        Object x$1 = null;
        Function2 & Serializable & scala.Serializable x$2 = (Function2 & Serializable & scala.Serializable)(maybeU, v) -> {
            breeze.linalg.DenseVector U = maybeU == null ? new DenseVector.mcD.sp(nt, ClassTag$.MODULE$.Double()) : maybeU;
            int n = v.size();
            double[] na = (double[])Array$.MODULE$.ofDim(n, ClassTag$.MODULE$.Double());
            Vector means = (Vector)bc.value();
            double[] ta = v.toArray();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
                na$1[index] = ta[index] - means.apply(index);
            });
            BLAS$.MODULE$.spr(1.0, (Vector)new DenseVector(na), U.data$mcD$sp());
            return U;
        };
        Function2 & Serializable & scala.Serializable x$3 = (Function2 & Serializable & scala.Serializable)(U1, U2) -> U1 == null ? U2 : (U2 == null ? U1 : (breeze.linalg.DenseVector)U1.$plus$eq(U2, breeze.linalg.DenseVector$.MODULE$.canAddIntoD()));
        int x$4 = this.rows().treeAggregate$default$4(x$1);
        breeze.linalg.DenseVector MU = (breeze.linalg.DenseVector)this.rows().treeAggregate(x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(breeze.linalg.DenseVector.class));
        bc.destroy();
        breeze.linalg.Matrix<Object> M = RowMatrix$.MODULE$.org$apache$spark$mllib$linalg$distributed$RowMatrix$$triuToFull(n, MU.data$mcD$sp()).asBreeze();
        int j = 0;
        double m1 = (double)m - 1.0;
        for (int i = 0; i < n; ++i) {
            for (j = i; j < n; ++j) {
                double Mij = M.apply$mcD$sp(i, j) / m1;
                M.update$mcD$sp(i, j, Mij);
                M.update$mcD$sp(j, i, Mij);
            }
        }
        return Matrices$.MODULE$.fromBreeze(M);
    }

    private Matrix computeSparseVectorCovariance(Vector mean, int n, long m) {
        breeze.linalg.Matrix<Object> G = this.computeGramianMatrix().asBreeze();
        int j = 0;
        double m1 = (double)m - 1.0;
        double alpha = 0.0;
        for (int i = 0; i < n; ++i) {
            alpha = (double)m / m1 * mean.apply(i);
            for (j = i; j < n; ++j) {
                double Gij = G.apply$mcD$sp(i, j) / m1 - alpha * mean.apply(j);
                G.update$mcD$sp(i, j, Gij);
                G.update$mcD$sp(j, i, Gij);
            }
        }
        return Matrices$.MODULE$.fromBreeze(G);
    }

    private void checkNumColumns(int cols) {
        block1: {
            if (cols > 65535) {
                throw new IllegalArgumentException(new StringBuilder(36).append("Argument with more than 65535 cols: ").append(cols).toString());
            }
            if (cols <= 10000) break block1;
            long memMB = (long)cols * (long)cols / 125000L;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append(cols).append(" columns will require at least ").append(memMB).append(" megabytes of memory!").toString());
        }
    }

    public SingularValueDecomposition<RowMatrix, Matrix> computeSVD(int k, boolean computeU, double rCond) {
        int maxIter = package$.MODULE$.max(300, k * 3);
        double tol = 1.0E-10;
        return this.computeSVD(k, computeU, rCond, maxIter, tol, "auto");
    }

    public SingularValueDecomposition<RowMatrix, Matrix> computeSVD(int k, boolean computeU, double rCond, int maxIter, double tol, String mode) {
        SingularValueDecomposition<RowMatrix, Matrix> singularValueDecomposition;
        breeze.linalg.DenseVector denseVector;
        breeze.linalg.DenseMatrix u;
        Enumeration.Value computeMode;
        int n;
        LazyRef SVDMode$module;
        block33: {
            Tuple2 tuple2;
            block32: {
                Tuple2 tuple22;
                block28: {
                    Enumeration.Value value;
                    block29: {
                        breeze.linalg.DenseMatrix denseMatrix;
                        breeze.linalg.DenseVector sigmaSquaresFull;
                        block31: {
                            svd.SVD sVD;
                            block30: {
                                block27: {
                                    Enumeration.Value value2;
                                    SVDMode$module = new LazyRef();
                                    n = (int)this.numCols();
                                    Predef$.MODULE$.require(k > 0 && k <= n, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Requested k singular values but got k=").append(k).append(" and numCols=").append(n).append(".").toString());
                                    String string = mode;
                                    if ("auto".equals(string)) {
                                        if (k > 5000) {
                                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("computing svd with k=").append(k).append(" and n=").append(n).append(", please check necessity").toString());
                                        }
                                        value2 = n < 100 || k > n / 2 && n <= 15000 ? (k < n / 3 ? this.SVDMode$2(SVDMode$module).LocalARPACK() : this.SVDMode$2(SVDMode$module).LocalLAPACK()) : this.SVDMode$2(SVDMode$module).DistARPACK();
                                    } else if ("local-svd".equals(string)) {
                                        value2 = this.SVDMode$2(SVDMode$module).LocalLAPACK();
                                    } else if ("local-eigs".equals(string)) {
                                        value2 = this.SVDMode$2(SVDMode$module).LocalARPACK();
                                    } else if ("dist-eigs".equals(string)) {
                                        value2 = this.SVDMode$2(SVDMode$module).DistARPACK();
                                    } else {
                                        throw new IllegalArgumentException(new StringBuilder(21).append("Do not support mode ").append(mode).append(".").toString());
                                    }
                                    value = computeMode = value2;
                                    Enumeration.Value value3 = this.SVDMode$2(SVDMode$module).LocalARPACK();
                                    Enumeration.Value value4 = value;
                                    if (value3 != null ? !value3.equals(value4) : value4 != null) break block27;
                                    Predef$.MODULE$.require(k < n, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("k must be smaller than n in local-eigs mode but got k=").append(k).append(" and n=").append(n).append(".").toString());
                                    breeze.linalg.DenseMatrix G = (breeze.linalg.DenseMatrix)this.computeGramianMatrix().asBreeze();
                                    tuple22 = EigenValueDecomposition$.MODULE$.symmetricEigs((Function1<breeze.linalg.DenseVector<Object>, breeze.linalg.DenseVector<Object>>)(Function1 & Serializable & scala.Serializable)v -> (breeze.linalg.DenseVector)G.$times(v, (UFunc.UImpl2)DenseMatrix$.MODULE$.implOpMulMatrix_DMD_DVD_eq_DVD()), n, k, tol, maxIter);
                                    break block28;
                                }
                                Enumeration.Value value5 = this.SVDMode$2(SVDMode$module).LocalLAPACK();
                                Enumeration.Value value6 = value;
                                if (value5 != null ? !value5.equals(value6) : value6 != null) break block29;
                                Predef$.MODULE$.require(n < 17515, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append(n).append(" exceeds the breeze svd capability").toString());
                                breeze.linalg.DenseMatrix G = (breeze.linalg.DenseMatrix)this.computeGramianMatrix().asBreeze();
                                sVD = (svd.SVD)svd$.MODULE$.apply((Object)G, (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
                                if (sVD == null) break block30;
                                breeze.linalg.DenseMatrix uFull = (breeze.linalg.DenseMatrix)sVD.leftVectors();
                                sigmaSquaresFull = (breeze.linalg.DenseVector)sVD.singularValues();
                                if (uFull == null) break block30;
                                denseMatrix = uFull;
                                if (sigmaSquaresFull != null) break block31;
                            }
                            throw new MatchError((Object)sVD);
                        }
                        breeze.linalg.DenseVector denseVector2 = sigmaSquaresFull;
                        Tuple2 tuple23 = new Tuple2((Object)denseMatrix, (Object)denseVector2);
                        Tuple2 tuple24 = tuple23;
                        breeze.linalg.DenseMatrix uFull = (breeze.linalg.DenseMatrix)tuple24._1();
                        breeze.linalg.DenseVector sigmaSquaresFull2 = (breeze.linalg.DenseVector)tuple24._2();
                        tuple22 = new Tuple2((Object)sigmaSquaresFull2, (Object)uFull);
                        break block28;
                    }
                    Enumeration.Value value7 = this.SVDMode$2(SVDMode$module).DistARPACK();
                    Enumeration.Value value8 = value;
                    if (!(value7 != null ? !value7.equals(value8) : value8 != null)) {
                        StorageLevel storageLevel = this.rows().getStorageLevel();
                        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
                        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The input data is not directly cached, which may hurt performance if its parent RDDs are also uncached.");
                        }
                        Predef$.MODULE$.require(k < n, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("k must be smaller than n in dist-eigs mode but got k=").append(k).append(" and n=").append(n).append(".").toString());
                        tuple22 = EigenValueDecomposition$.MODULE$.symmetricEigs((Function1<breeze.linalg.DenseVector<Object>, breeze.linalg.DenseVector<Object>>)(Function1 & Serializable & scala.Serializable)v -> this.multiplyGramianMatrixBy((breeze.linalg.DenseVector<Object>)v), n, k, tol, maxIter);
                    } else {
                        throw new MatchError((Object)value);
                    }
                }
                tuple2 = tuple22;
                if (tuple2 == null) break block32;
                breeze.linalg.DenseVector sigmaSquares = (breeze.linalg.DenseVector)tuple2._1();
                u = (breeze.linalg.DenseMatrix)tuple2._2();
                if (sigmaSquares == null) break block32;
                denseVector = sigmaSquares;
                if (u != null) break block33;
            }
            throw new MatchError(tuple2);
        }
        breeze.linalg.DenseMatrix denseMatrix = u;
        Tuple2 tuple2 = new Tuple2((Object)denseVector, (Object)denseMatrix);
        Tuple2 tuple25 = tuple2;
        breeze.linalg.DenseVector sigmaSquares = (breeze.linalg.DenseVector)tuple25._1();
        breeze.linalg.DenseMatrix u2 = (breeze.linalg.DenseMatrix)tuple25._2();
        breeze.linalg.DenseVector sigmas = (breeze.linalg.DenseVector)package.sqrt$.MODULE$.apply((Object)sigmaSquares, package.sqrt$.MODULE$.fromLowOrderCanMapActiveValues(breeze.linalg.DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.sqrt$.sqrtDoubleImpl$.MODULE$, mapActiveValues$.MODULE$.implFromCanMapValues(breeze.linalg.DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))));
        double sigma0 = sigmas.apply$mcD$sp(0);
        double threshold = rCond * sigma0;
        int i = 0;
        if (sigmas.length() < k) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Requested ").append(k).append(" singular values but only found ").append(sigmas.length()).append(" converged.").toString());
        }
        while (i < package$.MODULE$.min(k, sigmas.length()) && sigmas.apply$mcD$sp(i) >= threshold) {
            ++i;
        }
        int sk = i;
        if (sk < k) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Requested ").append(k).append(" singular values but only found ").append(sk).append(" nonzeros.").toString());
        }
        Enumeration.Value value = computeMode;
        Enumeration.Value value9 = this.SVDMode$2(SVDMode$module).DistARPACK();
        if (!(value != null ? !value.equals(value9) : value9 != null)) {
            StorageLevel storageLevel = this.rows().getStorageLevel();
            StorageLevel storageLevel3 = StorageLevel$.MODULE$.NONE();
            if (!(storageLevel != null ? !storageLevel.equals(storageLevel3) : storageLevel3 != null)) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The input data was not directly cached, which may hurt performance if its parent RDDs are also uncached.");
            }
        }
        Vector s = Vectors$.MODULE$.dense(Arrays.copyOfRange(sigmas.data$mcD$sp(), 0, sk));
        Matrix V = Matrices$.MODULE$.dense(n, sk, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * sk));
        if (computeU) {
            DenseMatrix.mcD.sp N = new DenseMatrix.mcD.sp(n, sk, Arrays.copyOfRange(u2.data$mcD$sp(), 0, n * sk));
            int i2 = 0;
            for (int j = 0; j < sk; ++j) {
                i2 = 0;
                double sigma = sigmas.apply$mcD$sp(j);
                while (i2 < n) {
                    int n2 = i2++;
                    int n3 = j;
                    N.update$mcD$sp(n2, n3, N.apply$mcD$sp(n2, n3) / sigma);
                }
            }
            RowMatrix U = this.multiply(Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)N));
            singularValueDecomposition = new SingularValueDecomposition<RowMatrix, Matrix>(U, s, V);
        } else {
            singularValueDecomposition = new SingularValueDecomposition<RowMatrix, Matrix>(null, s, V);
        }
        return singularValueDecomposition;
    }

    public boolean computeSVD$default$2() {
        return false;
    }

    public double computeSVD$default$3() {
        return 1.0E-9;
    }

    public Matrix computeCovariance() {
        int n = (int)this.numCols();
        this.checkNumColumns(n);
        SummarizerBuffer summary = Statistics$.MODULE$.colStats((RDD<Tuple2<Vector, Object>>)this.rows().map((Function1 & Serializable & scala.Serializable)x$3 -> new Tuple2(x$3, (Object)BoxesRunTime.boxToDouble((double)1.0)), ClassTag$.MODULE$.apply(Tuple2.class)), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"count", "mean"}))));
        long m = summary.count();
        Predef$.MODULE$.require(m > 1L, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(122).append("RowMatrix.computeCovariance called on matrix with only ").append(m).append(" rows.").append("  Cannot compute the covariance of a RowMatrix with <= 1 row.").toString());
        Vector mean = Vectors$.MODULE$.fromML(summary.mean());
        return this.rows().first() instanceof DenseVector ? this.computeDenseVectorCovariance(mean, n, m) : this.computeSparseVectorCovariance(mean, n, m);
    }

    public Tuple2<Matrix, Vector> computePrincipalComponentsAndExplainedVariance(int k) {
        Tuple2 tuple2;
        block3: {
            breeze.linalg.DenseMatrix denseMatrix;
            breeze.linalg.DenseVector s;
            int n;
            block5: {
                svd.SVD sVD;
                block4: {
                    block2: {
                        n = (int)this.numCols();
                        Predef$.MODULE$.require(k > 0 && k <= n, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("k = ").append(k).append(" out of range (0, n = ").append(n).append("]").toString());
                        if (n <= 65535) break block2;
                        SingularValueDecomposition<RowMatrix, Matrix> svd2 = this.computeSVD(k, this.computeSVD$default$2(), this.computeSVD$default$3());
                        double[] s2 = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(svd2.s().toArray())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)eigValue -> eigValue * eigValue / (double)(n - 1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                        double eigenSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(s2)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                        double[] explainedVariance = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(s2)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$4 -> x$4 / eigenSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                        tuple2 = new Tuple2((Object)svd2.V(), (Object)Vectors$.MODULE$.dense(explainedVariance));
                        break block3;
                    }
                    breeze.linalg.DenseMatrix Cov = (breeze.linalg.DenseMatrix)this.computeCovariance().asBreeze();
                    sVD = (svd.SVD)svd$.MODULE$.apply((Object)Cov, (UFunc.UImpl)svd.Svd_DM_Impl$.MODULE$);
                    if (sVD == null) break block4;
                    breeze.linalg.DenseMatrix u = (breeze.linalg.DenseMatrix)sVD.leftVectors();
                    s = (breeze.linalg.DenseVector)sVD.singularValues();
                    if (u == null) break block4;
                    denseMatrix = u;
                    if (s != null) break block5;
                }
                throw new MatchError((Object)sVD);
            }
            breeze.linalg.DenseVector denseVector = s;
            Tuple2 tuple22 = new Tuple2((Object)denseMatrix, (Object)denseVector);
            Tuple2 tuple23 = tuple22;
            breeze.linalg.DenseMatrix u = (breeze.linalg.DenseMatrix)tuple23._1();
            breeze.linalg.DenseVector s3 = (breeze.linalg.DenseVector)tuple23._2();
            double eigenSum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(s3.data$mcD$sp())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            double[] explainedVariance = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(s3.data$mcD$sp())).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x$6 -> x$6 / eigenSum, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            tuple2 = k == n ? new Tuple2((Object)Matrices$.MODULE$.dense(n, k, u.data$mcD$sp()), (Object)Vectors$.MODULE$.dense(explainedVariance)) : new Tuple2((Object)Matrices$.MODULE$.dense(n, k, Arrays.copyOfRange(u.data$mcD$sp(), 0, n * k)), (Object)Vectors$.MODULE$.dense(Arrays.copyOfRange(explainedVariance, 0, k)));
        }
        return tuple2;
    }

    public Matrix computePrincipalComponents(int k) {
        return (Matrix)this.computePrincipalComponentsAndExplainedVariance(k)._1();
    }

    /*
     * WARNING - void declaration
     */
    public MultivariateStatisticalSummary computeColumnSummaryStatistics() {
        void var1_5;
        MultivariateOnlineSummarizer x$1 = new MultivariateOnlineSummarizer();
        Function2 & Serializable & scala.Serializable x$2 = (Function2 & Serializable & scala.Serializable)(aggregator, data) -> aggregator.add((Vector)data);
        Function2 & Serializable & scala.Serializable x$3 = (Function2 & Serializable & scala.Serializable)(aggregator1, aggregator2) -> aggregator1.merge((MultivariateOnlineSummarizer)aggregator2);
        int x$4 = this.rows().treeAggregate$default$4((Object)x$1);
        MultivariateOnlineSummarizer summary = (MultivariateOnlineSummarizer)this.rows().treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
        this.updateNumRows(summary.count());
        return var1_5;
    }

    public RowMatrix multiply(Matrix B) {
        int n = (int)this.numCols();
        int k = B.numCols();
        Predef$.MODULE$.require(n == B.numRows(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Dimension mismatch: ").append(n).append(" vs ").append(B.numRows()).toString());
        Predef$.MODULE$.require(B instanceof DenseMatrix, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Only support dense matrix at this time but found ").append(B.getClass().getName()).append(".").toString());
        Broadcast Bb = this.rows().context().broadcast((Object)((breeze.linalg.DenseMatrix)B.asBreeze()).toDenseVector$mcD$sp().toArray$mcD$sp(ClassTag$.MODULE$.Double()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD AB = this.rows().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            double[] Bi = (double[])Bb.value();
            return iter.map((Function1 & Serializable & scala.Serializable)row -> {
                breeze.linalg.DenseVector v = breeze.linalg.DenseVector$.MODULE$.zeros$mDc$sp(k, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
                for (int i = 0; i < k; ++i) {
                    v.update$mcD$sp(i, BoxesRunTime.unboxToDouble((Object)row.asBreeze().dot((Object)new DenseVector.mcD.sp(Bi, i * n, 1, n), Vector$.MODULE$.castOps(Predef$.MODULE$.$conforms(), Predef$.MODULE$.$conforms(), (UFunc.UImpl2)Vector$.MODULE$.canDot_V_V_Double()))));
                }
                return Vectors$.MODULE$.fromBreeze((breeze.linalg.Vector<Object>)v);
            });
        }, this.rows().mapPartitions$default$2(), ClassTag$.MODULE$.apply(Vector.class));
        return new RowMatrix((RDD<Vector>)AB, this.nRows(), B.numCols());
    }

    public CoordinateMatrix columnSimilarities() {
        return this.columnSimilarities(0.0);
    }

    public CoordinateMatrix columnSimilarities(double threshold) {
        Predef$.MODULE$.require(threshold >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Threshold cannot be negative: ").append(threshold).toString());
        if (threshold > 1.0) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(132).append("Threshold is greater than 1: ").append(threshold).append(" ").append("Computation will be more efficient with promoted sparsity, ").append(" however there is no correctness guarantee.").toString());
        }
        double gamma = threshold < 1.0E-6 ? Double.POSITIVE_INFINITY : (double)10 * package$.MODULE$.log((double)this.numCols()) / threshold;
        SummarizerBuffer summary = Statistics$.MODULE$.colStats((RDD<Tuple2<Vector, Object>>)this.rows().map((Function1 & Serializable & scala.Serializable)x$7 -> new Tuple2(x$7, (Object)BoxesRunTime.boxToDouble((double)1.0)), ClassTag$.MODULE$.apply(Tuple2.class)), (Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"normL2"}))));
        return this.columnSimilaritiesDIMSUM(summary.normL2().toArray(), gamma);
    }

    public QRDecomposition<RowMatrix, Matrix> tallSkinnyQR(boolean computeQ) {
        RowMatrix rowMatrix;
        int col = (int)this.numCols();
        RDD blockQRs = this.rows().retag(Vector.class).glom().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)RowMatrix.$anonfun$tallSkinnyQR$1(x$8))).map((Function1 & Serializable & scala.Serializable)partRows -> {
            breeze.linalg.DenseMatrix bdm = DenseMatrix$.MODULE$.zeros$mDc$sp(((Vector[])partRows).length, col, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
            IntRef i = IntRef.create((int)0);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partRows)).foreach((Function1 & Serializable & scala.Serializable)row -> {
                RowMatrix.$anonfun$tallSkinnyQR$3(bdm, i, row);
                return BoxedUnit.UNIT;
            });
            return (breeze.linalg.DenseMatrix)((qr.QR)qr.reduced$.MODULE$.apply((Object)bdm, (UFunc.UImpl)qr.reduced$.impl_reduced_DM_Double$.MODULE$)).r();
        }, ClassTag$.MODULE$.apply(breeze.linalg.DenseMatrix.class));
        breeze.linalg.DenseMatrix combinedR = (breeze.linalg.DenseMatrix)blockQRs.treeReduce((Function2 & Serializable & scala.Serializable)(r1, r2) -> {
            breeze.linalg.DenseMatrix stackedR = DenseMatrix$.MODULE$.vertcat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new breeze.linalg.DenseMatrix[]{r1, r2}), DenseMatrix$.MODULE$.dm_dm_UpdateOp_Double_OpSet(), ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
            return (breeze.linalg.DenseMatrix)((qr.QR)qr.reduced$.MODULE$.apply((Object)stackedR, (UFunc.UImpl)qr.reduced$.impl_reduced_DM_Double$.MODULE$)).r();
        }, blockQRs.treeReduce$default$2());
        Matrix finalR = Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)combinedR.toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$));
        if (computeQ) {
            try {
                breeze.linalg.DenseMatrix invR = (breeze.linalg.DenseMatrix)inv$.MODULE$.apply((Object)combinedR, inv$.MODULE$.canInvUsingLU_Double((UFunc.UImpl)LU.primitive$.LU_DM_Impl_Double$.MODULE$));
                rowMatrix = this.multiply(Matrices$.MODULE$.fromBreeze((breeze.linalg.Matrix<Object>)invR));
            }
            catch (MatrixSingularException err) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "R is not invertible and return Q as null");
                rowMatrix = null;
            }
        } else {
            rowMatrix = null;
        }
        RowMatrix finalQ = rowMatrix;
        return new QRDecomposition<Object, Matrix>(finalQ, finalR);
    }

    public boolean tallSkinnyQR$default$1() {
        return false;
    }

    public CoordinateMatrix columnSimilaritiesDIMSUM(double[] colMags, double gamma) {
        Predef$.MODULE$.require(gamma > 1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Oversampling should be greater than 1: ").append(gamma).toString());
        Predef$.MODULE$.require((long)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(colMags)).size() == this.numCols(), (Function0 & Serializable & scala.Serializable)() -> "Number of magnitudes didn't match column dimension");
        double sg = package$.MODULE$.sqrt(gamma);
        double[] colMagsCorrected = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(colMags)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)x -> x == 0.0 ? 1.0 : x, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        SparkContext sc = this.rows().context();
        Broadcast pBV = sc.broadcast(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(colMagsCorrected)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)c -> sg / c, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast qBV = sc.broadcast(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(colMagsCorrected)).map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)c -> package$.MODULE$.min(sg, c), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD sims = RDD$.MODULE$.rddToPairRDDFunctions(this.rows().mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(indx, iter) -> RowMatrix.$anonfun$columnSimilaritiesDIMSUM$6(pBV, qBV, BoxesRunTime.unboxToInt((Object)indx), iter), this.rows().mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKey((Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x$9, x$10) -> x$9 + x$10).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            double sim;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    sim = tuple22._2$mcD$sp();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            int i = tuple2._1$mcI$sp();
            int j = tuple2._2$mcI$sp();
            MatrixEntry matrixEntry = new MatrixEntry(i, j, sim);
            return matrixEntry;
        }, ClassTag$.MODULE$.apply(MatrixEntry.class));
        return new CoordinateMatrix((RDD<MatrixEntry>)sims, this.numCols(), this.numCols());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public breeze.linalg.DenseMatrix<Object> toBreeze() {
        void var3_3;
        int m = (int)this.numRows();
        int n = (int)this.numCols();
        breeze.linalg.DenseMatrix mat = DenseMatrix$.MODULE$.zeros$mDc$sp(m, n, ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        IntRef i = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.rows().collect())).foreach((Function1 & Serializable & scala.Serializable)vector -> {
            RowMatrix.$anonfun$toBreeze$1(mat, i, vector);
            return BoxedUnit.UNIT;
        });
        return var3_3;
    }

    private void updateNumRows(long m) {
        if (this.nRows() <= 0L) {
            this.nRows_$eq(m);
        } else {
            Predef$.MODULE$.require(this.nRows() == m, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(78).append("The number of rows ").append(m).append(" is different from what specified or previously computed: ").append(this.nRows()).append(".").toString());
        }
    }

    public int getTreeAggregateIdealDepth(long aggregatedObjectSizeInBytes) {
        double desiredTreeDepth;
        block1: {
            Predef$.MODULE$.require(aggregatedObjectSizeInBytes > 0L, (Function0 & Serializable & scala.Serializable)() -> "Cannot compute aggregate depth heuristic based on a zero-size object to aggregate");
            long maxDriverResultSizeInBytes = BoxesRunTime.unboxToLong((Object)this.rows().conf().get(org.apache.spark.internal.config.package$.MODULE$.MAX_RESULT_SIZE()));
            if (maxDriverResultSizeInBytes <= 0L) {
                return 1;
            }
            Predef$.MODULE$.require(maxDriverResultSizeInBytes > aggregatedObjectSizeInBytes, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Cannot aggregate object of size ").append(aggregatedObjectSizeInBytes).append(" Bytes, ").append("as it's bigger than maxResultSize (").append(maxDriverResultSizeInBytes).append(" Bytes)").toString());
            double numerator = package$.MODULE$.log((double)this.rows().getNumPartitions());
            double denominator = package$.MODULE$.log((double)maxDriverResultSizeInBytes) - package$.MODULE$.log((double)aggregatedObjectSizeInBytes);
            desiredTreeDepth = package$.MODULE$.ceil(numerator / denominator);
            if (!(desiredTreeDepth > (double)4)) break block1;
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(124).append("Desired tree depth for treeAggregation is big (").append(desiredTreeDepth).append(").").append("Consider increasing driver max result size or reducing number of partitions").toString());
        }
        return (int)package$.MODULE$.min(package$.MODULE$.max(1.0, desiredTreeDepth), 10.0);
    }

    private static final /* synthetic */ RowMatrix$SVDMode$1$ SVDMode$lzycompute$1(LazyRef SVDMode$module$1) {
        RowMatrix$SVDMode$1$ rowMatrix$SVDMode$1$;
        LazyRef lazyRef = SVDMode$module$1;
        synchronized (lazyRef) {
            rowMatrix$SVDMode$1$ = SVDMode$module$1.initialized() ? (RowMatrix$SVDMode$1$)((Object)SVDMode$module$1.value()) : (RowMatrix$SVDMode$1$)((Object)SVDMode$module$1.initialize((Object)new RowMatrix$SVDMode$1$(null)));
        }
        return rowMatrix$SVDMode$1$;
    }

    private final RowMatrix$SVDMode$1$ SVDMode$2(LazyRef SVDMode$module$1) {
        return SVDMode$module$1.initialized() ? (RowMatrix$SVDMode$1$)((Object)SVDMode$module$1.value()) : RowMatrix.SVDMode$lzycompute$1(SVDMode$module$1);
    }

    public static final /* synthetic */ boolean $anonfun$tallSkinnyQR$1(Vector[] x$8) {
        return x$8.length != 0;
    }

    public static final /* synthetic */ void $anonfun$tallSkinnyQR$3(breeze.linalg.DenseMatrix bdm$1, IntRef i$1, Vector row) {
        ((NumericOps)bdm$1.apply((Object)BoxesRunTime.boxToInteger((int)i$1.elem), (Object)scala.package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRow())).$colon$eq(row.asBreeze().t(Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.$conforms())), Transpose$.MODULE$.liftInPlaceOps((UFunc.InPlaceImpl2)breeze.linalg.DenseVector$.MODULE$.dv_v_InPlaceOp_Double_OpSet()));
        ++i$1.elem;
    }

    public static final /* synthetic */ ListBuffer $anonfun$columnSimilaritiesDIMSUM$8(int[] indices$1, double[] scaled$1, XORShiftRandom rand$1, double[] p$1, int nnz$1, int k) {
        ListBuffer buf = new ListBuffer();
        int i = indices$1[k];
        double iVal = scaled$1[k];
        if (iVal != 0.0 && rand$1.nextDouble() < p$1[i]) {
            for (int l = k + 1; l < nnz$1; ++l) {
                int j = indices$1[l];
                double jVal = scaled$1[l];
                Object object = jVal != 0.0 && rand$1.nextDouble() < p$1[j] ? buf.$plus$eq((Object)new Tuple2((Object)new Tuple2.mcII.sp(i, j), (Object)BoxesRunTime.boxToDouble((double)(iVal * jVal)))) : BoxedUnit.UNIT;
            }
        }
        return buf;
    }

    public static final /* synthetic */ ListBuffer $anonfun$columnSimilaritiesDIMSUM$9(double[] scaled$1, XORShiftRandom rand$1, double[] p$1, int n$4, int i) {
        ListBuffer buf = new ListBuffer();
        double iVal = scaled$1[i];
        if (iVal != 0.0 && rand$1.nextDouble() < p$1[i]) {
            for (int j = i + 1; j < n$4; ++j) {
                double jVal = scaled$1[j];
                Object object = jVal != 0.0 && rand$1.nextDouble() < p$1[j] ? buf.$plus$eq((Object)new Tuple2((Object)new Tuple2.mcII.sp(i, j), (Object)BoxesRunTime.boxToDouble((double)(iVal * jVal)))) : BoxedUnit.UNIT;
            }
        }
        return buf;
    }

    public static final /* synthetic */ Iterator $anonfun$columnSimilaritiesDIMSUM$6(Broadcast pBV$1, Broadcast qBV$1, int indx, Iterator iter) {
        double[] p = (double[])pBV$1.value();
        double[] q = (double[])qBV$1.value();
        XORShiftRandom rand = new XORShiftRandom((long)indx);
        double[] scaled = new double[new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(p)).size()];
        return iter.flatMap((Function1 & Serializable & scala.Serializable)row -> {
            DenseVector denseVector;
            Option<double[]> option;
            Iterator iterator;
            SparseVector sparseVector;
            Option<Tuple3<Object, int[], double[]>> option2;
            Vector vector = row;
            if (vector instanceof SparseVector && !(option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector)).isEmpty()) {
                int[] indices = (int[])((Tuple3)option2.get())._2();
                double[] values = (double[])((Tuple3)option2.get())._3();
                int nnz = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(indices)).size();
                for (int k2 = 0; k2 < nnz; ++k2) {
                    scaled$1[k2] = values[k2] / q[indices[k2]];
                }
                iterator = TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)scala.package$.MODULE$.Iterator().tabulate(nnz, (Function1 & Serializable & scala.Serializable)k -> RowMatrix.$anonfun$columnSimilaritiesDIMSUM$8(indices, scaled, rand, p, nnz, BoxesRunTime.unboxToInt((Object)k))), (Function1)Predef$.MODULE$.$conforms()).flatten();
            } else if (vector instanceof DenseVector && !(option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) {
                double[] values = (double[])option.get();
                int n = new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(values)).size();
                for (int i2 = 0; i2 < n; ++i2) {
                    scaled$1[i2] = values[i2] / q[i2];
                }
                iterator = TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)scala.package$.MODULE$.Iterator().tabulate(n, (Function1 & Serializable & scala.Serializable)i -> RowMatrix.$anonfun$columnSimilaritiesDIMSUM$9(scaled, rand, p, n, BoxesRunTime.unboxToInt((Object)i))), (Function1)Predef$.MODULE$.$conforms()).flatten();
            } else {
                throw new MatchError((Object)vector);
            }
            return iterator;
        });
    }

    public static final /* synthetic */ void $anonfun$toBreeze$1(breeze.linalg.DenseMatrix mat$1, IntRef i$2, Vector vector) {
        vector.foreachNonZero((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$1, x1$1);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int j = sp2._1$mcI$sp();
            double v = sp2._2$mcD$sp();
            mat$1.update$mcD$sp(i$2.elem, j, v);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        ++i$2.elem;
    }

    public RowMatrix(RDD<Vector> rows, long nRows, int nCols) {
        this.rows = rows;
        this.nRows = nRows;
        this.nCols = nCols;
        Logging.$init$((Logging)this);
    }

    public RowMatrix(RDD<Vector> rows) {
        this(rows, 0L, 0);
    }
}

