/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.evaluation.MulticlassClassificationEvaluator$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasPredictionCol;
import org.apache.spark.ml.param.shared.HasProbabilityCol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t]a\u0001\u0002\u0013&\u0001AB\u0001\u0002\u0014\u0001\u0003\u0006\u0004%\t%\u0014\u0005\tI\u0002\u0011\t\u0011)A\u0005\u001d\")a\r\u0001C\u0001O\")a\r\u0001C\u0001Y\"9a\u000e\u0001b\u0001\n\u0003y\u0007BB;\u0001A\u0003%\u0001\u000fC\u0003x\u0001\u0011\u0005Q\nC\u0003z\u0001\u0011\u0005!\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011\u0001\u0005\b\u0003\u000f\u0001A\u0011AA\u0005\u0011\u001d\ty\u0001\u0001C\u0001\u0003#Aq!a\u0007\u0001\t\u0003\ti\u0002C\u0005\u0002$\u0001\u0011\r\u0011\"\u0002\u0002&!A\u0011q\u0006\u0001!\u0002\u001b\t9\u0003C\u0004\u00024\u0001!\t!!\u000e\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D!I\u0011\u0011\n\u0001C\u0002\u0013\u0015\u0011Q\u0005\u0005\t\u0003\u001b\u0002\u0001\u0015!\u0004\u0002(!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005U\u0002bBA+\u0001\u0011\u0005\u0011q\u000b\u0005\n\u0003;\u0002!\u0019!C\u0003\u0003KA\u0001\"!\u0019\u0001A\u00035\u0011q\u0005\u0005\b\u0003K\u0002A\u0011AA\u001b\u0011\u001d\tI\u0007\u0001C\u0001\u0003WBq!!\u001d\u0001\t\u0003\n\u0019\bC\u0004\u0002$\u0002!\t%!*\t\u000f\u0005=\u0006\u0001\"\u0011\u00022\"9\u0011q\u0018\u0001\u0005B\u0005\u0005waBAdK!\u0005\u0011\u0011\u001a\u0004\u0007I\u0015B\t!a3\t\r\u0019tB\u0011AAp\u0011%\t\tO\bb\u0001\n\u0013\t\u0019\u000f\u0003\u0005\u0002zz\u0001\u000b\u0011BAs\u0011\u001d\tYP\bC!\u0003{D\u0011B!\u0003\u001f\u0003\u0003%IAa\u0003\u0003C5+H\u000e^5dY\u0006\u001c8o\u00117bgNLg-[2bi&|g.\u0012<bYV\fGo\u001c:\u000b\u0005\u0019:\u0013AC3wC2,\u0018\r^5p]*\u0011\u0001&K\u0001\u0003[2T!AK\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0002\u0001'\u001d\u0001\u0011'N\u001fA\u0007\u001a\u0003\"AM\u001a\u000e\u0003\u0015J!\u0001N\u0013\u0003\u0013\u00153\u0018\r\\;bi>\u0014\bC\u0001\u001c<\u001b\u00059$B\u0001\u001d:\u0003\u0019\u0019\b.\u0019:fI*\u0011!hJ\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0003y]\u0012\u0001\u0003S1t!J,G-[2uS>t7i\u001c7\u0011\u0005Yr\u0014BA 8\u0005-A\u0015m\u001d'bE\u0016d7i\u001c7\u0011\u0005Y\n\u0015B\u0001\"8\u00051A\u0015m],fS\u001eDGoQ8m!\t1D)\u0003\u0002Fo\t\t\u0002*Y:Qe>\u0014\u0017MY5mSRL8i\u001c7\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%;\u0013\u0001B;uS2L!a\u0013%\u0003+\u0011+g-Y;miB\u000b'/Y7t/JLG/\u00192mK\u0006\u0019Q/\u001b3\u0016\u00039\u0003\"a\u0014-\u000f\u0005A3\u0006CA)U\u001b\u0005\u0011&BA*0\u0003\u0019a$o\\8u})\tQ+A\u0003tG\u0006d\u0017-\u0003\u0002X)\u00061\u0001K]3eK\u001aL!!\u0017.\u0003\rM#(/\u001b8h\u0015\t9F\u000bK\u0002\u00029\n\u0004\"!\u00181\u000e\u0003yS!aX\u0015\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002b=\n)1+\u001b8dK\u0006\n1-A\u00032]Ur\u0003'\u0001\u0003vS\u0012\u0004\u0003f\u0001\u0002]E\u00061A(\u001b8jiz\"\"\u0001[5\u0011\u0005I\u0002\u0001\"\u0002'\u0004\u0001\u0004q\u0005fA5]E\"\u001a1\u0001\u00182\u0015\u0003!D3\u0001\u0002/c\u0003)iW\r\u001e:jG:\u000bW.Z\u000b\u0002aB\u0019\u0011O\u001d(\u000e\u0003eJ!a]\u001d\u0003\u000bA\u000b'/Y7)\u0007\u0015a&-A\u0006nKR\u0014\u0018n\u0019(b[\u0016\u0004\u0003f\u0001\u0004]E\u0006iq-\u001a;NKR\u0014\u0018n\u0019(b[\u0016D3a\u0002/c\u00035\u0019X\r^'fiJL7MT1nKR\u00111\u0010`\u0007\u0002\u0001!)Q\u0010\u0003a\u0001\u001d\u0006)a/\u00197vK\"\u001a\u0001\u0002\u00182\u0002!M,G\u000f\u0015:fI&\u001cG/[8o\u0007>dGcA>\u0002\u0004!)Q0\u0003a\u0001\u001d\"\u001a\u0011\u0002\u00182\u0002\u0017M,G\u000fT1cK2\u001cu\u000e\u001c\u000b\u0004w\u0006-\u0001\"B?\u000b\u0001\u0004q\u0005f\u0001\u0006]E\u0006a1/\u001a;XK&<\u0007\u000e^\"pYR\u001910a\u0005\t\u000bu\\\u0001\u0019\u0001()\t-a\u0016qC\u0011\u0003\u00033\tQa\r\u00181]A\n\u0011c]3u!J|'-\u00192jY&$\u0018pQ8m)\rY\u0018q\u0004\u0005\u0006{2\u0001\rA\u0014\u0015\u0005\u0019q\u000b9\"A\u0006nKR\u0014\u0018n\u0019'bE\u0016dWCAA\u0014!\r\t\u0018\u0011F\u0005\u0004\u0003WI$a\u0003#pk\ndW\rU1sC6DC!\u0004/\u0002\u0018\u0005aQ.\u001a;sS\u000ed\u0015MY3mA!\"a\u0002XA\f\u000399W\r^'fiJL7\rT1cK2,\"!a\u000e\u0011\t\u0005e\u00121H\u0007\u0002)&\u0019\u0011Q\b+\u0003\r\u0011{WO\u00197fQ\u0011yA,a\u0006\u0002\u001dM,G/T3ue&\u001cG*\u00192fYR\u001910!\u0012\t\ru\u0004\u0002\u0019AA\u001cQ\u0011\u0001B,a\u0006\u0002\t\t,G/\u0019\u0015\u0005#q\u000b9\"A\u0003cKR\f\u0007\u0005\u000b\u0003\u00139\u0006]\u0011aB4fi\n+G/\u0019\u0015\u0005'q\u000b9\"A\u0004tKR\u0014U\r^1\u0015\u0007m\fI\u0006\u0003\u0004~)\u0001\u0007\u0011q\u0007\u0015\u0005)q\u000b9\"A\u0002faNDC!\u0006/\u0002\u0018\u0005!Q\r]:!Q\u00111B,a\u0006\u0002\r\u001d,G/\u00129tQ\u00119B,a\u0006\u0002\rM,G/\u00129t)\rY\u0018Q\u000e\u0005\u0007{b\u0001\r!a\u000e)\taa\u0016qC\u0001\tKZ\fG.^1uKR!\u0011qGA;\u0011\u001d\t9(\u0007a\u0001\u0003s\nq\u0001Z1uCN,G\u000f\r\u0003\u0002|\u0005-\u0005CBA?\u0003\u0007\u000b9)\u0004\u0002\u0002\u0000)\u0019\u0011\u0011Q\u0015\u0002\u0007M\fH.\u0003\u0003\u0002\u0006\u0006}$a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003\u0013\u000bY\t\u0004\u0001\u0005\u0019\u00055\u0015QOA\u0001\u0002\u0003\u0015\t!a$\u0003\u0007}#\u0013'\u0005\u0003\u0002\u0012\u0006]\u0005\u0003BA\u001d\u0003'K1!!&U\u0005\u001dqu\u000e\u001e5j]\u001e\u0004B!!\u000f\u0002\u001a&\u0019\u00111\u0014+\u0003\u0007\u0005s\u0017\u0010\u000b\u0003\u001a9\u0006}\u0015EAAQ\u0003\u0015\u0011d\u0006\r\u00181\u00039I7\u000fT1sO\u0016\u0014()\u001a;uKJ,\"!a*\u0011\t\u0005e\u0012\u0011V\u0005\u0004\u0003W#&a\u0002\"p_2,\u0017M\u001c\u0015\u00045q\u0013\u0017\u0001B2paf$2\u0001[AZ\u0011\u001d\t)l\u0007a\u0001\u0003o\u000bQ!\u001a=ue\u0006\u00042!]A]\u0013\r\tY,\u000f\u0002\t!\u0006\u0014\u0018-\\'ba\"\u001a1\u0004\u00182\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A\u0014\u0015\u00059q\u000b9\u0002K\u0002\u00019\n\f\u0011%T;mi&\u001cG.Y:t\u00072\f7o]5gS\u000e\fG/[8o\u000bZ\fG.^1u_J\u0004\"A\r\u0010\u0014\u000fy\ti-a5\u0002ZB!\u0011\u0011HAh\u0013\r\t\t\u000e\u0016\u0002\u0007\u0003:L(+\u001a4\u0011\t\u001d\u000b)\u000e[\u0005\u0004\u0003/D%!\u0006#fM\u0006,H\u000e\u001e)be\u0006l7OU3bI\u0006\u0014G.\u001a\t\u0005\u0003s\tY.C\u0002\u0002^R\u0013AbU3sS\u0006d\u0017N_1cY\u0016$\"!!3\u0002)M,\b\u000f]8si\u0016$W*\u001a;sS\u000et\u0015-\\3t+\t\t)\u000f\u0005\u0004\u0002:\u0005\u001d\u00181^\u0005\u0004\u0003S$&!B!se\u0006L\b\u0003BAw\u0003ol!!a<\u000b\t\u0005E\u00181_\u0001\u0005Y\u0006twM\u0003\u0002\u0002v\u0006!!.\u0019<b\u0013\rI\u0016q^\u0001\u0016gV\u0004\bo\u001c:uK\u0012lU\r\u001e:jG:\u000bW.Z:!\u0003\u0011aw.\u00193\u0015\u0007!\fy\u0010\u0003\u0004\u0003\u0002\t\u0002\rAT\u0001\u0005a\u0006$\b\u000e\u000b\u0003#9\n\u0015\u0011E\u0001B\u0004\u0003\u0015\tdF\u000e\u00181\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t5\u0001\u0003BAw\u0005\u001fIAA!\u0005\u0002p\n1qJ\u00196fGRDCA\b/\u0003\u0006!\"Q\u0004\u0018B\u0003\u0001")
public class MulticlassClassificationEvaluator
extends Evaluator
implements HasPredictionCol,
HasLabelCol,
HasWeightCol,
HasProbabilityCol,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> metricName;
    private final DoubleParam metricLabel;
    private final DoubleParam beta;
    private final DoubleParam eps;
    private final Param<String> probabilityCol;
    private final Param<String> weightCol;
    private final Param<String> labelCol;
    private final Param<String> predictionCol;

    public static MulticlassClassificationEvaluator load(String string) {
        return MulticlassClassificationEvaluator$.MODULE$.load(string);
    }

    public static MLReader<MulticlassClassificationEvaluator> read() {
        return MulticlassClassificationEvaluator$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final String getProbabilityCol() {
        return HasProbabilityCol.getProbabilityCol$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol.getLabelCol$(this);
    }

    @Override
    public final String getPredictionCol() {
        return HasPredictionCol.getPredictionCol$(this);
    }

    @Override
    public final Param<String> probabilityCol() {
        return this.probabilityCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasProbabilityCol$_setter_$probabilityCol_$eq(Param<String> x$1) {
        this.probabilityCol = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param<String> x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final Param<String> predictionCol() {
        return this.predictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasPredictionCol$_setter_$predictionCol_$eq(Param<String> x$1) {
        this.predictionCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public MulticlassClassificationEvaluator setMetricName(String value) {
        return (MulticlassClassificationEvaluator)this.set(this.metricName(), value);
    }

    public MulticlassClassificationEvaluator setPredictionCol(String value) {
        return (MulticlassClassificationEvaluator)this.set(this.predictionCol(), value);
    }

    public MulticlassClassificationEvaluator setLabelCol(String value) {
        return (MulticlassClassificationEvaluator)this.set(this.labelCol(), value);
    }

    public MulticlassClassificationEvaluator setWeightCol(String value) {
        return (MulticlassClassificationEvaluator)this.set(this.weightCol(), value);
    }

    public MulticlassClassificationEvaluator setProbabilityCol(String value) {
        return (MulticlassClassificationEvaluator)this.set(this.probabilityCol(), value);
    }

    public final DoubleParam metricLabel() {
        return this.metricLabel;
    }

    public double getMetricLabel() {
        return BoxesRunTime.unboxToDouble((Object)this.$(this.metricLabel()));
    }

    public MulticlassClassificationEvaluator setMetricLabel(double value) {
        return (MulticlassClassificationEvaluator)this.set(this.metricLabel(), BoxesRunTime.boxToDouble((double)value));
    }

    public final DoubleParam beta() {
        return this.beta;
    }

    public double getBeta() {
        return BoxesRunTime.unboxToDouble((Object)this.$(this.beta()));
    }

    public MulticlassClassificationEvaluator setBeta(double value) {
        return (MulticlassClassificationEvaluator)this.set(this.beta(), BoxesRunTime.boxToDouble((double)value));
    }

    public final DoubleParam eps() {
        return this.eps;
    }

    public double getEps() {
        return BoxesRunTime.unboxToDouble((Object)this.$(this.eps()));
    }

    public MulticlassClassificationEvaluator setEps(double value) {
        return (MulticlassClassificationEvaluator)this.set(this.eps(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public double evaluate(Dataset<?> dataset) {
        double d;
        RDD rDD;
        StructType schema = dataset.schema();
        SchemaUtils$.MODULE$.checkColumnType(schema, this.$(this.predictionCol()), (DataType)DoubleType$.MODULE$, SchemaUtils$.MODULE$.checkColumnType$default$4());
        SchemaUtils$.MODULE$.checkNumericType(schema, this.$(this.labelCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        Column w = this.isDefined(this.weightCol()) && new StringOps(Predef$.MODULE$.augmentString(this.$(this.weightCol()))).nonEmpty() ? functions$.MODULE$.col(this.$(this.weightCol())).cast((DataType)DoubleType$.MODULE$) : functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0));
        String string = this.$(this.metricName());
        String string2 = "logLoss";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Predef$.MODULE$.require(this.isDefined(this.probabilityCol()) && new StringOps(Predef$.MODULE$.augmentString(this.$(this.probabilityCol()))).nonEmpty());
            Column p = DatasetUtils$.MODULE$.columnToVector(dataset, this.$(this.probabilityCol()));
            rDD = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.predictionCol())), functions$.MODULE$.col(this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$), w, p})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                double d;
                double d2;
                double d3;
                Object probability;
                block3: {
                    Row row;
                    block2: {
                        row = x0$1;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(4) != 0) break block2;
                        Object prediction = ((SeqLike)some.get()).apply(0);
                        Object label = ((SeqLike)some.get()).apply(1);
                        Object weight = ((SeqLike)some.get()).apply(2);
                        probability = ((SeqLike)some.get()).apply(3);
                        if (!(prediction instanceof Double)) break block2;
                        d3 = BoxesRunTime.unboxToDouble((Object)prediction);
                        if (!(label instanceof Double)) break block2;
                        d2 = BoxesRunTime.unboxToDouble((Object)label);
                        if (!(weight instanceof Double)) break block2;
                        d = BoxesRunTime.unboxToDouble((Object)weight);
                        if (probability instanceof Vector) break block3;
                    }
                    throw new MatchError((Object)row);
                }
                Vector vector = (Vector)probability;
                Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)d3), (Object)BoxesRunTime.boxToDouble((double)d2), (Object)BoxesRunTime.boxToDouble((double)d), (Object)vector.toArray());
                return tuple4;
            }, ClassTag$.MODULE$.apply(Tuple4.class));
        } else {
            rDD = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.predictionCol())), functions$.MODULE$.col(this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$), w})).rdd().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                double d;
                double d2;
                Object weight;
                block3: {
                    Row row;
                    block2: {
                        row = x0$2;
                        Some some = Row$.MODULE$.unapplySeq(row);
                        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) break block2;
                        Object prediction = ((SeqLike)some.get()).apply(0);
                        Object label = ((SeqLike)some.get()).apply(1);
                        weight = ((SeqLike)some.get()).apply(2);
                        if (!(prediction instanceof Double)) break block2;
                        d2 = BoxesRunTime.unboxToDouble((Object)prediction);
                        if (!(label instanceof Double)) break block2;
                        d = BoxesRunTime.unboxToDouble((Object)label);
                        if (weight instanceof Double) break block3;
                    }
                    throw new MatchError((Object)row);
                }
                double d3 = BoxesRunTime.unboxToDouble((Object)weight);
                Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)d2), (Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d3));
                return tuple3;
            }, ClassTag$.MODULE$.apply(Tuple3.class));
        }
        RDD rdd = rDD;
        MulticlassMetrics metrics = new MulticlassMetrics((RDD<? extends Product>)rdd);
        String string3 = this.$(this.metricName());
        if ("f1".equals(string3)) {
            d = metrics.weightedFMeasure();
        } else if ("accuracy".equals(string3)) {
            d = metrics.accuracy();
        } else if ("weightedPrecision".equals(string3)) {
            d = metrics.weightedPrecision();
        } else if ("weightedRecall".equals(string3)) {
            d = metrics.weightedRecall();
        } else if ("weightedTruePositiveRate".equals(string3)) {
            d = metrics.weightedTruePositiveRate();
        } else if ("weightedFalsePositiveRate".equals(string3)) {
            d = metrics.weightedFalsePositiveRate();
        } else if ("weightedFMeasure".equals(string3)) {
            d = metrics.weightedFMeasure(BoxesRunTime.unboxToDouble((Object)this.$(this.beta())));
        } else if ("truePositiveRateByLabel".equals(string3)) {
            d = metrics.truePositiveRate(BoxesRunTime.unboxToDouble((Object)this.$(this.metricLabel())));
        } else if ("falsePositiveRateByLabel".equals(string3)) {
            d = metrics.falsePositiveRate(BoxesRunTime.unboxToDouble((Object)this.$(this.metricLabel())));
        } else if ("precisionByLabel".equals(string3)) {
            d = metrics.precision(BoxesRunTime.unboxToDouble((Object)this.$(this.metricLabel())));
        } else if ("recallByLabel".equals(string3)) {
            d = metrics.recall(BoxesRunTime.unboxToDouble((Object)this.$(this.metricLabel())));
        } else if ("fMeasureByLabel".equals(string3)) {
            d = metrics.fMeasure(BoxesRunTime.unboxToDouble((Object)this.$(this.metricLabel())), BoxesRunTime.unboxToDouble((Object)this.$(this.beta())));
        } else if ("hammingLoss".equals(string3)) {
            d = metrics.hammingLoss();
        } else if ("logLoss".equals(string3)) {
            d = metrics.logLoss(BoxesRunTime.unboxToDouble((Object)this.$(this.eps())));
        } else {
            throw new MatchError((Object)string3);
        }
        return d;
    }

    @Override
    public boolean isLargerBetter() {
        String string = this.$(this.metricName());
        boolean bl = "weightedFalsePositiveRate".equals(string) ? true : ("falsePositiveRateByLabel".equals(string) ? true : ("logLoss".equals(string) ? true : "hammingLoss".equals(string)));
        boolean bl2 = !bl;
        return bl2;
    }

    @Override
    public MulticlassClassificationEvaluator copy(ParamMap extra) {
        return (MulticlassClassificationEvaluator)this.defaultCopy(extra);
    }

    @Override
    public String toString() {
        return new StringBuilder(79).append("MulticlassClassificationEvaluator: uid=").append(this.uid()).append(", metricName=").append((Object)this.$(this.metricName())).append(", ").append("metricLabel=").append(this.$(this.metricLabel())).append(", beta=").append(this.$(this.beta())).append(", eps=").append(this.$(this.eps())).toString();
    }

    public MulticlassClassificationEvaluator(String uid) {
        this.uid = uid;
        HasPredictionCol.$init$(this);
        HasLabelCol.$init$(this);
        HasWeightCol.$init$(this);
        HasProbabilityCol.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        this.metricName = new Param(this, "metricName", new StringBuilder(26).append("metric name in evaluation ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MulticlassClassificationEvaluator$.MODULE$.org$apache$spark$ml$evaluation$MulticlassClassificationEvaluator$$supportedMetricNames())).mkString("(", "|", ")")).toString(), ParamValidators$.MODULE$.inArray(MulticlassClassificationEvaluator$.MODULE$.org$apache$spark$ml$evaluation$MulticlassClassificationEvaluator$$supportedMetricNames()));
        this.metricLabel = new DoubleParam((Identifiable)this, "metricLabel", new StringBuilder(82).append("The class whose metric will be computed in ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MulticlassClassificationEvaluator$.MODULE$.org$apache$spark$ml$evaluation$MulticlassClassificationEvaluator$$supportedMetricNames())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.endsWith("ByLabel"))))).mkString("(", "|", ")")).append(". ").append("Must be >= 0. The default value is 0.").toString(), (Function1<Object, Object>)ParamValidators$.MODULE$.gtEq(0.0));
        this.beta = new DoubleParam((Identifiable)this, "beta", "The beta value, which controls precision vs recall weighting, used in (weightedFMeasure|fMeasureByLabel). Must be > 0. The default value is 1.", (Function1<Object, Object>)ParamValidators$.MODULE$.gt(0.0));
        this.eps = new DoubleParam((Identifiable)this, "eps", "log-loss is undefined for p=0 or p=1, so probabilities are clipped to max(eps, min(1 - eps, p)).", (Function1<Object, Object>)ParamValidators$.MODULE$.inRange(0.0, 0.5, false, false));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("f1"), this.eps().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-15)), this.metricLabel().$minus$greater(BoxesRunTime.boxToDouble((double)0.0)), this.beta().$minus$greater(BoxesRunTime.boxToDouble((double)1.0))}));
    }

    public MulticlassClassificationEvaluator() {
        this(Identifiable$.MODULE$.randomUID("mcEval"));
    }
}

